package webauthn

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// AuthenticatorID [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-AuthenticatorId
type AuthenticatorID string

// String returns the AuthenticatorID as string value.
func (t AuthenticatorID) String() string {
	return string(t)
}

// AuthenticatorProtocol [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-AuthenticatorProtocol
type AuthenticatorProtocol string

// String returns the AuthenticatorProtocol as string value.
func (t AuthenticatorProtocol) String() string {
	return string(t)
}

// AuthenticatorProtocol values.
const (
	AuthenticatorProtocolU2f   AuthenticatorProtocol = "u2f"
	AuthenticatorProtocolCtap2 AuthenticatorProtocol = "ctap2"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AuthenticatorProtocol) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AuthenticatorProtocol) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AuthenticatorProtocol) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AuthenticatorProtocol(v) {
	case AuthenticatorProtocolU2f:
		*t = AuthenticatorProtocolU2f
	case AuthenticatorProtocolCtap2:
		*t = AuthenticatorProtocolCtap2

	default:
		in.AddError(fmt.Errorf("unknown AuthenticatorProtocol value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AuthenticatorProtocol) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// Ctap2version [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-Ctap2Version
type Ctap2version string

// String returns the Ctap2version as string value.
func (t Ctap2version) String() string {
	return string(t)
}

// Ctap2version values.
const (
	Ctap2versionCtap20 Ctap2version = "ctap2_0"
	Ctap2versionCtap21 Ctap2version = "ctap2_1"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t Ctap2version) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t Ctap2version) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *Ctap2version) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch Ctap2version(v) {
	case Ctap2versionCtap20:
		*t = Ctap2versionCtap20
	case Ctap2versionCtap21:
		*t = Ctap2versionCtap21

	default:
		in.AddError(fmt.Errorf("unknown Ctap2version value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *Ctap2version) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AuthenticatorTransport [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-AuthenticatorTransport
type AuthenticatorTransport string

// String returns the AuthenticatorTransport as string value.
func (t AuthenticatorTransport) String() string {
	return string(t)
}

// AuthenticatorTransport values.
const (
	AuthenticatorTransportUsb      AuthenticatorTransport = "usb"
	AuthenticatorTransportNfc      AuthenticatorTransport = "nfc"
	AuthenticatorTransportBle      AuthenticatorTransport = "ble"
	AuthenticatorTransportCable    AuthenticatorTransport = "cable"
	AuthenticatorTransportInternal AuthenticatorTransport = "internal"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t AuthenticatorTransport) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t AuthenticatorTransport) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *AuthenticatorTransport) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch AuthenticatorTransport(v) {
	case AuthenticatorTransportUsb:
		*t = AuthenticatorTransportUsb
	case AuthenticatorTransportNfc:
		*t = AuthenticatorTransportNfc
	case AuthenticatorTransportBle:
		*t = AuthenticatorTransportBle
	case AuthenticatorTransportCable:
		*t = AuthenticatorTransportCable
	case AuthenticatorTransportInternal:
		*t = AuthenticatorTransportInternal

	default:
		in.AddError(fmt.Errorf("unknown AuthenticatorTransport value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *AuthenticatorTransport) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// VirtualAuthenticatorOptions [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-VirtualAuthenticatorOptions
type VirtualAuthenticatorOptions struct {
	Protocol                    AuthenticatorProtocol  `json:"protocol"`
	Ctap2version                Ctap2version           `json:"ctap2Version,omitempty"` // Defaults to ctap2_0. Ignored if |protocol| == u2f.
	Transport                   AuthenticatorTransport `json:"transport"`
	HasResidentKey              bool                   `json:"hasResidentKey,omitempty"`              // Defaults to false.
	HasUserVerification         bool                   `json:"hasUserVerification,omitempty"`         // Defaults to false.
	HasLargeBlob                bool                   `json:"hasLargeBlob,omitempty"`                // If set to true, the authenticator will support the largeBlob extension. https://w3c.github.io/webauthn#largeBlob Defaults to false.
	HasCredBlob                 bool                   `json:"hasCredBlob,omitempty"`                 // If set to true, the authenticator will support the credBlob extension. https://fidoalliance.org/specs/fido-v2.1-rd-20201208/fido-client-to-authenticator-protocol-v2.1-rd-20201208.html#sctn-credBlob-extension Defaults to false.
	HasMinPinLength             bool                   `json:"hasMinPinLength,omitempty"`             // If set to true, the authenticator will support the minPinLength extension. https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-minpinlength-extension Defaults to false.
	HasPrf                      bool                   `json:"hasPrf,omitempty"`                      // If set to true, the authenticator will support the prf extension. https://w3c.github.io/webauthn/#prf-extension Defaults to false.
	AutomaticPresenceSimulation bool                   `json:"automaticPresenceSimulation,omitempty"` // If set to true, tests of user presence will succeed immediately. Otherwise, they will not be resolved. Defaults to true.
	IsUserVerified              bool                   `json:"isUserVerified,omitempty"`              // Sets whether User Verification succeeds or fails for an authenticator. Defaults to false.
	DefaultBackupEligibility    bool                   `json:"defaultBackupEligibility,omitempty"`    // Credentials created by this authenticator will have the backup eligibility (BE) flag set to this value. Defaults to false. https://w3c.github.io/webauthn/#sctn-credential-backup
	DefaultBackupState          bool                   `json:"defaultBackupState,omitempty"`          // Credentials created by this authenticator will have the backup state (BS) flag set to this value. Defaults to false. https://w3c.github.io/webauthn/#sctn-credential-backup
}

// Credential [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#type-Credential
type Credential struct {
	CredentialID         string `json:"credentialId"`
	IsResidentCredential bool   `json:"isResidentCredential"`
	RpID                 string `json:"rpId,omitempty"`              // Relying Party ID the credential is scoped to. Must be set when adding a credential.
	PrivateKey           string `json:"privateKey"`                  // The ECDSA P-256 private key in PKCS#8 format.
	UserHandle           string `json:"userHandle,omitempty"`        // An opaque byte sequence with a maximum size of 64 bytes mapping the credential to a specific user.
	SignCount            int64  `json:"signCount"`                   // Signature counter. This is incremented by one for each successful assertion. See https://w3c.github.io/webauthn/#signature-counter
	LargeBlob            string `json:"largeBlob,omitempty"`         // The large blob associated with the credential. See https://w3c.github.io/webauthn/#sctn-large-blob-extension
	BackupEligibility    bool   `json:"backupEligibility,omitempty"` // Assertions returned by this credential will have the backup eligibility (BE) flag set to this value. Defaults to the authenticator's defaultBackupEligibility value.
	BackupState          bool   `json:"backupState,omitempty"`       // Assertions returned by this credential will have the backup state (BS) flag set to this value. Defaults to the authenticator's defaultBackupState value.
}
