// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchDetectDominantLanguage = "BatchDetectDominantLanguage"

// BatchDetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectDominantLanguage for more information on using the BatchDetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectDominantLanguageRequest method.
//	req, resp := client.BatchDetectDominantLanguageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguageRequest(input *BatchDetectDominantLanguageInput) (req *request.Request, output *BatchDetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opBatchDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectDominantLanguageInput{}
	}

	output = &BatchDetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text for a batch of documents.
// For a list of languages that Amazon Comprehend can detect, see Amazon Comprehend
// Supported Languages (https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectDominantLanguage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguage(input *BatchDetectDominantLanguageInput) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	return out, req.Send()
}

// BatchDetectDominantLanguageWithContext is the same as BatchDetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectDominantLanguageWithContext(ctx aws.Context, input *BatchDetectDominantLanguageInput, opts ...request.Option) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectEntities = "BatchDetectEntities"

// BatchDetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectEntities for more information on using the BatchDetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectEntitiesRequest method.
//	req, resp := client.BatchDetectEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntitiesRequest(input *BatchDetectEntitiesInput) (req *request.Request, output *BatchDetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectEntitiesInput{}
	}

	output = &BatchDetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectEntities API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for named entities and returns
// information about them. For more information about named entities, see Entities
// (https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html) in the
// Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectEntities for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntities(input *BatchDetectEntitiesInput) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	return out, req.Send()
}

// BatchDetectEntitiesWithContext is the same as BatchDetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectEntitiesWithContext(ctx aws.Context, input *BatchDetectEntitiesInput, opts ...request.Option) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectKeyPhrases = "BatchDetectKeyPhrases"

// BatchDetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectKeyPhrases for more information on using the BatchDetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectKeyPhrasesRequest method.
//	req, resp := client.BatchDetectKeyPhrasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrasesRequest(input *BatchDetectKeyPhrasesInput) (req *request.Request, output *BatchDetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectKeyPhrasesInput{}
	}

	output = &BatchDetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in a batch of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectKeyPhrases for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrases(input *BatchDetectKeyPhrasesInput) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// BatchDetectKeyPhrasesWithContext is the same as BatchDetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectKeyPhrasesWithContext(ctx aws.Context, input *BatchDetectKeyPhrasesInput, opts ...request.Option) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSentiment = "BatchDetectSentiment"

// BatchDetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSentiment for more information on using the BatchDetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectSentimentRequest method.
//	req, resp := client.BatchDetectSentimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentimentRequest(input *BatchDetectSentimentInput) (req *request.Request, output *BatchDetectSentimentOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSentimentInput{}
	}

	output = &BatchDetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSentiment API operation for Amazon Comprehend.
//
// Inspects a batch of documents and returns an inference of the prevailing
// sentiment, POSITIVE, NEUTRAL, MIXED, or NEGATIVE, in each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSentiment for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentiment(input *BatchDetectSentimentInput) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	return out, req.Send()
}

// BatchDetectSentimentWithContext is the same as BatchDetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSentimentWithContext(ctx aws.Context, input *BatchDetectSentimentInput, opts ...request.Option) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSyntax = "BatchDetectSyntax"

// BatchDetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSyntax for more information on using the BatchDetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectSyntaxRequest method.
//	req, resp := client.BatchDetectSyntaxRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntaxRequest(input *BatchDetectSyntaxInput) (req *request.Request, output *BatchDetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSyntaxInput{}
	}

	output = &BatchDetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSyntax API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for the syntax and part of speech
// of the words in the document and returns information about them. For more
// information, see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
// in the Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSyntax for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntax(input *BatchDetectSyntaxInput) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	return out, req.Send()
}

// BatchDetectSyntaxWithContext is the same as BatchDetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSyntaxWithContext(ctx aws.Context, input *BatchDetectSyntaxInput, opts ...request.Option) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectTargetedSentiment = "BatchDetectTargetedSentiment"

// BatchDetectTargetedSentimentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectTargetedSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectTargetedSentiment for more information on using the BatchDetectTargetedSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDetectTargetedSentimentRequest method.
//	req, resp := client.BatchDetectTargetedSentimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectTargetedSentiment
func (c *Comprehend) BatchDetectTargetedSentimentRequest(input *BatchDetectTargetedSentimentInput) (req *request.Request, output *BatchDetectTargetedSentimentOutput) {
	op := &request.Operation{
		Name:       opBatchDetectTargetedSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectTargetedSentimentInput{}
	}

	output = &BatchDetectTargetedSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectTargetedSentiment API operation for Amazon Comprehend.
//
// Inspects a batch of documents and returns a sentiment analysis for each entity
// identified in the documents.
//
// For more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectTargetedSentiment for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - BatchSizeLimitExceededException
//     The number of documents in the request exceeds the limit of 25. Try your
//     request again with fewer documents.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectTargetedSentiment
func (c *Comprehend) BatchDetectTargetedSentiment(input *BatchDetectTargetedSentimentInput) (*BatchDetectTargetedSentimentOutput, error) {
	req, out := c.BatchDetectTargetedSentimentRequest(input)
	return out, req.Send()
}

// BatchDetectTargetedSentimentWithContext is the same as BatchDetectTargetedSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectTargetedSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectTargetedSentimentWithContext(ctx aws.Context, input *BatchDetectTargetedSentimentInput, opts ...request.Option) (*BatchDetectTargetedSentimentOutput, error) {
	req, out := c.BatchDetectTargetedSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClassifyDocument = "ClassifyDocument"

// ClassifyDocumentRequest generates a "aws/request.Request" representing the
// client's request for the ClassifyDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClassifyDocument for more information on using the ClassifyDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ClassifyDocumentRequest method.
//	req, resp := client.ClassifyDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument
func (c *Comprehend) ClassifyDocumentRequest(input *ClassifyDocumentInput) (req *request.Request, output *ClassifyDocumentOutput) {
	op := &request.Operation{
		Name:       opClassifyDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClassifyDocumentInput{}
	}

	output = &ClassifyDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ClassifyDocument API operation for Amazon Comprehend.
//
// Creates a classification request to analyze a single document in real-time.
// ClassifyDocument supports the following model types:
//
//   - Custom classifier - a custom model that you have created and trained.
//     For input, you can provide plain text, a single-page document (PDF, Word,
//     or image), or Textract API output. For more information, see Custom classification
//     (https://docs.aws.amazon.com/comprehend/latest/dg/how-document-classification.html)
//     in the Amazon Comprehend Developer Guide.
//
//   - Prompt classifier - Amazon Comprehend provides a model for classifying
//     prompts. For input, you provide English plain text input. For prompt classification,
//     the response includes only the Classes field. For more information about
//     prompt classifiers, see Prompt classifiers (https://docs.aws.amazon.com/comprehend/latest/dg/prompt-classification.html)
//     in the Amazon Comprehend Developer Guide.
//
// If the system detects errors while processing a page in the input document,
// the API response includes an entry in Errors that describes the errors.
//
// If the system detects a document-level error in your input document, the
// API returns an InvalidRequestException error response. For details about
// this exception, see Errors in semi-structured documents (https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html)
// in the Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ClassifyDocument for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument
func (c *Comprehend) ClassifyDocument(input *ClassifyDocumentInput) (*ClassifyDocumentOutput, error) {
	req, out := c.ClassifyDocumentRequest(input)
	return out, req.Send()
}

// ClassifyDocumentWithContext is the same as ClassifyDocument with the addition of
// the ability to pass a context and additional request options.
//
// See ClassifyDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ClassifyDocumentWithContext(ctx aws.Context, input *ClassifyDocumentInput, opts ...request.Option) (*ClassifyDocumentOutput, error) {
	req, out := c.ClassifyDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opContainsPiiEntities = "ContainsPiiEntities"

// ContainsPiiEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the ContainsPiiEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ContainsPiiEntities for more information on using the ContainsPiiEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ContainsPiiEntitiesRequest method.
//	req, resp := client.ContainsPiiEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities
func (c *Comprehend) ContainsPiiEntitiesRequest(input *ContainsPiiEntitiesInput) (req *request.Request, output *ContainsPiiEntitiesOutput) {
	op := &request.Operation{
		Name:       opContainsPiiEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContainsPiiEntitiesInput{}
	}

	output = &ContainsPiiEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ContainsPiiEntities API operation for Amazon Comprehend.
//
// Analyzes input text for the presence of personally identifiable information
// (PII) and returns the labels of identified PII entity types such as name,
// address, bank account number, or phone number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ContainsPiiEntities for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ContainsPiiEntities
func (c *Comprehend) ContainsPiiEntities(input *ContainsPiiEntitiesInput) (*ContainsPiiEntitiesOutput, error) {
	req, out := c.ContainsPiiEntitiesRequest(input)
	return out, req.Send()
}

// ContainsPiiEntitiesWithContext is the same as ContainsPiiEntities with the addition of
// the ability to pass a context and additional request options.
//
// See ContainsPiiEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ContainsPiiEntitiesWithContext(ctx aws.Context, input *ContainsPiiEntitiesInput, opts ...request.Option) (*ContainsPiiEntitiesOutput, error) {
	req, out := c.ContainsPiiEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatasetRequest method.
//	req, resp := client.CreateDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDataset
func (c *Comprehend) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Comprehend.
//
// Creates a dataset to upload training or test data for a model associated
// with a flywheel. For more information about datasets, see Flywheel overview
// (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in
// the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDataset
func (c *Comprehend) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocumentClassifier = "CreateDocumentClassifier"

// CreateDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocumentClassifier for more information on using the CreateDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDocumentClassifierRequest method.
//	req, resp := client.CreateDocumentClassifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier
func (c *Comprehend) CreateDocumentClassifierRequest(input *CreateDocumentClassifierInput) (req *request.Request, output *CreateDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opCreateDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentClassifierInput{}
	}

	output = &CreateDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocumentClassifier API operation for Amazon Comprehend.
//
// Creates a new document classifier that you can use to categorize documents.
// To create a classifier, you provide a set of training documents that are
// labeled with the categories that you want to use. For more information, see
// Training classifier models (https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html)
// in the Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateDocumentClassifier for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier
func (c *Comprehend) CreateDocumentClassifier(input *CreateDocumentClassifierInput) (*CreateDocumentClassifierOutput, error) {
	req, out := c.CreateDocumentClassifierRequest(input)
	return out, req.Send()
}

// CreateDocumentClassifierWithContext is the same as CreateDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateDocumentClassifierWithContext(ctx aws.Context, input *CreateDocumentClassifierInput, opts ...request.Option) (*CreateDocumentClassifierOutput, error) {
	req, out := c.CreateDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointRequest method.
//	req, resp := client.CreateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint
func (c *Comprehend) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon Comprehend.
//
// Creates a model-specific endpoint for synchronous inference for a previously
// trained custom model For information about endpoints, see Managing endpoints
// (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint
func (c *Comprehend) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEntityRecognizer = "CreateEntityRecognizer"

// CreateEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEntityRecognizer for more information on using the CreateEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEntityRecognizerRequest method.
//	req, resp := client.CreateEntityRecognizerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer
func (c *Comprehend) CreateEntityRecognizerRequest(input *CreateEntityRecognizerInput) (req *request.Request, output *CreateEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opCreateEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEntityRecognizerInput{}
	}

	output = &CreateEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEntityRecognizer API operation for Amazon Comprehend.
//
// Creates an entity recognizer using submitted files. After your CreateEntityRecognizer
// request is submitted, you can check job status using the DescribeEntityRecognizer
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateEntityRecognizer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer
func (c *Comprehend) CreateEntityRecognizer(input *CreateEntityRecognizerInput) (*CreateEntityRecognizerOutput, error) {
	req, out := c.CreateEntityRecognizerRequest(input)
	return out, req.Send()
}

// CreateEntityRecognizerWithContext is the same as CreateEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateEntityRecognizerWithContext(ctx aws.Context, input *CreateEntityRecognizerInput, opts ...request.Option) (*CreateEntityRecognizerOutput, error) {
	req, out := c.CreateEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlywheel = "CreateFlywheel"

// CreateFlywheelRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlywheel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlywheel for more information on using the CreateFlywheel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlywheelRequest method.
//	req, resp := client.CreateFlywheelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateFlywheel
func (c *Comprehend) CreateFlywheelRequest(input *CreateFlywheelInput) (req *request.Request, output *CreateFlywheelOutput) {
	op := &request.Operation{
		Name:       opCreateFlywheel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlywheelInput{}
	}

	output = &CreateFlywheelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlywheel API operation for Amazon Comprehend.
//
// A flywheel is an Amazon Web Services resource that orchestrates the ongoing
// training of a model for custom classification or custom entity recognition.
// You can create a flywheel to start with an existing trained model, or Comprehend
// can create and train a new model.
//
// When you create the flywheel, Comprehend creates a data lake in your account.
// The data lake holds the training data and test data for all versions of the
// model.
//
// To use a flywheel with an existing trained model, you specify the active
// model version. Comprehend copies the model's training data and test data
// into the flywheel's data lake.
//
// To use the flywheel with a new model, you need to provide a dataset for training
// data (and optional test data) when you create the flywheel.
//
// For more information about flywheels, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateFlywheel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateFlywheel
func (c *Comprehend) CreateFlywheel(input *CreateFlywheelInput) (*CreateFlywheelOutput, error) {
	req, out := c.CreateFlywheelRequest(input)
	return out, req.Send()
}

// CreateFlywheelWithContext is the same as CreateFlywheel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlywheel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateFlywheelWithContext(ctx aws.Context, input *CreateFlywheelInput, opts ...request.Option) (*CreateFlywheelOutput, error) {
	req, out := c.CreateFlywheelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocumentClassifier = "DeleteDocumentClassifier"

// DeleteDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocumentClassifier for more information on using the DeleteDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDocumentClassifierRequest method.
//	req, resp := client.DeleteDocumentClassifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier
func (c *Comprehend) DeleteDocumentClassifierRequest(input *DeleteDocumentClassifierInput) (req *request.Request, output *DeleteDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opDeleteDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentClassifierInput{}
	}

	output = &DeleteDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocumentClassifier API operation for Amazon Comprehend.
//
// # Deletes a previously created document classifier
//
// Only those classifiers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the classifier into a DELETING state,
// and it is then removed by a background job. Once removed, the classifier
// disappears from your account and is no longer available for use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteDocumentClassifier for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier
func (c *Comprehend) DeleteDocumentClassifier(input *DeleteDocumentClassifierInput) (*DeleteDocumentClassifierOutput, error) {
	req, out := c.DeleteDocumentClassifierRequest(input)
	return out, req.Send()
}

// DeleteDocumentClassifierWithContext is the same as DeleteDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteDocumentClassifierWithContext(ctx aws.Context, input *DeleteDocumentClassifierInput, opts ...request.Option) (*DeleteDocumentClassifierOutput, error) {
	req, out := c.DeleteDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointRequest method.
//	req, resp := client.DeleteEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint
func (c *Comprehend) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon Comprehend.
//
// Deletes a model-specific endpoint for a previously-trained custom model.
// All endpoints must be deleted in order for the model to be deleted. For information
// about endpoints, see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint
func (c *Comprehend) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEntityRecognizer = "DeleteEntityRecognizer"

// DeleteEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEntityRecognizer for more information on using the DeleteEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEntityRecognizerRequest method.
//	req, resp := client.DeleteEntityRecognizerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer
func (c *Comprehend) DeleteEntityRecognizerRequest(input *DeleteEntityRecognizerInput) (req *request.Request, output *DeleteEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opDeleteEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEntityRecognizerInput{}
	}

	output = &DeleteEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEntityRecognizer API operation for Amazon Comprehend.
//
// Deletes an entity recognizer.
//
// Only those recognizers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the recognizer into a DELETING state,
// and it is then removed by a background job. Once removed, the recognizer
// disappears from your account and is no longer available for use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteEntityRecognizer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer
func (c *Comprehend) DeleteEntityRecognizer(input *DeleteEntityRecognizerInput) (*DeleteEntityRecognizerOutput, error) {
	req, out := c.DeleteEntityRecognizerRequest(input)
	return out, req.Send()
}

// DeleteEntityRecognizerWithContext is the same as DeleteEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteEntityRecognizerWithContext(ctx aws.Context, input *DeleteEntityRecognizerInput, opts ...request.Option) (*DeleteEntityRecognizerOutput, error) {
	req, out := c.DeleteEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlywheel = "DeleteFlywheel"

// DeleteFlywheelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlywheel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlywheel for more information on using the DeleteFlywheel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlywheelRequest method.
//	req, resp := client.DeleteFlywheelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteFlywheel
func (c *Comprehend) DeleteFlywheelRequest(input *DeleteFlywheelInput) (req *request.Request, output *DeleteFlywheelOutput) {
	op := &request.Operation{
		Name:       opDeleteFlywheel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlywheelInput{}
	}

	output = &DeleteFlywheelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFlywheel API operation for Amazon Comprehend.
//
// Deletes a flywheel. When you delete the flywheel, Amazon Comprehend does
// not delete the data lake or the model associated with the flywheel.
//
// For more information about flywheels, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteFlywheel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteFlywheel
func (c *Comprehend) DeleteFlywheel(input *DeleteFlywheelInput) (*DeleteFlywheelOutput, error) {
	req, out := c.DeleteFlywheelRequest(input)
	return out, req.Send()
}

// DeleteFlywheelWithContext is the same as DeleteFlywheel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlywheel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteFlywheelWithContext(ctx aws.Context, input *DeleteFlywheelInput, opts ...request.Option) (*DeleteFlywheelOutput, error) {
	req, out := c.DeleteFlywheelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteResourcePolicy
func (c *Comprehend) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Amazon Comprehend.
//
// Deletes a resource-based policy that is attached to a custom model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteResourcePolicy
func (c *Comprehend) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDatasetRequest method.
//	req, resp := client.DescribeDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDataset
func (c *Comprehend) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Comprehend.
//
// Returns information about the dataset that you specify. For more information
// about datasets, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDataset
func (c *Comprehend) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentClassificationJob = "DescribeDocumentClassificationJob"

// DescribeDocumentClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentClassificationJob for more information on using the DescribeDocumentClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentClassificationJobRequest method.
//	req, resp := client.DescribeDocumentClassificationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob
func (c *Comprehend) DescribeDocumentClassificationJobRequest(input *DescribeDocumentClassificationJobInput) (req *request.Request, output *DescribeDocumentClassificationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassificationJobInput{}
	}

	output = &DescribeDocumentClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentClassificationJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a document classification job. Use this
// operation to get the status of a classification job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDocumentClassificationJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob
func (c *Comprehend) DescribeDocumentClassificationJob(input *DescribeDocumentClassificationJobInput) (*DescribeDocumentClassificationJobOutput, error) {
	req, out := c.DescribeDocumentClassificationJobRequest(input)
	return out, req.Send()
}

// DescribeDocumentClassificationJobWithContext is the same as DescribeDocumentClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDocumentClassificationJobWithContext(ctx aws.Context, input *DescribeDocumentClassificationJobInput, opts ...request.Option) (*DescribeDocumentClassificationJobOutput, error) {
	req, out := c.DescribeDocumentClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentClassifier = "DescribeDocumentClassifier"

// DescribeDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentClassifier for more information on using the DescribeDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentClassifierRequest method.
//	req, resp := client.DescribeDocumentClassifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier
func (c *Comprehend) DescribeDocumentClassifierRequest(input *DescribeDocumentClassifierInput) (req *request.Request, output *DescribeDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassifierInput{}
	}

	output = &DescribeDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentClassifier API operation for Amazon Comprehend.
//
// Gets the properties associated with a document classifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDocumentClassifier for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier
func (c *Comprehend) DescribeDocumentClassifier(input *DescribeDocumentClassifierInput) (*DescribeDocumentClassifierOutput, error) {
	req, out := c.DescribeDocumentClassifierRequest(input)
	return out, req.Send()
}

// DescribeDocumentClassifierWithContext is the same as DescribeDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDocumentClassifierWithContext(ctx aws.Context, input *DescribeDocumentClassifierInput, opts ...request.Option) (*DescribeDocumentClassifierOutput, error) {
	req, out := c.DescribeDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDominantLanguageDetectionJob = "DescribeDominantLanguageDetectionJob"

// DescribeDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDominantLanguageDetectionJob for more information on using the DescribeDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDominantLanguageDetectionJobRequest method.
//	req, resp := client.DescribeDominantLanguageDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJobRequest(input *DescribeDominantLanguageDetectionJobInput) (req *request.Request, output *DescribeDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDominantLanguageDetectionJobInput{}
	}

	output = &DescribeDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a dominant language detection job. Use
// this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJob(input *DescribeDominantLanguageDetectionJobInput) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeDominantLanguageDetectionJobWithContext is the same as DescribeDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDominantLanguageDetectionJobWithContext(ctx aws.Context, input *DescribeDominantLanguageDetectionJobInput, opts ...request.Option) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEndpointRequest method.
//	req, resp := client.DescribeEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint
func (c *Comprehend) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon Comprehend.
//
// Gets the properties associated with a specific endpoint. Use this operation
// to get the status of an endpoint. For information about endpoints, see Managing
// endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint
func (c *Comprehend) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntitiesDetectionJob = "DescribeEntitiesDetectionJob"

// DescribeEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntitiesDetectionJob for more information on using the DescribeEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEntitiesDetectionJobRequest method.
//	req, resp := client.DescribeEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJobRequest(input *DescribeEntitiesDetectionJobInput) (req *request.Request, output *DescribeEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionJobInput{}
	}

	output = &DescribeEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with an entities detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJob(input *DescribeEntitiesDetectionJobInput) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeEntitiesDetectionJobWithContext is the same as DescribeEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEntitiesDetectionJobWithContext(ctx aws.Context, input *DescribeEntitiesDetectionJobInput, opts ...request.Option) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntityRecognizer = "DescribeEntityRecognizer"

// DescribeEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntityRecognizer for more information on using the DescribeEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEntityRecognizerRequest method.
//	req, resp := client.DescribeEntityRecognizerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer
func (c *Comprehend) DescribeEntityRecognizerRequest(input *DescribeEntityRecognizerInput) (req *request.Request, output *DescribeEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opDescribeEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntityRecognizerInput{}
	}

	output = &DescribeEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntityRecognizer API operation for Amazon Comprehend.
//
// Provides details about an entity recognizer including status, S3 buckets
// containing training data, recognizer metadata, metrics, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEntityRecognizer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer
func (c *Comprehend) DescribeEntityRecognizer(input *DescribeEntityRecognizerInput) (*DescribeEntityRecognizerOutput, error) {
	req, out := c.DescribeEntityRecognizerRequest(input)
	return out, req.Send()
}

// DescribeEntityRecognizerWithContext is the same as DescribeEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEntityRecognizerWithContext(ctx aws.Context, input *DescribeEntityRecognizerInput, opts ...request.Option) (*DescribeEntityRecognizerOutput, error) {
	req, out := c.DescribeEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventsDetectionJob = "DescribeEventsDetectionJob"

// DescribeEventsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventsDetectionJob for more information on using the DescribeEventsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventsDetectionJobRequest method.
//	req, resp := client.DescribeEventsDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob
func (c *Comprehend) DescribeEventsDetectionJobRequest(input *DescribeEventsDetectionJobInput) (req *request.Request, output *DescribeEventsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeEventsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventsDetectionJobInput{}
	}

	output = &DescribeEventsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventsDetectionJob API operation for Amazon Comprehend.
//
// Gets the status and details of an events detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEventsDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob
func (c *Comprehend) DescribeEventsDetectionJob(input *DescribeEventsDetectionJobInput) (*DescribeEventsDetectionJobOutput, error) {
	req, out := c.DescribeEventsDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeEventsDetectionJobWithContext is the same as DescribeEventsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEventsDetectionJobWithContext(ctx aws.Context, input *DescribeEventsDetectionJobInput, opts ...request.Option) (*DescribeEventsDetectionJobOutput, error) {
	req, out := c.DescribeEventsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlywheel = "DescribeFlywheel"

// DescribeFlywheelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlywheel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlywheel for more information on using the DescribeFlywheel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFlywheelRequest method.
//	req, resp := client.DescribeFlywheelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheel
func (c *Comprehend) DescribeFlywheelRequest(input *DescribeFlywheelInput) (req *request.Request, output *DescribeFlywheelOutput) {
	op := &request.Operation{
		Name:       opDescribeFlywheel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlywheelInput{}
	}

	output = &DescribeFlywheelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlywheel API operation for Amazon Comprehend.
//
// Provides configuration information about the flywheel. For more information
// about flywheels, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeFlywheel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheel
func (c *Comprehend) DescribeFlywheel(input *DescribeFlywheelInput) (*DescribeFlywheelOutput, error) {
	req, out := c.DescribeFlywheelRequest(input)
	return out, req.Send()
}

// DescribeFlywheelWithContext is the same as DescribeFlywheel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlywheel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeFlywheelWithContext(ctx aws.Context, input *DescribeFlywheelInput, opts ...request.Option) (*DescribeFlywheelOutput, error) {
	req, out := c.DescribeFlywheelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlywheelIteration = "DescribeFlywheelIteration"

// DescribeFlywheelIterationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlywheelIteration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlywheelIteration for more information on using the DescribeFlywheelIteration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFlywheelIterationRequest method.
//	req, resp := client.DescribeFlywheelIterationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheelIteration
func (c *Comprehend) DescribeFlywheelIterationRequest(input *DescribeFlywheelIterationInput) (req *request.Request, output *DescribeFlywheelIterationOutput) {
	op := &request.Operation{
		Name:       opDescribeFlywheelIteration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlywheelIterationInput{}
	}

	output = &DescribeFlywheelIterationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlywheelIteration API operation for Amazon Comprehend.
//
// Retrieve the configuration properties of a flywheel iteration. For more information
// about flywheels, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeFlywheelIteration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeFlywheelIteration
func (c *Comprehend) DescribeFlywheelIteration(input *DescribeFlywheelIterationInput) (*DescribeFlywheelIterationOutput, error) {
	req, out := c.DescribeFlywheelIterationRequest(input)
	return out, req.Send()
}

// DescribeFlywheelIterationWithContext is the same as DescribeFlywheelIteration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlywheelIteration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeFlywheelIterationWithContext(ctx aws.Context, input *DescribeFlywheelIterationInput, opts ...request.Option) (*DescribeFlywheelIterationOutput, error) {
	req, out := c.DescribeFlywheelIterationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKeyPhrasesDetectionJob = "DescribeKeyPhrasesDetectionJob"

// DescribeKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeyPhrasesDetectionJob for more information on using the DescribeKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeKeyPhrasesDetectionJobRequest method.
//	req, resp := client.DescribeKeyPhrasesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJobRequest(input *DescribeKeyPhrasesDetectionJobInput) (req *request.Request, output *DescribeKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPhrasesDetectionJobInput{}
	}

	output = &DescribeKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a key phrases detection job. Use this
// operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJob(input *DescribeKeyPhrasesDetectionJobInput) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeKeyPhrasesDetectionJobWithContext is the same as DescribeKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *DescribeKeyPhrasesDetectionJobInput, opts ...request.Option) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePiiEntitiesDetectionJob = "DescribePiiEntitiesDetectionJob"

// DescribePiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribePiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePiiEntitiesDetectionJob for more information on using the DescribePiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePiiEntitiesDetectionJobRequest method.
//	req, resp := client.DescribePiiEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob
func (c *Comprehend) DescribePiiEntitiesDetectionJobRequest(input *DescribePiiEntitiesDetectionJobInput) (req *request.Request, output *DescribePiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribePiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePiiEntitiesDetectionJobInput{}
	}

	output = &DescribePiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a PII entities detection job. For example,
// you can use this operation to get the job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribePiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob
func (c *Comprehend) DescribePiiEntitiesDetectionJob(input *DescribePiiEntitiesDetectionJobInput) (*DescribePiiEntitiesDetectionJobOutput, error) {
	req, out := c.DescribePiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribePiiEntitiesDetectionJobWithContext is the same as DescribePiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribePiiEntitiesDetectionJobWithContext(ctx aws.Context, input *DescribePiiEntitiesDetectionJobInput, opts ...request.Option) (*DescribePiiEntitiesDetectionJobOutput, error) {
	req, out := c.DescribePiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourcePolicy = "DescribeResourcePolicy"

// DescribeResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourcePolicy for more information on using the DescribeResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourcePolicyRequest method.
//	req, resp := client.DescribeResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeResourcePolicy
func (c *Comprehend) DescribeResourcePolicyRequest(input *DescribeResourcePolicyInput) (req *request.Request, output *DescribeResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourcePolicyInput{}
	}

	output = &DescribeResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourcePolicy API operation for Amazon Comprehend.
//
// Gets the details of a resource-based policy that is attached to a custom
// model, including the JSON body of the policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeResourcePolicy
func (c *Comprehend) DescribeResourcePolicy(input *DescribeResourcePolicyInput) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	return out, req.Send()
}

// DescribeResourcePolicyWithContext is the same as DescribeResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeResourcePolicyWithContext(ctx aws.Context, input *DescribeResourcePolicyInput, opts ...request.Option) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSentimentDetectionJob = "DescribeSentimentDetectionJob"

// DescribeSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSentimentDetectionJob for more information on using the DescribeSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSentimentDetectionJobRequest method.
//	req, resp := client.DescribeSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJobRequest(input *DescribeSentimentDetectionJobInput) (req *request.Request, output *DescribeSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSentimentDetectionJobInput{}
	}

	output = &DescribeSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSentimentDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a sentiment detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJob(input *DescribeSentimentDetectionJobInput) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeSentimentDetectionJobWithContext is the same as DescribeSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeSentimentDetectionJobWithContext(ctx aws.Context, input *DescribeSentimentDetectionJobInput, opts ...request.Option) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTargetedSentimentDetectionJob = "DescribeTargetedSentimentDetectionJob"

// DescribeTargetedSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTargetedSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTargetedSentimentDetectionJob for more information on using the DescribeTargetedSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTargetedSentimentDetectionJobRequest method.
//	req, resp := client.DescribeTargetedSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTargetedSentimentDetectionJob
func (c *Comprehend) DescribeTargetedSentimentDetectionJobRequest(input *DescribeTargetedSentimentDetectionJobInput) (req *request.Request, output *DescribeTargetedSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTargetedSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTargetedSentimentDetectionJobInput{}
	}

	output = &DescribeTargetedSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTargetedSentimentDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a targeted sentiment detection job. Use
// this operation to get the status of the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeTargetedSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTargetedSentimentDetectionJob
func (c *Comprehend) DescribeTargetedSentimentDetectionJob(input *DescribeTargetedSentimentDetectionJobInput) (*DescribeTargetedSentimentDetectionJobOutput, error) {
	req, out := c.DescribeTargetedSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeTargetedSentimentDetectionJobWithContext is the same as DescribeTargetedSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTargetedSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeTargetedSentimentDetectionJobWithContext(ctx aws.Context, input *DescribeTargetedSentimentDetectionJobInput, opts ...request.Option) (*DescribeTargetedSentimentDetectionJobOutput, error) {
	req, out := c.DescribeTargetedSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicsDetectionJob = "DescribeTopicsDetectionJob"

// DescribeTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicsDetectionJob for more information on using the DescribeTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTopicsDetectionJobRequest method.
//	req, resp := client.DescribeTopicsDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJobRequest(input *DescribeTopicsDetectionJobInput) (req *request.Request, output *DescribeTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsDetectionJobInput{}
	}

	output = &DescribeTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicsDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a topic detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeTopicsDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJob(input *DescribeTopicsDetectionJobInput) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeTopicsDetectionJobWithContext is the same as DescribeTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeTopicsDetectionJobWithContext(ctx aws.Context, input *DescribeTopicsDetectionJobInput, opts ...request.Option) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDominantLanguage = "DetectDominantLanguage"

// DetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the DetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDominantLanguage for more information on using the DetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectDominantLanguageRequest method.
//	req, resp := client.DetectDominantLanguageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguageRequest(input *DetectDominantLanguageInput) (req *request.Request, output *DetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDominantLanguageInput{}
	}

	output = &DetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text. For a list of languages
// that Amazon Comprehend can detect, see Amazon Comprehend Supported Languages
// (https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectDominantLanguage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguage(input *DetectDominantLanguageInput) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	return out, req.Send()
}

// DetectDominantLanguageWithContext is the same as DetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectDominantLanguageWithContext(ctx aws.Context, input *DetectDominantLanguageInput, opts ...request.Option) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectEntitiesRequest method.
//	req, resp := client.DetectEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for Amazon Comprehend.
//
// Detects named entities in input text when you use the pre-trained model.
// Detects custom entities if you have a custom entity recognition model.
//
// When detecting named entities using the pre-trained model, use plain text
// as the input. For more information about named entities, see Entities (https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html)
// in the Comprehend Developer Guide.
//
// When you use a custom entity recognition model, you can input plain text
// or you can upload a single-page input document (text, PDF, Word, or image).
//
// If the system detects errors while processing a page in the input document,
// the API response includes an entry in Errors for each error.
//
// If the system detects a document-level error in your input document, the
// API returns an InvalidRequestException error response. For details about
// this exception, see Errors in semi-structured documents (https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync-err.html)
// in the Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectEntities for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectKeyPhrases = "DetectKeyPhrases"

// DetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the DetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectKeyPhrases for more information on using the DetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectKeyPhrasesRequest method.
//	req, resp := client.DetectKeyPhrasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrasesRequest(input *DetectKeyPhrasesInput) (req *request.Request, output *DetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectKeyPhrasesInput{}
	}

	output = &DetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in the text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectKeyPhrases for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrases(input *DetectKeyPhrasesInput) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// DetectKeyPhrasesWithContext is the same as DetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See DetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectKeyPhrasesWithContext(ctx aws.Context, input *DetectKeyPhrasesInput, opts ...request.Option) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectPiiEntities = "DetectPiiEntities"

// DetectPiiEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectPiiEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectPiiEntities for more information on using the DetectPiiEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectPiiEntitiesRequest method.
//	req, resp := client.DetectPiiEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities
func (c *Comprehend) DetectPiiEntitiesRequest(input *DetectPiiEntitiesInput) (req *request.Request, output *DetectPiiEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectPiiEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectPiiEntitiesInput{}
	}

	output = &DetectPiiEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectPiiEntities API operation for Amazon Comprehend.
//
// Inspects the input text for entities that contain personally identifiable
// information (PII) and returns information about them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectPiiEntities for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities
func (c *Comprehend) DetectPiiEntities(input *DetectPiiEntitiesInput) (*DetectPiiEntitiesOutput, error) {
	req, out := c.DetectPiiEntitiesRequest(input)
	return out, req.Send()
}

// DetectPiiEntitiesWithContext is the same as DetectPiiEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectPiiEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectPiiEntitiesWithContext(ctx aws.Context, input *DetectPiiEntitiesInput, opts ...request.Option) (*DetectPiiEntitiesOutput, error) {
	req, out := c.DetectPiiEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSentiment = "DetectSentiment"

// DetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the DetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSentiment for more information on using the DetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectSentimentRequest method.
//	req, resp := client.DetectSentimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentimentRequest(input *DetectSentimentInput) (req *request.Request, output *DetectSentimentOutput) {
	op := &request.Operation{
		Name:       opDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSentimentInput{}
	}

	output = &DetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSentiment API operation for Amazon Comprehend.
//
// Inspects text and returns an inference of the prevailing sentiment (POSITIVE,
// NEUTRAL, MIXED, or NEGATIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSentiment for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentiment(input *DetectSentimentInput) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	return out, req.Send()
}

// DetectSentimentWithContext is the same as DetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSentimentWithContext(ctx aws.Context, input *DetectSentimentInput, opts ...request.Option) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSyntax = "DetectSyntax"

// DetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the DetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSyntax for more information on using the DetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectSyntaxRequest method.
//	req, resp := client.DetectSyntaxRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntaxRequest(input *DetectSyntaxInput) (req *request.Request, output *DetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSyntaxInput{}
	}

	output = &DetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSyntax API operation for Amazon Comprehend.
//
// Inspects text for syntax and the part of speech of words in the document.
// For more information, see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
// in the Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSyntax for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntax(input *DetectSyntaxInput) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	return out, req.Send()
}

// DetectSyntaxWithContext is the same as DetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSyntaxWithContext(ctx aws.Context, input *DetectSyntaxInput, opts ...request.Option) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectTargetedSentiment = "DetectTargetedSentiment"

// DetectTargetedSentimentRequest generates a "aws/request.Request" representing the
// client's request for the DetectTargetedSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectTargetedSentiment for more information on using the DetectTargetedSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectTargetedSentimentRequest method.
//	req, resp := client.DetectTargetedSentimentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectTargetedSentiment
func (c *Comprehend) DetectTargetedSentimentRequest(input *DetectTargetedSentimentInput) (req *request.Request, output *DetectTargetedSentimentOutput) {
	op := &request.Operation{
		Name:       opDetectTargetedSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectTargetedSentimentInput{}
	}

	output = &DetectTargetedSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectTargetedSentiment API operation for Amazon Comprehend.
//
// Inspects the input text and returns a sentiment analysis for each entity
// identified in the text.
//
// For more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectTargetedSentiment for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectTargetedSentiment
func (c *Comprehend) DetectTargetedSentiment(input *DetectTargetedSentimentInput) (*DetectTargetedSentimentOutput, error) {
	req, out := c.DetectTargetedSentimentRequest(input)
	return out, req.Send()
}

// DetectTargetedSentimentWithContext is the same as DetectTargetedSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectTargetedSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectTargetedSentimentWithContext(ctx aws.Context, input *DetectTargetedSentimentInput, opts ...request.Option) (*DetectTargetedSentimentOutput, error) {
	req, out := c.DetectTargetedSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectToxicContent = "DetectToxicContent"

// DetectToxicContentRequest generates a "aws/request.Request" representing the
// client's request for the DetectToxicContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectToxicContent for more information on using the DetectToxicContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectToxicContentRequest method.
//	req, resp := client.DetectToxicContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectToxicContent
func (c *Comprehend) DetectToxicContentRequest(input *DetectToxicContentInput) (req *request.Request, output *DetectToxicContentOutput) {
	op := &request.Operation{
		Name:       opDetectToxicContent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectToxicContentInput{}
	}

	output = &DetectToxicContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectToxicContent API operation for Amazon Comprehend.
//
// Performs toxicity analysis on the list of text strings that you provide as
// input. The analysis uses the order of strings in the list to determine context
// when predicting toxicity. The API response contains a results list that matches
// the size of the input list. For more information about toxicity detection,
// see Toxicity detection (https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html)
// in the Amazon Comprehend Developer Guide
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectToxicContent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TextSizeLimitExceededException
//     The size of the input text exceeds the limit. Use a smaller document.
//
//   - UnsupportedLanguageException
//     Amazon Comprehend can't process the language of the input text. For custom
//     entity recognition APIs, only English, Spanish, French, Italian, German,
//     or Portuguese are accepted. For a list of supported languages, Supported
//     languages (https://docs.aws.amazon.com/comprehend/latest/dg/supported-languages.html)
//     in the Comprehend Developer Guide.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectToxicContent
func (c *Comprehend) DetectToxicContent(input *DetectToxicContentInput) (*DetectToxicContentOutput, error) {
	req, out := c.DetectToxicContentRequest(input)
	return out, req.Send()
}

// DetectToxicContentWithContext is the same as DetectToxicContent with the addition of
// the ability to pass a context and additional request options.
//
// See DetectToxicContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectToxicContentWithContext(ctx aws.Context, input *DetectToxicContentInput, opts ...request.Option) (*DetectToxicContentOutput, error) {
	req, out := c.DetectToxicContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportModel = "ImportModel"

// ImportModelRequest generates a "aws/request.Request" representing the
// client's request for the ImportModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportModel for more information on using the ImportModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportModelRequest method.
//	req, resp := client.ImportModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ImportModel
func (c *Comprehend) ImportModelRequest(input *ImportModelInput) (req *request.Request, output *ImportModelOutput) {
	op := &request.Operation{
		Name:       opImportModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportModelInput{}
	}

	output = &ImportModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportModel API operation for Amazon Comprehend.
//
// Creates a new custom model that replicates a source custom model that you
// import. The source model can be in your Amazon Web Services account or another
// one.
//
// If the source model is in another Amazon Web Services account, then it must
// have a resource-based policy that authorizes you to import it.
//
// The source model must be in the same Amazon Web Services Region that you're
// using when you import. You can't import a model that's in a different Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ImportModel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ImportModel
func (c *Comprehend) ImportModel(input *ImportModelInput) (*ImportModelOutput, error) {
	req, out := c.ImportModelRequest(input)
	return out, req.Send()
}

// ImportModelWithContext is the same as ImportModel with the addition of
// the ability to pass a context and additional request options.
//
// See ImportModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ImportModelWithContext(ctx aws.Context, input *ImportModelInput, opts ...request.Option) (*ImportModelOutput, error) {
	req, out := c.ImportModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasets for more information on using the ListDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatasetsRequest method.
//	req, resp := client.ListDatasetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets
func (c *Comprehend) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	output = &ListDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasets API operation for Amazon Comprehend.
//
// List the datasets that you have configured in this Region. For more information
// about datasets, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDatasets for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDatasets
func (c *Comprehend) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	return out, req.Send()
}

// ListDatasetsWithContext is the same as ListDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDatasetsWithContext(ctx aws.Context, input *ListDatasetsInput, opts ...request.Option) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetsPages iterates over the pages of a ListDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatasets operation.
//	pageNum := 0
//	err := client.ListDatasetsPages(params,
//	    func(page *comprehend.ListDatasetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListDatasetsPages(input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool) error {
	return c.ListDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetsPagesWithContext same as ListDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDatasetsPagesWithContext(ctx aws.Context, input *ListDatasetsInput, fn func(*ListDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocumentClassificationJobs = "ListDocumentClassificationJobs"

// ListDocumentClassificationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentClassificationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentClassificationJobs for more information on using the ListDocumentClassificationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentClassificationJobsRequest method.
//	req, resp := client.ListDocumentClassificationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs
func (c *Comprehend) ListDocumentClassificationJobsRequest(input *ListDocumentClassificationJobsInput) (req *request.Request, output *ListDocumentClassificationJobsOutput) {
	op := &request.Operation{
		Name:       opListDocumentClassificationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentClassificationJobsInput{}
	}

	output = &ListDocumentClassificationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentClassificationJobs API operation for Amazon Comprehend.
//
// Gets a list of the documentation classification jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDocumentClassificationJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs
func (c *Comprehend) ListDocumentClassificationJobs(input *ListDocumentClassificationJobsInput) (*ListDocumentClassificationJobsOutput, error) {
	req, out := c.ListDocumentClassificationJobsRequest(input)
	return out, req.Send()
}

// ListDocumentClassificationJobsWithContext is the same as ListDocumentClassificationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentClassificationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassificationJobsWithContext(ctx aws.Context, input *ListDocumentClassificationJobsInput, opts ...request.Option) (*ListDocumentClassificationJobsOutput, error) {
	req, out := c.ListDocumentClassificationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentClassificationJobsPages iterates over the pages of a ListDocumentClassificationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentClassificationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocumentClassificationJobs operation.
//	pageNum := 0
//	err := client.ListDocumentClassificationJobsPages(params,
//	    func(page *comprehend.ListDocumentClassificationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListDocumentClassificationJobsPages(input *ListDocumentClassificationJobsInput, fn func(*ListDocumentClassificationJobsOutput, bool) bool) error {
	return c.ListDocumentClassificationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentClassificationJobsPagesWithContext same as ListDocumentClassificationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassificationJobsPagesWithContext(ctx aws.Context, input *ListDocumentClassificationJobsInput, fn func(*ListDocumentClassificationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentClassificationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentClassificationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentClassificationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocumentClassifierSummaries = "ListDocumentClassifierSummaries"

// ListDocumentClassifierSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentClassifierSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentClassifierSummaries for more information on using the ListDocumentClassifierSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentClassifierSummariesRequest method.
//	req, resp := client.ListDocumentClassifierSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries
func (c *Comprehend) ListDocumentClassifierSummariesRequest(input *ListDocumentClassifierSummariesInput) (req *request.Request, output *ListDocumentClassifierSummariesOutput) {
	op := &request.Operation{
		Name:       opListDocumentClassifierSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentClassifierSummariesInput{}
	}

	output = &ListDocumentClassifierSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentClassifierSummaries API operation for Amazon Comprehend.
//
// # Gets a list of summaries of the document classifiers that you have created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDocumentClassifierSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifierSummaries
func (c *Comprehend) ListDocumentClassifierSummaries(input *ListDocumentClassifierSummariesInput) (*ListDocumentClassifierSummariesOutput, error) {
	req, out := c.ListDocumentClassifierSummariesRequest(input)
	return out, req.Send()
}

// ListDocumentClassifierSummariesWithContext is the same as ListDocumentClassifierSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentClassifierSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifierSummariesWithContext(ctx aws.Context, input *ListDocumentClassifierSummariesInput, opts ...request.Option) (*ListDocumentClassifierSummariesOutput, error) {
	req, out := c.ListDocumentClassifierSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentClassifierSummariesPages iterates over the pages of a ListDocumentClassifierSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentClassifierSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocumentClassifierSummaries operation.
//	pageNum := 0
//	err := client.ListDocumentClassifierSummariesPages(params,
//	    func(page *comprehend.ListDocumentClassifierSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListDocumentClassifierSummariesPages(input *ListDocumentClassifierSummariesInput, fn func(*ListDocumentClassifierSummariesOutput, bool) bool) error {
	return c.ListDocumentClassifierSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentClassifierSummariesPagesWithContext same as ListDocumentClassifierSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifierSummariesPagesWithContext(ctx aws.Context, input *ListDocumentClassifierSummariesInput, fn func(*ListDocumentClassifierSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentClassifierSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentClassifierSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentClassifierSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocumentClassifiers = "ListDocumentClassifiers"

// ListDocumentClassifiersRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentClassifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentClassifiers for more information on using the ListDocumentClassifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentClassifiersRequest method.
//	req, resp := client.ListDocumentClassifiersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers
func (c *Comprehend) ListDocumentClassifiersRequest(input *ListDocumentClassifiersInput) (req *request.Request, output *ListDocumentClassifiersOutput) {
	op := &request.Operation{
		Name:       opListDocumentClassifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentClassifiersInput{}
	}

	output = &ListDocumentClassifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentClassifiers API operation for Amazon Comprehend.
//
// Gets a list of the document classifiers that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDocumentClassifiers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers
func (c *Comprehend) ListDocumentClassifiers(input *ListDocumentClassifiersInput) (*ListDocumentClassifiersOutput, error) {
	req, out := c.ListDocumentClassifiersRequest(input)
	return out, req.Send()
}

// ListDocumentClassifiersWithContext is the same as ListDocumentClassifiers with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentClassifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifiersWithContext(ctx aws.Context, input *ListDocumentClassifiersInput, opts ...request.Option) (*ListDocumentClassifiersOutput, error) {
	req, out := c.ListDocumentClassifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentClassifiersPages iterates over the pages of a ListDocumentClassifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentClassifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocumentClassifiers operation.
//	pageNum := 0
//	err := client.ListDocumentClassifiersPages(params,
//	    func(page *comprehend.ListDocumentClassifiersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListDocumentClassifiersPages(input *ListDocumentClassifiersInput, fn func(*ListDocumentClassifiersOutput, bool) bool) error {
	return c.ListDocumentClassifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentClassifiersPagesWithContext same as ListDocumentClassifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifiersPagesWithContext(ctx aws.Context, input *ListDocumentClassifiersInput, fn func(*ListDocumentClassifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentClassifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentClassifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentClassifiersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDominantLanguageDetectionJobs = "ListDominantLanguageDetectionJobs"

// ListDominantLanguageDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDominantLanguageDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDominantLanguageDetectionJobs for more information on using the ListDominantLanguageDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDominantLanguageDetectionJobsRequest method.
//	req, resp := client.ListDominantLanguageDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobsRequest(input *ListDominantLanguageDetectionJobsInput) (req *request.Request, output *ListDominantLanguageDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListDominantLanguageDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDominantLanguageDetectionJobsInput{}
	}

	output = &ListDominantLanguageDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDominantLanguageDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the dominant language detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDominantLanguageDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobs(input *ListDominantLanguageDetectionJobsInput) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsWithContext is the same as ListDominantLanguageDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDominantLanguageDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, opts ...request.Option) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsPages iterates over the pages of a ListDominantLanguageDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDominantLanguageDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDominantLanguageDetectionJobs operation.
//	pageNum := 0
//	err := client.ListDominantLanguageDetectionJobsPages(params,
//	    func(page *comprehend.ListDominantLanguageDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListDominantLanguageDetectionJobsPages(input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool) error {
	return c.ListDominantLanguageDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDominantLanguageDetectionJobsPagesWithContext same as ListDominantLanguageDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsPagesWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDominantLanguageDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDominantLanguageDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDominantLanguageDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEndpointsRequest method.
//	req, resp := client.ListEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints
func (c *Comprehend) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon Comprehend.
//
// Gets a list of all existing endpoints that you've created. For information
// about endpoints, see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints
func (c *Comprehend) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEndpoints operation.
//	pageNum := 0
//	err := client.ListEndpointsPages(params,
//	    func(page *comprehend.ListEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntitiesDetectionJobs = "ListEntitiesDetectionJobs"

// ListEntitiesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitiesDetectionJobs for more information on using the ListEntitiesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntitiesDetectionJobsRequest method.
//	req, resp := client.ListEntitiesDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobsRequest(input *ListEntitiesDetectionJobsInput) (req *request.Request, output *ListEntitiesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesDetectionJobsInput{}
	}

	output = &ListEntitiesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntitiesDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobs(input *ListEntitiesDetectionJobsInput) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListEntitiesDetectionJobsWithContext is the same as ListEntitiesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitiesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, opts ...request.Option) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesDetectionJobsPages iterates over the pages of a ListEntitiesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitiesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntitiesDetectionJobs operation.
//	pageNum := 0
//	err := client.ListEntitiesDetectionJobsPages(params,
//	    func(page *comprehend.ListEntitiesDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListEntitiesDetectionJobsPages(input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool) error {
	return c.ListEntitiesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesDetectionJobsPagesWithContext same as ListEntitiesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsPagesWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitiesDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntityRecognizerSummaries = "ListEntityRecognizerSummaries"

// ListEntityRecognizerSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListEntityRecognizerSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntityRecognizerSummaries for more information on using the ListEntityRecognizerSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntityRecognizerSummariesRequest method.
//	req, resp := client.ListEntityRecognizerSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries
func (c *Comprehend) ListEntityRecognizerSummariesRequest(input *ListEntityRecognizerSummariesInput) (req *request.Request, output *ListEntityRecognizerSummariesOutput) {
	op := &request.Operation{
		Name:       opListEntityRecognizerSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntityRecognizerSummariesInput{}
	}

	output = &ListEntityRecognizerSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntityRecognizerSummaries API operation for Amazon Comprehend.
//
// Gets a list of summaries for the entity recognizers that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntityRecognizerSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizerSummaries
func (c *Comprehend) ListEntityRecognizerSummaries(input *ListEntityRecognizerSummariesInput) (*ListEntityRecognizerSummariesOutput, error) {
	req, out := c.ListEntityRecognizerSummariesRequest(input)
	return out, req.Send()
}

// ListEntityRecognizerSummariesWithContext is the same as ListEntityRecognizerSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntityRecognizerSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizerSummariesWithContext(ctx aws.Context, input *ListEntityRecognizerSummariesInput, opts ...request.Option) (*ListEntityRecognizerSummariesOutput, error) {
	req, out := c.ListEntityRecognizerSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntityRecognizerSummariesPages iterates over the pages of a ListEntityRecognizerSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntityRecognizerSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntityRecognizerSummaries operation.
//	pageNum := 0
//	err := client.ListEntityRecognizerSummariesPages(params,
//	    func(page *comprehend.ListEntityRecognizerSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListEntityRecognizerSummariesPages(input *ListEntityRecognizerSummariesInput, fn func(*ListEntityRecognizerSummariesOutput, bool) bool) error {
	return c.ListEntityRecognizerSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntityRecognizerSummariesPagesWithContext same as ListEntityRecognizerSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizerSummariesPagesWithContext(ctx aws.Context, input *ListEntityRecognizerSummariesInput, fn func(*ListEntityRecognizerSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntityRecognizerSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntityRecognizerSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntityRecognizerSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntityRecognizers = "ListEntityRecognizers"

// ListEntityRecognizersRequest generates a "aws/request.Request" representing the
// client's request for the ListEntityRecognizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntityRecognizers for more information on using the ListEntityRecognizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntityRecognizersRequest method.
//	req, resp := client.ListEntityRecognizersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers
func (c *Comprehend) ListEntityRecognizersRequest(input *ListEntityRecognizersInput) (req *request.Request, output *ListEntityRecognizersOutput) {
	op := &request.Operation{
		Name:       opListEntityRecognizers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntityRecognizersInput{}
	}

	output = &ListEntityRecognizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntityRecognizers API operation for Amazon Comprehend.
//
// Gets a list of the properties of all entity recognizers that you created,
// including recognizers currently in training. Allows you to filter the list
// of recognizers based on criteria such as status and submission time. This
// call returns up to 500 entity recognizers in the list, with a default number
// of 100 recognizers in the list.
//
// The results of this list are not in any particular order. Please get the
// list and sort locally if needed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntityRecognizers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers
func (c *Comprehend) ListEntityRecognizers(input *ListEntityRecognizersInput) (*ListEntityRecognizersOutput, error) {
	req, out := c.ListEntityRecognizersRequest(input)
	return out, req.Send()
}

// ListEntityRecognizersWithContext is the same as ListEntityRecognizers with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntityRecognizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizersWithContext(ctx aws.Context, input *ListEntityRecognizersInput, opts ...request.Option) (*ListEntityRecognizersOutput, error) {
	req, out := c.ListEntityRecognizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntityRecognizersPages iterates over the pages of a ListEntityRecognizers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntityRecognizers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEntityRecognizers operation.
//	pageNum := 0
//	err := client.ListEntityRecognizersPages(params,
//	    func(page *comprehend.ListEntityRecognizersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListEntityRecognizersPages(input *ListEntityRecognizersInput, fn func(*ListEntityRecognizersOutput, bool) bool) error {
	return c.ListEntityRecognizersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntityRecognizersPagesWithContext same as ListEntityRecognizersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizersPagesWithContext(ctx aws.Context, input *ListEntityRecognizersInput, fn func(*ListEntityRecognizersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntityRecognizersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntityRecognizersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntityRecognizersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventsDetectionJobs = "ListEventsDetectionJobs"

// ListEventsDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventsDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventsDetectionJobs for more information on using the ListEventsDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventsDetectionJobsRequest method.
//	req, resp := client.ListEventsDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs
func (c *Comprehend) ListEventsDetectionJobsRequest(input *ListEventsDetectionJobsInput) (req *request.Request, output *ListEventsDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListEventsDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventsDetectionJobsInput{}
	}

	output = &ListEventsDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventsDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the events detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEventsDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs
func (c *Comprehend) ListEventsDetectionJobs(input *ListEventsDetectionJobsInput) (*ListEventsDetectionJobsOutput, error) {
	req, out := c.ListEventsDetectionJobsRequest(input)
	return out, req.Send()
}

// ListEventsDetectionJobsWithContext is the same as ListEventsDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventsDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEventsDetectionJobsWithContext(ctx aws.Context, input *ListEventsDetectionJobsInput, opts ...request.Option) (*ListEventsDetectionJobsOutput, error) {
	req, out := c.ListEventsDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventsDetectionJobsPages iterates over the pages of a ListEventsDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventsDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventsDetectionJobs operation.
//	pageNum := 0
//	err := client.ListEventsDetectionJobsPages(params,
//	    func(page *comprehend.ListEventsDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListEventsDetectionJobsPages(input *ListEventsDetectionJobsInput, fn func(*ListEventsDetectionJobsOutput, bool) bool) error {
	return c.ListEventsDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventsDetectionJobsPagesWithContext same as ListEventsDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEventsDetectionJobsPagesWithContext(ctx aws.Context, input *ListEventsDetectionJobsInput, fn func(*ListEventsDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventsDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventsDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventsDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlywheelIterationHistory = "ListFlywheelIterationHistory"

// ListFlywheelIterationHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListFlywheelIterationHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlywheelIterationHistory for more information on using the ListFlywheelIterationHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlywheelIterationHistoryRequest method.
//	req, resp := client.ListFlywheelIterationHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory
func (c *Comprehend) ListFlywheelIterationHistoryRequest(input *ListFlywheelIterationHistoryInput) (req *request.Request, output *ListFlywheelIterationHistoryOutput) {
	op := &request.Operation{
		Name:       opListFlywheelIterationHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlywheelIterationHistoryInput{}
	}

	output = &ListFlywheelIterationHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlywheelIterationHistory API operation for Amazon Comprehend.
//
// Information about the history of a flywheel iteration. For more information
// about flywheels, see Flywheel overview (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html)
// in the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListFlywheelIterationHistory for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheelIterationHistory
func (c *Comprehend) ListFlywheelIterationHistory(input *ListFlywheelIterationHistoryInput) (*ListFlywheelIterationHistoryOutput, error) {
	req, out := c.ListFlywheelIterationHistoryRequest(input)
	return out, req.Send()
}

// ListFlywheelIterationHistoryWithContext is the same as ListFlywheelIterationHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlywheelIterationHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListFlywheelIterationHistoryWithContext(ctx aws.Context, input *ListFlywheelIterationHistoryInput, opts ...request.Option) (*ListFlywheelIterationHistoryOutput, error) {
	req, out := c.ListFlywheelIterationHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlywheelIterationHistoryPages iterates over the pages of a ListFlywheelIterationHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlywheelIterationHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlywheelIterationHistory operation.
//	pageNum := 0
//	err := client.ListFlywheelIterationHistoryPages(params,
//	    func(page *comprehend.ListFlywheelIterationHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListFlywheelIterationHistoryPages(input *ListFlywheelIterationHistoryInput, fn func(*ListFlywheelIterationHistoryOutput, bool) bool) error {
	return c.ListFlywheelIterationHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlywheelIterationHistoryPagesWithContext same as ListFlywheelIterationHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListFlywheelIterationHistoryPagesWithContext(ctx aws.Context, input *ListFlywheelIterationHistoryInput, fn func(*ListFlywheelIterationHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlywheelIterationHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlywheelIterationHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlywheelIterationHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlywheels = "ListFlywheels"

// ListFlywheelsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlywheels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlywheels for more information on using the ListFlywheels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlywheelsRequest method.
//	req, resp := client.ListFlywheelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels
func (c *Comprehend) ListFlywheelsRequest(input *ListFlywheelsInput) (req *request.Request, output *ListFlywheelsOutput) {
	op := &request.Operation{
		Name:       opListFlywheels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlywheelsInput{}
	}

	output = &ListFlywheelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlywheels API operation for Amazon Comprehend.
//
// Gets a list of the flywheels that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListFlywheels for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListFlywheels
func (c *Comprehend) ListFlywheels(input *ListFlywheelsInput) (*ListFlywheelsOutput, error) {
	req, out := c.ListFlywheelsRequest(input)
	return out, req.Send()
}

// ListFlywheelsWithContext is the same as ListFlywheels with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlywheels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListFlywheelsWithContext(ctx aws.Context, input *ListFlywheelsInput, opts ...request.Option) (*ListFlywheelsOutput, error) {
	req, out := c.ListFlywheelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlywheelsPages iterates over the pages of a ListFlywheels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlywheels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlywheels operation.
//	pageNum := 0
//	err := client.ListFlywheelsPages(params,
//	    func(page *comprehend.ListFlywheelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListFlywheelsPages(input *ListFlywheelsInput, fn func(*ListFlywheelsOutput, bool) bool) error {
	return c.ListFlywheelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlywheelsPagesWithContext same as ListFlywheelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListFlywheelsPagesWithContext(ctx aws.Context, input *ListFlywheelsInput, fn func(*ListFlywheelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlywheelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlywheelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlywheelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeyPhrasesDetectionJobs = "ListKeyPhrasesDetectionJobs"

// ListKeyPhrasesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyPhrasesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyPhrasesDetectionJobs for more information on using the ListKeyPhrasesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeyPhrasesDetectionJobsRequest method.
//	req, resp := client.ListKeyPhrasesDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobsRequest(input *ListKeyPhrasesDetectionJobsInput) (req *request.Request, output *ListKeyPhrasesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListKeyPhrasesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyPhrasesDetectionJobsInput{}
	}

	output = &ListKeyPhrasesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyPhrasesDetectionJobs API operation for Amazon Comprehend.
//
// Get a list of key phrase detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListKeyPhrasesDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobs(input *ListKeyPhrasesDetectionJobsInput) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsWithContext is the same as ListKeyPhrasesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyPhrasesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, opts ...request.Option) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsPages iterates over the pages of a ListKeyPhrasesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyPhrasesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeyPhrasesDetectionJobs operation.
//	pageNum := 0
//	err := client.ListKeyPhrasesDetectionJobsPages(params,
//	    func(page *comprehend.ListKeyPhrasesDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListKeyPhrasesDetectionJobsPages(input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool) error {
	return c.ListKeyPhrasesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeyPhrasesDetectionJobsPagesWithContext same as ListKeyPhrasesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsPagesWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeyPhrasesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeyPhrasesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeyPhrasesDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPiiEntitiesDetectionJobs = "ListPiiEntitiesDetectionJobs"

// ListPiiEntitiesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListPiiEntitiesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPiiEntitiesDetectionJobs for more information on using the ListPiiEntitiesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPiiEntitiesDetectionJobsRequest method.
//	req, resp := client.ListPiiEntitiesDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs
func (c *Comprehend) ListPiiEntitiesDetectionJobsRequest(input *ListPiiEntitiesDetectionJobsInput) (req *request.Request, output *ListPiiEntitiesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListPiiEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPiiEntitiesDetectionJobsInput{}
	}

	output = &ListPiiEntitiesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPiiEntitiesDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the PII entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListPiiEntitiesDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs
func (c *Comprehend) ListPiiEntitiesDetectionJobs(input *ListPiiEntitiesDetectionJobsInput) (*ListPiiEntitiesDetectionJobsOutput, error) {
	req, out := c.ListPiiEntitiesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListPiiEntitiesDetectionJobsWithContext is the same as ListPiiEntitiesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPiiEntitiesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListPiiEntitiesDetectionJobsWithContext(ctx aws.Context, input *ListPiiEntitiesDetectionJobsInput, opts ...request.Option) (*ListPiiEntitiesDetectionJobsOutput, error) {
	req, out := c.ListPiiEntitiesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPiiEntitiesDetectionJobsPages iterates over the pages of a ListPiiEntitiesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPiiEntitiesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPiiEntitiesDetectionJobs operation.
//	pageNum := 0
//	err := client.ListPiiEntitiesDetectionJobsPages(params,
//	    func(page *comprehend.ListPiiEntitiesDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListPiiEntitiesDetectionJobsPages(input *ListPiiEntitiesDetectionJobsInput, fn func(*ListPiiEntitiesDetectionJobsOutput, bool) bool) error {
	return c.ListPiiEntitiesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPiiEntitiesDetectionJobsPagesWithContext same as ListPiiEntitiesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListPiiEntitiesDetectionJobsPagesWithContext(ctx aws.Context, input *ListPiiEntitiesDetectionJobsInput, fn func(*ListPiiEntitiesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPiiEntitiesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPiiEntitiesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPiiEntitiesDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSentimentDetectionJobs = "ListSentimentDetectionJobs"

// ListSentimentDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSentimentDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSentimentDetectionJobs for more information on using the ListSentimentDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSentimentDetectionJobsRequest method.
//	req, resp := client.ListSentimentDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobsRequest(input *ListSentimentDetectionJobsInput) (req *request.Request, output *ListSentimentDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListSentimentDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSentimentDetectionJobsInput{}
	}

	output = &ListSentimentDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSentimentDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of sentiment detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListSentimentDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobs(input *ListSentimentDetectionJobsInput) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	return out, req.Send()
}

// ListSentimentDetectionJobsWithContext is the same as ListSentimentDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSentimentDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, opts ...request.Option) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSentimentDetectionJobsPages iterates over the pages of a ListSentimentDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSentimentDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSentimentDetectionJobs operation.
//	pageNum := 0
//	err := client.ListSentimentDetectionJobsPages(params,
//	    func(page *comprehend.ListSentimentDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListSentimentDetectionJobsPages(input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool) error {
	return c.ListSentimentDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSentimentDetectionJobsPagesWithContext same as ListSentimentDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsPagesWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSentimentDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSentimentDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSentimentDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource
func (c *Comprehend) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Comprehend.
//
// Lists all tags associated with a given Amazon Comprehend resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource
func (c *Comprehend) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetedSentimentDetectionJobs = "ListTargetedSentimentDetectionJobs"

// ListTargetedSentimentDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetedSentimentDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetedSentimentDetectionJobs for more information on using the ListTargetedSentimentDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTargetedSentimentDetectionJobsRequest method.
//	req, resp := client.ListTargetedSentimentDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs
func (c *Comprehend) ListTargetedSentimentDetectionJobsRequest(input *ListTargetedSentimentDetectionJobsInput) (req *request.Request, output *ListTargetedSentimentDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListTargetedSentimentDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetedSentimentDetectionJobsInput{}
	}

	output = &ListTargetedSentimentDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetedSentimentDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of targeted sentiment detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTargetedSentimentDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTargetedSentimentDetectionJobs
func (c *Comprehend) ListTargetedSentimentDetectionJobs(input *ListTargetedSentimentDetectionJobsInput) (*ListTargetedSentimentDetectionJobsOutput, error) {
	req, out := c.ListTargetedSentimentDetectionJobsRequest(input)
	return out, req.Send()
}

// ListTargetedSentimentDetectionJobsWithContext is the same as ListTargetedSentimentDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetedSentimentDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTargetedSentimentDetectionJobsWithContext(ctx aws.Context, input *ListTargetedSentimentDetectionJobsInput, opts ...request.Option) (*ListTargetedSentimentDetectionJobsOutput, error) {
	req, out := c.ListTargetedSentimentDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTargetedSentimentDetectionJobsPages iterates over the pages of a ListTargetedSentimentDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTargetedSentimentDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTargetedSentimentDetectionJobs operation.
//	pageNum := 0
//	err := client.ListTargetedSentimentDetectionJobsPages(params,
//	    func(page *comprehend.ListTargetedSentimentDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListTargetedSentimentDetectionJobsPages(input *ListTargetedSentimentDetectionJobsInput, fn func(*ListTargetedSentimentDetectionJobsOutput, bool) bool) error {
	return c.ListTargetedSentimentDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTargetedSentimentDetectionJobsPagesWithContext same as ListTargetedSentimentDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTargetedSentimentDetectionJobsPagesWithContext(ctx aws.Context, input *ListTargetedSentimentDetectionJobsInput, fn func(*ListTargetedSentimentDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTargetedSentimentDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTargetedSentimentDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTargetedSentimentDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTopicsDetectionJobs = "ListTopicsDetectionJobs"

// ListTopicsDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicsDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicsDetectionJobs for more information on using the ListTopicsDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTopicsDetectionJobsRequest method.
//	req, resp := client.ListTopicsDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobsRequest(input *ListTopicsDetectionJobsInput) (req *request.Request, output *ListTopicsDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListTopicsDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsDetectionJobsInput{}
	}

	output = &ListTopicsDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicsDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the topic detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTopicsDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - InvalidFilterException
//     The filter specified for the operation is invalid. Specify a different filter.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobs(input *ListTopicsDetectionJobsInput) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	return out, req.Send()
}

// ListTopicsDetectionJobsWithContext is the same as ListTopicsDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicsDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, opts ...request.Option) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTopicsDetectionJobsPages iterates over the pages of a ListTopicsDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopicsDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTopicsDetectionJobs operation.
//	pageNum := 0
//	err := client.ListTopicsDetectionJobsPages(params,
//	    func(page *comprehend.ListTopicsDetectionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Comprehend) ListTopicsDetectionJobsPages(input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool) error {
	return c.ListTopicsDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTopicsDetectionJobsPagesWithContext same as ListTopicsDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsPagesWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTopicsDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTopicsDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTopicsDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/PutResourcePolicy
func (c *Comprehend) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for Amazon Comprehend.
//
// Attaches a resource-based policy to a custom model. You can use this policy
// to authorize an entity in another Amazon Web Services account to import the
// custom model, which replicates it in Amazon Comprehend in their account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/PutResourcePolicy
func (c *Comprehend) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDocumentClassificationJob = "StartDocumentClassificationJob"

// StartDocumentClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentClassificationJob for more information on using the StartDocumentClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDocumentClassificationJobRequest method.
//	req, resp := client.StartDocumentClassificationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob
func (c *Comprehend) StartDocumentClassificationJobRequest(input *StartDocumentClassificationJobInput) (req *request.Request, output *StartDocumentClassificationJobOutput) {
	op := &request.Operation{
		Name:       opStartDocumentClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentClassificationJobInput{}
	}

	output = &StartDocumentClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentClassificationJob API operation for Amazon Comprehend.
//
// Starts an asynchronous document classification job. Use the DescribeDocumentClassificationJob
// operation to track the progress of the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartDocumentClassificationJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob
func (c *Comprehend) StartDocumentClassificationJob(input *StartDocumentClassificationJobInput) (*StartDocumentClassificationJobOutput, error) {
	req, out := c.StartDocumentClassificationJobRequest(input)
	return out, req.Send()
}

// StartDocumentClassificationJobWithContext is the same as StartDocumentClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartDocumentClassificationJobWithContext(ctx aws.Context, input *StartDocumentClassificationJobInput, opts ...request.Option) (*StartDocumentClassificationJobOutput, error) {
	req, out := c.StartDocumentClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDominantLanguageDetectionJob = "StartDominantLanguageDetectionJob"

// StartDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDominantLanguageDetectionJob for more information on using the StartDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDominantLanguageDetectionJobRequest method.
//	req, resp := client.StartDominantLanguageDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJobRequest(input *StartDominantLanguageDetectionJobInput) (req *request.Request, output *StartDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDominantLanguageDetectionJobInput{}
	}

	output = &StartDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous dominant language detection job for a collection of
// documents. Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJob(input *StartDominantLanguageDetectionJobInput) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StartDominantLanguageDetectionJobWithContext is the same as StartDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StartDominantLanguageDetectionJobInput, opts ...request.Option) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEntitiesDetectionJob = "StartEntitiesDetectionJob"

// StartEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEntitiesDetectionJob for more information on using the StartEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEntitiesDetectionJobRequest method.
//	req, resp := client.StartEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJobRequest(input *StartEntitiesDetectionJobInput) (req *request.Request, output *StartEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEntitiesDetectionJobInput{}
	}

	output = &StartEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous entity detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// This API can be used for either standard entity detection or custom entity
// recognition. In order to be used for custom entity recognition, the optional
// EntityRecognizerArn must be used in order to provide access to the recognizer
// being used to detect the custom entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJob(input *StartEntitiesDetectionJobInput) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StartEntitiesDetectionJobWithContext is the same as StartEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartEntitiesDetectionJobWithContext(ctx aws.Context, input *StartEntitiesDetectionJobInput, opts ...request.Option) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEventsDetectionJob = "StartEventsDetectionJob"

// StartEventsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartEventsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEventsDetectionJob for more information on using the StartEventsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEventsDetectionJobRequest method.
//	req, resp := client.StartEventsDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob
func (c *Comprehend) StartEventsDetectionJobRequest(input *StartEventsDetectionJobInput) (req *request.Request, output *StartEventsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartEventsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEventsDetectionJobInput{}
	}

	output = &StartEventsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEventsDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous event detection job for a collection of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartEventsDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob
func (c *Comprehend) StartEventsDetectionJob(input *StartEventsDetectionJobInput) (*StartEventsDetectionJobOutput, error) {
	req, out := c.StartEventsDetectionJobRequest(input)
	return out, req.Send()
}

// StartEventsDetectionJobWithContext is the same as StartEventsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartEventsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartEventsDetectionJobWithContext(ctx aws.Context, input *StartEventsDetectionJobInput, opts ...request.Option) (*StartEventsDetectionJobOutput, error) {
	req, out := c.StartEventsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFlywheelIteration = "StartFlywheelIteration"

// StartFlywheelIterationRequest generates a "aws/request.Request" representing the
// client's request for the StartFlywheelIteration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFlywheelIteration for more information on using the StartFlywheelIteration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFlywheelIterationRequest method.
//	req, resp := client.StartFlywheelIterationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartFlywheelIteration
func (c *Comprehend) StartFlywheelIterationRequest(input *StartFlywheelIterationInput) (req *request.Request, output *StartFlywheelIterationOutput) {
	op := &request.Operation{
		Name:       opStartFlywheelIteration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFlywheelIterationInput{}
	}

	output = &StartFlywheelIterationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFlywheelIteration API operation for Amazon Comprehend.
//
// Start the flywheel iteration.This operation uses any new datasets to train
// a new model version. For more information about flywheels, see Flywheel overview
// (https://docs.aws.amazon.com/comprehend/latest/dg/flywheels-about.html) in
// the Amazon Comprehend Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartFlywheelIteration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartFlywheelIteration
func (c *Comprehend) StartFlywheelIteration(input *StartFlywheelIterationInput) (*StartFlywheelIterationOutput, error) {
	req, out := c.StartFlywheelIterationRequest(input)
	return out, req.Send()
}

// StartFlywheelIterationWithContext is the same as StartFlywheelIteration with the addition of
// the ability to pass a context and additional request options.
//
// See StartFlywheelIteration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartFlywheelIterationWithContext(ctx aws.Context, input *StartFlywheelIterationInput, opts ...request.Option) (*StartFlywheelIterationOutput, error) {
	req, out := c.StartFlywheelIterationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartKeyPhrasesDetectionJob = "StartKeyPhrasesDetectionJob"

// StartKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartKeyPhrasesDetectionJob for more information on using the StartKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartKeyPhrasesDetectionJobRequest method.
//	req, resp := client.StartKeyPhrasesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJobRequest(input *StartKeyPhrasesDetectionJobInput) (req *request.Request, output *StartKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartKeyPhrasesDetectionJobInput{}
	}

	output = &StartKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous key phrase detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJob(input *StartKeyPhrasesDetectionJobInput) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StartKeyPhrasesDetectionJobWithContext is the same as StartKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StartKeyPhrasesDetectionJobInput, opts ...request.Option) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPiiEntitiesDetectionJob = "StartPiiEntitiesDetectionJob"

// StartPiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartPiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPiiEntitiesDetectionJob for more information on using the StartPiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartPiiEntitiesDetectionJobRequest method.
//	req, resp := client.StartPiiEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob
func (c *Comprehend) StartPiiEntitiesDetectionJobRequest(input *StartPiiEntitiesDetectionJobInput) (req *request.Request, output *StartPiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartPiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPiiEntitiesDetectionJobInput{}
	}

	output = &StartPiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous PII entity detection job for a collection of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartPiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob
func (c *Comprehend) StartPiiEntitiesDetectionJob(input *StartPiiEntitiesDetectionJobInput) (*StartPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StartPiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StartPiiEntitiesDetectionJobWithContext is the same as StartPiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartPiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartPiiEntitiesDetectionJobWithContext(ctx aws.Context, input *StartPiiEntitiesDetectionJobInput, opts ...request.Option) (*StartPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StartPiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSentimentDetectionJob = "StartSentimentDetectionJob"

// StartSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSentimentDetectionJob for more information on using the StartSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSentimentDetectionJobRequest method.
//	req, resp := client.StartSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJobRequest(input *StartSentimentDetectionJobInput) (req *request.Request, output *StartSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSentimentDetectionJobInput{}
	}

	output = &StartSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSentimentDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous sentiment detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJob(input *StartSentimentDetectionJobInput) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StartSentimentDetectionJobWithContext is the same as StartSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartSentimentDetectionJobWithContext(ctx aws.Context, input *StartSentimentDetectionJobInput, opts ...request.Option) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTargetedSentimentDetectionJob = "StartTargetedSentimentDetectionJob"

// StartTargetedSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTargetedSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTargetedSentimentDetectionJob for more information on using the StartTargetedSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTargetedSentimentDetectionJobRequest method.
//	req, resp := client.StartTargetedSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTargetedSentimentDetectionJob
func (c *Comprehend) StartTargetedSentimentDetectionJobRequest(input *StartTargetedSentimentDetectionJobInput) (req *request.Request, output *StartTargetedSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartTargetedSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTargetedSentimentDetectionJobInput{}
	}

	output = &StartTargetedSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTargetedSentimentDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous targeted sentiment detection job for a collection
// of documents. Use the DescribeTargetedSentimentDetectionJob operation to
// track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartTargetedSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTargetedSentimentDetectionJob
func (c *Comprehend) StartTargetedSentimentDetectionJob(input *StartTargetedSentimentDetectionJobInput) (*StartTargetedSentimentDetectionJobOutput, error) {
	req, out := c.StartTargetedSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StartTargetedSentimentDetectionJobWithContext is the same as StartTargetedSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTargetedSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartTargetedSentimentDetectionJobWithContext(ctx aws.Context, input *StartTargetedSentimentDetectionJobInput, opts ...request.Option) (*StartTargetedSentimentDetectionJobOutput, error) {
	req, out := c.StartTargetedSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTopicsDetectionJob = "StartTopicsDetectionJob"

// StartTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTopicsDetectionJob for more information on using the StartTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTopicsDetectionJobRequest method.
//	req, resp := client.StartTopicsDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJobRequest(input *StartTopicsDetectionJobInput) (req *request.Request, output *StartTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTopicsDetectionJobInput{}
	}

	output = &StartTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTopicsDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous topic detection job. Use the DescribeTopicDetectionJob
// operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartTopicsDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJob(input *StartTopicsDetectionJobInput) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// StartTopicsDetectionJobWithContext is the same as StartTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartTopicsDetectionJobWithContext(ctx aws.Context, input *StartTopicsDetectionJobInput, opts ...request.Option) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDominantLanguageDetectionJob = "StopDominantLanguageDetectionJob"

// StopDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDominantLanguageDetectionJob for more information on using the StopDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopDominantLanguageDetectionJobRequest method.
//	req, resp := client.StopDominantLanguageDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJobRequest(input *StopDominantLanguageDetectionJobInput) (req *request.Request, output *StopDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDominantLanguageDetectionJobInput{}
	}

	output = &StopDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Stops a dominant language detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJob(input *StopDominantLanguageDetectionJobInput) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StopDominantLanguageDetectionJobWithContext is the same as StopDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StopDominantLanguageDetectionJobInput, opts ...request.Option) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEntitiesDetectionJob = "StopEntitiesDetectionJob"

// StopEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEntitiesDetectionJob for more information on using the StopEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEntitiesDetectionJobRequest method.
//	req, resp := client.StopEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJobRequest(input *StopEntitiesDetectionJobInput) (req *request.Request, output *StopEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionJobInput{}
	}

	output = &StopEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Stops an entities detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJob(input *StopEntitiesDetectionJobInput) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StopEntitiesDetectionJobWithContext is the same as StopEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopEntitiesDetectionJobWithContext(ctx aws.Context, input *StopEntitiesDetectionJobInput, opts ...request.Option) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEventsDetectionJob = "StopEventsDetectionJob"

// StopEventsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEventsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEventsDetectionJob for more information on using the StopEventsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEventsDetectionJobRequest method.
//	req, resp := client.StopEventsDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob
func (c *Comprehend) StopEventsDetectionJobRequest(input *StopEventsDetectionJobInput) (req *request.Request, output *StopEventsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopEventsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEventsDetectionJobInput{}
	}

	output = &StopEventsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEventsDetectionJob API operation for Amazon Comprehend.
//
// Stops an events detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopEventsDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob
func (c *Comprehend) StopEventsDetectionJob(input *StopEventsDetectionJobInput) (*StopEventsDetectionJobOutput, error) {
	req, out := c.StopEventsDetectionJobRequest(input)
	return out, req.Send()
}

// StopEventsDetectionJobWithContext is the same as StopEventsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEventsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopEventsDetectionJobWithContext(ctx aws.Context, input *StopEventsDetectionJobInput, opts ...request.Option) (*StopEventsDetectionJobOutput, error) {
	req, out := c.StopEventsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopKeyPhrasesDetectionJob = "StopKeyPhrasesDetectionJob"

// StopKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopKeyPhrasesDetectionJob for more information on using the StopKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopKeyPhrasesDetectionJobRequest method.
//	req, resp := client.StopKeyPhrasesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJobRequest(input *StopKeyPhrasesDetectionJobInput) (req *request.Request, output *StopKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopKeyPhrasesDetectionJobInput{}
	}

	output = &StopKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Stops a key phrases detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJob(input *StopKeyPhrasesDetectionJobInput) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StopKeyPhrasesDetectionJobWithContext is the same as StopKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StopKeyPhrasesDetectionJobInput, opts ...request.Option) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPiiEntitiesDetectionJob = "StopPiiEntitiesDetectionJob"

// StopPiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopPiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPiiEntitiesDetectionJob for more information on using the StopPiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopPiiEntitiesDetectionJobRequest method.
//	req, resp := client.StopPiiEntitiesDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob
func (c *Comprehend) StopPiiEntitiesDetectionJobRequest(input *StopPiiEntitiesDetectionJobInput) (req *request.Request, output *StopPiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopPiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPiiEntitiesDetectionJobInput{}
	}

	output = &StopPiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Stops a PII entities detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopPiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob
func (c *Comprehend) StopPiiEntitiesDetectionJob(input *StopPiiEntitiesDetectionJobInput) (*StopPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StopPiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StopPiiEntitiesDetectionJobWithContext is the same as StopPiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopPiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopPiiEntitiesDetectionJobWithContext(ctx aws.Context, input *StopPiiEntitiesDetectionJobInput, opts ...request.Option) (*StopPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StopPiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSentimentDetectionJob = "StopSentimentDetectionJob"

// StopSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSentimentDetectionJob for more information on using the StopSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopSentimentDetectionJobRequest method.
//	req, resp := client.StopSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJobRequest(input *StopSentimentDetectionJobInput) (req *request.Request, output *StopSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSentimentDetectionJobInput{}
	}

	output = &StopSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSentimentDetectionJob API operation for Amazon Comprehend.
//
// Stops a sentiment detection job in progress.
//
// If the job state is IN_PROGRESS, the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is be stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJob(input *StopSentimentDetectionJobInput) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StopSentimentDetectionJobWithContext is the same as StopSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopSentimentDetectionJobWithContext(ctx aws.Context, input *StopSentimentDetectionJobInput, opts ...request.Option) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTargetedSentimentDetectionJob = "StopTargetedSentimentDetectionJob"

// StopTargetedSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTargetedSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTargetedSentimentDetectionJob for more information on using the StopTargetedSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopTargetedSentimentDetectionJobRequest method.
//	req, resp := client.StopTargetedSentimentDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTargetedSentimentDetectionJob
func (c *Comprehend) StopTargetedSentimentDetectionJobRequest(input *StopTargetedSentimentDetectionJobInput) (req *request.Request, output *StopTargetedSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopTargetedSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTargetedSentimentDetectionJobInput{}
	}

	output = &StopTargetedSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTargetedSentimentDetectionJob API operation for Amazon Comprehend.
//
// Stops a targeted sentiment detection job in progress.
//
// If the job state is IN_PROGRESS, the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is be stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopTargetedSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - JobNotFoundException
//     The specified job was not found. Check the job ID and try again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTargetedSentimentDetectionJob
func (c *Comprehend) StopTargetedSentimentDetectionJob(input *StopTargetedSentimentDetectionJobInput) (*StopTargetedSentimentDetectionJobOutput, error) {
	req, out := c.StopTargetedSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StopTargetedSentimentDetectionJobWithContext is the same as StopTargetedSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTargetedSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopTargetedSentimentDetectionJobWithContext(ctx aws.Context, input *StopTargetedSentimentDetectionJobInput, opts ...request.Option) (*StopTargetedSentimentDetectionJobOutput, error) {
	req, out := c.StopTargetedSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingDocumentClassifier = "StopTrainingDocumentClassifier"

// StopTrainingDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingDocumentClassifier for more information on using the StopTrainingDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopTrainingDocumentClassifierRequest method.
//	req, resp := client.StopTrainingDocumentClassifierRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier
func (c *Comprehend) StopTrainingDocumentClassifierRequest(input *StopTrainingDocumentClassifierInput) (req *request.Request, output *StopTrainingDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opStopTrainingDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingDocumentClassifierInput{}
	}

	output = &StopTrainingDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingDocumentClassifier API operation for Amazon Comprehend.
//
// Stops a document classifier training job while in progress.
//
// If the training job state is TRAINING, the job is marked for termination
// and put into the STOP_REQUESTED state. If the training job completes before
// it can be stopped, it is put into the TRAINED; otherwise the training job
// is stopped and put into the STOPPED state and the service sends back an HTTP
// 200 response with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopTrainingDocumentClassifier for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier
func (c *Comprehend) StopTrainingDocumentClassifier(input *StopTrainingDocumentClassifierInput) (*StopTrainingDocumentClassifierOutput, error) {
	req, out := c.StopTrainingDocumentClassifierRequest(input)
	return out, req.Send()
}

// StopTrainingDocumentClassifierWithContext is the same as StopTrainingDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopTrainingDocumentClassifierWithContext(ctx aws.Context, input *StopTrainingDocumentClassifierInput, opts ...request.Option) (*StopTrainingDocumentClassifierOutput, error) {
	req, out := c.StopTrainingDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingEntityRecognizer = "StopTrainingEntityRecognizer"

// StopTrainingEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingEntityRecognizer for more information on using the StopTrainingEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopTrainingEntityRecognizerRequest method.
//	req, resp := client.StopTrainingEntityRecognizerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer
func (c *Comprehend) StopTrainingEntityRecognizerRequest(input *StopTrainingEntityRecognizerInput) (req *request.Request, output *StopTrainingEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opStopTrainingEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingEntityRecognizerInput{}
	}

	output = &StopTrainingEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingEntityRecognizer API operation for Amazon Comprehend.
//
// Stops an entity recognizer training job while in progress.
//
// If the training job state is TRAINING, the job is marked for termination
// and put into the STOP_REQUESTED state. If the training job completes before
// it can be stopped, it is put into the TRAINED; otherwise the training job
// is stopped and putted into the STOPPED state and the service sends back an
// HTTP 200 response with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopTrainingEntityRecognizer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer
func (c *Comprehend) StopTrainingEntityRecognizer(input *StopTrainingEntityRecognizerInput) (*StopTrainingEntityRecognizerOutput, error) {
	req, out := c.StopTrainingEntityRecognizerRequest(input)
	return out, req.Send()
}

// StopTrainingEntityRecognizerWithContext is the same as StopTrainingEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopTrainingEntityRecognizerWithContext(ctx aws.Context, input *StopTrainingEntityRecognizerInput, opts ...request.Option) (*StopTrainingEntityRecognizerOutput, error) {
	req, out := c.StopTrainingEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource
func (c *Comprehend) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Comprehend.
//
// Associates a specific tag with an Amazon Comprehend resource. A tag is a
// key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
// For example, a tag with "Sales" as the key might be added to a resource to
// indicate its use by the sales department.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ConcurrentModificationException
//     Concurrent modification of the tags associated with an Amazon Comprehend
//     resource is not supported.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource
func (c *Comprehend) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource
func (c *Comprehend) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Comprehend.
//
// Removes a specific tag associated with an Amazon Comprehend resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyTagKeysException
//     The request contains more tag keys than can be associated with a resource
//     (50 tag keys per resource).
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ConcurrentModificationException
//     Concurrent modification of the tags associated with an Amazon Comprehend
//     resource is not supported.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource
func (c *Comprehend) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEndpointRequest method.
//	req, resp := client.UpdateEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint
func (c *Comprehend) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon Comprehend.
//
// Updates information about the specified endpoint. For information about endpoints,
// see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - ResourceInUseException
//     The specified resource name is already in use. Use a different name and try
//     your request again.
//
//   - ResourceLimitExceededException
//     The maximum number of resources per account has been exceeded. Review the
//     resources, and then try your request again.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - ResourceUnavailableException
//     The specified resource is not available. Check the resource and try your
//     request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint
func (c *Comprehend) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlywheel = "UpdateFlywheel"

// UpdateFlywheelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlywheel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlywheel for more information on using the UpdateFlywheel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlywheelRequest method.
//	req, resp := client.UpdateFlywheelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateFlywheel
func (c *Comprehend) UpdateFlywheelRequest(input *UpdateFlywheelInput) (req *request.Request, output *UpdateFlywheelOutput) {
	op := &request.Operation{
		Name:       opUpdateFlywheel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFlywheelInput{}
	}

	output = &UpdateFlywheelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlywheel API operation for Amazon Comprehend.
//
// Update the configuration information for an existing flywheel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation UpdateFlywheel for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - TooManyRequestsException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - KmsKeyValidationException
//     The KMS customer managed key (CMK) entered cannot be validated. Verify the
//     key and re-enter it.
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateFlywheel
func (c *Comprehend) UpdateFlywheel(input *UpdateFlywheelInput) (*UpdateFlywheelOutput, error) {
	req, out := c.UpdateFlywheelRequest(input)
	return out, req.Send()
}

// UpdateFlywheelWithContext is the same as UpdateFlywheel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlywheel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) UpdateFlywheelWithContext(ctx aws.Context, input *UpdateFlywheelInput, opts ...request.Option) (*UpdateFlywheelOutput, error) {
	req, out := c.UpdateFlywheelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An augmented manifest file that provides training data for your custom model.
// An augmented manifest file is a labeled dataset that is produced by Amazon
// SageMaker Ground Truth.
type AugmentedManifestsListItem struct {
	_ struct{} `type:"structure"`

	// The S3 prefix to the annotation files that are referred in the augmented
	// manifest file.
	AnnotationDataS3Uri *string `type:"string"`

	// The JSON attribute that contains the annotations for your training documents.
	// The number of attribute names that you specify depends on whether your augmented
	// manifest file is the output of a single labeling job or a chained labeling
	// job.
	//
	// If your file is the output of a single labeling job, specify the LabelAttributeName
	// key that was used when the job was created in Ground Truth.
	//
	// If your file is the output of a chained labeling job, specify the LabelAttributeName
	// key for one or more jobs in the chain. Each LabelAttributeName key provides
	// the annotations from an individual job.
	//
	// AttributeNames is a required field
	AttributeNames []*string `type:"list" required:"true"`

	// The type of augmented manifest. PlainTextDocument or SemiStructuredDocument.
	// If you don't specify, the default is PlainTextDocument.
	//
	//    * PLAIN_TEXT_DOCUMENT A document type that represents any unicode text
	//    that is encoded in UTF-8.
	//
	//    * SEMI_STRUCTURED_DOCUMENT A document type with positional and structural
	//    context, like a PDF. For training with Amazon Comprehend, only PDFs are
	//    supported. For inference, Amazon Comprehend support PDFs, DOCX and TXT.
	DocumentType *string `type:"string" enum:"AugmentedManifestsDocumentTypeFormat"`

	// The Amazon S3 location of the augmented manifest file.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`

	// The S3 prefix to the source files (PDFs) that are referred to in the augmented
	// manifest file.
	SourceDocumentsS3Uri *string `type:"string"`

	// The purpose of the data you've provided in the augmented manifest. You can
	// either train or test this data. If you don't specify, the default is train.
	//
	// TRAIN - all of the documents in the manifest will be used for training. If
	// no test documents are provided, Amazon Comprehend will automatically reserve
	// a portion of the training documents for testing.
	//
	// TEST - all of the documents in the manifest will be used for testing.
	Split *string `type:"string" enum:"Split"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AugmentedManifestsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AugmentedManifestsListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AugmentedManifestsListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AugmentedManifestsListItem"}
	if s.AttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeNames"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationDataS3Uri sets the AnnotationDataS3Uri field's value.
func (s *AugmentedManifestsListItem) SetAnnotationDataS3Uri(v string) *AugmentedManifestsListItem {
	s.AnnotationDataS3Uri = &v
	return s
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *AugmentedManifestsListItem) SetAttributeNames(v []*string) *AugmentedManifestsListItem {
	s.AttributeNames = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *AugmentedManifestsListItem) SetDocumentType(v string) *AugmentedManifestsListItem {
	s.DocumentType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AugmentedManifestsListItem) SetS3Uri(v string) *AugmentedManifestsListItem {
	s.S3Uri = &v
	return s
}

// SetSourceDocumentsS3Uri sets the SourceDocumentsS3Uri field's value.
func (s *AugmentedManifestsListItem) SetSourceDocumentsS3Uri(v string) *AugmentedManifestsListItem {
	s.SourceDocumentsS3Uri = &v
	return s
}

// SetSplit sets the Split field's value.
func (s *AugmentedManifestsListItem) SetSplit(v string) *AugmentedManifestsListItem {
	s.Split = &v
	return s
}

type BatchDetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. Each document should contain at least
	// 20 characters. The maximum size of each document is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectDominantLanguageInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectDominantLanguageInput"}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectDominantLanguageInput) SetTextList(v []*string) *BatchDetectDominantLanguageInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more DominantLanguage objects describing the dominant languages in
	// the document.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectDominantLanguageItemResult) SetIndex(v int64) *BatchDetectDominantLanguageItemResult {
	s.Index = &v
	return s
}

// SetLanguages sets the Languages field's value.
func (s *BatchDetectDominantLanguageItemResult) SetLanguages(v []*DominantLanguage) *BatchDetectDominantLanguageItemResult {
	s.Languages = v
	return s
}

type BatchDetectDominantLanguageOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectDominantLanguageItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectDominantLanguageOutput) SetErrorList(v []*BatchItemError) *BatchDetectDominantLanguageOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectDominantLanguageOutput) SetResultList(v []*BatchDetectDominantLanguageItemResult) *BatchDetectDominantLanguageOutput {
	s.ResultList = v
	return s
}

type BatchDetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. The maximum size of each document
	// is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectEntitiesInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectEntitiesInput) SetLanguageCode(v string) *BatchDetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectEntitiesInput) SetTextList(v []*string) *BatchDetectEntitiesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {
	_ struct{} `type:"structure"`

	// One or more Entity objects, one for each entity detected in the document.
	Entities []*Entity `type:"list"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesItemResult) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchDetectEntitiesItemResult) SetEntities(v []*Entity) *BatchDetectEntitiesItemResult {
	s.Entities = v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchDetectEntitiesItemResult) SetIndex(v int64) *BatchDetectEntitiesItemResult {
	s.Index = &v
	return s
}

type BatchDetectEntitiesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectEntitiesItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectEntitiesOutput) SetErrorList(v []*BatchItemError) *BatchDetectEntitiesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectEntitiesOutput) SetResultList(v []*BatchDetectEntitiesItemResult) *BatchDetectEntitiesOutput {
	s.ResultList = v
	return s
}

type BatchDetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. The maximum size of each document
	// is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectKeyPhrasesInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectKeyPhrasesInput) SetLanguageCode(v string) *BatchDetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectKeyPhrasesInput) SetTextList(v []*string) *BatchDetectKeyPhrasesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetIndex(v int64) *BatchDetectKeyPhrasesItemResult {
	s.Index = &v
	return s
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetKeyPhrases(v []*KeyPhrase) *BatchDetectKeyPhrasesItemResult {
	s.KeyPhrases = v
	return s
}

type BatchDetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectKeyPhrasesItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetErrorList(v []*BatchItemError) *BatchDetectKeyPhrasesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetResultList(v []*BatchDetectKeyPhrasesItemResult) *BatchDetectKeyPhrasesOutput {
	s.ResultList = v
	return s
}

type BatchDetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. The maximum size of each document
	// is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectSentimentInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSentimentInput) SetLanguageCode(v string) *BatchDetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSentimentInput) SetTextList(v []*string) *BatchDetectSentimentInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The sentiment detected in the document.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSentimentItemResult) SetIndex(v int64) *BatchDetectSentimentItemResult {
	s.Index = &v
	return s
}

// SetSentiment sets the Sentiment field's value.
func (s *BatchDetectSentimentItemResult) SetSentiment(v string) *BatchDetectSentimentItemResult {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *BatchDetectSentimentItemResult) SetSentimentScore(v *SentimentScore) *BatchDetectSentimentItemResult {
	s.SentimentScore = v
	return s
}

type BatchDetectSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSentimentItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSentimentOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSentimentOutput) SetErrorList(v []*BatchItemError) *BatchDetectSentimentOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSentimentOutput) SetResultList(v []*BatchDetectSentimentItemResult) *BatchDetectSentimentOutput {
	s.ResultList = v
	return s
}

type BatchDetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the following
	// languages supported by Amazon Comprehend: German ("de"), English ("en"),
	// Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All
	// documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. The maximum size for each document
	// is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectSyntaxInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSyntaxInput) SetLanguageCode(v string) *BatchDetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSyntaxInput) SetTextList(v []*string) *BatchDetectSyntaxInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object that
// is successfully processed by the operation.
type BatchDetectSyntaxItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The syntax tokens for the words in the document, one token for each word.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSyntaxItemResult) SetIndex(v int64) *BatchDetectSyntaxItemResult {
	s.Index = &v
	return s
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *BatchDetectSyntaxItemResult) SetSyntaxTokens(v []*SyntaxToken) *BatchDetectSyntaxItemResult {
	s.SyntaxTokens = v
	return s
}

type BatchDetectSyntaxOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSyntaxItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSyntaxOutput) SetErrorList(v []*BatchItemError) *BatchDetectSyntaxOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSyntaxOutput) SetResultList(v []*BatchDetectSyntaxItemResult) *BatchDetectSyntaxOutput {
	s.ResultList = v
	return s
}

type BatchDetectTargetedSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. Currently, English is the only supported
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the UTF-8 encoded text of the input documents. The list
	// can contain a maximum of 25 documents. The maximum size of each document
	// is 5 KB.
	//
	// TextList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDetectTargetedSentimentInput's
	// String and GoString methods.
	//
	// TextList is a required field
	TextList []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectTargetedSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectTargetedSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}
	if s.TextList != nil && len(s.TextList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectTargetedSentimentInput) SetLanguageCode(v string) *BatchDetectTargetedSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectTargetedSentimentInput) SetTextList(v []*string) *BatchDetectTargetedSentimentInput {
	s.TextList = v
	return s
}

// Analysis results for one of the documents in the batch.
type BatchDetectTargetedSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// An array of targeted sentiment entities.
	Entities []*TargetedSentimentEntity `type:"list"`

	// The zero-based index of this result in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentItemResult) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchDetectTargetedSentimentItemResult) SetEntities(v []*TargetedSentimentEntity) *BatchDetectTargetedSentimentItemResult {
	s.Entities = v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchDetectTargetedSentimentItemResult) SetIndex(v int64) *BatchDetectTargetedSentimentItemResult {
	s.Index = &v
	return s
}

type BatchDetectTargetedSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// List of errors that the operation can return.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectTargetedSentimentItemResult `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDetectTargetedSentimentOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectTargetedSentimentOutput) SetErrorList(v []*BatchItemError) *BatchDetectTargetedSentimentOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectTargetedSentimentOutput) SetResultList(v []*BatchDetectTargetedSentimentItemResult) *BatchDetectTargetedSentimentOutput {
	s.ResultList = v
	return s
}

// Describes an error that occurred while processing a document in a batch.
// The operation returns on BatchItemError object for each document that contained
// an error.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The numeric error code of the error.
	ErrorCode *string `min:"1" type:"string"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchItemError) SetErrorCode(v string) *BatchItemError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchItemError) SetErrorMessage(v string) *BatchItemError {
	s.ErrorMessage = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchItemError) SetIndex(v int64) *BatchItemError {
	s.Index = &v
	return s
}

// The number of documents in the request exceeds the limit of 25. Try your
// request again with fewer documents.
type BatchSizeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSizeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSizeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorBatchSizeLimitExceededException(v protocol.ResponseMetadata) error {
	return &BatchSizeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BatchSizeLimitExceededException) Code() string {
	return "BatchSizeLimitExceededException"
}

// Message returns the exception's message.
func (s *BatchSizeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BatchSizeLimitExceededException) OrigErr() error {
	return nil
}

func (s *BatchSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BatchSizeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BatchSizeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about each word or line of text in the input document.
//
// For additional information, see Block (https://docs.aws.amazon.com/textract/latest/dg/API_Block.html)
// in the Amazon Textract API reference.
type Block struct {
	_ struct{} `type:"structure"`

	// The block represents a line of text or one word of text.
	//
	//    * WORD - A word that's detected on a document page. A word is one or more
	//    ISO basic Latin script characters that aren't separated by spaces.
	//
	//    * LINE - A string of tab-delimited, contiguous words that are detected
	//    on a document page
	BlockType *string `type:"string" enum:"BlockType"`

	// Co-ordinates of the rectangle or polygon that contains the text.
	Geometry *Geometry `type:"structure"`

	// Unique identifier for the block.
	Id *string `min:"1" type:"string"`

	// Page number where the block appears.
	Page *int64 `type:"integer"`

	// A list of child blocks of the current block. For example, a LINE object has
	// child blocks for each WORD block that's part of the line of text.
	Relationships []*RelationshipsListItem `type:"list"`

	// The word or line of text extracted from the block.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) GoString() string {
	return s.String()
}

// SetBlockType sets the BlockType field's value.
func (s *Block) SetBlockType(v string) *Block {
	s.BlockType = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Block) SetGeometry(v *Geometry) *Block {
	s.Geometry = v
	return s
}

// SetId sets the Id field's value.
func (s *Block) SetId(v string) *Block {
	s.Id = &v
	return s
}

// SetPage sets the Page field's value.
func (s *Block) SetPage(v int64) *Block {
	s.Page = &v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *Block) SetRelationships(v []*RelationshipsListItem) *Block {
	s.Relationships = v
	return s
}

// SetText sets the Text field's value.
func (s *Block) SetText(v string) *Block {
	s.Text = &v
	return s
}

// A reference to a block.
type BlockReference struct {
	_ struct{} `type:"structure"`

	// Offset of the start of the block within its parent block.
	BeginOffset *int64 `type:"integer"`

	// Unique identifier for the block.
	BlockId *string `min:"1" type:"string"`

	// List of child blocks within this block.
	ChildBlocks []*ChildBlock `type:"list"`

	// Offset of the end of the block within its parent block.
	EndOffset *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockReference) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *BlockReference) SetBeginOffset(v int64) *BlockReference {
	s.BeginOffset = &v
	return s
}

// SetBlockId sets the BlockId field's value.
func (s *BlockReference) SetBlockId(v string) *BlockReference {
	s.BlockId = &v
	return s
}

// SetChildBlocks sets the ChildBlocks field's value.
func (s *BlockReference) SetChildBlocks(v []*ChildBlock) *BlockReference {
	s.ChildBlocks = v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *BlockReference) SetEndOffset(v int64) *BlockReference {
	s.EndOffset = &v
	return s
}

// The bounding box around the detected page or around an element on a document
// page. The left (x-coordinate) and top (y-coordinate) are coordinates that
// represent the top and left sides of the bounding box. Note that the upper-left
// corner of the image is the origin (0,0).
//
// For additional information, see BoundingBox (https://docs.aws.amazon.com/textract/latest/dg/API_BoundingBox.html)
// in the Amazon Textract API reference.
type BoundingBox struct {
	_ struct{} `type:"structure"`

	// The height of the bounding box as a ratio of the overall document page height.
	Height *float64 `type:"float"`

	// The left coordinate of the bounding box as a ratio of overall document page
	// width.
	Left *float64 `type:"float"`

	// The top coordinate of the bounding box as a ratio of overall document page
	// height.
	Top *float64 `type:"float"`

	// The width of the bounding box as a ratio of the overall document page width.
	Width *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *BoundingBox) SetHeight(v float64) *BoundingBox {
	s.Height = &v
	return s
}

// SetLeft sets the Left field's value.
func (s *BoundingBox) SetLeft(v float64) *BoundingBox {
	s.Left = &v
	return s
}

// SetTop sets the Top field's value.
func (s *BoundingBox) SetTop(v float64) *BoundingBox {
	s.Top = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *BoundingBox) SetWidth(v float64) *BoundingBox {
	s.Width = &v
	return s
}

// Nested block contained within a block.
type ChildBlock struct {
	_ struct{} `type:"structure"`

	// Offset of the start of the child block within its parent block.
	BeginOffset *int64 `type:"integer"`

	// Unique identifier for the child block.
	ChildBlockId *string `min:"1" type:"string"`

	// Offset of the end of the child block within its parent block.
	EndOffset *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChildBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChildBlock) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *ChildBlock) SetBeginOffset(v int64) *ChildBlock {
	s.BeginOffset = &v
	return s
}

// SetChildBlockId sets the ChildBlockId field's value.
func (s *ChildBlock) SetChildBlockId(v string) *ChildBlock {
	s.ChildBlockId = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *ChildBlock) SetEndOffset(v int64) *ChildBlock {
	s.EndOffset = &v
	return s
}

// Describes the result metrics for the test data associated with an documentation
// classifier.
type ClassifierEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// The fraction of the labels that were correct recognized. It is computed by
	// dividing the number of labels in the test documents that were correctly recognized
	// by the total number of labels in the test documents.
	Accuracy *float64 `type:"double"`

	// A measure of how accurate the classifier results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is
	// 0.
	F1Score *float64 `type:"double"`

	// Indicates the fraction of labels that are incorrectly predicted. Also seen
	// as the fraction of wrong labels compared to the total number of labels. Scores
	// closer to zero are better.
	HammingLoss *float64 `type:"double"`

	// A measure of how accurate the classifier results are for the test data. It
	// is a combination of the Micro Precision and Micro Recall values. The Micro
	// F1Score is the harmonic mean of the two scores. The highest score is 1, and
	// the worst score is 0.
	MicroF1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant
	// results than irrelevant ones. Unlike the Precision metric which comes from
	// averaging the precision of all available labels, this is based on the overall
	// score of all precision scores added together.
	MicroPrecision *float64 `type:"double"`

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results. Specifically,
	// this indicates how many of the correct categories in the text that the model
	// can predict. It is a percentage of correct categories in the text that can
	// found. Instead of averaging the recall scores of all labels (as with Recall),
	// micro Recall is based on the overall score of all recall scores added together.
	MicroRecall *float64 `type:"double"`

	// A measure of the usefulness of the classifier results in the test data. High
	// precision means that the classifier returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifierEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifierEvaluationMetrics) GoString() string {
	return s.String()
}

// SetAccuracy sets the Accuracy field's value.
func (s *ClassifierEvaluationMetrics) SetAccuracy(v float64) *ClassifierEvaluationMetrics {
	s.Accuracy = &v
	return s
}

// SetF1Score sets the F1Score field's value.
func (s *ClassifierEvaluationMetrics) SetF1Score(v float64) *ClassifierEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetHammingLoss sets the HammingLoss field's value.
func (s *ClassifierEvaluationMetrics) SetHammingLoss(v float64) *ClassifierEvaluationMetrics {
	s.HammingLoss = &v
	return s
}

// SetMicroF1Score sets the MicroF1Score field's value.
func (s *ClassifierEvaluationMetrics) SetMicroF1Score(v float64) *ClassifierEvaluationMetrics {
	s.MicroF1Score = &v
	return s
}

// SetMicroPrecision sets the MicroPrecision field's value.
func (s *ClassifierEvaluationMetrics) SetMicroPrecision(v float64) *ClassifierEvaluationMetrics {
	s.MicroPrecision = &v
	return s
}

// SetMicroRecall sets the MicroRecall field's value.
func (s *ClassifierEvaluationMetrics) SetMicroRecall(v float64) *ClassifierEvaluationMetrics {
	s.MicroRecall = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ClassifierEvaluationMetrics) SetPrecision(v float64) *ClassifierEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *ClassifierEvaluationMetrics) SetRecall(v float64) *ClassifierEvaluationMetrics {
	s.Recall = &v
	return s
}

// Provides information about a document classifier.
type ClassifierMetadata struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Describes the result metrics for the test data associated with an documentation
	// classifier.
	EvaluationMetrics *ClassifierEvaluationMetrics `type:"structure"`

	// The number of labels in the input data.
	NumberOfLabels *int64 `type:"integer"`

	// The number of documents in the input data that were used to test the classifier.
	// Typically this is 10 to 20 percent of the input documents, up to 10,000 documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the classifier.
	// Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifierMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifierMetadata) GoString() string {
	return s.String()
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *ClassifierMetadata) SetEvaluationMetrics(v *ClassifierEvaluationMetrics) *ClassifierMetadata {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfLabels sets the NumberOfLabels field's value.
func (s *ClassifierMetadata) SetNumberOfLabels(v int64) *ClassifierMetadata {
	s.NumberOfLabels = &v
	return s
}

// SetNumberOfTestDocuments sets the NumberOfTestDocuments field's value.
func (s *ClassifierMetadata) SetNumberOfTestDocuments(v int64) *ClassifierMetadata {
	s.NumberOfTestDocuments = &v
	return s
}

// SetNumberOfTrainedDocuments sets the NumberOfTrainedDocuments field's value.
func (s *ClassifierMetadata) SetNumberOfTrainedDocuments(v int64) *ClassifierMetadata {
	s.NumberOfTrainedDocuments = &v
	return s
}

type ClassifyDocumentInput struct {
	_ struct{} `type:"structure"`

	// Use the Bytes parameter to input a text, PDF, Word or image file.
	//
	// When you classify a document using a custom model, you can also use the Bytes
	// parameter to input an Amazon Textract DetectDocumentText or AnalyzeDocument
	// output file.
	//
	// To classify a document using the prompt classifier, use the Text parameter
	// for input.
	//
	// Provide the input document as a sequence of base64-encoded bytes. If your
	// code uses an Amazon Web Services SDK to classify documents, the SDK may encode
	// the document file bytes for you.
	//
	// The maximum length of this field depends on the input document type. For
	// details, see Inputs for real-time custom analysis (https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html)
	// in the Comprehend Developer Guide.
	//
	// If you use the Bytes parameter, do not use the Text parameter.
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Provides configuration parameters to override the default actions for extracting
	// text from PDF documents and image files.
	DocumentReaderConfig *DocumentReaderConfig `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint.
	//
	// For prompt classification, Amazon Comprehend provides the endpoint ARN: zzz.
	//
	// For custom classification, you create an endpoint for your custom model.
	// For more information, see Using Amazon Comprehend endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/using-endpoints.html).
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The document text to be analyzed. If you enter text using this parameter,
	// do not use the Bytes parameter.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ClassifyDocumentInput's
	// String and GoString methods.
	Text *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifyDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifyDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassifyDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClassifyDocumentInput"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bytes", 1))
	}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.DocumentReaderConfig != nil {
		if err := s.DocumentReaderConfig.Validate(); err != nil {
			invalidParams.AddNested("DocumentReaderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytes sets the Bytes field's value.
func (s *ClassifyDocumentInput) SetBytes(v []byte) *ClassifyDocumentInput {
	s.Bytes = v
	return s
}

// SetDocumentReaderConfig sets the DocumentReaderConfig field's value.
func (s *ClassifyDocumentInput) SetDocumentReaderConfig(v *DocumentReaderConfig) *ClassifyDocumentInput {
	s.DocumentReaderConfig = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *ClassifyDocumentInput) SetEndpointArn(v string) *ClassifyDocumentInput {
	s.EndpointArn = &v
	return s
}

// SetText sets the Text field's value.
func (s *ClassifyDocumentInput) SetText(v string) *ClassifyDocumentInput {
	s.Text = &v
	return s
}

type ClassifyDocumentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The classes used by the document being analyzed. These are used for multi-class
	// trained models. Individual classes are mutually exclusive and each document
	// is expected to have only a single class assigned to it. For example, an animal
	// can be a dog or a cat, but not both at the same time.
	//
	// For prompt classification, the response includes a single class (UNDESIRED_PROMPT),
	// along with a confidence score. A higher confidence score indicates that the
	// input prompt is undesired in nature.
	Classes []*DocumentClass `type:"list"`

	// Extraction information about the document. This field is present in the response
	// only if your request includes the Byte parameter.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The document type for each page in the input document. This field is present
	// in the response only if your request includes the Byte parameter.
	DocumentType []*DocumentTypeListItem `type:"list"`

	// Page-level errors that the system detected while processing the input document.
	// The field is empty if the system encountered no errors.
	Errors []*ErrorsListItem `type:"list"`

	// The labels used the document being analyzed. These are used for multi-label
	// trained models. Individual labels represent different categories that are
	// related in some manner and are not mutually exclusive. For example, a movie
	// can be just an action movie, or it can be an action movie, a science fiction
	// movie, and a comedy, all at the same time.
	Labels []*DocumentLabel `type:"list"`

	// Warnings detected while processing the input document. The response includes
	// a warning if there is a mismatch between the input document type and the
	// model type associated with the endpoint that you specified. The response
	// can also include warnings for individual pages that have a mismatch.
	//
	// The field is empty if the system generated no warnings.
	Warnings []*WarningsListItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifyDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClassifyDocumentOutput) GoString() string {
	return s.String()
}

// SetClasses sets the Classes field's value.
func (s *ClassifyDocumentOutput) SetClasses(v []*DocumentClass) *ClassifyDocumentOutput {
	s.Classes = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *ClassifyDocumentOutput) SetDocumentMetadata(v *DocumentMetadata) *ClassifyDocumentOutput {
	s.DocumentMetadata = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *ClassifyDocumentOutput) SetDocumentType(v []*DocumentTypeListItem) *ClassifyDocumentOutput {
	s.DocumentType = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *ClassifyDocumentOutput) SetErrors(v []*ErrorsListItem) *ClassifyDocumentOutput {
	s.Errors = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ClassifyDocumentOutput) SetLabels(v []*DocumentLabel) *ClassifyDocumentOutput {
	s.Labels = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ClassifyDocumentOutput) SetWarnings(v []*WarningsListItem) *ClassifyDocumentOutput {
	s.Warnings = v
	return s
}

// Concurrent modification of the tags associated with an Amazon Comprehend
// resource is not supported.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ContainsPiiEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. Currently, English is the only valid
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. The maximum string size is 100 KB.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainsPiiEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainsPiiEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainsPiiEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainsPiiEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *ContainsPiiEntitiesInput) SetLanguageCode(v string) *ContainsPiiEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *ContainsPiiEntitiesInput) SetText(v string) *ContainsPiiEntitiesInput {
	s.Text = &v
	return s
}

type ContainsPiiEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The labels used in the document being analyzed. Individual labels represent
	// personally identifiable information (PII) entity types.
	Labels []*EntityLabel `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainsPiiEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContainsPiiEntitiesOutput) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *ContainsPiiEntitiesOutput) SetLabels(v []*EntityLabel) *ContainsPiiEntitiesOutput {
	s.Labels = v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Name of the dataset.
	//
	// DatasetName is a required field
	DatasetName *string `type:"string" required:"true"`

	// The dataset type. You can specify that the data in a dataset is for training
	// the model or for testing the model.
	DatasetType *string `type:"string" enum:"DatasetType"`

	// Description of the dataset.
	Description *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel of the flywheel to receive
	// the data.
	//
	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`

	// Information about the input data configuration. The type of input data varies
	// based on the format of the input and whether the data is for a classifier
	// model or an entity recognition model.
	//
	// InputDataConfig is a required field
	InputDataConfig *DatasetInputDataConfig `type:"structure" required:"true"`

	// Tags for the dataset.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDatasetInput) SetClientRequestToken(v string) *CreateDatasetInput {
	s.ClientRequestToken = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *CreateDatasetInput) SetDatasetName(v string) *CreateDatasetInput {
	s.DatasetName = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDatasetInput) SetDescription(v string) *CreateDatasetInput {
	s.Description = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *CreateDatasetInput) SetFlywheelArn(v string) *CreateDatasetInput {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateDatasetInput) SetInputDataConfig(v *DatasetInputDataConfig) *CreateDatasetInput {
	s.InputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatasetInput) SetTags(v []*Tag) *CreateDatasetInput {
	s.Tags = v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	DatasetArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type CreateDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the document classifier.
	//
	// DocumentClassifierName is a required field
	DocumentClassifierName *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *DocumentClassifierInputDataConfig `type:"structure" required:"true"`

	// The language of the input documents. You can specify any of the languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Indicates the mode in which the classifier will be trained. The classifier
	// can be trained in multi-class mode, which identifies one and only one class
	// for each document, or multi-label mode, which identifies one or more labels
	// for each document. In multi-label mode, multiple labels for an individual
	// document are separated by a delimiter. The default delimiter between labels
	// is a pipe (|).
	Mode *string `type:"string" enum:"DocumentClassifierMode"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// The resource-based policy to attach to your custom document classifier model.
	// You can use this policy to allow another Amazon Web Services account to import
	// your custom model.
	//
	// Provide your policy as a JSON body that you enter as a UTF-8 encoded string
	// without line breaks. To provide valid JSON, enclose the attribute names and
	// values in double quotes. If the JSON body is also enclosed in double quotes,
	// then you must escape the double quotes that are inside the policy:
	//
	// "{\"attribute\": \"value\", \"attribute\": [\"value\"]}"
	//
	// To avoid escaping quotes, you can use single quotes to enclose the policy
	// and double quotes to enclose the JSON names and values:
	//
	// '{"attribute": "value", "attribute": ["value"]}'
	ModelPolicy *string `min:"1" type:"string"`

	// Specifies the location for the output files from a custom classifier job.
	// This parameter is required for a request that creates a native document model.
	OutputDataConfig *DocumentClassifierOutputDataConfig `type:"structure"`

	// Tags to associate with the document classifier. A tag is a key-value pair
	// that adds as a metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// The version name given to the newly created classifier. Version names can
	// have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and
	// underscores (_) are allowed. The version name must be unique among all models
	// with the same classifier name in the Amazon Web Services account/Amazon Web
	// Services Region.
	VersionName *string `type:"string"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your custom classifier. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentClassifierInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DocumentClassifierName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierName"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.ModelPolicy != nil && len(*s.ModelPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPolicy", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDocumentClassifierInput) SetClientRequestToken(v string) *CreateDocumentClassifierInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateDocumentClassifierInput) SetDataAccessRoleArn(v string) *CreateDocumentClassifierInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierName sets the DocumentClassifierName field's value.
func (s *CreateDocumentClassifierInput) SetDocumentClassifierName(v string) *CreateDocumentClassifierInput {
	s.DocumentClassifierName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateDocumentClassifierInput) SetInputDataConfig(v *DocumentClassifierInputDataConfig) *CreateDocumentClassifierInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateDocumentClassifierInput) SetLanguageCode(v string) *CreateDocumentClassifierInput {
	s.LanguageCode = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CreateDocumentClassifierInput) SetMode(v string) *CreateDocumentClassifierInput {
	s.Mode = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *CreateDocumentClassifierInput) SetModelKmsKeyId(v string) *CreateDocumentClassifierInput {
	s.ModelKmsKeyId = &v
	return s
}

// SetModelPolicy sets the ModelPolicy field's value.
func (s *CreateDocumentClassifierInput) SetModelPolicy(v string) *CreateDocumentClassifierInput {
	s.ModelPolicy = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateDocumentClassifierInput) SetOutputDataConfig(v *DocumentClassifierOutputDataConfig) *CreateDocumentClassifierInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDocumentClassifierInput) SetTags(v []*Tag) *CreateDocumentClassifierInput {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateDocumentClassifierInput) SetVersionName(v string) *CreateDocumentClassifierInput {
	s.VersionName = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *CreateDocumentClassifierInput) SetVolumeKmsKeyId(v string) *CreateDocumentClassifierInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateDocumentClassifierInput) SetVpcConfig(v *VpcConfig) *CreateDocumentClassifierInput {
	s.VpcConfig = v
	return s
}

type CreateDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentClassifierOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *CreateDocumentClassifierOutput) SetDocumentClassifierArn(v string) *CreateDocumentClassifierOutput {
	s.DocumentClassifierArn = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// An idempotency token provided by the customer. If this token matches a previous
	// endpoint creation request, Amazon Comprehend will not return a ResourceInUseException.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to trained custom models encrypted with a customer managed key
	// (ModelKmsKeyId).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	//
	// DesiredInferenceUnits is a required field
	DesiredInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// This is the descriptive suffix that becomes part of the EndpointArn used
	// for all subsequent requests to this resource.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the flywheel to which the endpoint will
	// be attached.
	FlywheelArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint will
	// be attached.
	ModelArn *string `type:"string"`

	// Tags to associate with the endpoint. A tag is a key-value pair that adds
	// metadata to the endpoint. For example, a tag with "Sales" as the key might
	// be added to an endpoint to indicate its use by the sales department.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DesiredInferenceUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInferenceUnits"))
	}
	if s.DesiredInferenceUnits != nil && *s.DesiredInferenceUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredInferenceUnits", 1))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEndpointInput) SetClientRequestToken(v string) *CreateEndpointInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateEndpointInput) SetDataAccessRoleArn(v string) *CreateEndpointInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDesiredInferenceUnits sets the DesiredInferenceUnits field's value.
func (s *CreateEndpointInput) SetDesiredInferenceUnits(v int64) *CreateEndpointInput {
	s.DesiredInferenceUnits = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateEndpointInput) SetEndpointName(v string) *CreateEndpointInput {
	s.EndpointName = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *CreateEndpointInput) SetFlywheelArn(v string) *CreateEndpointInput {
	s.FlywheelArn = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateEndpointInput) SetModelArn(v string) *CreateEndpointInput {
	s.ModelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being created.
	EndpointArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateEndpointOutput) SetModelArn(v string) *CreateEndpointOutput {
	s.ModelArn = &v
	return s
}

type CreateEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data. The S3 bucket containing
	// the input data must be located in the same Region as the entity recognizer
	// being created.
	//
	// InputDataConfig is a required field
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure" required:"true"`

	// You can specify any of the following languages: English ("en"), Spanish ("es"),
	// French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). If you
	// plan to use this entity recognizer with PDF, Word, or image input files,
	// you must specify English as the language. All training documents must be
	// in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// The JSON resource-based policy to attach to your custom entity recognizer
	// model. You can use this policy to allow another Amazon Web Services account
	// to import your custom model.
	//
	// Provide your JSON as a UTF-8 encoded string without line breaks. To provide
	// valid JSON for your policy, enclose the attribute names and values in double
	// quotes. If the JSON body is also enclosed in double quotes, then you must
	// escape the double quotes that are inside the policy:
	//
	// "{\"attribute\": \"value\", \"attribute\": [\"value\"]}"
	//
	// To avoid escaping quotes, you can use single quotes to enclose the policy
	// and double quotes to enclose the JSON names and values:
	//
	// '{"attribute": "value", "attribute": ["value"]}'
	ModelPolicy *string `min:"1" type:"string"`

	// The name given to the newly created recognizer. Recognizer names can be a
	// maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores
	// (_) are allowed. The name must be unique in the account/Region.
	//
	// RecognizerName is a required field
	RecognizerName *string `type:"string" required:"true"`

	// Tags to associate with the entity recognizer. A tag is a key-value pair that
	// adds as a metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// The version name given to the newly created recognizer. Version names can
	// be a maximum of 256 characters. Alphanumeric characters, hyphens (-) and
	// underscores (_) are allowed. The version name must be unique among all models
	// with the same recognizer name in the account/Region.
	VersionName *string `type:"string"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your custom entity recognizer.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEntityRecognizerInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.ModelPolicy != nil && len(*s.ModelPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelPolicy", 1))
	}
	if s.RecognizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecognizerName"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEntityRecognizerInput) SetClientRequestToken(v string) *CreateEntityRecognizerInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateEntityRecognizerInput) SetDataAccessRoleArn(v string) *CreateEntityRecognizerInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateEntityRecognizerInput) SetInputDataConfig(v *EntityRecognizerInputDataConfig) *CreateEntityRecognizerInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateEntityRecognizerInput) SetLanguageCode(v string) *CreateEntityRecognizerInput {
	s.LanguageCode = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *CreateEntityRecognizerInput) SetModelKmsKeyId(v string) *CreateEntityRecognizerInput {
	s.ModelKmsKeyId = &v
	return s
}

// SetModelPolicy sets the ModelPolicy field's value.
func (s *CreateEntityRecognizerInput) SetModelPolicy(v string) *CreateEntityRecognizerInput {
	s.ModelPolicy = &v
	return s
}

// SetRecognizerName sets the RecognizerName field's value.
func (s *CreateEntityRecognizerInput) SetRecognizerName(v string) *CreateEntityRecognizerInput {
	s.RecognizerName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEntityRecognizerInput) SetTags(v []*Tag) *CreateEntityRecognizerInput {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateEntityRecognizerInput) SetVersionName(v string) *CreateEntityRecognizerInput {
	s.VersionName = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *CreateEntityRecognizerInput) SetVolumeKmsKeyId(v string) *CreateEntityRecognizerInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateEntityRecognizerInput) SetVpcConfig(v *VpcConfig) *CreateEntityRecognizerInput {
	s.VpcConfig = v
	return s
}

type CreateEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEntityRecognizerOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *CreateEntityRecognizerOutput) SetEntityRecognizerArn(v string) *CreateEntityRecognizerOutput {
	s.EntityRecognizerArn = &v
	return s
}

type CreateFlywheelInput struct {
	_ struct{} `type:"structure"`

	// To associate an existing model with the flywheel, specify the Amazon Resource
	// Number (ARN) of the model version. Do not set TaskConfig or ModelType if
	// you specify an ActiveModelArn.
	ActiveModelArn *string `type:"string"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// the permissions required to access the flywheel data in the data lake.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Enter the S3 location for the data lake. You can specify a new S3 bucket
	// or a new folder of an existing S3 bucket. The flywheel creates the data lake
	// at this location.
	//
	// DataLakeS3Uri is a required field
	DataLakeS3Uri *string `type:"string" required:"true"`

	// Data security configurations.
	DataSecurityConfig *DataSecurityConfig `type:"structure"`

	// Name for the flywheel.
	//
	// FlywheelName is a required field
	FlywheelName *string `type:"string" required:"true"`

	// The model type. You need to set ModelType if you are creating a flywheel
	// for a new model.
	ModelType *string `type:"string" enum:"ModelType"`

	// The tags to associate with this flywheel.
	Tags []*Tag `type:"list"`

	// Configuration about the model associated with the flywheel. You need to set
	// TaskConfig if you are creating a flywheel for a new model.
	TaskConfig *TaskConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlywheelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlywheelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlywheelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlywheelInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DataLakeS3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLakeS3Uri"))
	}
	if s.FlywheelName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelName"))
	}
	if s.DataSecurityConfig != nil {
		if err := s.DataSecurityConfig.Validate(); err != nil {
			invalidParams.AddNested("DataSecurityConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TaskConfig != nil {
		if err := s.TaskConfig.Validate(); err != nil {
			invalidParams.AddNested("TaskConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveModelArn sets the ActiveModelArn field's value.
func (s *CreateFlywheelInput) SetActiveModelArn(v string) *CreateFlywheelInput {
	s.ActiveModelArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFlywheelInput) SetClientRequestToken(v string) *CreateFlywheelInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateFlywheelInput) SetDataAccessRoleArn(v string) *CreateFlywheelInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDataLakeS3Uri sets the DataLakeS3Uri field's value.
func (s *CreateFlywheelInput) SetDataLakeS3Uri(v string) *CreateFlywheelInput {
	s.DataLakeS3Uri = &v
	return s
}

// SetDataSecurityConfig sets the DataSecurityConfig field's value.
func (s *CreateFlywheelInput) SetDataSecurityConfig(v *DataSecurityConfig) *CreateFlywheelInput {
	s.DataSecurityConfig = v
	return s
}

// SetFlywheelName sets the FlywheelName field's value.
func (s *CreateFlywheelInput) SetFlywheelName(v string) *CreateFlywheelInput {
	s.FlywheelName = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateFlywheelInput) SetModelType(v string) *CreateFlywheelInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFlywheelInput) SetTags(v []*Tag) *CreateFlywheelInput {
	s.Tags = v
	return s
}

// SetTaskConfig sets the TaskConfig field's value.
func (s *CreateFlywheelInput) SetTaskConfig(v *TaskConfig) *CreateFlywheelInput {
	s.TaskConfig = v
	return s
}

type CreateFlywheelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the active model version.
	ActiveModelArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel.
	FlywheelArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlywheelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlywheelOutput) GoString() string {
	return s.String()
}

// SetActiveModelArn sets the ActiveModelArn field's value.
func (s *CreateFlywheelOutput) SetActiveModelArn(v string) *CreateFlywheelOutput {
	s.ActiveModelArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *CreateFlywheelOutput) SetFlywheelArn(v string) *CreateFlywheelOutput {
	s.FlywheelArn = &v
	return s
}

// Data security configuration.
type DataSecurityConfig struct {
	_ struct{} `type:"structure"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt the data in the
	// data lake.
	DataLakeKmsKeyId *string `type:"string"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt the volume.
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for the job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSecurityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSecurityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSecurityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSecurityConfig"}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataLakeKmsKeyId sets the DataLakeKmsKeyId field's value.
func (s *DataSecurityConfig) SetDataLakeKmsKeyId(v string) *DataSecurityConfig {
	s.DataLakeKmsKeyId = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *DataSecurityConfig) SetModelKmsKeyId(v string) *DataSecurityConfig {
	s.ModelKmsKeyId = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DataSecurityConfig) SetVolumeKmsKeyId(v string) *DataSecurityConfig {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DataSecurityConfig) SetVpcConfig(v *VpcConfig) *DataSecurityConfig {
	s.VpcConfig = v
	return s
}

// An augmented manifest file that provides training data for your custom model.
// An augmented manifest file is a labeled dataset that is produced by Amazon
// SageMaker Ground Truth.
type DatasetAugmentedManifestsListItem struct {
	_ struct{} `type:"structure"`

	// The S3 prefix to the annotation files that are referred in the augmented
	// manifest file.
	AnnotationDataS3Uri *string `type:"string"`

	// The JSON attribute that contains the annotations for your training documents.
	// The number of attribute names that you specify depends on whether your augmented
	// manifest file is the output of a single labeling job or a chained labeling
	// job.
	//
	// If your file is the output of a single labeling job, specify the LabelAttributeName
	// key that was used when the job was created in Ground Truth.
	//
	// If your file is the output of a chained labeling job, specify the LabelAttributeName
	// key for one or more jobs in the chain. Each LabelAttributeName key provides
	// the annotations from an individual job.
	//
	// AttributeNames is a required field
	AttributeNames []*string `type:"list" required:"true"`

	// The type of augmented manifest. If you don't specify, the default is PlainTextDocument.
	//
	// PLAIN_TEXT_DOCUMENT A document type that represents any unicode text that
	// is encoded in UTF-8.
	DocumentType *string `type:"string" enum:"AugmentedManifestsDocumentTypeFormat"`

	// The Amazon S3 location of the augmented manifest file.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`

	// The S3 prefix to the source files (PDFs) that are referred to in the augmented
	// manifest file.
	SourceDocumentsS3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetAugmentedManifestsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetAugmentedManifestsListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetAugmentedManifestsListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetAugmentedManifestsListItem"}
	if s.AttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeNames"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationDataS3Uri sets the AnnotationDataS3Uri field's value.
func (s *DatasetAugmentedManifestsListItem) SetAnnotationDataS3Uri(v string) *DatasetAugmentedManifestsListItem {
	s.AnnotationDataS3Uri = &v
	return s
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *DatasetAugmentedManifestsListItem) SetAttributeNames(v []*string) *DatasetAugmentedManifestsListItem {
	s.AttributeNames = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *DatasetAugmentedManifestsListItem) SetDocumentType(v string) *DatasetAugmentedManifestsListItem {
	s.DocumentType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DatasetAugmentedManifestsListItem) SetS3Uri(v string) *DatasetAugmentedManifestsListItem {
	s.S3Uri = &v
	return s
}

// SetSourceDocumentsS3Uri sets the SourceDocumentsS3Uri field's value.
func (s *DatasetAugmentedManifestsListItem) SetSourceDocumentsS3Uri(v string) *DatasetAugmentedManifestsListItem {
	s.SourceDocumentsS3Uri = &v
	return s
}

// Describes the dataset input data configuration for a document classifier
// model.
//
// For more information on how the input file is formatted, see Preparing training
// data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
// in the Comprehend Developer Guide.
type DatasetDocumentClassifierInputDataConfig struct {
	_ struct{} `type:"structure"`

	// Indicates the delimiter used to separate each label for training a multi-label
	// classifier. The default delimiter between labels is a pipe (|). You can use
	// a different character as a delimiter (if it's an allowed character) by specifying
	// it under Delimiter for labels. If the training documents use a delimiter
	// other than the default or the delimiter you specify, the labels on that line
	// will be combined to make a single unique label, such as LABELLABELLABEL.
	LabelDelimiter *string `min:"1" type:"string"`

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same Region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// This parameter is required if you set DataFormat to COMPREHEND_CSV.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDocumentClassifierInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDocumentClassifierInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetDocumentClassifierInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetDocumentClassifierInputDataConfig"}
	if s.LabelDelimiter != nil && len(*s.LabelDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelDelimiter", 1))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelDelimiter sets the LabelDelimiter field's value.
func (s *DatasetDocumentClassifierInputDataConfig) SetLabelDelimiter(v string) *DatasetDocumentClassifierInputDataConfig {
	s.LabelDelimiter = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DatasetDocumentClassifierInputDataConfig) SetS3Uri(v string) *DatasetDocumentClassifierInputDataConfig {
	s.S3Uri = &v
	return s
}

// Describes the annotations associated with a entity recognizer.
type DatasetEntityRecognizerAnnotations struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerAnnotations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerAnnotations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetEntityRecognizerAnnotations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetEntityRecognizerAnnotations"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *DatasetEntityRecognizerAnnotations) SetS3Uri(v string) *DatasetEntityRecognizerAnnotations {
	s.S3Uri = &v
	return s
}

// Describes the documents submitted with a dataset for an entity recognizer
// model.
type DatasetEntityRecognizerDocuments struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed. This is optional,
	// and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered
	// a separate document. Use this option when you are processing large documents,
	// such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each
	// line in a file is considered a separate document. Use this option when you
	// are processing many short documents, such as text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// Specifies the Amazon S3 location where the documents for the dataset are
	// located.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetEntityRecognizerDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetEntityRecognizerDocuments"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputFormat sets the InputFormat field's value.
func (s *DatasetEntityRecognizerDocuments) SetInputFormat(v string) *DatasetEntityRecognizerDocuments {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DatasetEntityRecognizerDocuments) SetS3Uri(v string) *DatasetEntityRecognizerDocuments {
	s.S3Uri = &v
	return s
}

// Describes the dataset entity list for an entity recognizer model.
//
// For more information on how the input file is formatted, see Preparing training
// data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-training-data-cer.html)
// in the Comprehend Developer Guide.
type DatasetEntityRecognizerEntityList struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the entity list is located.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerEntityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerEntityList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetEntityRecognizerEntityList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetEntityRecognizerEntityList"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *DatasetEntityRecognizerEntityList) SetS3Uri(v string) *DatasetEntityRecognizerEntityList {
	s.S3Uri = &v
	return s
}

// Specifies the format and location of the input data. You must provide either
// the Annotations parameter or the EntityList parameter.
type DatasetEntityRecognizerInputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location of the annotation documents for your custom entity recognizer.
	Annotations *DatasetEntityRecognizerAnnotations `type:"structure"`

	// The format and location of the training documents for your custom entity
	// recognizer.
	//
	// Documents is a required field
	Documents *DatasetEntityRecognizerDocuments `type:"structure" required:"true"`

	// The S3 location of the entity list for your custom entity recognizer.
	EntityList *DatasetEntityRecognizerEntityList `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetEntityRecognizerInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetEntityRecognizerInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetEntityRecognizerInputDataConfig"}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.Annotations != nil {
		if err := s.Annotations.Validate(); err != nil {
			invalidParams.AddNested("Annotations", err.(request.ErrInvalidParams))
		}
	}
	if s.Documents != nil {
		if err := s.Documents.Validate(); err != nil {
			invalidParams.AddNested("Documents", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityList != nil {
		if err := s.EntityList.Validate(); err != nil {
			invalidParams.AddNested("EntityList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotations sets the Annotations field's value.
func (s *DatasetEntityRecognizerInputDataConfig) SetAnnotations(v *DatasetEntityRecognizerAnnotations) *DatasetEntityRecognizerInputDataConfig {
	s.Annotations = v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *DatasetEntityRecognizerInputDataConfig) SetDocuments(v *DatasetEntityRecognizerDocuments) *DatasetEntityRecognizerInputDataConfig {
	s.Documents = v
	return s
}

// SetEntityList sets the EntityList field's value.
func (s *DatasetEntityRecognizerInputDataConfig) SetEntityList(v *DatasetEntityRecognizerEntityList) *DatasetEntityRecognizerInputDataConfig {
	s.EntityList = v
	return s
}

// Filter the datasets based on creation time or dataset status.
type DatasetFilter struct {
	_ struct{} `type:"structure"`

	// Filter the datasets to include datasets created after the specified time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Filter the datasets to include datasets created before the specified time.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// Filter the datasets based on the dataset type.
	DatasetType *string `type:"string" enum:"DatasetType"`

	// Filter the datasets based on the dataset status.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetFilter) GoString() string {
	return s.String()
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *DatasetFilter) SetCreationTimeAfter(v time.Time) *DatasetFilter {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *DatasetFilter) SetCreationTimeBefore(v time.Time) *DatasetFilter {
	s.CreationTimeBefore = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetFilter) SetDatasetType(v string) *DatasetFilter {
	s.DatasetType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetFilter) SetStatus(v string) *DatasetFilter {
	s.Status = &v
	return s
}

// Specifies the format and location of the input data for the dataset.
type DatasetInputDataConfig struct {
	_ struct{} `type:"structure"`

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	AugmentedManifests []*DatasetAugmentedManifestsListItem `type:"list"`

	// COMPREHEND_CSV: The data format is a two-column CSV file, where the first
	// column contains labels and the second column contains documents.
	//
	// AUGMENTED_MANIFEST: The data format
	DataFormat *string `type:"string" enum:"DatasetDataFormat"`

	// The input properties for training a document classifier model.
	//
	// For more information on how the input file is formatted, see Preparing training
	// data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
	// in the Comprehend Developer Guide.
	DocumentClassifierInputDataConfig *DatasetDocumentClassifierInputDataConfig `type:"structure"`

	// The input properties for training an entity recognizer model.
	EntityRecognizerInputDataConfig *DatasetEntityRecognizerInputDataConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetInputDataConfig"}
	if s.AugmentedManifests != nil {
		for i, v := range s.AugmentedManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AugmentedManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DocumentClassifierInputDataConfig != nil {
		if err := s.DocumentClassifierInputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("DocumentClassifierInputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityRecognizerInputDataConfig != nil {
		if err := s.EntityRecognizerInputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("EntityRecognizerInputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAugmentedManifests sets the AugmentedManifests field's value.
func (s *DatasetInputDataConfig) SetAugmentedManifests(v []*DatasetAugmentedManifestsListItem) *DatasetInputDataConfig {
	s.AugmentedManifests = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *DatasetInputDataConfig) SetDataFormat(v string) *DatasetInputDataConfig {
	s.DataFormat = &v
	return s
}

// SetDocumentClassifierInputDataConfig sets the DocumentClassifierInputDataConfig field's value.
func (s *DatasetInputDataConfig) SetDocumentClassifierInputDataConfig(v *DatasetDocumentClassifierInputDataConfig) *DatasetInputDataConfig {
	s.DocumentClassifierInputDataConfig = v
	return s
}

// SetEntityRecognizerInputDataConfig sets the EntityRecognizerInputDataConfig field's value.
func (s *DatasetInputDataConfig) SetEntityRecognizerInputDataConfig(v *DatasetEntityRecognizerInputDataConfig) *DatasetInputDataConfig {
	s.EntityRecognizerInputDataConfig = v
	return s
}

// Properties associated with the dataset.
type DatasetProperties struct {
	_ struct{} `type:"structure"`

	// Creation time of the dataset.
	CreationTime *time.Time `type:"timestamp"`

	// The ARN of the dataset.
	DatasetArn *string `type:"string"`

	// The name of the dataset.
	DatasetName *string `type:"string"`

	// The S3 URI where the dataset is stored.
	DatasetS3Uri *string `type:"string"`

	// The dataset type (training data or test data).
	DatasetType *string `type:"string" enum:"DatasetType"`

	// Description of the dataset.
	Description *string `type:"string"`

	// Time when the data from the dataset becomes available in the data lake.
	EndTime *time.Time `type:"timestamp"`

	// A description of the status of the dataset.
	Message *string `type:"string"`

	// The number of documents in the dataset.
	NumberOfDocuments *int64 `type:"long"`

	// The dataset status. While the system creates the dataset, the status is CREATING.
	// When the dataset is ready to use, the status changes to COMPLETED.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetProperties) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DatasetProperties) SetCreationTime(v time.Time) *DatasetProperties {
	s.CreationTime = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetProperties) SetDatasetArn(v string) *DatasetProperties {
	s.DatasetArn = &v
	return s
}

// SetDatasetName sets the DatasetName field's value.
func (s *DatasetProperties) SetDatasetName(v string) *DatasetProperties {
	s.DatasetName = &v
	return s
}

// SetDatasetS3Uri sets the DatasetS3Uri field's value.
func (s *DatasetProperties) SetDatasetS3Uri(v string) *DatasetProperties {
	s.DatasetS3Uri = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetProperties) SetDatasetType(v string) *DatasetProperties {
	s.DatasetType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DatasetProperties) SetDescription(v string) *DatasetProperties {
	s.Description = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DatasetProperties) SetEndTime(v time.Time) *DatasetProperties {
	s.EndTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DatasetProperties) SetMessage(v string) *DatasetProperties {
	s.Message = &v
	return s
}

// SetNumberOfDocuments sets the NumberOfDocuments field's value.
func (s *DatasetProperties) SetNumberOfDocuments(v int64) *DatasetProperties {
	s.NumberOfDocuments = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetProperties) SetStatus(v string) *DatasetProperties {
	s.Status = &v
	return s
}

type DeleteDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DeleteDocumentClassifierInput) SetDocumentClassifierArn(v string) *DeleteDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type DeleteDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentClassifierOutput) GoString() string {
	return s.String()
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being deleted.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *DeleteEntityRecognizerInput) SetEntityRecognizerArn(v string) *DeleteEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type DeleteEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEntityRecognizerOutput) GoString() string {
	return s.String()
}

type DeleteFlywheelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the flywheel to delete.
	//
	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlywheelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlywheelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlywheelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlywheelInput"}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *DeleteFlywheelInput) SetFlywheelArn(v string) *DeleteFlywheelInput {
	s.FlywheelArn = &v
	return s
}

type DeleteFlywheelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlywheelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlywheelOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The revision ID of the policy to delete.
	PolicyRevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the custom model version that has the policy
	// to delete.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyRevisionId sets the PolicyRevisionId field's value.
func (s *DeleteResourcePolicyInput) SetPolicyRevisionId(v string) *DeleteResourcePolicyInput {
	s.PolicyRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dataset.
	//
	// DatasetArn is a required field
	DatasetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetInput) SetDatasetArn(v string) *DescribeDatasetInput {
	s.DatasetArn = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The dataset properties.
	DatasetProperties *DatasetProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetProperties sets the DatasetProperties field's value.
func (s *DescribeDatasetOutput) SetDatasetProperties(v *DatasetProperties) *DescribeDatasetOutput {
	s.DatasetProperties = v
	return s
}

type DescribeDocumentClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The StartDocumentClassificationJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentClassificationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDocumentClassificationJobInput) SetJobId(v string) *DescribeDocumentClassificationJobInput {
	s.JobId = &v
	return s
}

type DescribeDocumentClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the properties associated with the document classification
	// job.
	DocumentClassificationJobProperties *DocumentClassificationJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassificationJobOutput) GoString() string {
	return s.String()
}

// SetDocumentClassificationJobProperties sets the DocumentClassificationJobProperties field's value.
func (s *DescribeDocumentClassificationJobOutput) SetDocumentClassificationJobProperties(v *DocumentClassificationJobProperties) *DescribeDocumentClassificationJobOutput {
	s.DocumentClassificationJobProperties = v
	return s
}

type DescribeDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier. The
	// CreateDocumentClassifier operation returns this identifier in its response.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DescribeDocumentClassifierInput) SetDocumentClassifierArn(v string) *DescribeDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type DescribeDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a document classifier.
	DocumentClassifierProperties *DocumentClassifierProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDocumentClassifierOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierProperties sets the DocumentClassifierProperties field's value.
func (s *DescribeDocumentClassifierOutput) SetDocumentClassifierProperties(v *DocumentClassifierProperties) *DescribeDocumentClassifierOutput {
	s.DocumentClassifierProperties = v
	return s
}

type DescribeDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The StartDominantLanguageDetectionJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDominantLanguageDetectionJobInput) SetJobId(v string) *DescribeDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a dominant language
	// detection job.
	DominantLanguageDetectionJobProperties *DominantLanguageDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobProperties sets the DominantLanguageDetectionJobProperties field's value.
func (s *DescribeDominantLanguageDetectionJobOutput) SetDominantLanguageDetectionJobProperties(v *DominantLanguageDetectionJobProperties) *DescribeDominantLanguageDetectionJobOutput {
	s.DominantLanguageDetectionJobProperties = v
	return s
}

type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being described.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeEndpointInput) SetEndpointArn(v string) *DescribeEndpointInput {
	s.EndpointArn = &v
	return s
}

type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Describes information associated with the specific endpoint.
	EndpointProperties *EndpointProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointProperties sets the EndpointProperties field's value.
func (s *DescribeEndpointOutput) SetEndpointProperties(v *EndpointProperties) *DescribeEndpointOutput {
	s.EndpointProperties = v
	return s
}

type DescribeEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The StartEntitiesDetectionJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEntitiesDetectionJobInput) SetJobId(v string) *DescribeEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an entities detection
	// job.
	EntitiesDetectionJobProperties *EntitiesDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobProperties sets the EntitiesDetectionJobProperties field's value.
func (s *DescribeEntitiesDetectionJobOutput) SetEntitiesDetectionJobProperties(v *EntitiesDetectionJobProperties) *DescribeEntitiesDetectionJobOutput {
	s.EntitiesDetectionJobProperties = v
	return s
}

type DescribeEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *DescribeEntityRecognizerInput) SetEntityRecognizerArn(v string) *DescribeEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type DescribeEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`

	// Describes information associated with an entity recognizer.
	EntityRecognizerProperties *EntityRecognizerProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntityRecognizerOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerProperties sets the EntityRecognizerProperties field's value.
func (s *DescribeEntityRecognizerOutput) SetEntityRecognizerProperties(v *EntityRecognizerProperties) *DescribeEntityRecognizerOutput {
	s.EntityRecognizerProperties = v
	return s
}

type DescribeEventsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the events detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEventsDetectionJobInput) SetJobId(v string) *DescribeEventsDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeEventsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an event detection
	// job.
	EventsDetectionJobProperties *EventsDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetEventsDetectionJobProperties sets the EventsDetectionJobProperties field's value.
func (s *DescribeEventsDetectionJobOutput) SetEventsDetectionJobProperties(v *EventsDetectionJobProperties) *DescribeEventsDetectionJobOutput {
	s.EventsDetectionJobProperties = v
	return s
}

type DescribeFlywheelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the flywheel.
	//
	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlywheelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlywheelInput"}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *DescribeFlywheelInput) SetFlywheelArn(v string) *DescribeFlywheelInput {
	s.FlywheelArn = &v
	return s
}

type DescribeFlywheelIterationInput struct {
	_ struct{} `type:"structure"`

	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`

	// FlywheelIterationId is a required field
	FlywheelIterationId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelIterationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelIterationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlywheelIterationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlywheelIterationInput"}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}
	if s.FlywheelIterationId == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelIterationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *DescribeFlywheelIterationInput) SetFlywheelArn(v string) *DescribeFlywheelIterationInput {
	s.FlywheelArn = &v
	return s
}

// SetFlywheelIterationId sets the FlywheelIterationId field's value.
func (s *DescribeFlywheelIterationInput) SetFlywheelIterationId(v string) *DescribeFlywheelIterationInput {
	s.FlywheelIterationId = &v
	return s
}

type DescribeFlywheelIterationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration properties of a flywheel iteration.
	FlywheelIterationProperties *FlywheelIterationProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelIterationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelIterationOutput) GoString() string {
	return s.String()
}

// SetFlywheelIterationProperties sets the FlywheelIterationProperties field's value.
func (s *DescribeFlywheelIterationOutput) SetFlywheelIterationProperties(v *FlywheelIterationProperties) *DescribeFlywheelIterationOutput {
	s.FlywheelIterationProperties = v
	return s
}

type DescribeFlywheelOutput struct {
	_ struct{} `type:"structure"`

	// The flywheel properties.
	FlywheelProperties *FlywheelProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFlywheelOutput) GoString() string {
	return s.String()
}

// SetFlywheelProperties sets the FlywheelProperties field's value.
func (s *DescribeFlywheelOutput) SetFlywheelProperties(v *FlywheelProperties) *DescribeFlywheelOutput {
	s.FlywheelProperties = v
	return s
}

type DescribeKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The StartKeyPhrasesDetectionJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeKeyPhrasesDetectionJobInput) SetJobId(v string) *DescribeKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a key phrases detection
	// job.
	KeyPhrasesDetectionJobProperties *KeyPhrasesDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobProperties sets the KeyPhrasesDetectionJobProperties field's value.
func (s *DescribeKeyPhrasesDetectionJobOutput) SetKeyPhrasesDetectionJobProperties(v *KeyPhrasesDetectionJobProperties) *DescribeKeyPhrasesDetectionJobOutput {
	s.KeyPhrasesDetectionJobProperties = v
	return s
}

type DescribePiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePiiEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribePiiEntitiesDetectionJobInput) SetJobId(v string) *DescribePiiEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribePiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about a PII entities detection job.
	PiiEntitiesDetectionJobProperties *PiiEntitiesDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetPiiEntitiesDetectionJobProperties sets the PiiEntitiesDetectionJobProperties field's value.
func (s *DescribePiiEntitiesDetectionJobOutput) SetPiiEntitiesDetectionJobProperties(v *PiiEntitiesDetectionJobProperties) *DescribePiiEntitiesDetectionJobOutput {
	s.PiiEntitiesDetectionJobProperties = v
	return s
}

type DescribeResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom model version that has the resource
	// policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyInput) SetResourceArn(v string) *DescribeResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the policy was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time at which the policy was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The revision ID of the policy. Each time you modify a policy, Amazon Comprehend
	// assigns a new revision ID, and it deletes the prior version of the policy.
	PolicyRevisionId *string `type:"string"`

	// The JSON body of the resource-based policy.
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeResourcePolicyOutput) SetCreationTime(v time.Time) *DescribeResourcePolicyOutput {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribeResourcePolicyOutput) SetLastModifiedTime(v time.Time) *DescribeResourcePolicyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetPolicyRevisionId sets the PolicyRevisionId field's value.
func (s *DescribeResourcePolicyOutput) SetPolicyRevisionId(v string) *DescribeResourcePolicyOutput {
	s.PolicyRevisionId = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *DescribeResourcePolicyOutput) SetResourcePolicy(v string) *DescribeResourcePolicyOutput {
	s.ResourcePolicy = &v
	return s
}

type DescribeSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSentimentDetectionJobInput) SetJobId(v string) *DescribeSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a sentiment detection
	// job.
	SentimentDetectionJobProperties *SentimentDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetSentimentDetectionJobProperties sets the SentimentDetectionJobProperties field's value.
func (s *DescribeSentimentDetectionJobOutput) SetSentimentDetectionJobProperties(v *SentimentDetectionJobProperties) *DescribeSentimentDetectionJobOutput {
	s.SentimentDetectionJobProperties = v
	return s
}

type DescribeTargetedSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The StartTargetedSentimentDetectionJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTargetedSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTargetedSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetedSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTargetedSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTargetedSentimentDetectionJobInput) SetJobId(v string) *DescribeTargetedSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeTargetedSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a targeted sentiment
	// detection job.
	TargetedSentimentDetectionJobProperties *TargetedSentimentDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTargetedSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTargetedSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetTargetedSentimentDetectionJobProperties sets the TargetedSentimentDetectionJobProperties field's value.
func (s *DescribeTargetedSentimentDetectionJobOutput) SetTargetedSentimentDetectionJobProperties(v *TargetedSentimentDetectionJobProperties) *DescribeTargetedSentimentDetectionJobOutput {
	s.TargetedSentimentDetectionJobProperties = v
	return s
}

type DescribeTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier assigned by the user to the detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTopicsDetectionJobInput) SetJobId(v string) *DescribeTopicsDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties for the requested job.
	TopicsDetectionJobProperties *TopicsDetectionJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetTopicsDetectionJobProperties sets the TopicsDetectionJobProperties field's value.
func (s *DescribeTopicsDetectionJobOutput) SetTopicsDetectionJobProperties(v *TopicsDetectionJobProperties) *DescribeTopicsDetectionJobOutput {
	s.TopicsDetectionJobProperties = v
	return s
}

type DetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string. The string must contain at least 20 characters. The
	// maximum string size is 100 KB.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectDominantLanguageInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDominantLanguageInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectDominantLanguageInput) SetText(v string) *DetectDominantLanguageInput {
	s.Text = &v
	return s
}

type DetectDominantLanguageOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Array of languages that Amazon Comprehend detected in the input text. The
	// array is sorted in descending order of the score (the dominant language is
	// always the first element in the array).
	//
	// For each language, the response returns the RFC 5646 language code and the
	// level of confidence that Amazon Comprehend has in the accuracy of its inference.
	// For more information about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *DetectDominantLanguageOutput) SetLanguages(v []*DominantLanguage) *DetectDominantLanguageOutput {
	s.Languages = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// This field applies only when you use a custom entity recognition model that
	// was trained with PDF annotations. For other cases, enter your text input
	// in the Text field.
	//
	// Use the Bytes parameter to input a text, PDF, Word or image file. Using a
	// plain-text file in the Bytes parameter is equivelent to using the Text parameter
	// (the Entities field in the response is identical).
	//
	// You can also use the Bytes parameter to input an Amazon Textract DetectDocumentText
	// or AnalyzeDocument output file.
	//
	// Provide the input document as a sequence of base64-encoded bytes. If your
	// code uses an Amazon Web Services SDK to detect entities, the SDK may encode
	// the document file bytes for you.
	//
	// The maximum length of this field depends on the input document type. For
	// details, see Inputs for real-time custom analysis (https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html)
	// in the Comprehend Developer Guide.
	//
	// If you use the Bytes parameter, do not use the Text parameter.
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Provides configuration parameters to override the default actions for extracting
	// text from PDF documents and image files.
	DocumentReaderConfig *DocumentReaderConfig `type:"structure"`

	// The Amazon Resource Name of an endpoint that is associated with a custom
	// entity recognition model. Provide an endpoint if you want to detect entities
	// by using your own custom model instead of the default model that is used
	// by Amazon Comprehend.
	//
	// If you specify an endpoint, Amazon Comprehend uses the language of your custom
	// model, and it ignores any language code that you provide in your request.
	//
	// For information about endpoints, see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
	EndpointArn *string `type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. If your request includes the endpoint for
	// a custom entity recognition model, Amazon Comprehend uses the language of
	// your custom model, and it ignores any language code that you specify here.
	//
	// All input documents must be in the same language.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A UTF-8 text string. The maximum string size is 100 KB. If you enter text
	// using this parameter, do not use the Bytes parameter.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectEntitiesInput's
	// String and GoString methods.
	Text *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bytes", 1))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.DocumentReaderConfig != nil {
		if err := s.DocumentReaderConfig.Validate(); err != nil {
			invalidParams.AddNested("DocumentReaderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytes sets the Bytes field's value.
func (s *DetectEntitiesInput) SetBytes(v []byte) *DetectEntitiesInput {
	s.Bytes = v
	return s
}

// SetDocumentReaderConfig sets the DocumentReaderConfig field's value.
func (s *DetectEntitiesInput) SetDocumentReaderConfig(v *DocumentReaderConfig) *DetectEntitiesInput {
	s.DocumentReaderConfig = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DetectEntitiesInput) SetEndpointArn(v string) *DetectEntitiesInput {
	s.EndpointArn = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectEntitiesInput) SetLanguageCode(v string) *DetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Information about each block of text in the input document. Blocks are nested.
	// A page block contains a block for each line of text, which contains a block
	// for each word.
	//
	// The Block content for a Word input document does not include a Geometry field.
	//
	// The Block field is not present in the response for plain-text inputs.
	Blocks []*Block `type:"list"`

	// Information about the document, discovered during text extraction. This field
	// is present in the response only if your request used the Byte parameter.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The document type for each page in the input document. This field is present
	// in the response only if your request used the Byte parameter.
	DocumentType []*DocumentTypeListItem `type:"list"`

	// A collection of entities identified in the input text. For each entity, the
	// response provides the entity text, entity type, where the entity text begins
	// and ends, and the level of confidence that Amazon Comprehend has in the detection.
	//
	// If your request uses a custom entity recognition model, Amazon Comprehend
	// detects the entities that the model is trained to recognize. Otherwise, it
	// detects the default entity types. For a list of default entity types, see
	// Entities (https://docs.aws.amazon.com/comprehend/latest/dg/how-entities.html)
	// in the Comprehend Developer Guide.
	Entities []*Entity `type:"list"`

	// Page-level errors that the system detected while processing the input document.
	// The field is empty if the system encountered no errors.
	Errors []*ErrorsListItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *DetectEntitiesOutput) SetBlocks(v []*Block) *DetectEntitiesOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *DetectEntitiesOutput) SetDocumentMetadata(v *DocumentMetadata) *DetectEntitiesOutput {
	s.DocumentMetadata = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *DetectEntitiesOutput) SetDocumentType(v []*DocumentTypeListItem) *DetectEntitiesOutput {
	s.DocumentType = v
	return s
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DetectEntitiesOutput) SetErrors(v []*ErrorsListItem) *DetectEntitiesOutput {
	s.Errors = v
	return s
}

type DetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. The string must contain less than 100 KB of UTF-8 encoded
	// characters.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectKeyPhrasesInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectKeyPhrasesInput) SetLanguageCode(v string) *DetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectKeyPhrasesInput) SetText(v string) *DetectKeyPhrasesInput {
	s.Text = &v
	return s
}

type DetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of key phrases that Amazon Comprehend identified in the input
	// text. For each key phrase, the response provides the text of the key phrase,
	// where the key phrase begins and ends, and the level of confidence that Amazon
	// Comprehend has in the accuracy of the detection.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *DetectKeyPhrasesOutput) SetKeyPhrases(v []*KeyPhrase) *DetectKeyPhrasesOutput {
	s.KeyPhrases = v
	return s
}

type DetectPiiEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. Currently, English is the only valid
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. The maximum string size is 100 KB.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPiiEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPiiEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectPiiEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectPiiEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectPiiEntitiesInput) SetLanguageCode(v string) *DetectPiiEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectPiiEntitiesInput) SetText(v string) *DetectPiiEntitiesInput {
	s.Text = &v
	return s
}

type DetectPiiEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of PII entities identified in the input text. For each entity,
	// the response provides the entity type, where the entity text begins and ends,
	// and the level of confidence that Amazon Comprehend has in the detection.
	Entities []*PiiEntity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPiiEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPiiEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectPiiEntitiesOutput) SetEntities(v []*PiiEntity) *DetectPiiEntitiesOutput {
	s.Entities = v
	return s
}

type DetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. The maximum string size is 5 KB.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectSentimentInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSentimentInput) SetLanguageCode(v string) *DetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSentimentInput) SetText(v string) *DetectSentimentInput {
	s.Text = &v
	return s
}

type DetectSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The inferred sentiment that Amazon Comprehend has the highest level of confidence
	// in.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// An object that lists the sentiments, and their corresponding confidence levels.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSentimentOutput) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *DetectSentimentOutput) SetSentiment(v string) *DetectSentimentOutput {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *DetectSentimentOutput) SetSentimentScore(v *SentimentScore) *DetectSentimentOutput {
	s.SentimentScore = v
	return s
}

type DetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language code of the input documents. You can specify any of the following
	// languages supported by Amazon Comprehend: German ("de"), English ("en"),
	// Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A UTF-8 string. The maximum string size is 5 KB.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectSyntaxInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSyntaxInput) SetLanguageCode(v string) *DetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSyntaxInput) SetText(v string) *DetectSyntaxInput {
	s.Text = &v
	return s
}

type DetectSyntaxOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of syntax tokens describing the text. For each token, the response
	// provides the text, the token type, where the text begins and ends, and the
	// level of confidence that Amazon Comprehend has that the token is correct.
	// For a list of token types, see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
	// in the Comprehend Developer Guide.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *DetectSyntaxOutput) SetSyntaxTokens(v []*SyntaxToken) *DetectSyntaxOutput {
	s.SyntaxTokens = v
	return s
}

type DetectTargetedSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. Currently, English is the only supported
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. The maximum string length is 5 KB.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectTargetedSentimentInput's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTargetedSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTargetedSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectTargetedSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectTargetedSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectTargetedSentimentInput) SetLanguageCode(v string) *DetectTargetedSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectTargetedSentimentInput) SetText(v string) *DetectTargetedSentimentInput {
	s.Text = &v
	return s
}

type DetectTargetedSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Targeted sentiment analysis for each of the entities identified in the input
	// text.
	Entities []*TargetedSentimentEntity `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTargetedSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTargetedSentimentOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectTargetedSentimentOutput) SetEntities(v []*TargetedSentimentEntity) *DetectTargetedSentimentOutput {
	s.Entities = v
	return s
}

type DetectToxicContentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input text. Currently, English is the only supported
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list of up to 10 text strings. The maximum size for the list is 10 KB.
	//
	// TextSegments is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetectToxicContentInput's
	// String and GoString methods.
	//
	// TextSegments is a required field
	TextSegments []*TextSegment `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectToxicContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectToxicContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectToxicContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectToxicContentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextSegments == nil {
		invalidParams.Add(request.NewErrParamRequired("TextSegments"))
	}
	if s.TextSegments != nil && len(s.TextSegments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextSegments", 1))
	}
	if s.TextSegments != nil {
		for i, v := range s.TextSegments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextSegments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectToxicContentInput) SetLanguageCode(v string) *DetectToxicContentInput {
	s.LanguageCode = &v
	return s
}

// SetTextSegments sets the TextSegments field's value.
func (s *DetectToxicContentInput) SetTextSegments(v []*TextSegment) *DetectToxicContentInput {
	s.TextSegments = v
	return s
}

type DetectToxicContentOutput struct {
	_ struct{} `type:"structure"`

	// Results of the content moderation analysis. Each entry in the results list
	// contains a list of toxic content types identified in the text, along with
	// a confidence score for each content type. The results list also includes
	// a toxicity score for each entry in the results list.
	ResultList []*ToxicLabels `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectToxicContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectToxicContentOutput) GoString() string {
	return s.String()
}

// SetResultList sets the ResultList field's value.
func (s *DetectToxicContentOutput) SetResultList(v []*ToxicLabels) *DetectToxicContentOutput {
	s.ResultList = v
	return s
}

// Specifies the class that categorizes the document being analyzed
type DocumentClass struct {
	_ struct{} `type:"structure"`

	// The name of the class.
	Name *string `min:"1" type:"string"`

	// Page number in the input document. This field is present in the response
	// only if your request includes the Byte parameter.
	Page *int64 `type:"integer"`

	// The confidence score that Amazon Comprehend has this class correctly attributed.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClass) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClass) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DocumentClass) SetName(v string) *DocumentClass {
	s.Name = &v
	return s
}

// SetPage sets the Page field's value.
func (s *DocumentClass) SetPage(v int64) *DocumentClass {
	s.Page = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DocumentClass) SetScore(v float64) *DocumentClass {
	s.Score = &v
	return s
}

// Configuration required for a document classification model.
type DocumentClassificationConfig struct {
	_ struct{} `type:"structure"`

	// One or more labels to associate with the custom classifier.
	Labels []*string `type:"list"`

	// Classification mode indicates whether the documents are MULTI_CLASS or MULTI_LABEL.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"DocumentClassifierMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassificationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassificationConfig"}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabels sets the Labels field's value.
func (s *DocumentClassificationConfig) SetLabels(v []*string) *DocumentClassificationConfig {
	s.Labels = v
	return s
}

// SetMode sets the Mode field's value.
func (s *DocumentClassificationConfig) SetMode(v string) *DocumentClassificationConfig {
	s.Mode = &v
	return s
}

// Provides information for filtering a list of document classification jobs.
// For more information, see the operation. You can provide only one filter
// parameter in each request.
type DocumentClassificationJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list based on job status. Returns only jobs with the specified
	// status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassificationJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassificationJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DocumentClassificationJobFilter) SetJobName(v string) *DocumentClassificationJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DocumentClassificationJobFilter) SetJobStatus(v string) *DocumentClassificationJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DocumentClassificationJobFilter) SetSubmitTimeAfter(v time.Time) *DocumentClassificationJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DocumentClassificationJobFilter) SetSubmitTimeBefore(v time.Time) *DocumentClassificationJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a document classification job.
type DocumentClassificationJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that the document classification job completed.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string `type:"string"`

	// The input data configuration that you supplied when you created the document
	// classification job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the document classification job. It is
	// a unique, fully qualified identifier for the job. It includes the Amazon
	// Web Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the document classification job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the document classification job.
	JobName *string `min:"1" type:"string"`

	// The current status of the document classification job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description of the status of the job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the document
	// classification job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the document classification job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your document classification job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassificationJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DocumentClassificationJobProperties) SetDataAccessRoleArn(v string) *DocumentClassificationJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DocumentClassificationJobProperties) SetDocumentClassifierArn(v string) *DocumentClassificationJobProperties {
	s.DocumentClassifierArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DocumentClassificationJobProperties) SetEndTime(v time.Time) *DocumentClassificationJobProperties {
	s.EndTime = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *DocumentClassificationJobProperties) SetFlywheelArn(v string) *DocumentClassificationJobProperties {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DocumentClassificationJobProperties) SetInputDataConfig(v *InputDataConfig) *DocumentClassificationJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *DocumentClassificationJobProperties) SetJobArn(v string) *DocumentClassificationJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DocumentClassificationJobProperties) SetJobId(v string) *DocumentClassificationJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DocumentClassificationJobProperties) SetJobName(v string) *DocumentClassificationJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DocumentClassificationJobProperties) SetJobStatus(v string) *DocumentClassificationJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DocumentClassificationJobProperties) SetMessage(v string) *DocumentClassificationJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DocumentClassificationJobProperties) SetOutputDataConfig(v *OutputDataConfig) *DocumentClassificationJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DocumentClassificationJobProperties) SetSubmitTime(v time.Time) *DocumentClassificationJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DocumentClassificationJobProperties) SetVolumeKmsKeyId(v string) *DocumentClassificationJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DocumentClassificationJobProperties) SetVpcConfig(v *VpcConfig) *DocumentClassificationJobProperties {
	s.VpcConfig = v
	return s
}

// The location of the training documents. This parameter is required in a request
// to create a semi-structured document classification model.
type DocumentClassifierDocuments struct {
	_ struct{} `type:"structure"`

	// The S3 URI location of the training documents specified in the S3Uri CSV
	// file.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`

	// The S3 URI location of the test documents included in the TestS3Uri CSV file.
	// This field is not required if you do not specify a test CSV file.
	TestS3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassifierDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassifierDocuments"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *DocumentClassifierDocuments) SetS3Uri(v string) *DocumentClassifierDocuments {
	s.S3Uri = &v
	return s
}

// SetTestS3Uri sets the TestS3Uri field's value.
func (s *DocumentClassifierDocuments) SetTestS3Uri(v string) *DocumentClassifierDocuments {
	s.TestS3Uri = &v
	return s
}

// Provides information for filtering a list of document classifiers. You can
// only specify one filtering parameter in a request. For more information,
// see the ListDocumentClassifiers operation.
type DocumentClassifierFilter struct {
	_ struct{} `type:"structure"`

	// The name that you assigned to the document classifier
	DocumentClassifierName *string `type:"string"`

	// Filters the list of classifiers based on status.
	Status *string `type:"string" enum:"ModelStatus"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted after the specified
	// time. Classifiers are returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted before the specified
	// time. Classifiers are returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierFilter) GoString() string {
	return s.String()
}

// SetDocumentClassifierName sets the DocumentClassifierName field's value.
func (s *DocumentClassifierFilter) SetDocumentClassifierName(v string) *DocumentClassifierFilter {
	s.DocumentClassifierName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentClassifierFilter) SetStatus(v string) *DocumentClassifierFilter {
	s.Status = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DocumentClassifierFilter) SetSubmitTimeAfter(v time.Time) *DocumentClassifierFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DocumentClassifierFilter) SetSubmitTimeBefore(v time.Time) *DocumentClassifierFilter {
	s.SubmitTimeBefore = &v
	return s
}

// The input properties for training a document classifier.
//
// For more information on how the input file is formatted, see Preparing training
// data (https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html)
// in the Comprehend Developer Guide.
type DocumentClassifierInputDataConfig struct {
	_ struct{} `type:"structure"`

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	//
	// This parameter is required if you set DataFormat to AUGMENTED_MANIFEST.
	AugmentedManifests []*AugmentedManifestsListItem `type:"list"`

	// The format of your training data:
	//
	//    * COMPREHEND_CSV: A two-column CSV file, where labels are provided in
	//    the first column, and documents are provided in the second. If you use
	//    this value, you must provide the S3Uri parameter in your request.
	//
	//    * AUGMENTED_MANIFEST: A labeled dataset that is produced by Amazon SageMaker
	//    Ground Truth. This file is in JSON lines format. Each line is a complete
	//    JSON object that contains a training document and its associated labels.
	//    If you use this value, you must provide the AugmentedManifests parameter
	//    in your request.
	//
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat *string `type:"string" enum:"DocumentClassifierDataFormat"`

	// Provides configuration parameters to override the default actions for extracting
	// text from PDF documents and image files.
	//
	// By default, Amazon Comprehend performs the following actions to extract text
	// from files, based on the input file type:
	//
	//    * Word files - Amazon Comprehend parser extracts the text.
	//
	//    * Digital PDF files - Amazon Comprehend parser extracts the text.
	//
	//    * Image files and scanned PDF files - Amazon Comprehend uses the Amazon
	//    Textract DetectDocumentText API to extract the text.
	//
	// DocumentReaderConfig does not apply to plain text files or Word files.
	//
	// For image files and PDF documents, you can override these default actions
	// using the fields listed below. For more information, see Setting text extraction
	// options (https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html)
	// in the Comprehend Developer Guide.
	DocumentReaderConfig *DocumentReaderConfig `type:"structure"`

	// The type of input documents for training the model. Provide plain-text documents
	// to create a plain-text model, and provide semi-structured documents to create
	// a native document model.
	DocumentType *string `type:"string" enum:"DocumentClassifierDocumentTypeFormat"`

	// The S3 location of the training documents. This parameter is required in
	// a request to create a native document model.
	Documents *DocumentClassifierDocuments `type:"structure"`

	// Indicates the delimiter used to separate each label for training a multi-label
	// classifier. The default delimiter between labels is a pipe (|). You can use
	// a different character as a delimiter (if it's an allowed character) by specifying
	// it under Delimiter for labels. If the training documents use a delimiter
	// other than the default or the delimiter you specify, the labels on that line
	// will be combined to make a single unique label, such as LABELLABELLABEL.
	LabelDelimiter *string `min:"1" type:"string"`

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same Region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// This parameter is required if you set DataFormat to COMPREHEND_CSV.
	S3Uri *string `type:"string"`

	// This specifies the Amazon S3 location that contains the test annotations
	// for the document classifier. The URI must be in the same Amazon Web Services
	// Region as the API endpoint that you are calling.
	TestS3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassifierInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassifierInputDataConfig"}
	if s.LabelDelimiter != nil && len(*s.LabelDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelDelimiter", 1))
	}
	if s.AugmentedManifests != nil {
		for i, v := range s.AugmentedManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AugmentedManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DocumentReaderConfig != nil {
		if err := s.DocumentReaderConfig.Validate(); err != nil {
			invalidParams.AddNested("DocumentReaderConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Documents != nil {
		if err := s.Documents.Validate(); err != nil {
			invalidParams.AddNested("Documents", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAugmentedManifests sets the AugmentedManifests field's value.
func (s *DocumentClassifierInputDataConfig) SetAugmentedManifests(v []*AugmentedManifestsListItem) *DocumentClassifierInputDataConfig {
	s.AugmentedManifests = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *DocumentClassifierInputDataConfig) SetDataFormat(v string) *DocumentClassifierInputDataConfig {
	s.DataFormat = &v
	return s
}

// SetDocumentReaderConfig sets the DocumentReaderConfig field's value.
func (s *DocumentClassifierInputDataConfig) SetDocumentReaderConfig(v *DocumentReaderConfig) *DocumentClassifierInputDataConfig {
	s.DocumentReaderConfig = v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *DocumentClassifierInputDataConfig) SetDocumentType(v string) *DocumentClassifierInputDataConfig {
	s.DocumentType = &v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *DocumentClassifierInputDataConfig) SetDocuments(v *DocumentClassifierDocuments) *DocumentClassifierInputDataConfig {
	s.Documents = v
	return s
}

// SetLabelDelimiter sets the LabelDelimiter field's value.
func (s *DocumentClassifierInputDataConfig) SetLabelDelimiter(v string) *DocumentClassifierInputDataConfig {
	s.LabelDelimiter = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DocumentClassifierInputDataConfig) SetS3Uri(v string) *DocumentClassifierInputDataConfig {
	s.S3Uri = &v
	return s
}

// SetTestS3Uri sets the TestS3Uri field's value.
func (s *DocumentClassifierInputDataConfig) SetTestS3Uri(v string) *DocumentClassifierInputDataConfig {
	s.TestS3Uri = &v
	return s
}

// Provide the location for output data from a custom classifier job. This field
// is mandatory if you are training a native document model.
type DocumentClassifierOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 prefix for the data lake location of the flywheel statistics.
	FlywheelStatsS3Prefix *string `type:"string"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId
	// can be one of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object while creating a custom classifier,
	// you specify the Amazon S3 location where you want to write the confusion
	// matrix and other output files. The URI must be in the same Region as the
	// API endpoint that you are calling. The location is used as the prefix for
	// the actual location of this output file.
	//
	// When the custom classifier job is finished, the service creates the output
	// file in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the confusion matrix.
	S3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierOutputDataConfig) GoString() string {
	return s.String()
}

// SetFlywheelStatsS3Prefix sets the FlywheelStatsS3Prefix field's value.
func (s *DocumentClassifierOutputDataConfig) SetFlywheelStatsS3Prefix(v string) *DocumentClassifierOutputDataConfig {
	s.FlywheelStatsS3Prefix = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DocumentClassifierOutputDataConfig) SetKmsKeyId(v string) *DocumentClassifierOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DocumentClassifierOutputDataConfig) SetS3Uri(v string) *DocumentClassifierOutputDataConfig {
	s.S3Uri = &v
	return s
}

// Provides information about a document classifier.
type DocumentClassifierProperties struct {
	_ struct{} `type:"structure"`

	// Information about the document classifier, including the number of documents
	// used for training the classifier, the number of documents used for test the
	// classifier, and an accuracy rating.
	//
	// ClassifierMetadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DocumentClassifierProperties's
	// String and GoString methods.
	ClassifierMetadata *ClassifierMetadata `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that training the document classifier completed.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string `type:"string"`

	// The input data configuration that you supplied when you created the document
	// classifier for training.
	InputDataConfig *DocumentClassifierInputDataConfig `type:"structure"`

	// The language code for the language of the documents that the classifier was
	// trained on.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Additional information about the status of the classifier.
	Message *string `type:"string"`

	// Indicates the mode in which the specific classifier was trained. This also
	// indicates the format of input documents and the format of the confusion matrix.
	// Each classifier can only be trained in one mode and this cannot be changed
	// once the classifier is trained.
	Mode *string `type:"string" enum:"DocumentClassifierMode"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// Provides output results configuration parameters for custom classifier jobs.
	OutputDataConfig *DocumentClassifierOutputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the source model. This model was imported
	// from a different Amazon Web Services account to create the document classifier
	// model in your Amazon Web Services account.
	SourceModelArn *string `type:"string"`

	// The status of the document classifier. If the status is TRAINED the classifier
	// is ready to use. If the status is TRAINED_WITH_WARNINGS the classifier training
	// succeeded, but you should review the warnings returned in the CreateDocumentClassifier
	// response.
	//
	// If the status is FAILED you can see additional information about why the
	// classifier wasn't trained in the Message field.
	Status *string `type:"string" enum:"ModelStatus"`

	// The time that the document classifier was submitted for training.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the document classifier was completed. Indicates
	// the time when the training completes on documentation classifiers. You are
	// billed for the time interval between this time and the value of TrainingStartTime.
	TrainingEndTime *time.Time `type:"timestamp"`

	// Indicates the time when the training starts on documentation classifiers.
	// You are billed for the time interval between this time and the value of TrainingEndTime.
	TrainingStartTime *time.Time `type:"timestamp"`

	// The version name that you assigned to the document classifier.
	VersionName *string `type:"string"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom classifier. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierProperties) GoString() string {
	return s.String()
}

// SetClassifierMetadata sets the ClassifierMetadata field's value.
func (s *DocumentClassifierProperties) SetClassifierMetadata(v *ClassifierMetadata) *DocumentClassifierProperties {
	s.ClassifierMetadata = v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DocumentClassifierProperties) SetDataAccessRoleArn(v string) *DocumentClassifierProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DocumentClassifierProperties) SetDocumentClassifierArn(v string) *DocumentClassifierProperties {
	s.DocumentClassifierArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DocumentClassifierProperties) SetEndTime(v time.Time) *DocumentClassifierProperties {
	s.EndTime = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *DocumentClassifierProperties) SetFlywheelArn(v string) *DocumentClassifierProperties {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DocumentClassifierProperties) SetInputDataConfig(v *DocumentClassifierInputDataConfig) *DocumentClassifierProperties {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DocumentClassifierProperties) SetLanguageCode(v string) *DocumentClassifierProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DocumentClassifierProperties) SetMessage(v string) *DocumentClassifierProperties {
	s.Message = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *DocumentClassifierProperties) SetMode(v string) *DocumentClassifierProperties {
	s.Mode = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *DocumentClassifierProperties) SetModelKmsKeyId(v string) *DocumentClassifierProperties {
	s.ModelKmsKeyId = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DocumentClassifierProperties) SetOutputDataConfig(v *DocumentClassifierOutputDataConfig) *DocumentClassifierProperties {
	s.OutputDataConfig = v
	return s
}

// SetSourceModelArn sets the SourceModelArn field's value.
func (s *DocumentClassifierProperties) SetSourceModelArn(v string) *DocumentClassifierProperties {
	s.SourceModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentClassifierProperties) SetStatus(v string) *DocumentClassifierProperties {
	s.Status = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DocumentClassifierProperties) SetSubmitTime(v time.Time) *DocumentClassifierProperties {
	s.SubmitTime = &v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *DocumentClassifierProperties) SetTrainingEndTime(v time.Time) *DocumentClassifierProperties {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *DocumentClassifierProperties) SetTrainingStartTime(v time.Time) *DocumentClassifierProperties {
	s.TrainingStartTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DocumentClassifierProperties) SetVersionName(v string) *DocumentClassifierProperties {
	s.VersionName = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DocumentClassifierProperties) SetVolumeKmsKeyId(v string) *DocumentClassifierProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DocumentClassifierProperties) SetVpcConfig(v *VpcConfig) *DocumentClassifierProperties {
	s.VpcConfig = v
	return s
}

// Describes information about a document classifier and its versions.
type DocumentClassifierSummary struct {
	_ struct{} `type:"structure"`

	// The name that you assigned the document classifier.
	DocumentClassifierName *string `type:"string"`

	// The time that the latest document classifier version was submitted for processing.
	LatestVersionCreatedAt *time.Time `type:"timestamp"`

	// The version name you assigned to the latest document classifier version.
	LatestVersionName *string `type:"string"`

	// Provides the status of the latest document classifier version.
	LatestVersionStatus *string `type:"string" enum:"ModelStatus"`

	// The number of versions you created.
	NumberOfVersions *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentClassifierSummary) GoString() string {
	return s.String()
}

// SetDocumentClassifierName sets the DocumentClassifierName field's value.
func (s *DocumentClassifierSummary) SetDocumentClassifierName(v string) *DocumentClassifierSummary {
	s.DocumentClassifierName = &v
	return s
}

// SetLatestVersionCreatedAt sets the LatestVersionCreatedAt field's value.
func (s *DocumentClassifierSummary) SetLatestVersionCreatedAt(v time.Time) *DocumentClassifierSummary {
	s.LatestVersionCreatedAt = &v
	return s
}

// SetLatestVersionName sets the LatestVersionName field's value.
func (s *DocumentClassifierSummary) SetLatestVersionName(v string) *DocumentClassifierSummary {
	s.LatestVersionName = &v
	return s
}

// SetLatestVersionStatus sets the LatestVersionStatus field's value.
func (s *DocumentClassifierSummary) SetLatestVersionStatus(v string) *DocumentClassifierSummary {
	s.LatestVersionStatus = &v
	return s
}

// SetNumberOfVersions sets the NumberOfVersions field's value.
func (s *DocumentClassifierSummary) SetNumberOfVersions(v int64) *DocumentClassifierSummary {
	s.NumberOfVersions = &v
	return s
}

// Specifies one of the label or labels that categorize the document being analyzed.
type DocumentLabel struct {
	_ struct{} `type:"structure"`

	// The name of the label.
	Name *string `min:"1" type:"string"`

	// Page number where the label occurs. This field is present in the response
	// only if your request includes the Byte parameter.
	Page *int64 `type:"integer"`

	// The confidence score that Amazon Comprehend has this label correctly attributed.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentLabel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentLabel) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DocumentLabel) SetName(v string) *DocumentLabel {
	s.Name = &v
	return s
}

// SetPage sets the Page field's value.
func (s *DocumentLabel) SetPage(v int64) *DocumentLabel {
	s.Page = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DocumentLabel) SetScore(v float64) *DocumentLabel {
	s.Score = &v
	return s
}

// Information about the document, discovered during text extraction.
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// List of pages in the document, with the number of characters extracted from
	// each page.
	ExtractedCharacters []*ExtractedCharactersListItem `type:"list"`

	// Number of pages in the document.
	Pages *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadata) GoString() string {
	return s.String()
}

// SetExtractedCharacters sets the ExtractedCharacters field's value.
func (s *DocumentMetadata) SetExtractedCharacters(v []*ExtractedCharactersListItem) *DocumentMetadata {
	s.ExtractedCharacters = v
	return s
}

// SetPages sets the Pages field's value.
func (s *DocumentMetadata) SetPages(v int64) *DocumentMetadata {
	s.Pages = &v
	return s
}

// Provides configuration parameters to override the default actions for extracting
// text from PDF documents and image files.
//
// By default, Amazon Comprehend performs the following actions to extract text
// from files, based on the input file type:
//
//   - Word files - Amazon Comprehend parser extracts the text.
//
//   - Digital PDF files - Amazon Comprehend parser extracts the text.
//
//   - Image files and scanned PDF files - Amazon Comprehend uses the Amazon
//     Textract DetectDocumentText API to extract the text.
//
// DocumentReaderConfig does not apply to plain text files or Word files.
//
// For image files and PDF documents, you can override these default actions
// using the fields listed below. For more information, see Setting text extraction
// options (https://docs.aws.amazon.com/comprehend/latest/dg/idp-set-textract-options.html)
// in the Comprehend Developer Guide.
type DocumentReaderConfig struct {
	_ struct{} `type:"structure"`

	// This field defines the Amazon Textract API operation that Amazon Comprehend
	// uses to extract text from PDF files and image files. Enter one of the following
	// values:
	//
	//    * TEXTRACT_DETECT_DOCUMENT_TEXT - The Amazon Comprehend service uses the
	//    DetectDocumentText API operation.
	//
	//    * TEXTRACT_ANALYZE_DOCUMENT - The Amazon Comprehend service uses the AnalyzeDocument
	//    API operation.
	//
	// DocumentReadAction is a required field
	DocumentReadAction *string `type:"string" required:"true" enum:"DocumentReadAction"`

	// Determines the text extraction actions for PDF files. Enter one of the following
	// values:
	//
	//    * SERVICE_DEFAULT - use the Amazon Comprehend service defaults for PDF
	//    files.
	//
	//    * FORCE_DOCUMENT_READ_ACTION - Amazon Comprehend uses the Textract API
	//    specified by DocumentReadAction for all PDF files, including digital PDF
	//    files.
	DocumentReadMode *string `type:"string" enum:"DocumentReadMode"`

	// Specifies the type of Amazon Textract features to apply. If you chose TEXTRACT_ANALYZE_DOCUMENT
	// as the read action, you must specify one or both of the following values:
	//
	//    * TABLES - Returns information about any tables that are detected in the
	//    input document.
	//
	//    * FORMS - Returns information and the data from any forms that are detected
	//    in the input document.
	FeatureTypes []*string `min:"1" type:"list" enum:"DocumentReadFeatureTypes"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentReaderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentReaderConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentReaderConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentReaderConfig"}
	if s.DocumentReadAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentReadAction"))
	}
	if s.FeatureTypes != nil && len(s.FeatureTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentReadAction sets the DocumentReadAction field's value.
func (s *DocumentReaderConfig) SetDocumentReadAction(v string) *DocumentReaderConfig {
	s.DocumentReadAction = &v
	return s
}

// SetDocumentReadMode sets the DocumentReadMode field's value.
func (s *DocumentReaderConfig) SetDocumentReadMode(v string) *DocumentReaderConfig {
	s.DocumentReadMode = &v
	return s
}

// SetFeatureTypes sets the FeatureTypes field's value.
func (s *DocumentReaderConfig) SetFeatureTypes(v []*string) *DocumentReaderConfig {
	s.FeatureTypes = v
	return s
}

// Document type for each page in the document.
type DocumentTypeListItem struct {
	_ struct{} `type:"structure"`

	// Page number.
	Page *int64 `type:"integer"`

	// Document type.
	Type *string `type:"string" enum:"DocumentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentTypeListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentTypeListItem) GoString() string {
	return s.String()
}

// SetPage sets the Page field's value.
func (s *DocumentTypeListItem) SetPage(v int64) *DocumentTypeListItem {
	s.Page = &v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentTypeListItem) SetType(v string) *DocumentTypeListItem {
	s.Type = &v
	return s
}

// Returns the code for the dominant language in the input text and the level
// of confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the dominant language. For more information
	// about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	LanguageCode *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguage) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DominantLanguage) SetLanguageCode(v string) *DominantLanguage {
	s.LanguageCode = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DominantLanguage) SetScore(v float64) *DominantLanguage {
	s.Score = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type DominantLanguageDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguageDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguageDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DominantLanguageDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DominantLanguageDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobName(v string) *DominantLanguageDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobStatus(v string) *DominantLanguageDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a dominant language detection job.
type DominantLanguageDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the dominant language detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the dominant
	// language detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the dominant language detection job. It
	// is a unique, fully qualified identifier for the job. It includes the Amazon
	// Web Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the dominant language detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the dominant language detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the dominant language detection job. If the status
	// is FAILED, the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the dominant
	// language detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the dominant language detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your dominant language detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguageDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DominantLanguageDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DominantLanguageDetectionJobProperties) SetDataAccessRoleArn(v string) *DominantLanguageDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetEndTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *DominantLanguageDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobArn(v string) *DominantLanguageDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobId(v string) *DominantLanguageDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobName(v string) *DominantLanguageDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobStatus(v string) *DominantLanguageDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DominantLanguageDetectionJobProperties) SetMessage(v string) *DominantLanguageDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *DominantLanguageDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetSubmitTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DominantLanguageDetectionJobProperties) SetVolumeKmsKeyId(v string) *DominantLanguageDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetVpcConfig(v *VpcConfig) *DominantLanguageDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// The filter used to determine which endpoints are returned. You can filter
// jobs on their name, model, status, or the date and time that they were created.
// You can only set one filter at a time.
type EndpointFilter struct {
	_ struct{} `type:"structure"`

	// Specifies a date after which the returned endpoint or endpoints were created.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Specifies a date before which the returned endpoint or endpoints were created.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint being returned. Possible values are:
	// Creating, Ready, Updating, Deleting, Failed.
	Status *string `type:"string" enum:"EndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointFilter) GoString() string {
	return s.String()
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *EndpointFilter) SetCreationTimeAfter(v time.Time) *EndpointFilter {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *EndpointFilter) SetCreationTimeBefore(v time.Time) *EndpointFilter {
	s.CreationTimeBefore = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *EndpointFilter) SetModelArn(v string) *EndpointFilter {
	s.ModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EndpointFilter) SetStatus(v string) *EndpointFilter {
	s.Status = &v
	return s
}

// Specifies information about the specified endpoint. For information about
// endpoints, see Managing endpoints (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
type EndpointProperties struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the endpoint.
	CreationTime *time.Time `type:"timestamp"`

	// The number of inference units currently used by the model using this endpoint.
	CurrentInferenceUnits *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to trained custom models encrypted with a customer managed key
	// (ModelKmsKeyId).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// Data access role ARN to use in case the new model is encrypted with a customer
	// KMS key.
	DesiredDataAccessRoleArn *string `min:"20" type:"string"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	DesiredInferenceUnits *int64 `min:"1" type:"integer"`

	// ARN of the new model to use for updating an existing endpoint. This ARN is
	// going to be different from the model ARN when the update is in progress
	DesiredModelArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the endpoint.
	EndpointArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string `type:"string"`

	// The date and time that the endpoint was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Specifies a reason for failure in cases of Failed status.
	Message *string `type:"string"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint. Because the endpoint updates and creation
	// are asynchronous, so customers will need to wait for the endpoint to be Ready
	// status before making inference requests.
	Status *string `type:"string" enum:"EndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointProperties) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointProperties) SetCreationTime(v time.Time) *EndpointProperties {
	s.CreationTime = &v
	return s
}

// SetCurrentInferenceUnits sets the CurrentInferenceUnits field's value.
func (s *EndpointProperties) SetCurrentInferenceUnits(v int64) *EndpointProperties {
	s.CurrentInferenceUnits = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EndpointProperties) SetDataAccessRoleArn(v string) *EndpointProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDesiredDataAccessRoleArn sets the DesiredDataAccessRoleArn field's value.
func (s *EndpointProperties) SetDesiredDataAccessRoleArn(v string) *EndpointProperties {
	s.DesiredDataAccessRoleArn = &v
	return s
}

// SetDesiredInferenceUnits sets the DesiredInferenceUnits field's value.
func (s *EndpointProperties) SetDesiredInferenceUnits(v int64) *EndpointProperties {
	s.DesiredInferenceUnits = &v
	return s
}

// SetDesiredModelArn sets the DesiredModelArn field's value.
func (s *EndpointProperties) SetDesiredModelArn(v string) *EndpointProperties {
	s.DesiredModelArn = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *EndpointProperties) SetEndpointArn(v string) *EndpointProperties {
	s.EndpointArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *EndpointProperties) SetFlywheelArn(v string) *EndpointProperties {
	s.FlywheelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *EndpointProperties) SetLastModifiedTime(v time.Time) *EndpointProperties {
	s.LastModifiedTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EndpointProperties) SetMessage(v string) *EndpointProperties {
	s.Message = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *EndpointProperties) SetModelArn(v string) *EndpointProperties {
	s.ModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EndpointProperties) SetStatus(v string) *EndpointProperties {
	s.Status = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type EntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntitiesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobFilter) SetJobName(v string) *EntitiesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobFilter) SetJobStatus(v string) *EntitiesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about an entities detection job.
type EntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the entities detection job completed
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flywheel associated with this job.
	FlywheelArn *string `type:"string"`

	// The input data configuration that you supplied when you created the entities
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the entities detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the entities
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your entity detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntitiesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EntitiesDetectionJobProperties) SetDataAccessRoleArn(v string) *EntitiesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EntitiesDetectionJobProperties) SetEndTime(v time.Time) *EntitiesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *EntitiesDetectionJobProperties) SetEntityRecognizerArn(v string) *EntitiesDetectionJobProperties {
	s.EntityRecognizerArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *EntitiesDetectionJobProperties) SetFlywheelArn(v string) *EntitiesDetectionJobProperties {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *EntitiesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *EntitiesDetectionJobProperties) SetJobArn(v string) *EntitiesDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EntitiesDetectionJobProperties) SetJobId(v string) *EntitiesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobProperties) SetJobName(v string) *EntitiesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobProperties) SetJobStatus(v string) *EntitiesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EntitiesDetectionJobProperties) SetLanguageCode(v string) *EntitiesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EntitiesDetectionJobProperties) SetMessage(v string) *EntitiesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *EntitiesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EntitiesDetectionJobProperties) SetSubmitTime(v time.Time) *EntitiesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *EntitiesDetectionJobProperties) SetVolumeKmsKeyId(v string) *EntitiesDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *EntitiesDetectionJobProperties) SetVpcConfig(v *VpcConfig) *EntitiesDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// Provides information about an entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the entity.
	//
	// This field is empty for non-text input.
	BeginOffset *int64 `type:"integer"`

	// A reference to each block for this entity. This field is empty for plain-text
	// input.
	BlockReferences []*BlockReference `type:"list"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the entity.
	//
	// This field is empty for non-text input.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of the entity.
	Text *string `min:"1" type:"string"`

	// The entity type. For entity detection using the built-in model, this field
	// contains one of the standard entity types listed below.
	//
	// For custom entity detection, this field contains one of the entity types
	// that you specified when you trained your custom model.
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetBlockReferences sets the BlockReferences field's value.
func (s *Entity) SetBlockReferences(v []*BlockReference) *Entity {
	s.BlockReferences = v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// Specifies one of the label or labels that categorize the personally identifiable
// information (PII) entity being analyzed.
type EntityLabel struct {
	_ struct{} `type:"structure"`

	// The name of the label.
	Name *string `type:"string" enum:"PiiEntityType"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityLabel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityLabel) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EntityLabel) SetName(v string) *EntityLabel {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *EntityLabel) SetScore(v float64) *EntityLabel {
	s.Score = &v
	return s
}

// Configuration required for an entity recognition model.
type EntityRecognitionConfig struct {
	_ struct{} `type:"structure"`

	// Up to 25 entity types that the model is trained to recognize.
	//
	// EntityTypes is a required field
	EntityTypes []*EntityTypesListItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognitionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognitionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognitionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognitionConfig"}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.EntityTypes != nil {
		for i, v := range s.EntityTypes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityTypes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityRecognitionConfig) SetEntityTypes(v []*EntityTypesListItem) *EntityRecognitionConfig {
	s.EntityTypes = v
	return s
}

// Describes the annotations associated with a entity recognizer.
type EntityRecognizerAnnotations struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the annotations for an entity recognizer
	// are located. The URI must be in the same Region as the API endpoint that
	// you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`

	// Specifies the Amazon S3 location where the test annotations for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	TestS3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerAnnotations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerAnnotations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerAnnotations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerAnnotations"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerAnnotations) SetS3Uri(v string) *EntityRecognizerAnnotations {
	s.S3Uri = &v
	return s
}

// SetTestS3Uri sets the TestS3Uri field's value.
func (s *EntityRecognizerAnnotations) SetTestS3Uri(v string) *EntityRecognizerAnnotations {
	s.TestS3Uri = &v
	return s
}

// Describes the training documents submitted with an entity recognizer.
type EntityRecognizerDocuments struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed. This is optional,
	// and the default is ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered
	// a separate document. Use this option when you are processing large documents,
	// such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each
	// line in a file is considered a separate document. Use this option when you
	// are processing many short documents, such as text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same Region as the API endpoint
	// that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`

	// Specifies the Amazon S3 location where the test documents for an entity recognizer
	// are located. The URI must be in the same Amazon Web Services Region as the
	// API endpoint that you are calling.
	TestS3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerDocuments"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputFormat sets the InputFormat field's value.
func (s *EntityRecognizerDocuments) SetInputFormat(v string) *EntityRecognizerDocuments {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerDocuments) SetS3Uri(v string) *EntityRecognizerDocuments {
	s.S3Uri = &v
	return s
}

// SetTestS3Uri sets the TestS3Uri field's value.
func (s *EntityRecognizerDocuments) SetTestS3Uri(v string) *EntityRecognizerDocuments {
	s.TestS3Uri = &v
	return s
}

// Describes the entity list submitted with an entity recognizer.
type EntityRecognizerEntityList struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the entity list is located. The URI
	// must be in the same Region as the API endpoint that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerEntityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerEntityList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerEntityList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerEntityList"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerEntityList) SetS3Uri(v string) *EntityRecognizerEntityList {
	s.S3Uri = &v
	return s
}

// Detailed information about the accuracy of an entity recognizer.
type EntityRecognizerEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. For plain text entity recognizer models, the range
	// is 0 to 100, where 100 is the best score. For PDF/Word entity recognizer
	// models, the range is 0 to 1, where 1 is the best score.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for the test data. High
	// recall means that the recognizer returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerEvaluationMetrics) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *EntityRecognizerEvaluationMetrics) SetF1Score(v float64) *EntityRecognizerEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *EntityRecognizerEvaluationMetrics) SetPrecision(v float64) *EntityRecognizerEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *EntityRecognizerEvaluationMetrics) SetRecall(v float64) *EntityRecognizerEvaluationMetrics {
	s.Recall = &v
	return s
}

// Provides information for filtering a list of entity recognizers. You can
// only specify one filtering parameter in a request. For more information,
// see the ListEntityRecognizers operation./>
type EntityRecognizerFilter struct {
	_ struct{} `type:"structure"`

	// The name that you assigned the entity recognizer.
	RecognizerName *string `type:"string"`

	// The status of an entity recognizer.
	Status *string `type:"string" enum:"ModelStatus"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted after the specified time. Jobs
	// are returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted before the specified time. Jobs
	// are returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerFilter) GoString() string {
	return s.String()
}

// SetRecognizerName sets the RecognizerName field's value.
func (s *EntityRecognizerFilter) SetRecognizerName(v string) *EntityRecognizerFilter {
	s.RecognizerName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EntityRecognizerFilter) SetStatus(v string) *EntityRecognizerFilter {
	s.Status = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EntityRecognizerFilter) SetSubmitTimeAfter(v time.Time) *EntityRecognizerFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EntityRecognizerFilter) SetSubmitTimeBefore(v time.Time) *EntityRecognizerFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Specifies the format and location of the input data.
type EntityRecognizerInputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location of the CSV file that annotates your training documents.
	Annotations *EntityRecognizerAnnotations `type:"structure"`

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	//
	// This parameter is required if you set DataFormat to AUGMENTED_MANIFEST.
	AugmentedManifests []*AugmentedManifestsListItem `type:"list"`

	// The format of your training data:
	//
	//    * COMPREHEND_CSV: A CSV file that supplements your training documents.
	//    The CSV file contains information about the custom entities that your
	//    trained model will detect. The required format of the file depends on
	//    whether you are providing annotations or an entity list. If you use this
	//    value, you must provide your CSV file by using either the Annotations
	//    or EntityList parameters. You must provide your training documents by
	//    using the Documents parameter.
	//
	//    * AUGMENTED_MANIFEST: A labeled dataset that is produced by Amazon SageMaker
	//    Ground Truth. This file is in JSON lines format. Each line is a complete
	//    JSON object that contains a training document and its labels. Each label
	//    annotates a named entity in the training document. If you use this value,
	//    you must provide the AugmentedManifests parameter in your request.
	//
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat *string `type:"string" enum:"EntityRecognizerDataFormat"`

	// The S3 location of the folder that contains the training documents for your
	// custom entity recognizer.
	//
	// This parameter is required if you set DataFormat to COMPREHEND_CSV.
	Documents *EntityRecognizerDocuments `type:"structure"`

	// The S3 location of the CSV file that has the entity list for your custom
	// entity recognizer.
	EntityList *EntityRecognizerEntityList `type:"structure"`

	// The entity types in the labeled training data that Amazon Comprehend uses
	// to train the custom entity recognizer. Any entity types that you don't specify
	// are ignored.
	//
	// A maximum of 25 entity types can be used at one time to train an entity recognizer.
	// Entity types must not contain the following invalid characters: \n (line
	// break), \\n (escaped line break), \r (carriage return), \\r (escaped carriage
	// return), \t (tab), \\t (escaped tab), space, and , (comma).
	//
	// EntityTypes is a required field
	EntityTypes []*EntityTypesListItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerInputDataConfig"}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.Annotations != nil {
		if err := s.Annotations.Validate(); err != nil {
			invalidParams.AddNested("Annotations", err.(request.ErrInvalidParams))
		}
	}
	if s.AugmentedManifests != nil {
		for i, v := range s.AugmentedManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AugmentedManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Documents != nil {
		if err := s.Documents.Validate(); err != nil {
			invalidParams.AddNested("Documents", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityList != nil {
		if err := s.EntityList.Validate(); err != nil {
			invalidParams.AddNested("EntityList", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityTypes != nil {
		for i, v := range s.EntityTypes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityTypes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotations sets the Annotations field's value.
func (s *EntityRecognizerInputDataConfig) SetAnnotations(v *EntityRecognizerAnnotations) *EntityRecognizerInputDataConfig {
	s.Annotations = v
	return s
}

// SetAugmentedManifests sets the AugmentedManifests field's value.
func (s *EntityRecognizerInputDataConfig) SetAugmentedManifests(v []*AugmentedManifestsListItem) *EntityRecognizerInputDataConfig {
	s.AugmentedManifests = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *EntityRecognizerInputDataConfig) SetDataFormat(v string) *EntityRecognizerInputDataConfig {
	s.DataFormat = &v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *EntityRecognizerInputDataConfig) SetDocuments(v *EntityRecognizerDocuments) *EntityRecognizerInputDataConfig {
	s.Documents = v
	return s
}

// SetEntityList sets the EntityList field's value.
func (s *EntityRecognizerInputDataConfig) SetEntityList(v *EntityRecognizerEntityList) *EntityRecognizerInputDataConfig {
	s.EntityList = v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityRecognizerInputDataConfig) SetEntityTypes(v []*EntityTypesListItem) *EntityRecognizerInputDataConfig {
	s.EntityTypes = v
	return s
}

// Detailed information about an entity recognizer.
type EntityRecognizerMetadata struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Entity types from the metadata of an entity recognizer.
	EntityTypes []*EntityRecognizerMetadataEntityTypesListItem `type:"list"`

	// Detailed information about the accuracy of an entity recognizer.
	EvaluationMetrics *EntityRecognizerEvaluationMetrics `type:"structure"`

	// The number of documents in the input data that were used to test the entity
	// recognizer. Typically this is 10 to 20 percent of the input documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the entity
	// recognizer. Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerMetadata) GoString() string {
	return s.String()
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityRecognizerMetadata) SetEntityTypes(v []*EntityRecognizerMetadataEntityTypesListItem) *EntityRecognizerMetadata {
	s.EntityTypes = v
	return s
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *EntityRecognizerMetadata) SetEvaluationMetrics(v *EntityRecognizerEvaluationMetrics) *EntityRecognizerMetadata {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfTestDocuments sets the NumberOfTestDocuments field's value.
func (s *EntityRecognizerMetadata) SetNumberOfTestDocuments(v int64) *EntityRecognizerMetadata {
	s.NumberOfTestDocuments = &v
	return s
}

// SetNumberOfTrainedDocuments sets the NumberOfTrainedDocuments field's value.
func (s *EntityRecognizerMetadata) SetNumberOfTrainedDocuments(v int64) *EntityRecognizerMetadata {
	s.NumberOfTrainedDocuments = &v
	return s
}

// Individual item from the list of entity types in the metadata of an entity
// recognizer.
type EntityRecognizerMetadataEntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// Detailed information about the accuracy of the entity recognizer for a specific
	// item on the list of entity types.
	EvaluationMetrics *EntityTypesEvaluationMetrics `type:"structure"`

	// Indicates the number of times the given entity type was seen in the training
	// data.
	NumberOfTrainMentions *int64 `type:"integer"`

	// Type of entity from the list of entity types in the metadata of an entity
	// recognizer.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerMetadataEntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerMetadataEntityTypesListItem) GoString() string {
	return s.String()
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetEvaluationMetrics(v *EntityTypesEvaluationMetrics) *EntityRecognizerMetadataEntityTypesListItem {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfTrainMentions sets the NumberOfTrainMentions field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetNumberOfTrainMentions(v int64) *EntityRecognizerMetadataEntityTypesListItem {
	s.NumberOfTrainMentions = &v
	return s
}

// SetType sets the Type field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetType(v string) *EntityRecognizerMetadataEntityTypesListItem {
	s.Type = &v
	return s
}

// Output data configuration.
type EntityRecognizerOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 prefix for the data lake location of the flywheel statistics.
	FlywheelStatsS3Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerOutputDataConfig) GoString() string {
	return s.String()
}

// SetFlywheelStatsS3Prefix sets the FlywheelStatsS3Prefix field's value.
func (s *EntityRecognizerOutputDataConfig) SetFlywheelStatsS3Prefix(v string) *EntityRecognizerOutputDataConfig {
	s.FlywheelStatsS3Prefix = &v
	return s
}

// Describes information about an entity recognizer.
type EntityRecognizerProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the recognizer creation completed.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string `type:"string"`

	// The input data properties of an entity recognizer.
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	// Only English ("en") is currently supported.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of the recognizer.
	Message *string `type:"string"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// Output data configuration.
	OutputDataConfig *EntityRecognizerOutputDataConfig `type:"structure"`

	// Provides information about an entity recognizer.
	//
	// RecognizerMetadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EntityRecognizerProperties's
	// String and GoString methods.
	RecognizerMetadata *EntityRecognizerMetadata `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the source model. This model was imported
	// from a different Amazon Web Services account to create the entity recognizer
	// model in your Amazon Web Services account.
	SourceModelArn *string `type:"string"`

	// Provides the status of the entity recognizer.
	Status *string `type:"string" enum:"ModelStatus"`

	// The time that the recognizer was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer was completed.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer started.
	TrainingStartTime *time.Time `type:"timestamp"`

	// The version name you assigned to the entity recognizer.
	VersionName *string `type:"string"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom entity recognizer. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EntityRecognizerProperties) SetDataAccessRoleArn(v string) *EntityRecognizerProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EntityRecognizerProperties) SetEndTime(v time.Time) *EntityRecognizerProperties {
	s.EndTime = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *EntityRecognizerProperties) SetEntityRecognizerArn(v string) *EntityRecognizerProperties {
	s.EntityRecognizerArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *EntityRecognizerProperties) SetFlywheelArn(v string) *EntityRecognizerProperties {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EntityRecognizerProperties) SetInputDataConfig(v *EntityRecognizerInputDataConfig) *EntityRecognizerProperties {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EntityRecognizerProperties) SetLanguageCode(v string) *EntityRecognizerProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EntityRecognizerProperties) SetMessage(v string) *EntityRecognizerProperties {
	s.Message = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *EntityRecognizerProperties) SetModelKmsKeyId(v string) *EntityRecognizerProperties {
	s.ModelKmsKeyId = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *EntityRecognizerProperties) SetOutputDataConfig(v *EntityRecognizerOutputDataConfig) *EntityRecognizerProperties {
	s.OutputDataConfig = v
	return s
}

// SetRecognizerMetadata sets the RecognizerMetadata field's value.
func (s *EntityRecognizerProperties) SetRecognizerMetadata(v *EntityRecognizerMetadata) *EntityRecognizerProperties {
	s.RecognizerMetadata = v
	return s
}

// SetSourceModelArn sets the SourceModelArn field's value.
func (s *EntityRecognizerProperties) SetSourceModelArn(v string) *EntityRecognizerProperties {
	s.SourceModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EntityRecognizerProperties) SetStatus(v string) *EntityRecognizerProperties {
	s.Status = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EntityRecognizerProperties) SetSubmitTime(v time.Time) *EntityRecognizerProperties {
	s.SubmitTime = &v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *EntityRecognizerProperties) SetTrainingEndTime(v time.Time) *EntityRecognizerProperties {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *EntityRecognizerProperties) SetTrainingStartTime(v time.Time) *EntityRecognizerProperties {
	s.TrainingStartTime = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *EntityRecognizerProperties) SetVersionName(v string) *EntityRecognizerProperties {
	s.VersionName = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *EntityRecognizerProperties) SetVolumeKmsKeyId(v string) *EntityRecognizerProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *EntityRecognizerProperties) SetVpcConfig(v *VpcConfig) *EntityRecognizerProperties {
	s.VpcConfig = v
	return s
}

// Describes the information about an entity recognizer and its versions.
type EntityRecognizerSummary struct {
	_ struct{} `type:"structure"`

	// The time that the latest entity recognizer version was submitted for processing.
	LatestVersionCreatedAt *time.Time `type:"timestamp"`

	// The version name you assigned to the latest entity recognizer version.
	LatestVersionName *string `type:"string"`

	// Provides the status of the latest entity recognizer version.
	LatestVersionStatus *string `type:"string" enum:"ModelStatus"`

	// The number of versions you created.
	NumberOfVersions *int64 `type:"integer"`

	// The name that you assigned the entity recognizer.
	RecognizerName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityRecognizerSummary) GoString() string {
	return s.String()
}

// SetLatestVersionCreatedAt sets the LatestVersionCreatedAt field's value.
func (s *EntityRecognizerSummary) SetLatestVersionCreatedAt(v time.Time) *EntityRecognizerSummary {
	s.LatestVersionCreatedAt = &v
	return s
}

// SetLatestVersionName sets the LatestVersionName field's value.
func (s *EntityRecognizerSummary) SetLatestVersionName(v string) *EntityRecognizerSummary {
	s.LatestVersionName = &v
	return s
}

// SetLatestVersionStatus sets the LatestVersionStatus field's value.
func (s *EntityRecognizerSummary) SetLatestVersionStatus(v string) *EntityRecognizerSummary {
	s.LatestVersionStatus = &v
	return s
}

// SetNumberOfVersions sets the NumberOfVersions field's value.
func (s *EntityRecognizerSummary) SetNumberOfVersions(v int64) *EntityRecognizerSummary {
	s.NumberOfVersions = &v
	return s
}

// SetRecognizerName sets the RecognizerName field's value.
func (s *EntityRecognizerSummary) SetRecognizerName(v string) *EntityRecognizerSummary {
	s.RecognizerName = &v
	return s
}

// Detailed information about the accuracy of an entity recognizer for a specific
// entity type.
type EntityTypesEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for a specific entity
	// type in the test data. It is derived from the Precision and Recall values.
	// The F1Score is the harmonic average of the two scores. The highest score
	// is 1, and the worst score is 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results for a specific entity
	// type in the test data. High precision means that the recognizer returned
	// substantially more relevant results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for a specific entity
	// type in the test data. High recall means that the recognizer returned most
	// of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypesEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypesEvaluationMetrics) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *EntityTypesEvaluationMetrics) SetF1Score(v float64) *EntityTypesEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *EntityTypesEvaluationMetrics) SetPrecision(v float64) *EntityTypesEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *EntityTypesEvaluationMetrics) SetRecall(v float64) *EntityTypesEvaluationMetrics {
	s.Recall = &v
	return s
}

// An entity type within a labeled training dataset that Amazon Comprehend uses
// to train a custom entity recognizer.
type EntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// An entity type within a labeled training dataset that Amazon Comprehend uses
	// to train a custom entity recognizer.
	//
	// Entity types must not contain the following invalid characters: \n (line
	// break), \\n (escaped line break, \r (carriage return), \\r (escaped carriage
	// return), \t (tab), \\t (escaped tab), space, and , (comma).
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EntityTypesListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityTypesListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityTypesListItem"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EntityTypesListItem) SetType(v string) *EntityTypesListItem {
	s.Type = &v
	return s
}

// Text extraction encountered one or more page-level errors in the input document.
//
// The ErrorCode contains one of the following values:
//
//   - TEXTRACT_BAD_PAGE - Amazon Textract cannot read the page. For more information
//     about page limits in Amazon Textract, see Page Quotas in Amazon Textract
//     (https://docs.aws.amazon.com/textract/latest/dg/limits-document.html).
//
//   - TEXTRACT_PROVISIONED_THROUGHPUT_EXCEEDED - The number of requests exceeded
//     your throughput limit. For more information about throughput quotas in
//     Amazon Textract, see Default quotas in Amazon Textract (https://docs.aws.amazon.com/textract/latest/dg/limits-quotas-explained.html).
//
//   - PAGE_CHARACTERS_EXCEEDED - Too many text characters on the page (10,000
//     characters maximum).
//
//   - PAGE_SIZE_EXCEEDED - The maximum page size is 10 MB.
//
//   - INTERNAL_SERVER_ERROR - The request encountered a service issue. Try
//     the API request again.
type ErrorsListItem struct {
	_ struct{} `type:"structure"`

	// Error code for the cause of the error.
	ErrorCode *string `type:"string" enum:"PageBasedErrorCode"`

	// Text message explaining the reason for the error.
	ErrorMessage *string `min:"1" type:"string"`

	// Page number where the error occurred.
	Page *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorsListItem) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorsListItem) SetErrorCode(v string) *ErrorsListItem {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorsListItem) SetErrorMessage(v string) *ErrorsListItem {
	s.ErrorMessage = &v
	return s
}

// SetPage sets the Page field's value.
func (s *ErrorsListItem) SetPage(v int64) *ErrorsListItem {
	s.Page = &v
	return s
}

// Provides information for filtering a list of event detection jobs.
type EventsDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the events detection job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventsDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventsDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventsDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *EventsDetectionJobFilter) SetJobName(v string) *EventsDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EventsDetectionJobFilter) SetJobStatus(v string) *EventsDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EventsDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *EventsDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EventsDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *EventsDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about an events detection job.
type EventsDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the events detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the events
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the events detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the events detection job.
	JobId *string `min:"1" type:"string"`

	// The name you assigned the events detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the events detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of the events detection job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the events
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the events detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// The types of events that are detected by the job.
	TargetEventTypes []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventsDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventsDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EventsDetectionJobProperties) SetDataAccessRoleArn(v string) *EventsDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EventsDetectionJobProperties) SetEndTime(v time.Time) *EventsDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EventsDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *EventsDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *EventsDetectionJobProperties) SetJobArn(v string) *EventsDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EventsDetectionJobProperties) SetJobId(v string) *EventsDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *EventsDetectionJobProperties) SetJobName(v string) *EventsDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EventsDetectionJobProperties) SetJobStatus(v string) *EventsDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EventsDetectionJobProperties) SetLanguageCode(v string) *EventsDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EventsDetectionJobProperties) SetMessage(v string) *EventsDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *EventsDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *EventsDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EventsDetectionJobProperties) SetSubmitTime(v time.Time) *EventsDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetTargetEventTypes sets the TargetEventTypes field's value.
func (s *EventsDetectionJobProperties) SetTargetEventTypes(v []*string) *EventsDetectionJobProperties {
	s.TargetEventTypes = v
	return s
}

// Array of the number of characters extracted from each page.
type ExtractedCharactersListItem struct {
	_ struct{} `type:"structure"`

	// Number of characters extracted from each page.
	Count *int64 `type:"integer"`

	// Page number.
	Page *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtractedCharactersListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtractedCharactersListItem) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ExtractedCharactersListItem) SetCount(v int64) *ExtractedCharactersListItem {
	s.Count = &v
	return s
}

// SetPage sets the Page field's value.
func (s *ExtractedCharactersListItem) SetPage(v int64) *ExtractedCharactersListItem {
	s.Page = &v
	return s
}

// Filter the flywheels based on creation time or flywheel status.
type FlywheelFilter struct {
	_ struct{} `type:"structure"`

	// Filter the flywheels to include flywheels created after the specified time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Filter the flywheels to include flywheels created before the specified time.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// Filter the flywheels based on the flywheel status.
	Status *string `type:"string" enum:"FlywheelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelFilter) GoString() string {
	return s.String()
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *FlywheelFilter) SetCreationTimeAfter(v time.Time) *FlywheelFilter {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *FlywheelFilter) SetCreationTimeBefore(v time.Time) *FlywheelFilter {
	s.CreationTimeBefore = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlywheelFilter) SetStatus(v string) *FlywheelFilter {
	s.Status = &v
	return s
}

// Filter the flywheel iterations based on creation time.
type FlywheelIterationFilter struct {
	_ struct{} `type:"structure"`

	// Filter the flywheel iterations to include iterations created after the specified
	// time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Filter the flywheel iterations to include iterations created before the specified
	// time.
	CreationTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelIterationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelIterationFilter) GoString() string {
	return s.String()
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *FlywheelIterationFilter) SetCreationTimeAfter(v time.Time) *FlywheelIterationFilter {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *FlywheelIterationFilter) SetCreationTimeBefore(v time.Time) *FlywheelIterationFilter {
	s.CreationTimeBefore = &v
	return s
}

// The configuration properties of a flywheel iteration.
type FlywheelIterationProperties struct {
	_ struct{} `type:"structure"`

	// The creation start time of the flywheel iteration.
	CreationTime *time.Time `type:"timestamp"`

	// The completion time of this flywheel iteration.
	EndTime *time.Time `type:"timestamp"`

	// The ARN of the evaluated model associated with this flywheel iteration.
	EvaluatedModelArn *string `type:"string"`

	// The evaluation metrics associated with the evaluated model.
	EvaluatedModelMetrics *FlywheelModelEvaluationMetrics `type:"structure"`

	EvaluationManifestS3Prefix *string `type:"string"`

	FlywheelArn *string `type:"string"`

	FlywheelIterationId *string `type:"string"`

	// A description of the status of the flywheel iteration.
	Message *string `type:"string"`

	// The status of the flywheel iteration.
	Status *string `type:"string" enum:"FlywheelIterationStatus"`

	// The ARN of the trained model associated with this flywheel iteration.
	TrainedModelArn *string `type:"string"`

	// The metrics associated with the trained model.
	TrainedModelMetrics *FlywheelModelEvaluationMetrics `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelIterationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelIterationProperties) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *FlywheelIterationProperties) SetCreationTime(v time.Time) *FlywheelIterationProperties {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *FlywheelIterationProperties) SetEndTime(v time.Time) *FlywheelIterationProperties {
	s.EndTime = &v
	return s
}

// SetEvaluatedModelArn sets the EvaluatedModelArn field's value.
func (s *FlywheelIterationProperties) SetEvaluatedModelArn(v string) *FlywheelIterationProperties {
	s.EvaluatedModelArn = &v
	return s
}

// SetEvaluatedModelMetrics sets the EvaluatedModelMetrics field's value.
func (s *FlywheelIterationProperties) SetEvaluatedModelMetrics(v *FlywheelModelEvaluationMetrics) *FlywheelIterationProperties {
	s.EvaluatedModelMetrics = v
	return s
}

// SetEvaluationManifestS3Prefix sets the EvaluationManifestS3Prefix field's value.
func (s *FlywheelIterationProperties) SetEvaluationManifestS3Prefix(v string) *FlywheelIterationProperties {
	s.EvaluationManifestS3Prefix = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *FlywheelIterationProperties) SetFlywheelArn(v string) *FlywheelIterationProperties {
	s.FlywheelArn = &v
	return s
}

// SetFlywheelIterationId sets the FlywheelIterationId field's value.
func (s *FlywheelIterationProperties) SetFlywheelIterationId(v string) *FlywheelIterationProperties {
	s.FlywheelIterationId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FlywheelIterationProperties) SetMessage(v string) *FlywheelIterationProperties {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlywheelIterationProperties) SetStatus(v string) *FlywheelIterationProperties {
	s.Status = &v
	return s
}

// SetTrainedModelArn sets the TrainedModelArn field's value.
func (s *FlywheelIterationProperties) SetTrainedModelArn(v string) *FlywheelIterationProperties {
	s.TrainedModelArn = &v
	return s
}

// SetTrainedModelMetrics sets the TrainedModelMetrics field's value.
func (s *FlywheelIterationProperties) SetTrainedModelMetrics(v *FlywheelModelEvaluationMetrics) *FlywheelIterationProperties {
	s.TrainedModelMetrics = v
	return s
}

// The evaluation metrics associated with the evaluated model.
type FlywheelModelEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// Average accuracy metric for the model.
	AverageAccuracy *float64 `type:"double"`

	// The average F1 score from the evaluation metrics.
	AverageF1Score *float64 `type:"double"`

	// Average precision metric for the model.
	AveragePrecision *float64 `type:"double"`

	// Average recall metric for the model.
	AverageRecall *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelModelEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelModelEvaluationMetrics) GoString() string {
	return s.String()
}

// SetAverageAccuracy sets the AverageAccuracy field's value.
func (s *FlywheelModelEvaluationMetrics) SetAverageAccuracy(v float64) *FlywheelModelEvaluationMetrics {
	s.AverageAccuracy = &v
	return s
}

// SetAverageF1Score sets the AverageF1Score field's value.
func (s *FlywheelModelEvaluationMetrics) SetAverageF1Score(v float64) *FlywheelModelEvaluationMetrics {
	s.AverageF1Score = &v
	return s
}

// SetAveragePrecision sets the AveragePrecision field's value.
func (s *FlywheelModelEvaluationMetrics) SetAveragePrecision(v float64) *FlywheelModelEvaluationMetrics {
	s.AveragePrecision = &v
	return s
}

// SetAverageRecall sets the AverageRecall field's value.
func (s *FlywheelModelEvaluationMetrics) SetAverageRecall(v float64) *FlywheelModelEvaluationMetrics {
	s.AverageRecall = &v
	return s
}

// The flywheel properties.
type FlywheelProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the active model version.
	ActiveModelArn *string `type:"string"`

	// Creation time of the flywheel.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// permission to access the flywheel data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// Amazon S3 URI of the data lake location.
	DataLakeS3Uri *string `type:"string"`

	// Data security configuration.
	DataSecurityConfig *DataSecurityConfig `type:"structure"`

	// The Amazon Resource Number (ARN) of the flywheel.
	FlywheelArn *string `type:"string"`

	// Last modified time for the flywheel.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The most recent flywheel iteration.
	LatestFlywheelIteration *string `type:"string"`

	// A description of the status of the flywheel.
	Message *string `type:"string"`

	// Model type of the flywheel's model.
	ModelType *string `type:"string" enum:"ModelType"`

	// The status of the flywheel.
	Status *string `type:"string" enum:"FlywheelStatus"`

	// Configuration about the model associated with a flywheel.
	TaskConfig *TaskConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelProperties) GoString() string {
	return s.String()
}

// SetActiveModelArn sets the ActiveModelArn field's value.
func (s *FlywheelProperties) SetActiveModelArn(v string) *FlywheelProperties {
	s.ActiveModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FlywheelProperties) SetCreationTime(v time.Time) *FlywheelProperties {
	s.CreationTime = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *FlywheelProperties) SetDataAccessRoleArn(v string) *FlywheelProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDataLakeS3Uri sets the DataLakeS3Uri field's value.
func (s *FlywheelProperties) SetDataLakeS3Uri(v string) *FlywheelProperties {
	s.DataLakeS3Uri = &v
	return s
}

// SetDataSecurityConfig sets the DataSecurityConfig field's value.
func (s *FlywheelProperties) SetDataSecurityConfig(v *DataSecurityConfig) *FlywheelProperties {
	s.DataSecurityConfig = v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *FlywheelProperties) SetFlywheelArn(v string) *FlywheelProperties {
	s.FlywheelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FlywheelProperties) SetLastModifiedTime(v time.Time) *FlywheelProperties {
	s.LastModifiedTime = &v
	return s
}

// SetLatestFlywheelIteration sets the LatestFlywheelIteration field's value.
func (s *FlywheelProperties) SetLatestFlywheelIteration(v string) *FlywheelProperties {
	s.LatestFlywheelIteration = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FlywheelProperties) SetMessage(v string) *FlywheelProperties {
	s.Message = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *FlywheelProperties) SetModelType(v string) *FlywheelProperties {
	s.ModelType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlywheelProperties) SetStatus(v string) *FlywheelProperties {
	s.Status = &v
	return s
}

// SetTaskConfig sets the TaskConfig field's value.
func (s *FlywheelProperties) SetTaskConfig(v *TaskConfig) *FlywheelProperties {
	s.TaskConfig = v
	return s
}

// Flywheel summary information.
type FlywheelSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the active model version for the flywheel.
	ActiveModelArn *string `type:"string"`

	// Creation time of the flywheel.
	CreationTime *time.Time `type:"timestamp"`

	// Amazon S3 URI of the data lake location.
	DataLakeS3Uri *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel
	FlywheelArn *string `type:"string"`

	// Last modified time for the flywheel.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The most recent flywheel iteration.
	LatestFlywheelIteration *string `type:"string"`

	// A description of the status of the flywheel.
	Message *string `type:"string"`

	// Model type of the flywheel's model.
	ModelType *string `type:"string" enum:"ModelType"`

	// The status of the flywheel.
	Status *string `type:"string" enum:"FlywheelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlywheelSummary) GoString() string {
	return s.String()
}

// SetActiveModelArn sets the ActiveModelArn field's value.
func (s *FlywheelSummary) SetActiveModelArn(v string) *FlywheelSummary {
	s.ActiveModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FlywheelSummary) SetCreationTime(v time.Time) *FlywheelSummary {
	s.CreationTime = &v
	return s
}

// SetDataLakeS3Uri sets the DataLakeS3Uri field's value.
func (s *FlywheelSummary) SetDataLakeS3Uri(v string) *FlywheelSummary {
	s.DataLakeS3Uri = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *FlywheelSummary) SetFlywheelArn(v string) *FlywheelSummary {
	s.FlywheelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FlywheelSummary) SetLastModifiedTime(v time.Time) *FlywheelSummary {
	s.LastModifiedTime = &v
	return s
}

// SetLatestFlywheelIteration sets the LatestFlywheelIteration field's value.
func (s *FlywheelSummary) SetLatestFlywheelIteration(v string) *FlywheelSummary {
	s.LatestFlywheelIteration = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FlywheelSummary) SetMessage(v string) *FlywheelSummary {
	s.Message = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *FlywheelSummary) SetModelType(v string) *FlywheelSummary {
	s.ModelType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlywheelSummary) SetStatus(v string) *FlywheelSummary {
	s.Status = &v
	return s
}

// Information about the location of items on a document page.
//
// For additional information, see Geometry (https://docs.aws.amazon.com/textract/latest/dg/API_Geometry.html)
// in the Amazon Textract API reference.
type Geometry struct {
	_ struct{} `type:"structure"`

	// An axis-aligned coarse representation of the location of the recognized item
	// on the document page.
	BoundingBox *BoundingBox `type:"structure"`

	// Within the bounding box, a fine-grained polygon around the recognized item.
	Polygon []*Point `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Geometry) SetBoundingBox(v *BoundingBox) *Geometry {
	s.BoundingBox = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *Geometry) SetPolygon(v []*Point) *Geometry {
	s.Polygon = v
	return s
}

type ImportModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// permission to use Amazon Key Management Service (KMS) to encrypt or decrypt
	// the custom model.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
	// models. The ModelKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	ModelKmsKeyId *string `type:"string"`

	// The name to assign to the custom model that is created in Amazon Comprehend
	// by this import.
	ModelName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the custom model to import.
	//
	// SourceModelArn is a required field
	SourceModelArn *string `type:"string" required:"true"`

	// Tags to associate with the custom model that is created by this import. A
	// tag is a key-value pair that adds as a metadata to a resource used by Amazon
	// Comprehend. For example, a tag with "Sales" as the key might be added to
	// a resource to indicate its use by the sales department.
	Tags []*Tag `type:"list"`

	// The version name given to the custom model that is created by this import.
	// Version names can have a maximum of 256 characters. Alphanumeric characters,
	// hyphens (-) and underscores (_) are allowed. The version name must be unique
	// among all models with the same classifier name in the account/Region.
	VersionName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportModelInput"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.SourceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceModelArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ImportModelInput) SetDataAccessRoleArn(v string) *ImportModelInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetModelKmsKeyId sets the ModelKmsKeyId field's value.
func (s *ImportModelInput) SetModelKmsKeyId(v string) *ImportModelInput {
	s.ModelKmsKeyId = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *ImportModelInput) SetModelName(v string) *ImportModelInput {
	s.ModelName = &v
	return s
}

// SetSourceModelArn sets the SourceModelArn field's value.
func (s *ImportModelInput) SetSourceModelArn(v string) *ImportModelInput {
	s.SourceModelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportModelInput) SetTags(v []*Tag) *ImportModelInput {
	s.Tags = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *ImportModelInput) SetVersionName(v string) *ImportModelInput {
	s.VersionName = &v
	return s
}

type ImportModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the custom model being imported.
	ModelArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportModelOutput) GoString() string {
	return s.String()
}

// SetModelArn sets the ModelArn field's value.
func (s *ImportModelOutput) SetModelArn(v string) *ImportModelOutput {
	s.ModelArn = &v
	return s
}

// The input properties for an inference job. The document reader config field
// applies only to non-text inputs for custom analysis.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Provides configuration parameters to override the default actions for extracting
	// text from PDF documents and image files.
	DocumentReaderConfig *DocumentReaderConfig `type:"structure"`

	// Specifies how the text in an input file should be processed:
	//
	//    * ONE_DOC_PER_FILE - Each file is considered a separate document. Use
	//    this option when you are processing large documents, such as newspaper
	//    articles or scientific papers.
	//
	//    * ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//    Use this option when you are processing many short documents, such as
	//    text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// The Amazon S3 URI for the input data. The URI must be in same Region as the
	// API endpoint that you are calling. The URI can point to a single input file
	// or it can provide the prefix for a collection of data files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.DocumentReaderConfig != nil {
		if err := s.DocumentReaderConfig.Validate(); err != nil {
			invalidParams.AddNested("DocumentReaderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentReaderConfig sets the DocumentReaderConfig field's value.
func (s *InputDataConfig) SetDocumentReaderConfig(v *DocumentReaderConfig) *InputDataConfig {
	s.DocumentReaderConfig = v
	return s
}

// SetInputFormat sets the InputFormat field's value.
func (s *InputDataConfig) SetInputFormat(v string) *InputDataConfig {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter specified for the operation is invalid. Specify a different filter.
type InvalidFilterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFilterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFilterException) GoString() string {
	return s.String()
}

func newErrorInvalidFilterException(v protocol.ResponseMetadata) error {
	return &InvalidFilterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidFilterException) Code() string {
	return "InvalidFilterException"
}

// Message returns the exception's message.
func (s *InvalidFilterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidFilterException) OrigErr() error {
	return nil
}

func (s *InvalidFilterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidFilterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidFilterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides additional detail about why the request failed:
//
//   - Document size is too large - Check the size of your file and resubmit
//     the request.
//
//   - Document type is not supported - Check the file type and resubmit the
//     request.
//
//   - Too many pages in the document - Check the number of pages in your file
//     and resubmit the request.
//
//   - Access denied to Amazon Textract - Verify that your account has permission
//     to use Amazon Textract API operations and resubmit the request.
type InvalidRequestDetail struct {
	_ struct{} `type:"structure"`

	// Reason code is INVALID_DOCUMENT.
	Reason *string `type:"string" enum:"InvalidRequestDetailReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestDetail) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *InvalidRequestDetail) SetReason(v string) *InvalidRequestDetail {
	s.Reason = &v
	return s
}

// The request is invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Provides additional detail about why the request failed:
	//
	//    * Document size is too large - Check the size of your file and resubmit
	//    the request.
	//
	//    * Document type is not supported - Check the file type and resubmit the
	//    request.
	//
	//    * Too many pages in the document - Check the number of pages in your file
	//    and resubmit the request.
	//
	//    * Access denied to Amazon Textract - Verify that your account has permission
	//    to use Amazon Textract API operations and resubmit the request.
	Detail *InvalidRequestDetail `type:"structure"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`

	Reason *string `type:"string" enum:"InvalidRequestReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified job was not found. Check the job ID and try again.
type JobNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobNotFoundException) GoString() string {
	return s.String()
}

func newErrorJobNotFoundException(v protocol.ResponseMetadata) error {
	return &JobNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *JobNotFoundException) Code() string {
	return "JobNotFoundException"
}

// Message returns the exception's message.
func (s *JobNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *JobNotFoundException) OrigErr() error {
	return nil
}

func (s *JobNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *JobNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *JobNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a key noun phrase.
type KeyPhrase struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the key phrase.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the key phrase.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of a key noun phrase.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrase) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *KeyPhrase) SetBeginOffset(v int64) *KeyPhrase {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *KeyPhrase) SetEndOffset(v int64) *KeyPhrase {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *KeyPhrase) SetScore(v float64) *KeyPhrase {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *KeyPhrase) SetText(v string) *KeyPhrase {
	s.Text = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type KeyPhrasesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrasesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrasesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyPhrasesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyPhrasesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobName(v string) *KeyPhrasesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobStatus(v string) *KeyPhrasesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a key phrases detection job.
type KeyPhrasesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the key phrases detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the key phrases
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the key phrases detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the key phrases detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the key phrases detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the key phrases detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the key
	// phrases detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the key phrases detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt data on the storage
	// volume attached to the ML compute instance(s) that process the analysis job.
	// The VolumeKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your key phrases detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrasesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyPhrasesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *KeyPhrasesDetectionJobProperties) SetDataAccessRoleArn(v string) *KeyPhrasesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetEndTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobArn(v string) *KeyPhrasesDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobId(v string) *KeyPhrasesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobName(v string) *KeyPhrasesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobStatus(v string) *KeyPhrasesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *KeyPhrasesDetectionJobProperties) SetLanguageCode(v string) *KeyPhrasesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *KeyPhrasesDetectionJobProperties) SetMessage(v string) *KeyPhrasesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetSubmitTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *KeyPhrasesDetectionJobProperties) SetVolumeKmsKeyId(v string) *KeyPhrasesDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetVpcConfig(v *VpcConfig) *KeyPhrasesDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// The KMS customer managed key (CMK) entered cannot be validated. Verify the
// key and re-enter it.
type KmsKeyValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsKeyValidationException) GoString() string {
	return s.String()
}

func newErrorKmsKeyValidationException(v protocol.ResponseMetadata) error {
	return &KmsKeyValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KmsKeyValidationException) Code() string {
	return "KmsKeyValidationException"
}

// Message returns the exception's message.
func (s *KmsKeyValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KmsKeyValidationException) OrigErr() error {
	return nil
}

func (s *KmsKeyValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KmsKeyValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KmsKeyValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// Filters the datasets to be returned in the response.
	Filter *DatasetFilter `type:"structure"`

	// The Amazon Resource Number (ARN) of the flywheel.
	FlywheelArn *string `type:"string"`

	// Maximum number of results to return in a response. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDatasetsInput) SetFilter(v *DatasetFilter) *ListDatasetsInput {
	s.Filter = v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *ListDatasetsInput) SetFlywheelArn(v string) *ListDatasetsInput {
	s.FlywheelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetsInput) SetMaxResults(v int64) *ListDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsInput) SetNextToken(v string) *ListDatasetsInput {
	s.NextToken = &v
	return s
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// The dataset properties list.
	DatasetPropertiesList []*DatasetProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// SetDatasetPropertiesList sets the DatasetPropertiesList field's value.
func (s *ListDatasetsOutput) SetDatasetPropertiesList(v []*DatasetProperties) *ListDatasetsOutput {
	s.DatasetPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetsOutput) SetNextToken(v string) *ListDatasetsOutput {
	s.NextToken = &v
	return s
}

type ListDocumentClassificationJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their names, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DocumentClassificationJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassificationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassificationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentClassificationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentClassificationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDocumentClassificationJobsInput) SetFilter(v *DocumentClassificationJobFilter) *ListDocumentClassificationJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentClassificationJobsInput) SetMaxResults(v int64) *ListDocumentClassificationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassificationJobsInput) SetNextToken(v string) *ListDocumentClassificationJobsInput {
	s.NextToken = &v
	return s
}

type ListDocumentClassificationJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	DocumentClassificationJobPropertiesList []*DocumentClassificationJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassificationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassificationJobsOutput) GoString() string {
	return s.String()
}

// SetDocumentClassificationJobPropertiesList sets the DocumentClassificationJobPropertiesList field's value.
func (s *ListDocumentClassificationJobsOutput) SetDocumentClassificationJobPropertiesList(v []*DocumentClassificationJobProperties) *ListDocumentClassificationJobsOutput {
	s.DocumentClassificationJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassificationJobsOutput) SetNextToken(v string) *ListDocumentClassificationJobsOutput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifierSummariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return on each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifierSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifierSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentClassifierSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentClassifierSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentClassifierSummariesInput) SetMaxResults(v int64) *ListDocumentClassifierSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifierSummariesInput) SetNextToken(v string) *ListDocumentClassifierSummariesInput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifierSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The list of summaries of document classifiers.
	DocumentClassifierSummariesList []*DocumentClassifierSummary `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifierSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifierSummariesOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierSummariesList sets the DocumentClassifierSummariesList field's value.
func (s *ListDocumentClassifierSummariesOutput) SetDocumentClassifierSummariesList(v []*DocumentClassifierSummary) *ListDocumentClassifierSummariesOutput {
	s.DocumentClassifierSummariesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifierSummariesOutput) SetNextToken(v string) *ListDocumentClassifierSummariesOutput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifiersInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DocumentClassifierFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifiersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentClassifiersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentClassifiersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDocumentClassifiersInput) SetFilter(v *DocumentClassifierFilter) *ListDocumentClassifiersInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentClassifiersInput) SetMaxResults(v int64) *ListDocumentClassifiersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifiersInput) SetNextToken(v string) *ListDocumentClassifiersInput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifiersOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	DocumentClassifierPropertiesList []*DocumentClassifierProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentClassifiersOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierPropertiesList sets the DocumentClassifierPropertiesList field's value.
func (s *ListDocumentClassifiersOutput) SetDocumentClassifierPropertiesList(v []*DocumentClassifierProperties) *ListDocumentClassifiersOutput {
	s.DocumentClassifierPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifiersOutput) SetNextToken(v string) *ListDocumentClassifiersOutput {
	s.NextToken = &v
	return s
}

type ListDominantLanguageDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters that jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DominantLanguageDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDominantLanguageDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDominantLanguageDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDominantLanguageDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDominantLanguageDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetFilter(v *DominantLanguageDetectionJobFilter) *ListDominantLanguageDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetMaxResults(v int64) *ListDominantLanguageDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetNextToken(v string) *ListDominantLanguageDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListDominantLanguageDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	DominantLanguageDetectionJobPropertiesList []*DominantLanguageDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDominantLanguageDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDominantLanguageDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobPropertiesList sets the DominantLanguageDetectionJobPropertiesList field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetDominantLanguageDetectionJobPropertiesList(v []*DominantLanguageDetectionJobProperties) *ListDominantLanguageDetectionJobsOutput {
	s.DominantLanguageDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetNextToken(v string) *ListDominantLanguageDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters the endpoints that are returned. You can filter endpoints on their
	// name, model, status, or the date and time that they were created. You can
	// only set one filter at a time.
	Filter *EndpointFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEndpointsInput) SetFilter(v *EndpointFilter) *ListEndpointsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Displays a list of endpoint properties being retrieved by the service in
	// response to the request.
	EndpointPropertiesList []*EndpointProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointPropertiesList sets the EndpointPropertiesList field's value.
func (s *ListEndpointsOutput) SetEndpointPropertiesList(v []*EndpointProperties) *ListEndpointsOutput {
	s.EndpointPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *EntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntitiesDetectionJobsInput) SetFilter(v *EntitiesDetectionJobFilter) *ListEntitiesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesDetectionJobsInput) SetMaxResults(v int64) *ListEntitiesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsInput) SetNextToken(v string) *ListEntitiesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	EntitiesDetectionJobPropertiesList []*EntitiesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobPropertiesList sets the EntitiesDetectionJobPropertiesList field's value.
func (s *ListEntitiesDetectionJobsOutput) SetEntitiesDetectionJobPropertiesList(v []*EntitiesDetectionJobProperties) *ListEntitiesDetectionJobsOutput {
	s.EntitiesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsOutput) SetNextToken(v string) *ListEntitiesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizerSummariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return on each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizerSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizerSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntityRecognizerSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntityRecognizerSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntityRecognizerSummariesInput) SetMaxResults(v int64) *ListEntityRecognizerSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizerSummariesInput) SetNextToken(v string) *ListEntityRecognizerSummariesInput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizerSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The list entity recognizer summaries.
	EntityRecognizerSummariesList []*EntityRecognizerSummary `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizerSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizerSummariesOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerSummariesList sets the EntityRecognizerSummariesList field's value.
func (s *ListEntityRecognizerSummariesOutput) SetEntityRecognizerSummariesList(v []*EntityRecognizerSummary) *ListEntityRecognizerSummariesOutput {
	s.EntityRecognizerSummariesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizerSummariesOutput) SetNextToken(v string) *ListEntityRecognizerSummariesOutput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizersInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of entities returned. You can filter on Status, SubmitTimeBefore,
	// or SubmitTimeAfter. You can only set one filter at a time.
	Filter *EntityRecognizerFilter `type:"structure"`

	// The maximum number of results to return on each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntityRecognizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntityRecognizersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntityRecognizersInput) SetFilter(v *EntityRecognizerFilter) *ListEntityRecognizersInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntityRecognizersInput) SetMaxResults(v int64) *ListEntityRecognizersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizersInput) SetNextToken(v string) *ListEntityRecognizersInput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizersOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties of an entity recognizer.
	EntityRecognizerPropertiesList []*EntityRecognizerProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntityRecognizersOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerPropertiesList sets the EntityRecognizerPropertiesList field's value.
func (s *ListEntityRecognizersOutput) SetEntityRecognizerPropertiesList(v []*EntityRecognizerProperties) *ListEntityRecognizersOutput {
	s.EntityRecognizerPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizersOutput) SetNextToken(v string) *ListEntityRecognizersOutput {
	s.NextToken = &v
	return s
}

type ListEventsDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *EventsDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEventsDetectionJobsInput) SetFilter(v *EventsDetectionJobFilter) *ListEventsDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventsDetectionJobsInput) SetMaxResults(v int64) *ListEventsDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsDetectionJobsInput) SetNextToken(v string) *ListEventsDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListEventsDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	EventsDetectionJobPropertiesList []*EventsDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventsDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetEventsDetectionJobPropertiesList sets the EventsDetectionJobPropertiesList field's value.
func (s *ListEventsDetectionJobsOutput) SetEventsDetectionJobPropertiesList(v []*EventsDetectionJobProperties) *ListEventsDetectionJobsOutput {
	s.EventsDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsDetectionJobsOutput) SetNextToken(v string) *ListEventsDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListFlywheelIterationHistoryInput struct {
	_ struct{} `type:"structure"`

	// Filter the flywheel iteration history based on creation time.
	Filter *FlywheelIterationFilter `type:"structure"`

	// The ARN of the flywheel.
	//
	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`

	// Maximum number of iteration history results to return
	MaxResults *int64 `min:"1" type:"integer"`

	// Next token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelIterationHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelIterationHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlywheelIterationHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlywheelIterationHistoryInput"}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListFlywheelIterationHistoryInput) SetFilter(v *FlywheelIterationFilter) *ListFlywheelIterationHistoryInput {
	s.Filter = v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *ListFlywheelIterationHistoryInput) SetFlywheelArn(v string) *ListFlywheelIterationHistoryInput {
	s.FlywheelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlywheelIterationHistoryInput) SetMaxResults(v int64) *ListFlywheelIterationHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlywheelIterationHistoryInput) SetNextToken(v string) *ListFlywheelIterationHistoryInput {
	s.NextToken = &v
	return s
}

type ListFlywheelIterationHistoryOutput struct {
	_ struct{} `type:"structure"`

	// List of flywheel iteration properties
	FlywheelIterationPropertiesList []*FlywheelIterationProperties `type:"list"`

	// Next token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelIterationHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelIterationHistoryOutput) GoString() string {
	return s.String()
}

// SetFlywheelIterationPropertiesList sets the FlywheelIterationPropertiesList field's value.
func (s *ListFlywheelIterationHistoryOutput) SetFlywheelIterationPropertiesList(v []*FlywheelIterationProperties) *ListFlywheelIterationHistoryOutput {
	s.FlywheelIterationPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlywheelIterationHistoryOutput) SetNextToken(v string) *ListFlywheelIterationHistoryOutput {
	s.NextToken = &v
	return s
}

type ListFlywheelsInput struct {
	_ struct{} `type:"structure"`

	// Filters the flywheels that are returned. You can filter flywheels on their
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *FlywheelFilter `type:"structure"`

	// Maximum number of results to return in a response. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlywheelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlywheelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListFlywheelsInput) SetFilter(v *FlywheelFilter) *ListFlywheelsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlywheelsInput) SetMaxResults(v int64) *ListFlywheelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlywheelsInput) SetNextToken(v string) *ListFlywheelsInput {
	s.NextToken = &v
	return s
}

type ListFlywheelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of flywheel properties retrieved by the service in response to the
	// request.
	FlywheelSummaryList []*FlywheelSummary `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlywheelsOutput) GoString() string {
	return s.String()
}

// SetFlywheelSummaryList sets the FlywheelSummaryList field's value.
func (s *ListFlywheelsOutput) SetFlywheelSummaryList(v []*FlywheelSummary) *ListFlywheelsOutput {
	s.FlywheelSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlywheelsOutput) SetNextToken(v string) *ListFlywheelsOutput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *KeyPhrasesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPhrasesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPhrasesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPhrasesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyPhrasesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetFilter(v *KeyPhrasesDetectionJobFilter) *ListKeyPhrasesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetMaxResults(v int64) *ListKeyPhrasesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	KeyPhrasesDetectionJobPropertiesList []*KeyPhrasesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPhrasesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyPhrasesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobPropertiesList sets the KeyPhrasesDetectionJobPropertiesList field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetKeyPhrasesDetectionJobPropertiesList(v []*KeyPhrasesDetectionJobProperties) *ListKeyPhrasesDetectionJobsOutput {
	s.KeyPhrasesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListPiiEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *PiiEntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPiiEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPiiEntitiesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPiiEntitiesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPiiEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetFilter(v *PiiEntitiesDetectionJobFilter) *ListPiiEntitiesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetMaxResults(v int64) *ListPiiEntitiesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetNextToken(v string) *ListPiiEntitiesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListPiiEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	PiiEntitiesDetectionJobPropertiesList []*PiiEntitiesDetectionJobProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPiiEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPiiEntitiesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPiiEntitiesDetectionJobsOutput) SetNextToken(v string) *ListPiiEntitiesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetPiiEntitiesDetectionJobPropertiesList sets the PiiEntitiesDetectionJobPropertiesList field's value.
func (s *ListPiiEntitiesDetectionJobsOutput) SetPiiEntitiesDetectionJobPropertiesList(v []*PiiEntitiesDetectionJobProperties) *ListPiiEntitiesDetectionJobsOutput {
	s.PiiEntitiesDetectionJobPropertiesList = v
	return s
}

type ListSentimentDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *SentimentDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSentimentDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSentimentDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSentimentDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSentimentDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSentimentDetectionJobsInput) SetFilter(v *SentimentDetectionJobFilter) *ListSentimentDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSentimentDetectionJobsInput) SetMaxResults(v int64) *ListSentimentDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsInput) SetNextToken(v string) *ListSentimentDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListSentimentDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	SentimentDetectionJobPropertiesList []*SentimentDetectionJobProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSentimentDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSentimentDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsOutput) SetNextToken(v string) *ListSentimentDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetSentimentDetectionJobPropertiesList sets the SentimentDetectionJobPropertiesList field's value.
func (s *ListSentimentDetectionJobsOutput) SetSentimentDetectionJobPropertiesList(v []*SentimentDetectionJobProperties) *ListSentimentDetectionJobsOutput {
	s.SentimentDetectionJobPropertiesList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you
	// are querying.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you
	// are querying.
	ResourceArn *string `type:"string"`

	// Tags associated with the Amazon Comprehend resource being queried. A tag
	// is a key-value pair that adds as a metadata to a resource used by Amazon
	// Comprehend. For example, a tag with "Sales" as the key might be added to
	// a resource to indicate its use by the sales department.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTargetedSentimentDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *TargetedSentimentDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetedSentimentDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetedSentimentDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetedSentimentDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetedSentimentDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTargetedSentimentDetectionJobsInput) SetFilter(v *TargetedSentimentDetectionJobFilter) *ListTargetedSentimentDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetedSentimentDetectionJobsInput) SetMaxResults(v int64) *ListTargetedSentimentDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetedSentimentDetectionJobsInput) SetNextToken(v string) *ListTargetedSentimentDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListTargetedSentimentDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	TargetedSentimentDetectionJobPropertiesList []*TargetedSentimentDetectionJobProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetedSentimentDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTargetedSentimentDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetedSentimentDetectionJobsOutput) SetNextToken(v string) *ListTargetedSentimentDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetTargetedSentimentDetectionJobPropertiesList sets the TargetedSentimentDetectionJobPropertiesList field's value.
func (s *ListTargetedSentimentDetectionJobsOutput) SetTargetedSentimentDetectionJobPropertiesList(v []*TargetedSentimentDetectionJobProperties) *ListTargetedSentimentDetectionJobsOutput {
	s.TargetedSentimentDetectionJobPropertiesList = v
	return s
}

type ListTopicsDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. Jobs can be filtered on their name, status,
	// or the date and time that they were submitted. You can set only one filter
	// at a time.
	Filter *TopicsDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTopicsDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTopicsDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTopicsDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTopicsDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTopicsDetectionJobsInput) SetFilter(v *TopicsDetectionJobFilter) *ListTopicsDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTopicsDetectionJobsInput) SetMaxResults(v int64) *ListTopicsDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsInput) SetNextToken(v string) *ListTopicsDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListTopicsDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	TopicsDetectionJobPropertiesList []*TopicsDetectionJobProperties `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTopicsDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTopicsDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsOutput) SetNextToken(v string) *ListTopicsDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetTopicsDetectionJobPropertiesList sets the TopicsDetectionJobPropertiesList field's value.
func (s *ListTopicsDetectionJobsOutput) SetTopicsDetectionJobPropertiesList(v []*TopicsDetectionJobProperties) *ListTopicsDetectionJobsOutput {
	s.TopicsDetectionJobPropertiesList = v
	return s
}

// Contains the sentiment and sentiment score for one mention of an entity.
//
// For more information about targeted sentiment, see Targeted sentiment (https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html)
// in the Amazon Comprehend Developer Guide.
type MentionSentiment struct {
	_ struct{} `type:"structure"`

	// The sentiment of the mention.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// Describes the level of confidence that Amazon Comprehend has in the accuracy
	// of its detection of sentiments.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MentionSentiment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MentionSentiment) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *MentionSentiment) SetSentiment(v string) *MentionSentiment {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *MentionSentiment) SetSentimentScore(v *SentimentScore) *MentionSentiment {
	s.SentimentScore = v
	return s
}

// Provides configuration parameters for the output of inference jobs.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job. Specify
	// the Key Id of a symmetric key, because you cannot use an asymmetric key for
	// uploading data to S3.
	//
	// The KmsKeyId can be one of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same Region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output
	// file.
	//
	// When the topic detection job is finished, the service creates an output file
	// in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the ouput of the operation.
	//
	// For a PII entity detection job, the output file is plain text, not a compressed
	// archive. The output file name is the same as the input file, with .out appended
	// at the end.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *OutputDataConfig) SetKmsKeyId(v string) *OutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Identifies the part of speech represented by the token and gives the confidence
// that Amazon Comprehend has that the part of speech was correctly identified.
// For more information about the parts of speech that Amazon Comprehend can
// identify, see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
// in the Comprehend Developer Guide.
type PartOfSpeechTag struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Comprehend has that the part of speech was correctly
	// identified.
	Score *float64 `type:"float"`

	// Identifies the part of speech that the token represents.
	Tag *string `type:"string" enum:"PartOfSpeechTagType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartOfSpeechTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartOfSpeechTag) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *PartOfSpeechTag) SetScore(v float64) *PartOfSpeechTag {
	s.Score = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *PartOfSpeechTag) SetTag(v string) *PartOfSpeechTag {
	s.Tag = &v
	return s
}

// Provides information for filtering a list of PII entity detection jobs.
type PiiEntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntitiesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PiiEntitiesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PiiEntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *PiiEntitiesDetectionJobFilter) SetJobName(v string) *PiiEntitiesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *PiiEntitiesDetectionJobFilter) SetJobStatus(v string) *PiiEntitiesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *PiiEntitiesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *PiiEntitiesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *PiiEntitiesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *PiiEntitiesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a PII entities detection job.
type PiiEntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the PII entities detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input properties for a PII entities detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the PII entities detection job. It is a
	// unique, fully qualified identifier for the job. It includes the Amazon Web
	// Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the PII entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the PII entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the PII entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// Specifies whether the output provides the locations (offsets) of PII entities
	// or a file in which PII entities are redacted.
	Mode *string `type:"string" enum:"PiiEntitiesDetectionMode"`

	// The output data configuration that you supplied when you created the PII
	// entities detection job.
	OutputDataConfig *PiiOutputDataConfig `type:"structure"`

	// Provides configuration parameters for PII entity redaction.
	//
	// This parameter is required if you set the Mode parameter to ONLY_REDACTION.
	// In that case, you must provide a RedactionConfig definition that includes
	// the PiiEntityTypes parameter.
	RedactionConfig *RedactionConfig `type:"structure"`

	// The time that the PII entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntitiesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *PiiEntitiesDetectionJobProperties) SetDataAccessRoleArn(v string) *PiiEntitiesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *PiiEntitiesDetectionJobProperties) SetEndTime(v time.Time) *PiiEntitiesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *PiiEntitiesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobArn(v string) *PiiEntitiesDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobId(v string) *PiiEntitiesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobName(v string) *PiiEntitiesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobStatus(v string) *PiiEntitiesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *PiiEntitiesDetectionJobProperties) SetLanguageCode(v string) *PiiEntitiesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PiiEntitiesDetectionJobProperties) SetMessage(v string) *PiiEntitiesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *PiiEntitiesDetectionJobProperties) SetMode(v string) *PiiEntitiesDetectionJobProperties {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetOutputDataConfig(v *PiiOutputDataConfig) *PiiEntitiesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetRedactionConfig sets the RedactionConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetRedactionConfig(v *RedactionConfig) *PiiEntitiesDetectionJobProperties {
	s.RedactionConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *PiiEntitiesDetectionJobProperties) SetSubmitTime(v time.Time) *PiiEntitiesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// Provides information about a PII entity.
type PiiEntity struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the entity.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the entity.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The entity's type.
	Type *string `type:"string" enum:"PiiEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiEntity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *PiiEntity) SetBeginOffset(v int64) *PiiEntity {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *PiiEntity) SetEndOffset(v int64) *PiiEntity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *PiiEntity) SetScore(v float64) *PiiEntity {
	s.Score = &v
	return s
}

// SetType sets the Type field's value.
func (s *PiiEntity) SetType(v string) *PiiEntity {
	s.Type = &v
	return s
}

// Provides configuration parameters for the output of PII entity detection
// jobs.
type PiiOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt the output results from an analysis job.
	KmsKeyId *string `type:"string"`

	// When you use the PiiOutputDataConfig object with asynchronous operations,
	// you specify the Amazon S3 location where you want to write the output data.
	//
	// For a PII entity detection job, the output file is plain text, not a compressed
	// archive. The output file name is the same as the input file, with .out appended
	// at the end.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PiiOutputDataConfig) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *PiiOutputDataConfig) SetKmsKeyId(v string) *PiiOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *PiiOutputDataConfig) SetS3Uri(v string) *PiiOutputDataConfig {
	s.S3Uri = &v
	return s
}

// The X and Y coordinates of a point on a document page.
//
// For additional information, see Point (https://docs.aws.amazon.com/textract/latest/dg/API_Point.html)
// in the Amazon Textract API reference.
type Point struct {
	_ struct{} `type:"structure"`

	// The value of the X coordinate for a point on a polygon
	X *float64 `type:"float"`

	// The value of the Y coordinate for a point on a polygon
	Y *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) GoString() string {
	return s.String()
}

// SetX sets the X field's value.
func (s *Point) SetX(v float64) *Point {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *Point) SetY(v float64) *Point {
	s.Y = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The revision ID that Amazon Comprehend assigned to the policy that you are
	// updating. If you are creating a new policy that has no prior version, don't
	// use this parameter. Amazon Comprehend creates the revision ID for you.
	PolicyRevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the custom model to attach the policy to.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The JSON resource-based policy to attach to your custom model. Provide your
	// JSON as a UTF-8 encoded string without line breaks. To provide valid JSON
	// for your policy, enclose the attribute names and values in double quotes.
	// If the JSON body is also enclosed in double quotes, then you must escape
	// the double quotes that are inside the policy:
	//
	// "{\"attribute\": \"value\", \"attribute\": [\"value\"]}"
	//
	// To avoid escaping quotes, you can use single quotes to enclose the policy
	// and double quotes to enclose the JSON names and values:
	//
	// '{"attribute": "value", "attribute": ["value"]}'
	//
	// ResourcePolicy is a required field
	ResourcePolicy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourcePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcePolicy"))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyRevisionId sets the PolicyRevisionId field's value.
func (s *PutResourcePolicyInput) SetPolicyRevisionId(v string) *PutResourcePolicyInput {
	s.PolicyRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *PutResourcePolicyInput) SetResourcePolicy(v string) *PutResourcePolicyInput {
	s.ResourcePolicy = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The revision ID of the policy. Each time you modify a policy, Amazon Comprehend
	// assigns a new revision ID, and it deletes the prior version of the policy.
	PolicyRevisionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyRevisionId sets the PolicyRevisionId field's value.
func (s *PutResourcePolicyOutput) SetPolicyRevisionId(v string) *PutResourcePolicyOutput {
	s.PolicyRevisionId = &v
	return s
}

// Provides configuration parameters for PII entity redaction.
type RedactionConfig struct {
	_ struct{} `type:"structure"`

	// A character that replaces each character in the redacted PII entity.
	MaskCharacter *string `min:"1" type:"string"`

	// Specifies whether the PII entity is redacted with the mask character or the
	// entity type.
	MaskMode *string `type:"string" enum:"PiiEntitiesDetectionMaskMode"`

	// An array of the types of PII entities that Amazon Comprehend detects in the
	// input text for your request.
	PiiEntityTypes []*string `type:"list" enum:"PiiEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedactionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedactionConfig"}
	if s.MaskCharacter != nil && len(*s.MaskCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaskCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaskCharacter sets the MaskCharacter field's value.
func (s *RedactionConfig) SetMaskCharacter(v string) *RedactionConfig {
	s.MaskCharacter = &v
	return s
}

// SetMaskMode sets the MaskMode field's value.
func (s *RedactionConfig) SetMaskMode(v string) *RedactionConfig {
	s.MaskMode = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *RedactionConfig) SetPiiEntityTypes(v []*string) *RedactionConfig {
	s.PiiEntityTypes = v
	return s
}

// List of child blocks for the current block.
type RelationshipsListItem struct {
	_ struct{} `type:"structure"`

	// Identifers of the child blocks.
	Ids []*string `type:"list"`

	// Only supported relationship is a child relationship.
	Type *string `type:"string" enum:"RelationshipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelationshipsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelationshipsListItem) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *RelationshipsListItem) SetIds(v []*string) *RelationshipsListItem {
	s.Ids = v
	return s
}

// SetType sets the Type field's value.
func (s *RelationshipsListItem) SetType(v string) *RelationshipsListItem {
	s.Type = &v
	return s
}

// The specified resource name is already in use. Use a different name and try
// your request again.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of resources per account has been exceeded. Review the
// resources, and then try your request again.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource ARN was not found. Check the ARN and try your request
// again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is not available. Check the resource and try your
// request again.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type SentimentDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SentimentDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobFilter) SetJobName(v string) *SentimentDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobFilter) SetJobStatus(v string) *SentimentDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a sentiment detection job.
type SentimentDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the sentiment detection job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the sentiment
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier assigned to the sentiment detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the sentiment detection job
	JobName *string `min:"1" type:"string"`

	// The current status of the sentiment detection job. If the status is FAILED,
	// the Messages field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the sentiment
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the sentiment detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your sentiment detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *SentimentDetectionJobProperties) SetDataAccessRoleArn(v string) *SentimentDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SentimentDetectionJobProperties) SetEndTime(v time.Time) *SentimentDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *SentimentDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *SentimentDetectionJobProperties) SetJobArn(v string) *SentimentDetectionJobProperties {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SentimentDetectionJobProperties) SetJobId(v string) *SentimentDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobProperties) SetJobName(v string) *SentimentDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobProperties) SetJobStatus(v string) *SentimentDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SentimentDetectionJobProperties) SetLanguageCode(v string) *SentimentDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *SentimentDetectionJobProperties) SetMessage(v string) *SentimentDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *SentimentDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *SentimentDetectionJobProperties) SetSubmitTime(v time.Time) *SentimentDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *SentimentDetectionJobProperties) SetVolumeKmsKeyId(v string) *SentimentDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *SentimentDetectionJobProperties) SetVpcConfig(v *VpcConfig) *SentimentDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy
// of its detection of sentiments.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentScore) GoString() string {
	return s.String()
}

// SetMixed sets the Mixed field's value.
func (s *SentimentScore) SetMixed(v float64) *SentimentScore {
	s.Mixed = &v
	return s
}

// SetNegative sets the Negative field's value.
func (s *SentimentScore) SetNegative(v float64) *SentimentScore {
	s.Negative = &v
	return s
}

// SetNeutral sets the Neutral field's value.
func (s *SentimentScore) SetNeutral(v float64) *SentimentScore {
	s.Neutral = &v
	return s
}

// SetPositive sets the Positive field's value.
func (s *SentimentScore) SetPositive(v float64) *SentimentScore {
	s.Positive = &v
	return s
}

type StartDocumentClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the document classifier to use to process
	// the job.
	DocumentClassifierArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel associated with the model
	// to use.
	FlywheelArn *string `type:"string"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the document classification job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your document classification job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentClassificationJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentClassificationJobInput) SetClientRequestToken(v string) *StartDocumentClassificationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDocumentClassificationJobInput) SetDataAccessRoleArn(v string) *StartDocumentClassificationJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *StartDocumentClassificationJobInput) SetDocumentClassifierArn(v string) *StartDocumentClassificationJobInput {
	s.DocumentClassifierArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *StartDocumentClassificationJobInput) SetFlywheelArn(v string) *StartDocumentClassificationJobInput {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartDocumentClassificationJobInput) SetInputDataConfig(v *InputDataConfig) *StartDocumentClassificationJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDocumentClassificationJobInput) SetJobName(v string) *StartDocumentClassificationJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartDocumentClassificationJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartDocumentClassificationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartDocumentClassificationJobInput) SetTags(v []*Tag) *StartDocumentClassificationJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartDocumentClassificationJobInput) SetVolumeKmsKeyId(v string) *StartDocumentClassificationJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartDocumentClassificationJobInput) SetVpcConfig(v *VpcConfig) *StartDocumentClassificationJobInput {
	s.VpcConfig = v
	return s
}

type StartDocumentClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom classification model.
	DocumentClassifierArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the document classification job. It is
	// a unique, fully qualified identifier for the job. It includes the Amazon
	// Web Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeDocumentClassificationJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. For details, use the DescribeDocumentClassificationJob
	//    operation.
	//
	//    * STOP_REQUESTED - Amazon Comprehend has received a stop request for the
	//    job and is processing the request.
	//
	//    * STOPPED - The job was successfully stopped without completing.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentClassificationJobOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *StartDocumentClassificationJobOutput) SetDocumentClassifierArn(v string) *StartDocumentClassificationJobOutput {
	s.DocumentClassifierArn = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *StartDocumentClassificationJobOutput) SetJobArn(v string) *StartDocumentClassificationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentClassificationJobOutput) SetJobId(v string) *StartDocumentClassificationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDocumentClassificationJobOutput) SetJobStatus(v string) *StartDocumentClassificationJobOutput {
	s.JobStatus = &v
	return s
}

type StartDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// An identifier for the job.
	JobName *string `min:"1" type:"string"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the dominant language detection job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your dominant language detection
	// job. For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDominantLanguageDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDominantLanguageDetectionJobInput) SetClientRequestToken(v string) *StartDominantLanguageDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDominantLanguageDetectionJobInput) SetDataAccessRoleArn(v string) *StartDominantLanguageDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDominantLanguageDetectionJobInput) SetJobName(v string) *StartDominantLanguageDetectionJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartDominantLanguageDetectionJobInput) SetTags(v []*Tag) *StartDominantLanguageDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartDominantLanguageDetectionJobInput) SetVolumeKmsKeyId(v string) *StartDominantLanguageDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartDominantLanguageDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dominant language detection job. It
	// is a unique, fully qualified identifier for the job. It includes the Amazon
	// Web Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:dominant-language-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:dominant-language-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobArn(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobId(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the specific entity recognizer
	// to be used by the StartEntitiesDetectionJob. This ARN is optional and is
	// only used for a custom entity recognition job.
	EntityRecognizerArn *string `type:"string"`

	// The Amazon Resource Number (ARN) of the flywheel associated with the model
	// to use.
	FlywheelArn *string `type:"string"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	// You can specify any of the languages supported by Amazon Comprehend. If custom
	// entities recognition is used, this parameter is ignored and the language
	// used for training the model is used instead.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the entities detection job. A tag is a key-value pair
	// that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your entity detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEntitiesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEntitiesDetectionJobInput) SetClientRequestToken(v string) *StartEntitiesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEntitiesDetectionJobInput) SetDataAccessRoleArn(v string) *StartEntitiesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *StartEntitiesDetectionJobInput) SetEntityRecognizerArn(v string) *StartEntitiesDetectionJobInput {
	s.EntityRecognizerArn = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *StartEntitiesDetectionJobInput) SetFlywheelArn(v string) *StartEntitiesDetectionJobInput {
	s.FlywheelArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartEntitiesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEntitiesDetectionJobInput) SetJobName(v string) *StartEntitiesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEntitiesDetectionJobInput) SetLanguageCode(v string) *StartEntitiesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEntitiesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartEntitiesDetectionJobInput) SetTags(v []*Tag) *StartEntitiesDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartEntitiesDetectionJobInput) SetVolumeKmsKeyId(v string) *StartEntitiesDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartEntitiesDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom entity recognition model.
	EntityRecognizerArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the entities detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	//
	//    * STOP_REQUESTED - Amazon Comprehend has received a stop request for the
	//    job and is processing the request.
	//
	//    * STOPPED - The job was successfully stopped without completing.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *StartEntitiesDetectionJobOutput) SetEntityRecognizerArn(v string) *StartEntitiesDetectionJobOutput {
	s.EntityRecognizerArn = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobArn(v string) *StartEntitiesDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobId(v string) *StartEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobStatus(v string) *StartEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartEventsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// An unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the events detection job.
	JobName *string `min:"1" type:"string"`

	// The language code of the input documents.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the events detection job. A tag is a key-value pair
	// that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// The types of events to detect in the input documents.
	//
	// TargetEventTypes is a required field
	TargetEventTypes []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEventsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEventsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEventsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEventsDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.TargetEventTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEventTypes"))
	}
	if s.TargetEventTypes != nil && len(s.TargetEventTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetEventTypes", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEventsDetectionJobInput) SetClientRequestToken(v string) *StartEventsDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEventsDetectionJobInput) SetDataAccessRoleArn(v string) *StartEventsDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEventsDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartEventsDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEventsDetectionJobInput) SetJobName(v string) *StartEventsDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEventsDetectionJobInput) SetLanguageCode(v string) *StartEventsDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEventsDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEventsDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartEventsDetectionJobInput) SetTags(v []*Tag) *StartEventsDetectionJobInput {
	s.Tags = v
	return s
}

// SetTargetEventTypes sets the TargetEventTypes field's value.
func (s *StartEventsDetectionJobInput) SetTargetEventTypes(v []*string) *StartEventsDetectionJobInput {
	s.TargetEventTypes = v
	return s
}

type StartEventsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the events detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:events-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:events-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// An unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	JobId *string `min:"1" type:"string"`

	// The status of the events detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEventsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEventsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartEventsDetectionJobOutput) SetJobArn(v string) *StartEventsDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartEventsDetectionJobOutput) SetJobId(v string) *StartEventsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartEventsDetectionJobOutput) SetJobStatus(v string) *StartEventsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartFlywheelIterationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string"`

	// The ARN of the flywheel.
	//
	// FlywheelArn is a required field
	FlywheelArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlywheelIterationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlywheelIterationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFlywheelIterationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFlywheelIterationInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.FlywheelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlywheelArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartFlywheelIterationInput) SetClientRequestToken(v string) *StartFlywheelIterationInput {
	s.ClientRequestToken = &v
	return s
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *StartFlywheelIterationInput) SetFlywheelArn(v string) *StartFlywheelIterationInput {
	s.FlywheelArn = &v
	return s
}

type StartFlywheelIterationOutput struct {
	_ struct{} `type:"structure"`

	FlywheelArn *string `type:"string"`

	FlywheelIterationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlywheelIterationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFlywheelIterationOutput) GoString() string {
	return s.String()
}

// SetFlywheelArn sets the FlywheelArn field's value.
func (s *StartFlywheelIterationOutput) SetFlywheelArn(v string) *StartFlywheelIterationOutput {
	s.FlywheelArn = &v
	return s
}

// SetFlywheelIterationId sets the FlywheelIterationId field's value.
func (s *StartFlywheelIterationOutput) SetFlywheelIterationId(v string) *StartFlywheelIterationOutput {
	s.FlywheelIterationId = &v
	return s
}

type StartKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the key phrases detection job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your key phrases detection job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartKeyPhrasesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetClientRequestToken(v string) *StartKeyPhrasesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetDataAccessRoleArn(v string) *StartKeyPhrasesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetJobName(v string) *StartKeyPhrasesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetLanguageCode(v string) *StartKeyPhrasesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetTags(v []*Tag) *StartKeyPhrasesDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetVolumeKmsKeyId(v string) *StartKeyPhrasesDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartKeyPhrasesDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the key phrase detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobArn(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobId(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartPiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The input properties for a PII entities detection job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. Currently, English is the only valid
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies whether the output provides the locations (offsets) of PII entities
	// or a file in which PII entities are redacted.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"PiiEntitiesDetectionMode"`

	// Provides conﬁguration parameters for the output of PII entity detection
	// jobs.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Provides configuration parameters for PII entity redaction.
	//
	// This parameter is required if you set the Mode parameter to ONLY_REDACTION.
	// In that case, you must provide a RedactionConfig definition that includes
	// the PiiEntityTypes parameter.
	RedactionConfig *RedactionConfig `type:"structure"`

	// Tags to associate with the PII entities detection job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPiiEntitiesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.RedactionConfig != nil {
		if err := s.RedactionConfig.Validate(); err != nil {
			invalidParams.AddNested("RedactionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetClientRequestToken(v string) *StartPiiEntitiesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetDataAccessRoleArn(v string) *StartPiiEntitiesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartPiiEntitiesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetJobName(v string) *StartPiiEntitiesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetLanguageCode(v string) *StartPiiEntitiesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetMode(v string) *StartPiiEntitiesDetectionJobInput {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartPiiEntitiesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRedactionConfig sets the RedactionConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetRedactionConfig(v *RedactionConfig) *StartPiiEntitiesDetectionJobInput {
	s.RedactionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetTags(v []*Tag) *StartPiiEntitiesDetectionJobInput {
	s.Tags = v
	return s
}

type StartPiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the PII entity detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartPiiEntitiesDetectionJobOutput) SetJobArn(v string) *StartPiiEntitiesDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartPiiEntitiesDetectionJobOutput) SetJobId(v string) *StartPiiEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartPiiEntitiesDetectionJobOutput) SetJobStatus(v string) *StartPiiEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the sentiment detection job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your sentiment detection job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSentimentDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSentimentDetectionJobInput) SetClientRequestToken(v string) *StartSentimentDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartSentimentDetectionJobInput) SetDataAccessRoleArn(v string) *StartSentimentDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartSentimentDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartSentimentDetectionJobInput) SetJobName(v string) *StartSentimentDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartSentimentDetectionJobInput) SetLanguageCode(v string) *StartSentimentDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartSentimentDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSentimentDetectionJobInput) SetTags(v []*Tag) *StartSentimentDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartSentimentDetectionJobInput) SetVolumeKmsKeyId(v string) *StartSentimentDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartSentimentDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartSentimentDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the sentiment detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:sentiment-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartSentimentDetectionJobOutput) SetJobArn(v string) *StartSentimentDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartSentimentDetectionJobOutput) SetJobId(v string) *StartSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartSentimentDetectionJobOutput) SetJobStatus(v string) *StartSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartTargetedSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The input properties for an inference job. The document reader config field
	// applies only to non-text inputs for custom analysis.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. Currently, English is the only supported
	// language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the targeted sentiment detection job. A tag is a key-value
	// pair that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the KMS key that Amazon Comprehend uses to encrypt data on the storage
	// volume attached to the ML compute instance(s) that process the analysis job.
	// The VolumeKmsKeyId can be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for the job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTargetedSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTargetedSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTargetedSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTargetedSentimentDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetClientRequestToken(v string) *StartTargetedSentimentDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetDataAccessRoleArn(v string) *StartTargetedSentimentDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartTargetedSentimentDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetJobName(v string) *StartTargetedSentimentDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetLanguageCode(v string) *StartTargetedSentimentDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTargetedSentimentDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetTags(v []*Tag) *StartTargetedSentimentDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetVolumeKmsKeyId(v string) *StartTargetedSentimentDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartTargetedSentimentDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartTargetedSentimentDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartTargetedSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the targeted sentiment detection job. It
	// is a unique, fully qualified identifier for the job. It includes the Amazon
	// Web Services account, Amazon Web Services Region, and the job ID. The format
	// of the ARN is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:targeted-sentiment-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:targeted-sentiment-detection-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the DescribeTargetedSentimentDetectionJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTargetedSentimentDetectionJob
	//    operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTargetedSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTargetedSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartTargetedSentimentDetectionJobOutput) SetJobArn(v string) *StartTargetedSentimentDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartTargetedSentimentDetectionJobOutput) SetJobId(v string) *StartTargetedSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTargetedSentimentDetectionJobOutput) SetJobStatus(v string) *StartTargetedSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend
	// read access to your input data. For more information, see Role-based permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/security_iam_id-based-policy-examples.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The number of topics to detect.
	NumberOfTopics *int64 `min:"1" type:"integer"`

	// Specifies where to send the output files. The output is a compressed archive
	// with two files, topic-terms.csv that lists the terms associated with each
	// topic, and doc-topics.csv that lists the documents associated with each topic
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Tags to associate with the topics detection job. A tag is a key-value pair
	// that adds metadata to a resource used by Amazon Comprehend. For example,
	// a tag with "Sales" as the key might be added to a resource to indicate its
	// use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the Amazon Web Services Key Management Service (KMS) key that Amazon
	// Comprehend uses to encrypt data on the storage volume attached to the ML
	// compute instance(s) that process the analysis job. The VolumeKmsKeyId can
	// be either of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your topic detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTopicsDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.NumberOfTopics != nil && *s.NumberOfTopics < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfTopics", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTopicsDetectionJobInput) SetClientRequestToken(v string) *StartTopicsDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTopicsDetectionJobInput) SetDataAccessRoleArn(v string) *StartTopicsDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartTopicsDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTopicsDetectionJobInput) SetJobName(v string) *StartTopicsDetectionJobInput {
	s.JobName = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *StartTopicsDetectionJobInput) SetNumberOfTopics(v int64) *StartTopicsDetectionJobInput {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTopicsDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTopicsDetectionJobInput) SetTags(v []*Tag) *StartTopicsDetectionJobInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartTopicsDetectionJobInput) SetVolumeKmsKeyId(v string) *StartTopicsDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartTopicsDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartTopicsDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the topics detection job. It is a unique,
	// fully qualified identifier for the job. It includes the Amazon Web Services
	// account, Amazon Web Services Region, and the job ID. The format of the ARN
	// is as follows:
	//
	// arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id>
	//
	// The following is an example job ARN:
	//
	// arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab
	JobArn *string `type:"string"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeTopicDetectionJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTopicDetectionJob
	//    operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *StartTopicsDetectionJobOutput) SetJobArn(v string) *StartTopicsDetectionJobOutput {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartTopicsDetectionJobOutput) SetJobId(v string) *StartTopicsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTopicsDetectionJobOutput) SetJobStatus(v string) *StartTopicsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobInput) SetJobId(v string) *StopDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type StopDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopDominantLanguageDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobId(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobInput) SetJobId(v string) *StopEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopEntitiesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobId(v string) *StopEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobStatus(v string) *StopEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopEventsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the events detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEventsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEventsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEventsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEventsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEventsDetectionJobInput) SetJobId(v string) *StopEventsDetectionJobInput {
	s.JobId = &v
	return s
}

type StopEventsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the events detection job to stop.
	JobId *string `min:"1" type:"string"`

	// The status of the events detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEventsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEventsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEventsDetectionJobOutput) SetJobId(v string) *StopEventsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopEventsDetectionJobOutput) SetJobStatus(v string) *StopEventsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobInput) SetJobId(v string) *StopKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopKeyPhrasesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobId(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopPiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PII entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPiiEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopPiiEntitiesDetectionJobInput) SetJobId(v string) *StopPiiEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopPiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PII entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// The status of the PII entities detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopPiiEntitiesDetectionJobOutput) SetJobId(v string) *StopPiiEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopPiiEntitiesDetectionJobOutput) SetJobStatus(v string) *StopPiiEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobInput) SetJobId(v string) *StopSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type StopSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopSentimentDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobOutput) SetJobId(v string) *StopSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopSentimentDetectionJobOutput) SetJobStatus(v string) *StopSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopTargetedSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the targeted sentiment detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTargetedSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTargetedSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTargetedSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTargetedSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopTargetedSentimentDetectionJobInput) SetJobId(v string) *StopTargetedSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type StopTargetedSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the targeted sentiment detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopSentimentDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTargetedSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTargetedSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopTargetedSentimentDetectionJobOutput) SetJobId(v string) *StopTargetedSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopTargetedSentimentDetectionJobOutput) SetJobStatus(v string) *StopTargetedSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopTrainingDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier currently
	// being trained.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTrainingDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *StopTrainingDocumentClassifierInput) SetDocumentClassifierArn(v string) *StopTrainingDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type StopTrainingDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingDocumentClassifierOutput) GoString() string {
	return s.String()
}

type StopTrainingEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer currently
	// being trained.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTrainingEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *StopTrainingEntityRecognizerInput) SetEntityRecognizerArn(v string) *StopTrainingEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type StopTrainingEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopTrainingEntityRecognizerOutput) GoString() string {
	return s.String()
}

// Represents a work in the input text that was recognized and assigned a part
// of speech. There is one syntax token record for each word in the source text.
type SyntaxToken struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the word.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the word.
	EndOffset *int64 `type:"integer"`

	// Provides the part of speech label and the confidence level that Amazon Comprehend
	// has that the part of speech was correctly identified. For more information,
	// see Syntax (https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html)
	// in the Comprehend Developer Guide.
	PartOfSpeech *PartOfSpeechTag `type:"structure"`

	// The word that was recognized in the source text.
	Text *string `min:"1" type:"string"`

	// A unique identifier for a token.
	TokenId *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyntaxToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyntaxToken) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SyntaxToken) SetBeginOffset(v int64) *SyntaxToken {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SyntaxToken) SetEndOffset(v int64) *SyntaxToken {
	s.EndOffset = &v
	return s
}

// SetPartOfSpeech sets the PartOfSpeech field's value.
func (s *SyntaxToken) SetPartOfSpeech(v *PartOfSpeechTag) *SyntaxToken {
	s.PartOfSpeech = v
	return s
}

// SetText sets the Text field's value.
func (s *SyntaxToken) SetText(v string) *SyntaxToken {
	s.Text = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *SyntaxToken) SetTokenId(v int64) *SyntaxToken {
	s.TokenId = &v
	return s
}

// A key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
// For example, a tag with the key-value pair ‘Department’:’Sales’ might
// be added to a resource to indicate its use by a particular department.
type Tag struct {
	_ struct{} `type:"structure"`

	// The initial part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the key portion of the pair,
	// with multiple possible values such as “sales,” “legal,” and “administration.”
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The second part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the initial (key) portion
	// of the pair, with a value of “sales” to indicate the sales department.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to
	// which you want to associate the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// Tags being associated with a specific Amazon Comprehend resource. There can
	// be a maximum of 50 tags (both existing and pending) associated with a specific
	// resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the ListTargetedSentimentDetectionJobs operation.
type TargetedSenti