package reservations

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AppliedScopeType enumerates the values for applied scope type.
type AppliedScopeType string

const (
	// AppliedScopeTypeShared ...
	AppliedScopeTypeShared AppliedScopeType = "Shared"
	// AppliedScopeTypeSingle ...
	AppliedScopeTypeSingle AppliedScopeType = "Single"
)

// PossibleAppliedScopeTypeValues returns an array of possible values for the AppliedScopeType const type.
func PossibleAppliedScopeTypeValues() []AppliedScopeType {
	return []AppliedScopeType{AppliedScopeTypeShared, AppliedScopeTypeSingle}
}

// CalculateExchangeOperationResultStatus enumerates the values for calculate exchange operation result status.
type CalculateExchangeOperationResultStatus string

const (
	// CalculateExchangeOperationResultStatusCancelled ...
	CalculateExchangeOperationResultStatusCancelled CalculateExchangeOperationResultStatus = "Cancelled"
	// CalculateExchangeOperationResultStatusFailed ...
	CalculateExchangeOperationResultStatusFailed CalculateExchangeOperationResultStatus = "Failed"
	// CalculateExchangeOperationResultStatusPending ...
	CalculateExchangeOperationResultStatusPending CalculateExchangeOperationResultStatus = "Pending"
	// CalculateExchangeOperationResultStatusSucceeded ...
	CalculateExchangeOperationResultStatusSucceeded CalculateExchangeOperationResultStatus = "Succeeded"
)

// PossibleCalculateExchangeOperationResultStatusValues returns an array of possible values for the CalculateExchangeOperationResultStatus const type.
func PossibleCalculateExchangeOperationResultStatusValues() []CalculateExchangeOperationResultStatus {
	return []CalculateExchangeOperationResultStatus{CalculateExchangeOperationResultStatusCancelled, CalculateExchangeOperationResultStatusFailed, CalculateExchangeOperationResultStatusPending, CalculateExchangeOperationResultStatusSucceeded}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// ErrorResponseCode enumerates the values for error response code.
type ErrorResponseCode string

const (
	// ErrorResponseCodeActivateQuoteFailed ...
	ErrorResponseCodeActivateQuoteFailed ErrorResponseCode = "ActivateQuoteFailed"
	// ErrorResponseCodeAppliedScopesNotAssociatedWithCommerceAccount ...
	ErrorResponseCodeAppliedScopesNotAssociatedWithCommerceAccount ErrorResponseCode = "AppliedScopesNotAssociatedWithCommerceAccount"
	// ErrorResponseCodeAppliedScopesSameAsExisting ...
	ErrorResponseCodeAppliedScopesSameAsExisting ErrorResponseCode = "AppliedScopesSameAsExisting"
	// ErrorResponseCodeAuthorizationFailed ...
	ErrorResponseCodeAuthorizationFailed ErrorResponseCode = "AuthorizationFailed"
	// ErrorResponseCodeBadRequest ...
	ErrorResponseCodeBadRequest ErrorResponseCode = "BadRequest"
	// ErrorResponseCodeBillingCustomerInputError ...
	ErrorResponseCodeBillingCustomerInputError ErrorResponseCode = "BillingCustomerInputError"
	// ErrorResponseCodeBillingError ...
	ErrorResponseCodeBillingError ErrorResponseCode = "BillingError"
	// ErrorResponseCodeBillingPaymentInstrumentHardError ...
	ErrorResponseCodeBillingPaymentInstrumentHardError ErrorResponseCode = "BillingPaymentInstrumentHardError"
	// ErrorResponseCodeBillingPaymentInstrumentSoftError ...
	ErrorResponseCodeBillingPaymentInstrumentSoftError ErrorResponseCode = "BillingPaymentInstrumentSoftError"
	// ErrorResponseCodeBillingScopeIDCannotBeChanged ...
	ErrorResponseCodeBillingScopeIDCannotBeChanged ErrorResponseCode = "BillingScopeIdCannotBeChanged"
	// ErrorResponseCodeBillingTransientError ...
	ErrorResponseCodeBillingTransientError ErrorResponseCode = "BillingTransientError"
	// ErrorResponseCodeCalculatePriceFailed ...
	ErrorResponseCodeCalculatePriceFailed ErrorResponseCode = "CalculatePriceFailed"
	// ErrorResponseCodeCapacityUpdateScopesFailed ...
	ErrorResponseCodeCapacityUpdateScopesFailed ErrorResponseCode = "CapacityUpdateScopesFailed"
	// ErrorResponseCodeClientCertificateThumbprintNotSet ...
	ErrorResponseCodeClientCertificateThumbprintNotSet ErrorResponseCode = "ClientCertificateThumbprintNotSet"
	// ErrorResponseCodeCreateQuoteFailed ...
	ErrorResponseCodeCreateQuoteFailed ErrorResponseCode = "CreateQuoteFailed"
	// ErrorResponseCodeForbidden ...
	ErrorResponseCodeForbidden ErrorResponseCode = "Forbidden"
	// ErrorResponseCodeFulfillmentConfigurationError ...
	ErrorResponseCodeFulfillmentConfigurationError ErrorResponseCode = "FulfillmentConfigurationError"
	// ErrorResponseCodeFulfillmentError ...
	ErrorResponseCodeFulfillmentError ErrorResponseCode = "FulfillmentError"
	// ErrorResponseCodeFulfillmentOutOfStockError ...
	ErrorResponseCodeFulfillmentOutOfStockError ErrorResponseCode = "FulfillmentOutOfStockError"
	// ErrorResponseCodeFulfillmentTransientError ...
	ErrorResponseCodeFulfillmentTransientError ErrorResponseCode = "FulfillmentTransientError"
	// ErrorResponseCodeHTTPMethodNotSupported ...
	ErrorResponseCodeHTTPMethodNotSupported ErrorResponseCode = "HttpMethodNotSupported"
	// ErrorResponseCodeInternalServerError ...
	ErrorResponseCodeInternalServerError ErrorResponseCode = "InternalServerError"
	// ErrorResponseCodeInvalidAccessToken ...
	ErrorResponseCodeInvalidAccessToken ErrorResponseCode = "InvalidAccessToken"
	// ErrorResponseCodeInvalidFulfillmentRequestParameters ...
	ErrorResponseCodeInvalidFulfillmentRequestParameters ErrorResponseCode = "InvalidFulfillmentRequestParameters"
	// ErrorResponseCodeInvalidHealthCheckType ...
	ErrorResponseCodeInvalidHealthCheckType ErrorResponseCode = "InvalidHealthCheckType"
	// ErrorResponseCodeInvalidLocationID ...
	ErrorResponseCodeInvalidLocationID ErrorResponseCode = "InvalidLocationId"
	// ErrorResponseCodeInvalidRefundQuantity ...
	ErrorResponseCodeInvalidRefundQuantity ErrorResponseCode = "InvalidRefundQuantity"
	// ErrorResponseCodeInvalidRequestContent ...
	ErrorResponseCodeInvalidRequestContent ErrorResponseCode = "InvalidRequestContent"
	// ErrorResponseCodeInvalidRequestURI ...
	ErrorResponseCodeInvalidRequestURI ErrorResponseCode = "InvalidRequestUri"
	// ErrorResponseCodeInvalidReservationID ...
	ErrorResponseCodeInvalidReservationID ErrorResponseCode = "InvalidReservationId"
	// ErrorResponseCodeInvalidReservationOrderID ...
	ErrorResponseCodeInvalidReservationOrderID ErrorResponseCode = "InvalidReservationOrderId"
	// ErrorResponseCodeInvalidSingleAppliedScopesCount ...
	ErrorResponseCodeInvalidSingleAppliedScopesCount ErrorResponseCode = "InvalidSingleAppliedScopesCount"
	// ErrorResponseCodeInvalidSubscriptionID ...
	ErrorResponseCodeInvalidSubscriptionID ErrorResponseCode = "InvalidSubscriptionId"
	// ErrorResponseCodeInvalidTenantID ...
	ErrorResponseCodeInvalidTenantID ErrorResponseCode = "InvalidTenantId"
	// ErrorResponseCodeMissingAppliedScopesForSingle ...
	ErrorResponseCodeMissingAppliedScopesForSingle ErrorResponseCode = "MissingAppliedScopesForSingle"
	// ErrorResponseCodeMissingTenantID ...
	ErrorResponseCodeMissingTenantID ErrorResponseCode = "MissingTenantId"
	// ErrorResponseCodeNonsupportedAccountID ...
	ErrorResponseCodeNonsupportedAccountID ErrorResponseCode = "NonsupportedAccountId"
	// ErrorResponseCodeNotSpecified ...
	ErrorResponseCodeNotSpecified ErrorResponseCode = "NotSpecified"
	// ErrorResponseCodeNotSupportedCountry ...
	ErrorResponseCodeNotSupportedCountry ErrorResponseCode = "NotSupportedCountry"
	// ErrorResponseCodeNoValidReservationsToReRate ...
	ErrorResponseCodeNoValidReservationsToReRate ErrorResponseCode = "NoValidReservationsToReRate"
	// ErrorResponseCodeOperationCannotBePerformedInCurrentState ...
	ErrorResponseCodeOperationCannotBePerformedInCurrentState ErrorResponseCode = "OperationCannotBePerformedInCurrentState"
	// ErrorResponseCodeOperationFailed ...
	ErrorResponseCodeOperationFailed ErrorResponseCode = "OperationFailed"
	// ErrorResponseCodePatchValuesSameAsExisting ...
	ErrorResponseCodePatchValuesSameAsExisting ErrorResponseCode = "PatchValuesSameAsExisting"
	// ErrorResponseCodePaymentInstrumentNotFound ...
	ErrorResponseCodePaymentInstrumentNotFound ErrorResponseCode = "PaymentInstrumentNotFound"
	// ErrorResponseCodePurchaseError ...
	ErrorResponseCodePurchaseError ErrorResponseCode = "PurchaseError"
	// ErrorResponseCodeReRateOnlyAllowedForEA ...
	ErrorResponseCodeReRateOnlyAllowedForEA ErrorResponseCode = "ReRateOnlyAllowedForEA"
	// ErrorResponseCodeReservationIDNotInReservationOrder ...
	ErrorResponseCodeReservationIDNotInReservationOrder ErrorResponseCode = "ReservationIdNotInReservationOrder"
	// ErrorResponseCodeReservationOrderCreationFailed ...
	ErrorResponseCodeReservationOrderCreationFailed ErrorResponseCode = "ReservationOrderCreationFailed"
	// ErrorResponseCodeReservationOrderIDAlreadyExists ...
	ErrorResponseCodeReservationOrderIDAlreadyExists ErrorResponseCode = "ReservationOrderIdAlreadyExists"
	// ErrorResponseCodeReservationOrderNotEnabled ...
	ErrorResponseCodeReservationOrderNotEnabled ErrorResponseCode = "ReservationOrderNotEnabled"
	// ErrorResponseCodeReservationOrderNotFound ...
	ErrorResponseCodeReservationOrderNotFound ErrorResponseCode = "ReservationOrderNotFound"
	// ErrorResponseCodeRiskCheckFailed ...
	ErrorResponseCodeRiskCheckFailed ErrorResponseCode = "RiskCheckFailed"
	// ErrorResponseCodeRoleAssignmentCreationFailed ...
	ErrorResponseCodeRoleAssignmentCreationFailed ErrorResponseCode = "RoleAssignmentCreationFailed"
	// ErrorResponseCodeServerTimeout ...
	ErrorResponseCodeServerTimeout ErrorResponseCode = "ServerTimeout"
	// ErrorResponseCodeUnauthenticatedRequestsThrottled ...
	ErrorResponseCodeUnauthenticatedRequestsThrottled ErrorResponseCode = "UnauthenticatedRequestsThrottled"
	// ErrorResponseCodeUnsupportedReservationTerm ...
	ErrorResponseCodeUnsupportedReservationTerm ErrorResponseCode = "UnsupportedReservationTerm"
)

// PossibleErrorResponseCodeValues returns an array of possible values for the ErrorResponseCode const type.
func PossibleErrorResponseCodeValues() []ErrorResponseCode {
	return []ErrorResponseCode{ErrorResponseCodeActivateQuoteFailed, ErrorResponseCodeAppliedScopesNotAssociatedWithCommerceAccount, ErrorResponseCodeAppliedScopesSameAsExisting, ErrorResponseCodeAuthorizationFailed, ErrorResponseCodeBadRequest, ErrorResponseCodeBillingCustomerInputError, ErrorResponseCodeBillingError, ErrorResponseCodeBillingPaymentInstrumentHardError, ErrorResponseCodeBillingPaymentInstrumentSoftError, ErrorResponseCodeBillingScopeIDCannotBeChanged, ErrorResponseCodeBillingTransientError, ErrorResponseCodeCalculatePriceFailed, ErrorResponseCodeCapacityUpdateScopesFailed, ErrorResponseCodeClientCertificateThumbprintNotSet, ErrorResponseCodeCreateQuoteFailed, ErrorResponseCodeForbidden, ErrorResponseCodeFulfillmentConfigurationError, ErrorResponseCodeFulfillmentError, ErrorResponseCodeFulfillmentOutOfStockError, ErrorResponseCodeFulfillmentTransientError, ErrorResponseCodeHTTPMethodNotSupported, ErrorResponseCodeInternalServerError, ErrorResponseCodeInvalidAccessToken, ErrorResponseCodeInvalidFulfillmentRequestParameters, ErrorResponseCodeInvalidHealthCheckType, ErrorResponseCodeInvalidLocationID, ErrorResponseCodeInvalidRefundQuantity, ErrorResponseCodeInvalidRequestContent, ErrorResponseCodeInvalidRequestURI, ErrorResponseCodeInvalidReservationID, ErrorResponseCodeInvalidReservationOrderID, ErrorResponseCodeInvalidSingleAppliedScopesCount, ErrorResponseCodeInvalidSubscriptionID, ErrorResponseCodeInvalidTenantID, ErrorResponseCodeMissingAppliedScopesForSingle, ErrorResponseCodeMissingTenantID, ErrorResponseCodeNonsupportedAccountID, ErrorResponseCodeNotSpecified, ErrorResponseCodeNotSupportedCountry, ErrorResponseCodeNoValidReservationsToReRate, ErrorResponseCodeOperationCannotBePerformedInCurrentState, ErrorResponseCodeOperationFailed, ErrorResponseCodePatchValuesSameAsExisting, ErrorResponseCodePaymentInstrumentNotFound, ErrorResponseCodePurchaseError, ErrorResponseCodeReRateOnlyAllowedForEA, ErrorResponseCodeReservationIDNotInReservationOrder, ErrorResponseCodeReservationOrderCreationFailed, ErrorResponseCodeReservationOrderIDAlreadyExists, ErrorResponseCodeReservationOrderNotEnabled, ErrorResponseCodeReservationOrderNotFound, ErrorResponseCodeRiskCheckFailed, ErrorResponseCodeRoleAssignmentCreationFailed, ErrorResponseCodeServerTimeout, ErrorResponseCodeUnauthenticatedRequestsThrottled, ErrorResponseCodeUnsupportedReservationTerm}
}

// ExchangeOperationResultStatus enumerates the values for exchange operation result status.
type ExchangeOperationResultStatus string

const (
	// ExchangeOperationResultStatusCancelled ...
	ExchangeOperationResultStatusCancelled ExchangeOperationResultStatus = "Cancelled"
	// ExchangeOperationResultStatusFailed ...
	ExchangeOperationResultStatusFailed ExchangeOperationResultStatus = "Failed"
	// ExchangeOperationResultStatusPendingPurchases ...
	ExchangeOperationResultStatusPendingPurchases ExchangeOperationResultStatus = "PendingPurchases"
	// ExchangeOperationResultStatusPendingRefunds ...
	ExchangeOperationResultStatusPendingRefunds ExchangeOperationResultStatus = "PendingRefunds"
	// ExchangeOperationResultStatusSucceeded ...
	ExchangeOperationResultStatusSucceeded ExchangeOperationResultStatus = "Succeeded"
)

// PossibleExchangeOperationResultStatusValues returns an array of possible values for the ExchangeOperationResultStatus const type.
func PossibleExchangeOperationResultStatusValues() []ExchangeOperationResultStatus {
	return []ExchangeOperationResultStatus{ExchangeOperationResultStatusCancelled, ExchangeOperationResultStatusFailed, ExchangeOperationResultStatusPendingPurchases, ExchangeOperationResultStatusPendingRefunds, ExchangeOperationResultStatusSucceeded}
}

// InstanceFlexibility enumerates the values for instance flexibility.
type InstanceFlexibility string

const (
	// InstanceFlexibilityOff ...
	InstanceFlexibilityOff InstanceFlexibility = "Off"
	// InstanceFlexibilityOn ...
	InstanceFlexibilityOn InstanceFlexibility = "On"
)

// PossibleInstanceFlexibilityValues returns an array of possible values for the InstanceFlexibility const type.
func PossibleInstanceFlexibilityValues() []InstanceFlexibility {
	return []InstanceFlexibility{InstanceFlexibilityOff, InstanceFlexibilityOn}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindMicrosoftCompute ...
	KindMicrosoftCompute Kind = "Microsoft.Compute"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindMicrosoftCompute}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCancelled ...
	OperationStatusCancelled OperationStatus = "Cancelled"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusPending ...
	OperationStatusPending OperationStatus = "Pending"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCancelled, OperationStatusFailed, OperationStatusPending, OperationStatusSucceeded}
}

// PaymentStatus enumerates the values for payment status.
type PaymentStatus string

const (
	// PaymentStatusCancelled ...
	PaymentStatusCancelled PaymentStatus = "Cancelled"
	// PaymentStatusFailed ...
	PaymentStatusFailed PaymentStatus = "Failed"
	// PaymentStatusScheduled ...
	PaymentStatusScheduled PaymentStatus = "Scheduled"
	// PaymentStatusSucceeded ...
	PaymentStatusSucceeded PaymentStatus = "Succeeded"
)

// PossiblePaymentStatusValues returns an array of possible values for the PaymentStatus const type.
func PossiblePaymentStatusValues() []PaymentStatus {
	return []PaymentStatus{PaymentStatusCancelled, PaymentStatusFailed, PaymentStatusScheduled, PaymentStatusSucceeded}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateBillingFailed ...
	ProvisioningStateBillingFailed ProvisioningState = "BillingFailed"
	// ProvisioningStateCancelled ...
	ProvisioningStateCancelled ProvisioningState = "Cancelled"
	// ProvisioningStateConfirmedBilling ...
	ProvisioningStateConfirmedBilling ProvisioningState = "ConfirmedBilling"
	// ProvisioningStateConfirmedResourceHold ...
	ProvisioningStateConfirmedResourceHold ProvisioningState = "ConfirmedResourceHold"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateExpired ...
	ProvisioningStateExpired ProvisioningState = "Expired"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMerged ...
	ProvisioningStateMerged ProvisioningState = "Merged"
	// ProvisioningStatePendingBilling ...
	ProvisioningStatePendingBilling ProvisioningState = "PendingBilling"
	// ProvisioningStatePendingResourceHold ...
	ProvisioningStatePendingResourceHold ProvisioningState = "PendingResourceHold"
	// ProvisioningStateSplit ...
	ProvisioningStateSplit ProvisioningState = "Split"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateBillingFailed, ProvisioningStateCancelled, ProvisioningStateConfirmedBilling, ProvisioningStateConfirmedResourceHold, ProvisioningStateCreated, ProvisioningStateCreating, ProvisioningStateExpired, ProvisioningStateFailed, ProvisioningStateMerged, ProvisioningStatePendingBilling, ProvisioningStatePendingResourceHold, ProvisioningStateSplit, ProvisioningStateSucceeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1BillingFailed ...
	ProvisioningState1BillingFailed ProvisioningState1 = "BillingFailed"
	// ProvisioningState1Cancelled ...
	ProvisioningState1Cancelled ProvisioningState1 = "Cancelled"
	// ProvisioningState1ConfirmedBilling ...
	ProvisioningState1ConfirmedBilling ProvisioningState1 = "ConfirmedBilling"
	// ProvisioningState1ConfirmedResourceHold ...
	ProvisioningState1ConfirmedResourceHold ProvisioningState1 = "ConfirmedResourceHold"
	// ProvisioningState1Created ...
	ProvisioningState1Created ProvisioningState1 = "Created"
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Expired ...
	ProvisioningState1Expired ProvisioningState1 = "Expired"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Merged ...
	ProvisioningState1Merged ProvisioningState1 = "Merged"
	// ProvisioningState1PendingBilling ...
	ProvisioningState1PendingBilling ProvisioningState1 = "PendingBilling"
	// ProvisioningState1PendingResourceHold ...
	ProvisioningState1PendingResourceHold ProvisioningState1 = "PendingResourceHold"
	// ProvisioningState1Split ...
	ProvisioningState1Split ProvisioningState1 = "Split"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1BillingFailed, ProvisioningState1Cancelled, ProvisioningState1ConfirmedBilling, ProvisioningState1ConfirmedResourceHold, ProvisioningState1Created, ProvisioningState1Creating, ProvisioningState1Expired, ProvisioningState1Failed, ProvisioningState1Merged, ProvisioningState1PendingBilling, ProvisioningState1PendingResourceHold, ProvisioningState1Split, ProvisioningState1Succeeded}
}

// QuotaRequestState enumerates the values for quota request state.
type QuotaRequestState string

const (
	// QuotaRequestStateAccepted ...
	QuotaRequestStateAccepted QuotaRequestState = "Accepted"
	// QuotaRequestStateFailed ...
	QuotaRequestStateFailed QuotaRequestState = "Failed"
	// QuotaRequestStateInProgress ...
	QuotaRequestStateInProgress QuotaRequestState = "InProgress"
	// QuotaRequestStateInvalid ...
	QuotaRequestStateInvalid QuotaRequestState = "Invalid"
	// QuotaRequestStateSucceeded ...
	QuotaRequestStateSucceeded QuotaRequestState = "Succeeded"
)

// PossibleQuotaRequestStateValues returns an array of possible values for the QuotaRequestState const type.
func PossibleQuotaRequestStateValues() []QuotaRequestState {
	return []QuotaRequestState{QuotaRequestStateAccepted, QuotaRequestStateFailed, QuotaRequestStateInProgress, QuotaRequestStateInvalid, QuotaRequestStateSucceeded}
}

// ReservationBillingPlan enumerates the values for reservation billing plan.
type ReservationBillingPlan string

const (
	// ReservationBillingPlanMonthly ...
	ReservationBillingPlanMonthly ReservationBillingPlan = "Monthly"
	// ReservationBillingPlanUpfront ...
	ReservationBillingPlanUpfront ReservationBillingPlan = "Upfront"
)

// PossibleReservationBillingPlanValues returns an array of possible values for the ReservationBillingPlan const type.
func PossibleReservationBillingPlanValues() []ReservationBillingPlan {
	return []ReservationBillingPlan{ReservationBillingPlanMonthly, ReservationBillingPlanUpfront}
}

// ReservationTerm enumerates the values for reservation term.
type ReservationTerm string

const (
	// ReservationTermP1Y ...
	ReservationTermP1Y ReservationTerm = "P1Y"
	// ReservationTermP3Y ...
	ReservationTermP3Y ReservationTerm = "P3Y"
	// ReservationTermP5Y ...
	ReservationTermP5Y ReservationTerm = "P5Y"
)

// PossibleReservationTermValues returns an array of possible values for the ReservationTerm const type.
func PossibleReservationTermValues() []ReservationTerm {
	return []ReservationTerm{ReservationTermP1Y, ReservationTermP3Y, ReservationTermP5Y}
}

// ReservedResourceType enumerates the values for reserved resource type.
type ReservedResourceType string

const (
	// ReservedResourceTypeAppService ...
	ReservedResourceTypeAppService ReservedResourceType = "AppService"
	// ReservedResourceTypeAVS ...
	ReservedResourceTypeAVS ReservedResourceType = "AVS"
	// ReservedResourceTypeAzureDataExplorer ...
	ReservedResourceTypeAzureDataExplorer ReservedResourceType = "AzureDataExplorer"
	// ReservedResourceTypeAzureFiles ...
	ReservedResourceTypeAzureFiles ReservedResourceType = "AzureFiles"
	// ReservedResourceTypeBlockBlob ...
	ReservedResourceTypeBlockBlob ReservedResourceType = "BlockBlob"
	// ReservedResourceTypeCosmosDb ...
	ReservedResourceTypeCosmosDb ReservedResourceType = "CosmosDb"
	// ReservedResourceTypeDatabricks ...
	ReservedResourceTypeDatabricks ReservedResourceType = "Databricks"
	// ReservedResourceTypeDataFactory ...
	ReservedResourceTypeDataFactory ReservedResourceType = "DataFactory"
	// ReservedResourceTypeDedicatedHost ...
	ReservedResourceTypeDedicatedHost ReservedResourceType = "DedicatedHost"
	// ReservedResourceTypeManagedDisk ...
	ReservedResourceTypeManagedDisk ReservedResourceType = "ManagedDisk"
	// ReservedResourceTypeMariaDb ...
	ReservedResourceTypeMariaDb ReservedResourceType = "MariaDb"
	// ReservedResourceTypeMySQL ...
	ReservedResourceTypeMySQL ReservedResourceType = "MySql"
	// ReservedResourceTypeNetAppStorage ...
	ReservedResourceTypeNetAppStorage ReservedResourceType = "NetAppStorage"
	// ReservedResourceTypePostgreSQL ...
	ReservedResourceTypePostgreSQL ReservedResourceType = "PostgreSql"
	// ReservedResourceTypeRedHat ...
	ReservedResourceTypeRedHat ReservedResourceType = "RedHat"
	// ReservedResourceTypeRedHatOsa ...
	ReservedResourceTypeRedHatOsa ReservedResourceType = "RedHatOsa"
	// ReservedResourceTypeRedisCache ...
	ReservedResourceTypeRedisCache ReservedResourceType = "RedisCache"
	// ReservedResourceTypeSapHana ...
	ReservedResourceTypeSapHana ReservedResourceType = "SapHana"
	// ReservedResourceTypeSQLAzureHybridBenefit ...
	ReservedResourceTypeSQLAzureHybridBenefit ReservedResourceType = "SqlAzureHybridBenefit"
	// ReservedResourceTypeSQLDatabases ...
	ReservedResourceTypeSQLDatabases ReservedResourceType = "SqlDatabases"
	// ReservedResourceTypeSQLDataWarehouse ...
	ReservedResourceTypeSQLDataWarehouse ReservedResourceType = "SqlDataWarehouse"
	// ReservedResourceTypeSQLEdge ...
	ReservedResourceTypeSQLEdge ReservedResourceType = "SqlEdge"
	// ReservedResourceTypeSuseLinux ...
	ReservedResourceTypeSuseLinux ReservedResourceType = "SuseLinux"
	// ReservedResourceTypeVirtualMachines ...
	ReservedResourceTypeVirtualMachines ReservedResourceType = "VirtualMachines"
	// ReservedResourceTypeVirtualMachineSoftware ...
	ReservedResourceTypeVirtualMachineSoftware ReservedResourceType = "VirtualMachineSoftware"
	// ReservedResourceTypeVMwareCloudSimple ...
	ReservedResourceTypeVMwareCloudSimple ReservedResourceType = "VMwareCloudSimple"
)

// PossibleReservedResourceTypeValues returns an array of possible values for the ReservedResourceType const type.
func PossibleReservedResourceTypeValues() []ReservedResourceType {
	return []ReservedResourceType{ReservedResourceTypeAppService, ReservedResourceTypeAVS, ReservedResourceTypeAzureDataExplorer, ReservedResourceTypeAzureFiles, ReservedResourceTypeBlockBlob, ReservedResourceTypeCosmosDb, ReservedResourceTypeDatabricks, ReservedResourceTypeDataFactory, ReservedResourceTypeDedicatedHost, ReservedResourceTypeManagedDisk, ReservedResourceTypeMariaDb, ReservedResourceTypeMySQL, ReservedResourceTypeNetAppStorage, ReservedResourceTypePostgreSQL, ReservedResourceTypeRedHat, ReservedResourceTypeRedHatOsa, ReservedResourceTypeRedisCache, ReservedResourceTypeSapHana, ReservedResourceTypeSQLAzureHybridBenefit, ReservedResourceTypeSQLDatabases, ReservedResourceTypeSQLDataWarehouse, ReservedResourceTypeSQLEdge, ReservedResourceTypeSuseLinux, ReservedResourceTypeVirtualMachines, ReservedResourceTypeVirtualMachineSoftware, ReservedResourceTypeVMwareCloudSimple}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// ResourceTypeDedicated ...
	ResourceTypeDedicated ResourceType = "dedicated"
	// ResourceTypeLowPriority ...
	ResourceTypeLowPriority ResourceType = "lowPriority"
	// ResourceTypeServiceSpecific ...
	ResourceTypeServiceSpecific ResourceType = "serviceSpecific"
	// ResourceTypeShared ...
	ResourceTypeShared ResourceType = "shared"
	// ResourceTypeStandard ...
	ResourceTypeStandard ResourceType = "standard"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{ResourceTypeDedicated, ResourceTypeLowPriority, ResourceTypeServiceSpecific, ResourceTypeShared, ResourceTypeStandard}
}

// StatusCode enumerates the values for status code.
type StatusCode string

const (
	// StatusCodeActive ...
	StatusCodeActive StatusCode = "Active"
	// StatusCodeExpired ...
	StatusCodeExpired StatusCode = "Expired"
	// StatusCodeMerged ...
	StatusCodeMerged StatusCode = "Merged"
	// StatusCodeNone ...
	StatusCodeNone StatusCode = "None"
	// StatusCodePaymentInstrumentError ...
	StatusCodePaymentInstrumentError StatusCode = "PaymentInstrumentError"
	// StatusCodePending ...
	StatusCodePending StatusCode = "Pending"
	// StatusCodeProcessing ...
	StatusCodeProcessing StatusCode = "Processing"
	// StatusCodePurchaseError ...
	StatusCodePurchaseError StatusCode = "PurchaseError"
	// StatusCodeSplit ...
	StatusCodeSplit StatusCode = "Split"
	// StatusCodeSucceeded ...
	StatusCodeSucceeded StatusCode = "Succeeded"
)

// PossibleStatusCodeValues returns an array of possible values for the StatusCode const type.
func PossibleStatusCodeValues() []StatusCode {
	return []StatusCode{StatusCodeActive, StatusCodeExpired, StatusCodeMerged, StatusCodeNone, StatusCodePaymentInstrumentError, StatusCodePending, StatusCodeProcessing, StatusCodePurchaseError, StatusCodeSplit, StatusCodeSucceeded}
}
