---
slug: git-cliff-1.2.0
title: What's new in 1.2.0?
date: 2023-04-28T00:00:00.000Z
authors: orhun
tags:
  - release
---
In this post, I'm giving a brief introduction to the new features in the 1.2.0 release while giving insight into the future of `git-cliff`.

<center>

 <a href="https://github.com/orhun/git-cliff">
    <img src="/img/git-cliff-banner.jpg" />
</a>

</center>

> [**git-cliff**](https://github.com/orhun/git-cliff) is a command-line tool (written in [Rust](https://www.rust-lang.org/)) that provides a highly customizable way to generate changelogs from git history. It supports using [custom regular expressions](/docs/configuration/git#commit_parsers) to alter changelogs which are mostly based on [conventional commits](/docs/configuration/git#conventional_commits). With a single [configuration file](/docs/configuration), a wide variety of formats can be applied for a changelog, thanks to the Jinja2/Django-inspired [template engine](/docs/category/templating). More information and examples can be found in the [GitHub repository](https://github.com/orhun/git-cliff).

Today, the new version of `git-cliff` (1.2.0) is released. There are a couple of major cool features that I believe are interesting and also there were some internal library changes. Let's have a look!

## What's new?

The full changelog can be found [here](https://github.com/orhun/git-cliff/blob/main/CHANGELOG.md).

### Improved documentation

`git-cliff` documentation is moved to [**https://git-cliff.org**](https://git-cliff.org).

It is surely better than cluttering up the `README.md` with all the information.

The source for the website can be found [here](https://github.com/orhun/git-cliff/tree/main/website).

### Python Integration

For Python projects, you can now place the `git-cliff` configuration inside `pyproject.toml` as follows:

```toml
name = "..."

[project]
dependencies = []

[tool.git-cliff.changelog]
header = "All notable changes to this project will be documented in this file."
body = "..."
footer = "<!-- generated by git-cliff -->"
# see [changelog] section for more keys

[tool.git-cliff.git]
conventional_commits = true
commit_parsers = []
filter_commits = false
# see [git] section for more keys
```

See the [documentation](https://git-cliff.org/docs/integration/python) for more information.

> Thanks to [@radusuciu](https://github.com/radusuciu) for the [implementation](https://github.com/orhun/git-cliff/pull/147)!

### Better commit grouping

You can now use regex values while grouping the commits via [`commit_parsers`](https://git-cliff.org/docs/configuration/git#commit_parsers).

Let's say we have this commit history for example:

```
* fix(args): rename help argument due to conflict
* feat(parser): add ability to parse arrays
```

For this configuration:

```toml
# regex for parsing and grouping commits
commit_parsers = [
    { message = '^fix\((.*)\)', group = 'Fix (${1})' },
    { message = '^feat\((.*)\)', group = 'Feat (${1})' },
]
```

We get:

```md
## [1.0.0] - 2021-07-18

### Feat (parser)

- Add ability to parse arrays

### Fix (args)

- Rename help argument due to conflict
```

> Thanks to [@erwinc1](https://github.com/erwinc1) for reporting the [issue](https://github.com/orhun/git-cliff/issues/145)!

### Overriding configuration with environment variables

It was reported by [@mackness](https://github.com/mackness) on [Discord](#discord-server) that overriding the nested configuration values with environment variables was not working as expected. So we made some changes:

- The prefix for environment variables is changed to `GIT_CLIFF` (from `CLIFF`).
- "`__`" can be used as the separator for nested fields.

For example:

- `GIT_CLIFF__CHANGELOG__FOOTER` overrides `changelog.footer`
- `GIT_CLIFF__GIT__IGNORE_TAGS` overrides `git.ignore_tags`

See the [documentation](https://git-cliff.org/docs/configuration#environment-configuration-overrides) for more information.

> Thanks to [@mackness](https://github.com/mackness) for the [implementation](https://github.com/orhun/git-cliff/pull/157)!

### New configuration file

For my own projects such as [halp](https://github.com/orhun/halp) and [linuxwave](https://github.com/orhun/linuxwave), I started to use a _fancier_ `git-cliff` configuration so I thought it would be nice to use it for the `git-cliff` repository as well.

Just to avoid confusion: the _default_ (basic) template has not changed. I'm just maintaining another `cliff.toml` at the root of the repository now.

- [`cliff.toml`](https://github.com/orhun/git-cliff/blob/main/config/cliff.toml) (default)
- [`cliff.toml`](https://github.com/orhun/git-cliff/blob/main/cliff.toml) (new)

The changelog looks something like this now:

```md
## [unreleased]

### ⛰️ Features

- _(cache)_ Use cache while fetching pages
- _(config)_ Support multiple file formats

## [1.0.1] - 2021-07-18

### 🚜 Refactor

- _(parser)_ Expose string functions

### ⚙️ Miscellaneous Tasks

- _(release)_ Add release script
```

See the other template examples in the [documentation](https://git-cliff.org/docs/templating/examples).

### New GitHub Action

A new GitHub Action for `git-cliff` has been created by [@jackton1](https://github.com/jackton1)!

> [tj-actions/git-cliff](https://github.com/tj-actions/git-cliff) is another GitHub Action that you can use to generate changelogs for your project.

> It uses a generic `cliff-template.toml` without the need to maintain multiple configuration files for each project or you can optionally provide a customized template as a path or URL which falls back to project's `cliff.toml` if it exist.

```yml
- name: Check out repository
  uses: actions/checkout@v3
  with:
    fetch-depth: 0

- name: Run git-cliff
  uses: tj-actions/git-cliff@v1
```

See the [documentation](https://git-cliff.org/docs/github-actions/tj-actions-git-cliff) for more information.

### Internal changes

Here is a list of changes that are worth mentioning if you use `git-cliff`/`git-cliff-core` in your Rust project as a library:

- Move `changelog` module to `git-cliff-core` ([2ab2c8f](https://github.com/orhun/git-cliff/commit/2ab2c8fb5e0c56b5ec51689ea33ebd4ec98a5310))
  - This reduces the number of dependencies since you will only depend on `git-cliff-core` for changelog generation.
- Make the fields of `Signature` public ([104aac9](https://github.com/orhun/git-cliff/commit/104aac93b468071c107e95ba0d377a69993e3403))
  - Useful if you want to construct this struct manually.

### Console interview

The [Console newsletter](https://console.substack.com/) interview came out where I talk about the story behind `git-cliff`, my motivation, and the technical challenges that I faced during development.

Read: [Console #141 - The Open Source Newsletter](https://console.substack.com/p/console-141)

### Discord server

If you are having a problem with `git-cliff` or want to contribute to the project or you just want to chit-chat, feel free to [join our Discord server](https://discord.gg/W3mAwMDWH4)!

## Looking forward

### Upcoming features

Here is the list of open pull requests that I'm planning to focus on for the next releases:

- [Publish `git-cliff` on PyPI](https://github.com/orhun/git-cliff/pull/158)
  - This would make it seamless for Python projects to install and use `git-cliff` and would pair nicely with the newly added support for configuration in `pyproject.toml`. It also fits nicely in the recent [rustification of python tooling trend](https://notes.crmarsh.com/python-tooling-could-be-much-much-faster).
- [Add postprocessors to changelog](https://github.com/orhun/git-cliff/pull/155)
  - This will enable things like replacing usernames with GitHub usernames for the generated changelog.

Also, see the [project issues](https://github.com/orhun/git-cliff/issues).

Apart from those, I'm planning _really_ big updates for the future that will _revolutionize_ the changelog generation. Stay tuned! 🚀

### New organization

I created an organization on GitHub: [https://github.com/git-cliff](https://github.com/git-cliff)

The following repositories will be moved there:

- `orhun/git-cliff` -> `git-cliff/git-cliff`
- `orhun/git-cliff-action` -> `git-cliff/action`

Just a heads-up :3

If you have a `git-cliff`-related repository that you're possibly interested in maintaining as a part of this organization, hit me up!

### Contributions

Any contribution is highly appreciated! There are [contribution guidelines](https://github.com/orhun/git-cliff/blob/main/CONTRIBUTING.md) for getting started.

Feel free to [submit issues](https://github.com/orhun/git-cliff/issues/new/choose) and throw in ideas!

## Donate

If you liked `git-cliff` and/or my other projects [on GitHub](https://github.com/orhun), consider donating to support my open source endeavors.

💖 [https://donate.orhun.dev](https://donate.orhun.dev)

Have a wonderful day! ⛰️
