/* gtkcolormapeditor.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2003 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#undef GTK_DISABLE_DEPRECATED /* we still need gtk_preview */
#warning GTK_DISABLE_DEPRECATED
#include "giram.h"
#include "color_map.h"

#include "giramintl.h"

#include "gtkcolormapeditor.h"

typedef enum
{
  CMAP_UPDATE_GRADIENT = 1 << 0,
  CMAP_UPDATE_PREVIEW  = 1 << 1,
  CMAP_UPDATE_CONTROL  = 1 << 2,
  CMAP_RESET_CONTROL   = 1 << 3  
} ColorMapEditorUpdateMask;

static gboolean preview_events(GtkWidget         *widget,
                               GdkEvent          *event,
                               GtkColorMapEditor *editor);
static void     preview_update(GtkColorMapEditor *editor,
                               gboolean           recalculate);
static void     preview_fill_image(GtkColorMapEditor *editor,
                                   gint               width,
                                   gint               height,
                                   gdouble            left,
                                   gdouble            right);
static void     color_map_editor_zoom_in_callback(GtkWidget         *widget,
                                                  GtkColorMapEditor *editor);
static void     color_map_editor_zoom_out_callback(GtkWidget         *widget,
                                                   GtkColorMapEditor *editor);
static void     color_map_editor_zoom_fit_callback(GtkWidget         *widget,
                                                   GtkColorMapEditor *editor);

static void color_map_editor_scrollbar_update(GtkAdjustment     *adj,
                                              GtkColorMapEditor *editor);

void color_map_editor_update(GtkColorMapEditor        *editor,
                             ColorMapEditorUpdateMask  flags);
static GtkWindowClass *parent_class = NULL;

/*************************************************************************
*  gtk_color_map_editor_class_init
**************************************************************************/
static void gtk_color_map_editor_class_init(GtkColorMapEditorClass *klass)
{
/*  GtkObjectClass *object_class;
  GtkButtonClass *button_class;
  GtkWidgetClass *widget_class;

  object_class = (GtkObjectClass*)class;
  button_class = (GtkButtonClass*)class;
  widget_class = (GtkWidgetClass*)class;
*/
  parent_class = g_type_class_peek_parent(klass);

/*  gtk_color_map_button_signals[COLOR_MAP_CHANGED] =
          gtk_signal_new("color_map_changed",
                         GTK_RUN_FIRST,
                         object_class->type,
                         GTK_SIGNAL_OFFSET(GtkColorMapButtonClass, color_map_changed),
                         gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
  gtk_object_class_add_signals(object_class, gtk_color_map_button_signals,
                               LAST_SIGNAL);
  class->color_map_changed = NULL;

  object_class->destroy       = gtk_color_map_button_destroy;
  button_class->clicked       = gtk_color_map_button_clicked;
  widget_class->state_changed = gtk_color_map_button_state_changed;*/
}

/*************************************************************************
*  gtk_color_map_editor_init
**************************************************************************/
static void gtk_color_map_editor_init(GtkColorMapEditor *gcme)
{
  GtkWidget *main_vbox, *separator, *button, *action_area;
  GtkWidget *frame, *vbox, *hbox;

  main_vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(gcme), main_vbox);
  gtk_widget_show(main_vbox);

  action_area = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_END);
  gtk_box_pack_end(GTK_BOX(main_vbox), action_area, FALSE, TRUE, 0);
  gtk_widget_show(action_area);

  separator = gtk_hseparator_new();
  gtk_box_pack_end(GTK_BOX(main_vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  /* The displayed colormap */
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_box_pack_start_defaults(GTK_BOX(main_vbox), frame);
  gtk_widget_show(frame);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  gcme->preview_rows[0] = gcme->preview_rows[1] = NULL;
  gcme->preview = gtk_preview_new(GTK_PREVIEW_COLOR);
  gtk_preview_set_dither(GTK_PREVIEW(gcme->preview), GDK_RGB_DITHER_MAX);
  gtk_preview_size(GTK_PREVIEW(gcme->preview), 600, 64);
  gtk_widget_set_size_request(gcme->preview, 600, 64);
  gtk_preview_set_expand(GTK_PREVIEW(gcme->preview), TRUE);
  gtk_widget_set_events(gcme->preview, GDK_EXPOSURE_MASK            |
                                       GDK_LEAVE_NOTIFY_MASK        |
                                       GDK_POINTER_MOTION_MASK      |
                                       GDK_POINTER_MOTION_HINT_MASK |
                                       GDK_BUTTON_PRESS_MASK        |
                                       GDK_BUTTON_RELEASE_MASK);
  g_signal_connect(G_OBJECT(gcme->preview), "event",
                   G_CALLBACK(preview_events), gcme);

  gtk_box_pack_start_defaults(GTK_BOX(vbox), gcme->preview);
  gtk_widget_show(gcme->preview);
  
  /* no control bar for now... */

  /* the Scrollbar */
  gcme->zoom_factor = 1;

  gcme->scroll_data = gtk_adjustment_new(0.0, 0.0, 1.0, 0.05, 0.75, 1.0);
  g_signal_connect(gcme->scroll_data, "value_changed",
                   G_CALLBACK(color_map_editor_scrollbar_update),
                   gcme);
  g_signal_connect(gcme->scroll_data, "changed",
                   G_CALLBACK(color_map_editor_scrollbar_update),
                   gcme);
  gcme->scrollbar = gtk_hscrollbar_new(GTK_ADJUSTMENT(gcme->scroll_data));
  gtk_range_set_update_policy(GTK_RANGE(gcme->scrollbar), GTK_UPDATE_CONTINUOUS);
  gtk_box_pack_start(GTK_BOX(main_vbox), gcme->scrollbar, FALSE, FALSE, 0);
  gtk_widget_show(gcme->scrollbar);

  /* Horizontal box for zoom controls and instant update toggle */
  hbox = gtk_hbox_new(FALSE, 4);
  gtk_box_pack_start(GTK_BOX(main_vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  button = gtk_button_new_from_stock(GTK_STOCK_ZOOM_FIT);
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(color_map_editor_zoom_fit_callback), gcme);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_from_stock(GTK_STOCK_ZOOM_IN);
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(color_map_editor_zoom_in_callback), gcme);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_from_stock(GTK_STOCK_ZOOM_OUT);
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(color_map_editor_zoom_out_callback), gcme);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
  gtk_widget_show(button);

  /* The button bar at the bottom */
  button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_box_pack_end(GTK_BOX(action_area), button, FALSE, TRUE, 0);
  gtk_widget_show(button);
  
/*  gcb->title    = NULL;

  gcb->color    = NULL;
  gcb->preview  = NULL;
  gcb->gcs      = NULL;*/
/*  gcmb->color_map = NULL;*/
  printf("bla\n");
}

/*************************************************************************
*  gtk_color_map_editor_get_type
**************************************************************************/
GType gtk_color_map_editor_get_type(void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo info =
      {
        sizeof (GtkColorMapEditorClass),
        NULL,       /* base_init */
        NULL,       /* base_finalize */
        (GClassInitFunc) gtk_color_map_editor_class_init,
        NULL,       /* class_finalize */
        NULL,       /* class_data */
        sizeof (GtkColorMapEditor),
        0,          /* n_preallocs */
        (GInstanceInitFunc) gtk_color_map_editor_init
      };

      type = g_type_register_static (GTK_TYPE_WINDOW,
                                     "GtkColorMapEditor", &info, 0);
    }

  return type;
}
/**
 * gtk_color_map_button_new:
 * @title: String that wil be used as title for the color_selector.
 * @width: Width of the colorpreview in pixels.
 * @height: Height of the colorpreview in pixels.
 * @color: An array of guchar holding the color (RGB or RGBA)
 * @bpp: May be 3 for RGB or 4 for RGBA.
 *
 * Creates a new GtkColorbutton widget. This returns a button with
 * a preview showing the color. When the button is clicked a
 * GtkColorSelectionDialog is opened. If the user changes the color
 * the new color is written into the array that was used to pass
 * the initial color and the "color_changed" signal is emitted.
 *
 * Returns: Pointer to the new GtkColorButton widget.
 */

GtkWidget *gtk_color_map_editor_new(GList *color_map)
{
  GtkColorMapEditor *gcme;


  gcme = g_object_new(GTK_TYPE_COLOR_MAP_EDITOR, NULL);

// FIXME: should really be  gcme->color_map = color_map_copy(color_map);


  gcme->color_map = NULL;

  { /* cheating for now */
    gdouble color[3];
    color[0] = 0.0; color[1] = 0.0; color[2] = 0.0;
    gcme->color_map = color_map_add_point(gcme->color_map, 0.0, color);
    color[0] = 1.0; color[1] = 0.0; color[2] = 0.0;
    gcme->color_map = color_map_add_point(gcme->color_map, 0.3, color);
    color[0] = 1.0; color[1] = 1.0; color[2] = 0.0;
    gcme->color_map = color_map_add_point(gcme->color_map, 0.6, color);
    color[0] = 1.0; color[1] = 1.0; color[2] = 1.0;
    gcme->color_map = color_map_add_point(gcme->color_map, 1.0, color);
  }
  
/*  gcmb->preview = gtk_preview_new(GTK_PREVIEW_COLOR);
  gtk_signal_connect(GTK_OBJECT(gcmb->preview), "destroy",
                     gtk_widget_destroyed, &gcmb->preview);

  gtk_preview_size(GTK_PREVIEW(gcmb->preview), width, height);
  gtk_container_add(GTK_CONTAINER(gcmb), gcmb->preview);
  gtk_widget_show(gcmb->preview);
  gtk_color_map_button_paint(gcmb);
*/
  return (GTK_WIDGET(gcme));
}



static gboolean preview_events(GtkWidget         *widget,
                               GdkEvent          *event,
                               GtkColorMapEditor *editor)
{
  switch (event->type)
  {
    case GDK_EXPOSE:
      preview_update(editor, FALSE);
      return FALSE;

    default:

      return FALSE;
  }

  return TRUE;
}

static void preview_update(GtkColorMapEditor *editor,
                           gboolean           recalculate)
{
  glong          row_size;
  guint16        width, height;
  GtkAdjustment *adjustment;

  static guint16 last_width = 0, last_height = 0;
  
  if (!GTK_WIDGET_DRAWABLE(editor->preview))
    return;
  
  width  = editor->preview->allocation.width;
  height = editor->preview->allocation.height;

  if (!editor->preview_rows[0] ||
      !editor->preview_rows[1] ||
      (width != last_width)    ||
      (height != last_height))
  {
    if (editor->preview_rows[0])
      g_free(editor->preview_rows[0]);
    if (editor->preview_rows[1])
      g_free(editor->preview_rows[1]);

    row_size = width * 3 * sizeof(guchar);

    editor->preview_rows[0] = g_malloc(row_size);
    editor->preview_rows[1] = g_malloc(row_size);

    recalculate = TRUE;
  }
  
  last_width  = width;
  last_height = height;

  if (recalculate)
  {
    adjustment = GTK_ADJUSTMENT(editor->scroll_data);
    preview_fill_image(editor, width, height,
                       adjustment->value,
                       adjustment->value + adjustment->page_size);

    gtk_widget_queue_draw(editor->preview);
  }
}

static void preview_fill_image(GtkColorMapEditor *editor,
                               gint               width,
                               gint               height,
                               gdouble            left,
                               gdouble            right)
{
  gint     x, y;
  gdouble  dx, cur_x;
  guchar  *p0;
  gdouble  color[3];

  p0    = editor->preview_rows[0];
  cur_x = left;
  dx    = (right - left) / (width - 1);

  for (x = 0 ; x < width ; x++)
  {
    color_map_evaluate(editor->color_map, cur_x, color);
    *p0++ = color[0] * 255.0;
    *p0++ = color[1] * 255.0;
    *p0++ = color[2] * 255.0;
    cur_x += dx;
  }

  for (y = 0 ; y < height ; y++)
  {
    gtk_preview_draw_row(GTK_PREVIEW(editor->preview),
                         editor->preview_rows[0], 0, y, width);
  }
}

static void color_map_editor_zoom_in_callback(GtkWidget         *widget,
                                              GtkColorMapEditor *editor)
{
  GtkAdjustment *adjustment;
  gdouble        old_value;
  gdouble        old_page_size;
  gdouble        page_size;

  adjustment = GTK_ADJUSTMENT(editor->scroll_data);

  old_value     = adjustment->value;
  old_page_size = adjustment->page_size;

  editor->zoom_factor++;

  page_size = 1.0 / editor->zoom_factor;

  adjustment->value      = old_value + (old_page_size - page_size) / 2.0;
  adjustment->page_size  = page_size;
  adjustment->step_increment = page_size * 0.05;
  adjustment->page_increment = page_size * 0.75;

  gtk_adjustment_changed(GTK_ADJUSTMENT(editor->scroll_data));
}

static void color_map_editor_zoom_out_callback(GtkWidget         *widget,
                                               GtkColorMapEditor *editor)
{
  GtkAdjustment *adjustment;
  gdouble        old_value;
  gdouble        value;
  gdouble        old_page_size;
  gdouble        page_size;

  if (editor->zoom_factor <= 1)
    return;

  adjustment = GTK_ADJUSTMENT(editor->scroll_data);

  old_value     = adjustment->value;
  old_page_size = adjustment->page_size;

  editor->zoom_factor--;

  page_size = 1.0 / editor->zoom_factor;
  value     = old_value - (page_size - old_page_size) / 2.0;

  if (value < 0.0)
    value = 0.0;
  else if ((value + page_size) > 1.0)
    value = 1.0 - page_size;

  adjustment->value          = value;
  adjustment->page_size      = page_size;
  adjustment->step_increment = page_size * 0.05;
  adjustment->page_increment = page_size * 0.75;

  gtk_adjustment_changed(GTK_ADJUSTMENT(editor->scroll_data));
}

static void color_map_editor_zoom_fit_callback(GtkWidget         *widget,
                                               GtkColorMapEditor *editor)
{
  GtkAdjustment *adjustment;

  adjustment = GTK_ADJUSTMENT(editor->scroll_data);

  editor->zoom_factor = 1;

  adjustment->value          = 0.0;
  adjustment->page_size      = 1.0;
  adjustment->step_increment = 0.05;
  adjustment->page_increment = 0.75;

  gtk_adjustment_changed(GTK_ADJUSTMENT(editor->scroll_data));
}

static void color_map_editor_scrollbar_update(GtkAdjustment     *adj,
                                              GtkColorMapEditor *editor)
{
  gchar *str1, *str2;

  str1 = g_strdup_printf(_("Zoom factor: %d:1"),
                         editor->zoom_factor);
  str2 = g_strdup_printf(_("Displaying [%0.6f, %0.6f]"),
                         adj->value,
                         adj->value + adj->page_size);

  //color_map_editor_set_hint(editor, str1, str2, "");
  g_free(str1);
  g_free(str2);

  color_map_editor_update(editor,
                          CMAP_UPDATE_PREVIEW | CMAP_UPDATE_CONTROL);
}


void color_map_editor_update(GtkColorMapEditor        *editor,
                             ColorMapEditorUpdateMask  flags)
{
  if (flags & CMAP_UPDATE_GRADIENT)
    preview_update(editor, TRUE);

  if (flags & CMAP_UPDATE_PREVIEW)
    preview_update (editor, TRUE);

/*  if (flags & GRAD_UPDATE_CONTROL)
    control_update (editor, gradient, FALSE);

  if (flags & GRAD_RESET_CONTROL)
    control_update (editor, gradient, TRUE);*/
}



