/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramquerybox.h
 * Copyright (C) 1999-2000 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_QUERY_BOX_H__
#define __GIRAM_QUERY_BOX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

 /* For information look into the C source or the html documentation */


/*  query box callback prototypes  */
typedef void (* GiramQueryStringCallback)(GtkWidget *query_box,
                                          gchar     *string,
                                          gpointer   data);

typedef void (* GiramQueryIntCallback)(GtkWidget *query_box,
                                       gint       value,
                                       gpointer   data);

typedef void (* GiramQueryDoubleCallback)(GtkWidget *query_box,
                                          gdouble    value,
                                          gpointer   data);

/*typedef void (* GiramQuerySizeCallback)(GtkWidget *query_box,
                                        gdouble    size,
                                        GiramUnit  unit,
                                        gpointer   data);*/

typedef void (* GiramQueryBooleanCallback)(GtkWidget *query_box,
                                           gboolean   value,
                                           gpointer   data);

/*  some simple query dialogs  */
GtkWidget *giram_query_string_box(const gchar               *title,
                                  GiramHelpFunc              help_func,
                                  const gchar               *help_data,
                                  const gchar               *message,
                                  const gchar               *initial,
                                  GtkObject                 *object,
                                  const gchar               *signal,
                                  GiramQueryStringCallback   callback,
                                  gpointer                   data);

GtkWidget *giram_query_int_box(const gchar              *title,
                               GiramHelpFunc             help_func,
                               const gchar              *help_data,
                               const gchar              *message,
                               gint                      initial,
                               gint                      lower,
                               gint                      upper,
                               GtkObject                *object,
                               const gchar              *signal,
                               GiramQueryIntCallback     callback,
                               gpointer                  data);

GtkWidget *giram_query_double_box(const gchar              *title,
                                  GiramHelpFunc             help_func,
                                  const gchar              *help_data,
                                  const gchar              *message,
                                  gdouble                   initial,
                                  gdouble                   lower,
                                  gdouble                   upper,
                                  gint                      digits,
                                  GtkObject                *object,
                                  const gchar              *signal,
                                  GiramQueryDoubleCallback  callback,
                                  gpointer                  data);

/*GtkWidget *giram_query_size_box(const gchar              *title,
                                GiramHelpFunc             help_func,
                                const gchar              *help_data,
                                const gchar              *message,
                                gdouble                   initial,
                                gdouble                   lower,
                                gdouble                   upper,
                                gint                      digits,
                                GiramUnit                 unit,
                                gdouble                   resolution,
                                gboolean                  dot_for_dot,
                                GtkObject                *object,
                                const gchar              *signal,
                                GiramQuerySizeCallback    callback,
                                gpointer                  data);*/

GtkWidget *giram_query_boolean_box(const gchar               *title,
                                   GiramHelpFunc              help_func,
                                   const gchar               *help_data,
                                   gboolean                   eek,
                                   const gchar               *message,
                                   const gchar               *true_button,
                                   const gchar               *false_button,
                                   GtkObject                 *object,
                                   const gchar               *signal,
                                   GiramQueryBooleanCallback  callback,
                                   gpointer                   data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_QUERY_BOX_H__ */

