/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *  
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * girampatheditor.h
 * Copyright (C) 1999 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_PATH_EDITOR_H__
#define __GIRAM_PATH_EDITOR_H__

G_BEGIN_DECLS

#define GIRAM_TYPE_PATH_EDITOR            (giram_path_editor_get_type())
#define GIRAM_PATH_EDITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GIRAM_TYPE_PATH_EDITOR, GiramPathEditor))
#define GIRAM_PATH_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GIRAM_TYPE_PATH_EDITOR, GiramPathEditorClass))
#define GIRAM_IS_PATH_EDITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE(obj, GIRAM_TYPE_PATH_EDITOR))
#define GIRAM_IS_PATH_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_PATH_EDITOR))
#define GIRAM_PATH_EDITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIRAM_TYPE_PATH_EDITOR, GiramPathEditorClass))

typedef struct _GiramPathEditorClass  GiramPathEditorClass;

struct _GiramPathEditor
{
  GtkVBox           parent_instance;

  GtkWidget        *upper_hbox;

  GtkWidget        *new_button;
  GtkWidget        *up_button;
  GtkWidget        *down_button;
  GtkWidget        *delete_button;

  GtkWidget        *file_selection;

  GtkListStore     *dir_list;

  GtkTreeSelection *sel;
  GtkTreePath      *sel_path;
  gint              num_items;
};

struct _GiramPathEditorClass
{
  GtkVBoxClass parent_class;

  void (* path_changed)(GiramPathEditor *gpe);
};

GType giram_path_editor_get_type(void) G_GNUC_CONST;

GtkWidget *giram_path_editor_new(const gchar *filesel_title,
                                 const gchar *path);

gchar *giram_path_editor_get_path(GiramPathEditor *gpe);

G_END_DECLS

#endif /* __GIRAM_PATH_EDITOR_H__ */

