/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramfileselection.h
 * Copyright (C) 1999 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_FILE_SELECTION_H__
#define __GIRAM_FILE_SELECTION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GIRAM_TYPE_FILE_SELECTION            (giram_file_selection_get_type())
#define GIRAM_FILE_SELECTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GIRAM_TYPE_FILE_SELECTION, GiramFileSelection))
#define GIRAM_FILE_SELECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GIRAM_TYPE_FILE_SELECTION, GiramFileSelectionClass))
#define GIRAM_IS_FILE_SELECTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE(obj, GIRAM_TYPE_FILE_SELECTION))
#define GIRAM_IS_FILE_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_FILE_SELECTION))
#define GIRAM_FILE_SELECTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GIRAM_FILE_SELECTION, GiramFileSelectionClass)

typedef struct _GiramFileSelection       GiramFileSelection;
typedef struct _GiramFileSelectionClass  GiramFileSelectionClass;

struct _GiramFileSelection
{
  GtkHBox    parent_instance;

  GtkWidget *file_exists;
  GtkWidget *entry;
  GtkWidget *browse_button;

  GtkWidget *file_selection;

  gchar     *title;
  gboolean   dir_only;
  gboolean   check_valid;
};

struct _GiramFileSelectionClass
{
  GtkHBoxClass parent_class;

  void (* filename_changed)(GiramFileSelection *gfs);
};

GType      giram_file_selection_get_type(void) G_GNUC_CONST;

GtkWidget *giram_file_selection_new(const gchar *title,
                                    const gchar *filename,
                                    gboolean     dir_only,
                                    gboolean     check_valid);

gchar *giram_file_selection_get_filename(GiramFileSelection *gfs);

void giram_file_selection_set_filename(GiramFileSelection *gfs,
                                       const gchar        *filename);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_FILE_SELECTION_H__ */

