/* trimesh.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2000 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "trimesh.h"

/*****************************************************************************
*  DestroyObjectTriangleMesh
******************************************************************************/
void DestroyObjectTriangleMesh(ObjectStruct *Object)
{
  TriangleListStruct *Tmp1, *Tmp2;

  Tmp1 = Object->FirstTriangle;
  Object->FirstTriangle = NULL;
  while(Tmp1)
  {
    Tmp2=Tmp1->Next;
    g_free(Tmp1);
    Tmp1=Tmp2;
  }
}

/*****************************************************************************
*  AddTriangleToObjectMesh
******************************************************************************/
void AddTriangleToObjectMesh(ObjectStruct *Object,
                             Vector P1, Vector P2, Vector P3,
                             Vector N1, Vector N2, Vector N3)
{
  TriangleListStruct *Tmp;

  Tmp = g_new(TriangleListStruct, 1);
  Tmp->Next = Object->FirstTriangle;
  Object->FirstTriangle = Tmp;
  V3Dcopy(Tmp->P1, P1); V3Dcopy(Tmp->N1, N1);
  V3Dcopy(Tmp->P2, P2); V3Dcopy(Tmp->N2, N2);
  V3Dcopy(Tmp->P3, P3); V3Dcopy(Tmp->N3, N3);
}

/*****************************************************************************
*  ComputeSelectionTriangleMesh
******************************************************************************/
TriangleListStruct *ComputeSelectionTriangleMesh(GList *selection)
{
  TriangleListStruct *SelTri, *TmpTri, *Triangle;
  GList              *tmp_selection;
  ObjectStruct       *object;

  SelTri = NULL;
  for (tmp_selection = selection ;
       tmp_selection ;
       tmp_selection = g_list_next(tmp_selection) )
  {
    object = tmp_selection->data;
    for (TmpTri = object->FirstTriangle ;
         TmpTri ;
         TmpTri = TmpTri->Next)
    { /* XXX: May use memcpy? */
      Triangle = g_new(TriangleListStruct, 1);
      Triangle->Next = SelTri;
      SelTri = Triangle;
      V3Dcopy(Triangle->P1, TmpTri->P1);
      V3Dcopy(Triangle->P2, TmpTri->P2);
      V3Dcopy(Triangle->P3, TmpTri->P3);
    }
  }

  return SelTri;
}

