/* tools.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TOOLS_H__
#define __TOOLS_H__

/* What a tool is made of: */
typedef GtkWidget *(*OptionsFuncType)(GtkWidget *VBox);

typedef struct GiramTool
{
  char  *ToolTip;
  char **Icon;
  char  *Path;
  OptionsFuncType OptionsFunc;
  void (* button_press)  (GtkWidget      *canvas,
                          GdkEventButton *bevent);
  void (* button_release)(GtkWidget      *canvas,
                          GdkEventButton *bevent);
  void (* motion)        (GtkWidget      *canvas,
                          GdkEventMotion *mevent);
  void (* cursor_update) (GtkWidget      *canvas,
                          guint           state);
  int ID;
  GtkWidget *option_box;
} GiramTool;

extern GList *all_tools;
extern GiramTool *current_tool;

/* This is the width of the main toolbox in icons (Vik) */
#ifdef WITH_VIK
#define TOOLBOX_WIDTH 5
#else
#define TOOLBOX_WIDTH 3
#endif

#define VERTICAL_TOOLBOX   0
#define HORIZONTAL_TOOLBOX 1
#define SQUARE_TOOLBOX     2
extern gint DynamicToolBoxShape;

GtkWidget *CreateTools(GtkWidget *Box);
void tool_init(void);

/* the pan tool should be accessible for the "middle button  pan" */
extern GiramTool *pan_tool;


#endif /* __TOOLS_H__ */
