/* tools.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#undef GTK_DISABLE_DEPRECATED
#warning GTK_DISABLE_DEPRECATED

#include <math.h>
#include "giram.h"
#include "tool_select.h"
#include "tool_move.h"
#include "tool_rotate.h"
#include "tool_scale.h"

#include "tool_box.h"
#include "tool_cone.h"
#include "tool_cylinder.h"
#include "tool_disc.h"
#include "tool_options.h"
#include "tool_plane.h"
#include "tool_quadric.h"
#include "tool_sor.h"
#include "tool_sphere.h"
#include "tool_superellipsoid.h"
#include "tool_torus.h"
#include "tool_triangle.h"
#include "tool_csg.h"
#include "tool_light_source.h"
#include "tool_heightfield.h"
#include "tool_bicubic_patch.h"

#include "tool_zoom.h"
#include "tool_pan.h"

#include "tools.h"
#include "giramrc.h"
#include "giramintl.h"

GList *all_tools = NULL;

GiramTool *current_tool = NULL;

GiramTool *pan_tool = NULL;

typedef struct
{
  char       *Path;
  int         ToolNumber;
  GtkWidget  *Button;
  int         nb_columns, nb_rows;
  GtkWidget  *PopWindow;
  GtkWidget  *Table;
  GSList     *Group;
  GtkWidget **PixmapInBox;
  GtkWidget  *Box;
  int         pos;
  GiramTool **IDTable;
} TableDescriptor;

#define VERTICAL_TOOLBOX   0
#define HORIZONTAL_TOOLBOX 1
#define SQUARE_TOOLBOX     2
gint DynamicToolBoxShape = SQUARE_TOOLBOX;

/*****************************************************************************
*  ToolSelect
******************************************************************************/
static void ToolSelect(GtkWidget *widget, gpointer data)
{
  current_tool = data;
  ShowOptionsForTool(current_tool);
}

/*****************************************************************************
*  SubToolSelect
******************************************************************************/
static void SubToolSelect(GtkObject *button)
{
  current_tool = g_object_get_data(G_OBJECT(button), "user_data");
  ShowOptionsForTool(current_tool);
}

/*****************************************************************************
*  SecondaryToolSelect
******************************************************************************/
static void SecondaryToolSelect(GtkObject *widget, gpointer data)
{
  TableDescriptor *TD;
  int              i, ToolIndex;

  TD = g_object_get_data(G_OBJECT(widget), "user_data");
  ToolIndex = (int)data;
  for (i=0 ; i < TD->ToolNumber ; i++)
  {
    if (i==ToolIndex)
      gtk_widget_show(TD->PixmapInBox[i]);
    else
      gtk_widget_hide(TD->PixmapInBox[i]);
  }
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(TD->Button)))
  {
    current_tool = TD->IDTable[ToolIndex]; 
    ShowOptionsForTool(current_tool);
  }
  g_object_set_data(G_OBJECT(TD->Button), "user_data",
                    TD->IDTable[ToolIndex]);
}

/*****************************************************************************
*  ToolsDoubleClick
******************************************************************************/
static gboolean ToolsDoubleClick(GtkWidget *w, GdkEventButton *event)
{
  if ((event->type == GDK_2BUTTON_PRESS) && (event->button == 1))
    ShowToolOptionsDialog();
  return FALSE;
}

/*****************************************************************************
*  SubToolButton
******************************************************************************/
static gboolean SubToolButton(GtkWidget *w, GdkEventButton *event, GtkWidget *PopWin)
{
  if ((event->type == GDK_2BUTTON_PRESS) && (event->button == 1))
    ShowToolOptionsDialog();
  else if (event->button == 3)
  {
    gtk_widget_show(PopWin);
  }
  return FALSE;
}

/*****************************************************************************
*  CreateTools
******************************************************************************/
GtkWidget *CreateTools(GtkWidget *Box)
{
  GtkWidget   *MainTable;
  GtkTooltips *ToolTips;
  GSList      *RadioGroup;
  GtkWidget   *Button;
  guint        number_of_main_tools;
  GdkBitmap   *MaskIcon;
  GdkColor     transparent;
  GdkPixmap   *PixmapIcon;
  GtkWidget   *Pixmap;
  GSList      *SecondaryTables = NULL;
  guint        pos;
  GList       *tmp_list;
  GiramTool   *tool;

  /* First Pass: Counting the number of icons on the Main Table */
  number_of_main_tools = 0;
  for (tmp_list = all_tools; tmp_list ; tmp_list = g_list_next(tmp_list) )
  {
    tool = tmp_list->data;

    if (!strcmp(tool->Path, "<ToolBar>") || toolbox_style == FALSE)
      number_of_main_tools++;
    else
    {
      GSList *TmpList;
      for (TmpList = SecondaryTables ;
           TmpList && strcmp(((TableDescriptor *)(TmpList->data))->Path, tool->Path) ;
           TmpList = TmpList->next)
        ;
      if (TmpList)
      {
        ((TableDescriptor *)(TmpList->data))->ToolNumber++;
      } else
      {
        TableDescriptor *NewTable;
        NewTable = g_new(TableDescriptor, 1);
        NewTable->Path = g_strdup(tool->Path);
        NewTable->ToolNumber = 1;
        SecondaryTables = g_slist_append(SecondaryTables, NewTable);
        number_of_main_tools++;
        NewTable->Button = NULL;
      }
    }
  }
  /* Second pass: the real creation */
  MainTable = gtk_table_new((number_of_main_tools-1)/TOOLBOX_WIDTH+1, TOOLBOX_WIDTH, TRUE);
  gtk_box_pack_start_defaults(GTK_BOX(Box), MainTable);
  gtk_widget_realize(MainTable);
  ToolTips = gtk_tooltips_new();
  RadioGroup = NULL;
  pos = 0;
  for (tmp_list = all_tools ; tmp_list ; tmp_list = g_list_next(tmp_list) )
  {
    tool = tmp_list->data;
    if (!strcmp(tool->Path, "<ToolBar>") || toolbox_style == FALSE)
    { /* We've found a lonely tool, that only belongs to the main ToolBar... */
      Button = gtk_radio_button_new(RadioGroup);
      gtk_container_set_border_width(GTK_CONTAINER(Button), 0);
      RadioGroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(Button));
      gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(Button), FALSE);
      gtk_table_attach(GTK_TABLE(MainTable), Button, pos%TOOLBOX_WIDTH,pos%TOOLBOX_WIDTH+1, pos/TOOLBOX_WIDTH,pos/TOOLBOX_WIDTH+1,
                       GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                       GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
      g_signal_connect(G_OBJECT(Button), "toggled",
                       G_CALLBACK(ToolSelect), tool);
      gtk_tooltips_set_tip(ToolTips, Button, tool->ToolTip, NULL);
      if (tool->Icon)
      {
        PixmapIcon = gdk_pixmap_create_from_xpm_d(MainTable->window,
                                                  &MaskIcon,
                                                  &transparent,
                                                  tool->Icon);
        Pixmap = gtk_pixmap_new(PixmapIcon, MaskIcon);
      } else
      {
        Pixmap = gtk_label_new(tool->ToolTip);
      }
      gtk_container_add(GTK_CONTAINER(Button), Pixmap);
      g_signal_connect(G_OBJECT(Button), "button_press_event",
                       G_CALLBACK(ToolsDoubleClick), NULL);
      gtk_widget_show(Pixmap);
      gtk_widget_show(Button);
      pos++;
    } else
    { /* This tools belongs to a secondary toolbox */
      GSList *TmpList;

      for (TmpList = SecondaryTables ;
           TmpList && strcmp(((TableDescriptor *)(TmpList->data))->Path, tool->Path) ;
           TmpList = TmpList->next)
        ;
      if (((TableDescriptor *)(TmpList->data))->Button)
      { /* Does the toolbox exists yet? yes */
        TableDescriptor *TD = TmpList->data;

        Button = gtk_radio_button_new(TD->Group);
        gtk_container_set_border_width(GTK_CONTAINER(Button), 0);
        TD->Group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(Button));
        gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(Button), FALSE);
        gtk_table_attach(GTK_TABLE(TD->Table), Button,
                                   TD->pos%TD->nb_columns, TD->pos%TD->nb_columns+1,
                                   TD->pos/TD->nb_columns, TD->pos/TD->nb_columns+1,
                                   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                                   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
        g_signal_connect(G_OBJECT(Button), "clicked",
                         G_CALLBACK(SecondaryToolSelect),
                           (gpointer)(TD->pos));
        gtk_signal_connect_object_after(GTK_OBJECT(Button), "clicked",
                                        GTK_SIGNAL_FUNC(gtk_widget_hide),
                                        GTK_OBJECT(TD->PopWindow));
        g_object_set_data(G_OBJECT(Button), "user_data", TD);
        gtk_widget_show(Button);
        if (tool->Icon)
        {
          GdkGC *gc;
          GdkColor color;
          int off;

          PixmapIcon = gdk_pixmap_create_from_xpm_d(MainTable->window,
                                                    &MaskIcon,
                                                    &transparent,
                                                    tool->Icon);
          Pixmap = gtk_pixmap_new(PixmapIcon, MaskIcon);
          PixmapIcon = gdk_pixmap_create_from_xpm_d(MainTable->window,
                                                    &MaskIcon,
                                                    &transparent,
                                                    tool->Icon);
          TD->PixmapInBox[TD->pos] = gtk_pixmap_new(PixmapIcon, MaskIcon);
          /* Draw the little black triangle */
          gc = gdk_gc_new((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->mask);
          gdk_color_white(gdk_colormap_get_system(), &color);
          gdk_gc_set_foreground(gc, &color);
          for (off=0 ; off<5 ; off++)
          {
            gdk_draw_line((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->pixmap,
                          MainTable->style->black_gc,
                          19+off,off, 23,off);
            gdk_draw_line((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->mask,
                          gc, 19+off,off, 23,off);
          }
          g_object_unref(gc);
        } else
        {
          Pixmap = gtk_label_new(tool->ToolTip);
          TD->PixmapInBox[TD->pos] = gtk_label_new(tool->ToolTip);
        }
        gtk_container_add(GTK_CONTAINER(Button), Pixmap);
        gtk_box_pack_start_defaults(GTK_BOX(TD->Box), TD->PixmapInBox[TD->pos]);
        gtk_widget_show(Pixmap);
        gtk_widget_show(TD->PixmapInBox[TD->pos]);
        gtk_widget_hide(TD->PixmapInBox[TD->pos]);
        TD->IDTable[TD->pos] = tool;
        TD->pos++;
      } else
      { /* We have to create the subtable */
        TableDescriptor *TD = TmpList->data;

        TD->Button = gtk_radio_button_new(RadioGroup);
        gtk_container_set_border_width(GTK_CONTAINER(TD->Button), 0);
        RadioGroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(TD->Button));
        gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(TD->Button), FALSE);
        gtk_table_attach(GTK_TABLE(MainTable), TD->Button, pos%TOOLBOX_WIDTH,pos%TOOLBOX_WIDTH+1, pos/TOOLBOX_WIDTH,pos/TOOLBOX_WIDTH+1,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
        gtk_widget_show(TD->Button);
        pos++;
        TD->Box = gtk_hbox_new(TRUE, 0);
        gtk_container_add(GTK_CONTAINER(TD->Button), TD->Box);
        gtk_widget_show(TD->Box);
        TD->PixmapInBox = g_new(GtkWidget *,TD->ToolNumber);
        switch (DynamicToolBoxShape)
        {
          case VERTICAL_TOOLBOX:
            TD->nb_columns = 1;
            TD->nb_rows = TD->ToolNumber;
            break;
          case HORIZONTAL_TOOLBOX:
            TD->nb_columns = TD->ToolNumber;
            TD->nb_rows = 1;
            break;
          case SQUARE_TOOLBOX:
            TD->nb_columns = 1+(int)(sqrt(TD->ToolNumber-1.0));
            TD->nb_rows = (TD->ToolNumber-1) / TD->nb_columns + 1;
            break;
        }
        TD->PopWindow = gtk_window_new(GTK_WINDOW_POPUP);
        gtk_window_set_position(GTK_WINDOW(TD->PopWindow), GTK_WIN_POS_MOUSE);
        gtk_window_set_modal(GTK_WINDOW(TD->PopWindow), TRUE);
        TD->Table = gtk_table_new(TD->nb_rows, TD->nb_columns, TRUE);
        gtk_container_add(GTK_CONTAINER(TD->PopWindow), TD->Table);
        gtk_widget_show(TD->Table);
        gtk_widget_realize(TD->PopWindow);

        if (tool->Icon)
        {
          GdkGC *gc;
          GdkColor color;
          int off;

          PixmapIcon = gdk_pixmap_create_from_xpm_d(MainTable->window,
                                                    &MaskIcon,
                                                    &transparent,
                                                    tool->Icon);
          Pixmap = gtk_pixmap_new(PixmapIcon, MaskIcon);
          PixmapIcon = gdk_pixmap_create_from_xpm_d(MainTable->window,
                                                    &MaskIcon,
                                                    &transparent,
                                                    tool->Icon);
          TD->pos = 0;
          TD->PixmapInBox[TD->pos] = gtk_pixmap_new(PixmapIcon, MaskIcon);
          /* Draw the little black triangle */
          gc = gdk_gc_new((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->mask);
          gdk_color_white(gdk_colormap_get_system(), &color);
          gdk_gc_set_foreground(gc, &color);
          for (off=0 ; off<5 ; off++)
          {
            gdk_draw_line((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->pixmap,
                          MainTable->style->black_gc,
                          19+off,off, 23,off);
            gdk_draw_line((GTK_PIXMAP(TD->PixmapInBox[TD->pos]))->mask,
                          gc, 19+off,off, 23,off);
          }
          g_object_unref(gc);
        } else
        {
          Pixmap = gtk_label_new(tool->ToolTip);
          TD->PixmapInBox[TD->pos] = gtk_label_new(tool->ToolTip);
        }
        gtk_box_pack_start_defaults(GTK_BOX(TD->Box), TD->PixmapInBox[TD->pos]);
        gtk_widget_show(TD->PixmapInBox[TD->pos]);
        TD->Group = NULL;
        Button = gtk_radio_button_new(TD->Group);
        gtk_container_set_border_width(GTK_CONTAINER(Button), 0);
        TD->Group = gtk_radio_button_get_group(GTK_RADIO_BUTTON(Button));
        gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(Button), FALSE);
        gtk_table_attach(GTK_TABLE(TD->Table), Button, 0,1, 0,1,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
        g_object_set_data(G_OBJECT(Button), "user_data", TD);
        gtk_widget_show(Button);
        gtk_container_add(GTK_CONTAINER(Button), Pixmap);
        gtk_widget_show(Pixmap);
        g_signal_connect(G_OBJECT(TD->Button), "clicked",
                         G_CALLBACK(SubToolSelect), NULL);
        g_object_set_data(G_OBJECT(TD->Button), "user_data", tool);
        g_signal_connect(G_OBJECT(TD->Button), "button_press_event",
                         G_CALLBACK(SubToolButton), TD->PopWindow);

        g_signal_connect(G_OBJECT(Button), "clicked",
                         G_CALLBACK(SecondaryToolSelect),
                           (gpointer)0);
        gtk_signal_connect_object_after(GTK_OBJECT(Button), "clicked",
                                        GTK_SIGNAL_FUNC(gtk_widget_hide),
                                        GTK_OBJECT(TD->PopWindow));
        gtk_widget_show(TD->PopWindow);
        gtk_widget_hide(TD->PopWindow);
        TD->IDTable = g_new(GiramTool*, TD->ToolNumber);
        TD->IDTable[0] = tool;
        TD->pos++;
      }
    }
  }

  return MainTable;
}

/****************************************************************************
*  tool_init
*****************************************************************************/
void tool_init(void)
{
  GiramTool *tool;

  tool = giram_tool_select_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_move_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_rotate_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_scale_register();
  all_tools = g_list_append(all_tools, tool);
  
  tool = giram_tool_zoom_register();
  all_tools = g_list_append(all_tools, tool);
  pan_tool = tool = giram_tool_pan_register();
  all_tools = g_list_append(all_tools, tool);

  /* primitive creation tools */
  tool = giram_tool_box_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_cone_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_cylinder_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_disc_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_plane_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_sor_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_sphere_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_superellipsoid_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_torus_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_heightfield_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_quadric_register();
  all_tools = g_list_append(all_tools, tool);
  tool = giram_tool_bicubic_patch_register();
  all_tools = g_list_append(all_tools, tool);
/*  tool = giram_tool_triangle_register();
  all_tools = g_list_append(all_tools, tool); FIXME... */
  tool = giram_tool_csg_register();
  all_tools = g_list_append(all_tools, tool);

  tool = giram_tool_light_source_register();
  all_tools = g_list_append(all_tools, tool);
}

