/* tool_quadric.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "giram.h"
#include "primitives/quadric.h"
#include "utils.h"
#include "csgtree.h"
#include "giramcursor.h"
#include "pixmaps/quadric.xpm"

#include "tool_heightfield.h"

#include "giramintl.h"

/****************************************************************************
*  tool_quadric_response
*****************************************************************************/
static void tool_quadric_reponse(GtkWidget *dialog, gint response, FrameStruct *frame)
{
  GtkEntry *entry;
  gdouble   A, B, C, D, E, F, G, H, I, J;
  GSList   *tmp_list;

  switch (response)
  {
    case GTK_RESPONSE_ACCEPT:
      {
        ObjectStruct *quadric;

        entry = g_object_get_data(G_OBJECT(dialog), "A");
        A = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "B");
        B = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "C");
        C = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "D");
        D = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "E");
        E = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "F");
        F = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "G");
        G = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "H");
        H = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "I");
        I = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "J");
        J = atoi(gtk_entry_get_text(entry));

        quadric = giram_quadric_new(A, B, C, D, E, F, G, H, I, J);
        frame->all_objects = g_slist_append(frame->all_objects, quadric);
        quadric->name = create_uniq_object_name(frame, _("quadric"));
        quadric->frame = frame;

        giram_object_build_triangle_mesh(quadric);
        /* Redraw all view plus CSG Tree */
        for (tmp_list = frame->all_views ;
             tmp_list ;
             tmp_list = tmp_list->next)
        {
          ViewStruct *TmpView = tmp_list->data;

          gtk_widget_queue_draw(TmpView->canvas);
        }
        giram_create_tree_model(frame);
      }
    case GTK_RESPONSE_REJECT:
      gtk_widget_destroy(dialog);
      break;
  }
}

/****************************************************************************
*  tool_quadric_button_press
*****************************************************************************/
static void tool_quadric_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  GtkWidget   *dialog, *label, *entry;
  GtkWidget   *table;
  ViewStruct  *view_data;
  FrameStruct *frame;

  view_data = get_current_view_data();
  frame = view_data->frame;
  
  dialog = gtk_dialog_new_with_buttons("New Quadric", NULL, 0,
                                       GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                                       GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
                                       NULL);
  g_signal_connect(G_OBJECT(dialog), "response",
                   G_CALLBACK(tool_quadric_reponse), frame);
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);

  table = gtk_table_new(4, 6, FALSE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, FALSE, FALSE, 0);
  
  /* <A, B, C> parameter */
  label = gtk_label_new(_("A:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 0,1);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 0,1);
  g_object_set_data(G_OBJECT(dialog), "A", entry);
  label = gtk_label_new(_("B:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 2,3, 0,1);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 3,4, 0,1);
  g_object_set_data(G_OBJECT(dialog), "B", entry);
  label = gtk_label_new(_("C:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 4,5, 0,1);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 5,6, 0,1);
  g_object_set_data(G_OBJECT(dialog), "C", entry);
  
  /* <D, E, F> parameter */
  label = gtk_label_new(_("D:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 1,2);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 1,2);
  g_object_set_data(G_OBJECT(dialog), "D", entry);
  label = gtk_label_new(_("E:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 2,3, 1,2);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 3,4, 1,2);
  g_object_set_data(G_OBJECT(dialog), "E", entry);
  label = gtk_label_new(_("F:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 4,5, 1,2);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 5,6, 1,2);
  g_object_set_data(G_OBJECT(dialog), "F", entry);
  
  /* <G, H, I> parameter */
  label = gtk_label_new(_("G:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 2,3);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 2,3);
  g_object_set_data(G_OBJECT(dialog), "G", entry);
  label = gtk_label_new(_("H:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 2,3, 2,3);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 3,4, 2,3);
  g_object_set_data(G_OBJECT(dialog), "H", entry);
  label = gtk_label_new(_("I:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 4,5, 2,3);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 5,6, 2,3);
  g_object_set_data(G_OBJECT(dialog), "I", entry);
  
  /* J parameter */
  label = gtk_label_new(_("J:"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 3,4);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 3,4);
  g_object_set_data(G_OBJECT(dialog), "J", entry);
  
  gtk_widget_show_all(dialog);
}

/****************************************************************************
*  tool_quadric_cursor_update
*****************************************************************************/
static void tool_quadric_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_quadric_register
*****************************************************************************/
GiramTool *giram_tool_quadric_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New Quadric");
  tool->Icon           = quadric_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_NEW_QUADRIC;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_quadric_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_quadric_cursor_update;

  return tool;
}

