/* tool_options.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Many ideas in this modules are borrowed from gimp/app/tools.c
 * (C) 1995 Spencer Kimball and Peter Mattis
 */
#include "giram.h"
#include "tool_rotate.h"
#include "tool_scale.h"
#include "tool_cone.h"
#include "tool_cylinder.h"
#include "tool_disc.h"
#include "tools.h"

#include "tool_options.h"

#include "giramintl.h"

GtkWidget *ToolOptionsDialog;

/*****************************************************************************
*  ShowToolOptionsDialog
******************************************************************************/
void ShowToolOptionsDialog(void)
{
  if (!GTK_WIDGET_VISIBLE(ToolOptionsDialog))
  {
    gtk_widget_show(ToolOptionsDialog);
  }
  else
  {
    gdk_window_raise(ToolOptionsDialog->window);
  }
}

/*****************************************************************************
*  BuildNoOptions
******************************************************************************/
GtkWidget *BuildNoOptions(GtkWidget *VBox, char *ToolName)
{
  GtkWidget *vbox, *label;
  /*  the main vbox  */
  vbox = gtk_vbox_new (FALSE, 1);
  /*  the main label  */
  label = gtk_label_new(ToolName);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  /*  this tool has no special options  */
  label = gtk_label_new(_("This tool has no options."));
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(VBox), vbox, TRUE, TRUE, 0);
  gtk_widget_show(vbox);

  return vbox;
}

/*****************************************************************************
*  ShowOptionsForTool
******************************************************************************/
void ShowOptionsForTool(GiramTool *tool)
{
  GList     *tmp_list;
  GiramTool *this_tool;

  for (tmp_list = all_tools ; tmp_list ; tmp_list = g_list_next(tmp_list))
  {
    this_tool = tmp_list->data;

    if (tool == this_tool)
      gtk_widget_show(this_tool->option_box);
    else
      gtk_widget_hide(this_tool->option_box);
  }
}

/*****************************************************************************
*  tool_options_response
******************************************************************************/
static void tool_options_response(GtkWidget *dialog)
{
  gtk_widget_hide(dialog);
}

/*****************************************************************************
*  tool_options_delete
******************************************************************************/
static gboolean tool_options_delete(GtkWidget *dialog)
{
  gtk_widget_hide(dialog);

  return TRUE;
}

/*****************************************************************************
*  CreateToolOptionsDialog
******************************************************************************/
void CreateToolOptionsDialog(void)
{
  GtkWidget *VBox;
  GList     *tmp_list;
  GiramTool *tool;

  ToolOptionsDialog = gtk_dialog_new_with_buttons(_("Tool Options"), NULL, 0,
                                                  GTK_STOCK_CLOSE, GTK_RESPONSE_NONE, NULL);
  g_signal_connect(G_OBJECT(ToolOptionsDialog), "response",
                   G_CALLBACK(tool_options_response), NULL);
  g_signal_connect(G_OBJECT(ToolOptionsDialog), "delete_event",
                   G_CALLBACK(tool_options_delete), NULL);
  VBox = gtk_vbox_new(FALSE, 2);
  gtk_container_set_border_width(GTK_CONTAINER(VBox), 2);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(ToolOptionsDialog)->vbox), VBox);
  gtk_widget_show(VBox);

  for (tmp_list = all_tools ; tmp_list ; tmp_list = g_list_next(tmp_list))
  {
    tool = tmp_list->data;
    if (tool->OptionsFunc)
    {
      tool->option_box = tool->OptionsFunc(VBox);
    } else
    {
      tool->option_box = BuildNoOptions(VBox, tool->ToolTip);
    }
  }
}

