/* tool_csg.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "giram.h"
#include "csg.h"
#include "csgtree.h"
#include "snap.h"
#include "utils.h"
#include "giramcursor.h"

#include "pixmaps/csg.xpm"

#include "tool_csg.h"

#include "giramintl.h"

/****************************************************************************
*  tool_csg_button_press
*****************************************************************************/
static void tool_csg_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  ViewStruct  *view_data;
  FrameStruct *frame;
  GSList      *tmp_list;

  view_data = get_current_view_data();

  frame = view_data->frame;

  if (!frame->selection || !frame->selection->next)
  {
    GtkWidget *dialog;

    dialog = gtk_message_dialog_new(NULL, 0, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                                    _("At least 2 objects should be\n"
                                      "selected to do some csg!\n"));
    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
  } else
  {
    GtkWidget         *dialog, *vbox, *hbox, *scr, *view, *radio_merge;
    GtkWidget         *radio_union, *radio_intersection, *radio_difference;
    GtkWidget         *check;
    GtkListStore      *list_store;
    GtkTreeIter        iter;
    GtkCellRenderer   *renderer;
    gint               col_offset;
    GtkTreeViewColumn *column;
    GList             *selection;

    dialog = gtk_dialog_new_with_buttons(_("CSG operation"),
                                         NULL,
                                         GTK_DIALOG_MODAL,
                                         GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                                         GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
                                         NULL);
    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    hbox = gtk_hbox_new(FALSE, 4);
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox);
    gtk_widget_show(hbox);
    
    /* show the selected objects in a list */
    list_store = gtk_list_store_new(1, G_TYPE_STRING);
    for (selection = frame->selection; selection ; selection = g_list_next(selection))
    {
      ObjectStruct  *tmp_object = selection->data;
      gtk_list_store_append(list_store, &iter);
      gtk_list_store_set(list_store, &iter, 0, tmp_object->name, -1);
    }

    scr = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scr),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start_defaults(GTK_BOX(hbox), scr);
    gtk_widget_show(scr);

    /* The view */
    view = gtk_tree_view_new_with_model((GtkTreeModel*)list_store);
    gtk_widget_set_size_request(view, 200, 220);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(view), TRUE);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view), FALSE);
    gtk_container_add(GTK_CONTAINER(scr), view);
    gtk_widget_show(view);
    /* name column */
    renderer = gtk_cell_renderer_text_new ();
    col_offset = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view), -1, "Names", renderer,
                                                             "text", 0, NULL);
    column = gtk_tree_view_get_column(GTK_TREE_VIEW(view), col_offset - 1);
    gtk_tree_view_set_expander_column(GTK_TREE_VIEW(view), column);
    gtk_tree_view_column_set_clickable(GTK_TREE_VIEW_COLUMN(column), TRUE);

    /* different csg choices */
    vbox = gtk_vbox_new(FALSE, 4);
    gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);
    gtk_widget_show(vbox);
    radio_union = gtk_radio_button_new_with_label(NULL, _("Union"));
    gtk_box_pack_start(GTK_BOX(vbox), radio_union, FALSE, FALSE, 0);
    gtk_widget_show(radio_union);
    radio_intersection = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_union),
                                                        _("Intersection"));
    gtk_box_pack_start(GTK_BOX(vbox), radio_intersection, FALSE, FALSE, 0);
    gtk_widget_show(radio_intersection);
    radio_difference = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_intersection),
                                                        _("Difference"));
    gtk_box_pack_start(GTK_BOX(vbox), radio_difference, FALSE, FALSE, 0);
    gtk_widget_show(radio_difference);
    radio_merge = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_difference),
                                                        _("Merge"));
    gtk_box_pack_start(GTK_BOX(vbox), radio_merge, FALSE, FALSE, 0);
    gtk_widget_show(radio_merge);   
  
    /*  a check bo to know if we want to keep  the textures */
    check = gtk_check_button_new_with_label(_("Keep each object's texture"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), check, FALSE, FALSE, 4);
    gtk_widget_show(check);
    if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
    {
      ObjectStruct *csg_object;
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_union)))
        csg_object = giram_csg_new(CSG_UNION);
      else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_intersection)))
        csg_object = giram_csg_new(CSG_INTERSECTION);
      else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio_difference)))
        csg_object = giram_csg_new(CSG_DIFFERENCE);
      else
        csg_object = giram_csg_new(CSG_MERGE);
      for (selection = frame->selection; selection ; selection = g_list_next(selection))
      {
        ObjectStruct  *tmp_object = selection->data;
        
        ((CSGStruct *)csg_object)->all_objects = g_slist_append(((CSGStruct*)csg_object)->all_objects, tmp_object);
        if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check)))
          tmp_object->Texture = NULL; /*  XXX  */
        tmp_object->parent = csg_object;
        frame->all_objects = g_slist_remove(frame->all_objects, tmp_object);
      }
      frame->all_objects = g_slist_append(frame->all_objects, csg_object);
      csg_object->name = create_uniq_object_name(frame, _("csg"));
      csg_object->frame = frame;
      
      giram_object_build_triangle_mesh(csg_object);
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check)))
        csg_object->Texture = NULL; /* XXX */
      
      /* Destroy the Current Selection */
      g_list_free(frame->selection);
      frame->selection = NULL;

      
      /* Redraw all view plus CSG Tree */
      for (tmp_list = frame->all_views ;
           tmp_list ;
           tmp_list = tmp_list->next)
      {
        ViewStruct *TmpView = tmp_list->data;
        gtk_widget_queue_draw(TmpView->canvas);
      }
      giram_create_tree_model(frame);
      
    }
    gtk_widget_destroy(dialog);
  }
}

/****************************************************************************
*  tool_csg_cursor_update
*****************************************************************************/
static void tool_csg_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_light_source_register
*****************************************************************************/
GiramTool *giram_tool_csg_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New CSG");
  tool->Icon           = csg_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_NEW_CSG;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_csg_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_csg_cursor_update;

  return tool;
}

