/* tool_bicubic_patch.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "giram.h"
#include "primitives/bicubic_patch.h"
#include "utils.h"
#include "csgtree.h"
#include "giramcursor.h"
#include "pixmaps/bicubic_patch.xpm"

#include "tool_bicubic_patch.h"

#include "giramintl.h"

/****************************************************************************
*  tool_bicubic_patch_response
*****************************************************************************/
static void tool_bicubic_patch_reponse(GtkWidget *dialog, gint response, FrameStruct *frame)
{
  GtkEntry *entry;
  Vector    control_points[16];
  gint      u_steps, v_steps;
  gint      i;
  GSList   *tmp_list;

  switch (response)
  {
    case GTK_RESPONSE_ACCEPT:
      {
        ObjectStruct *bicubic_patch;

        entry = g_object_get_data(G_OBJECT(dialog), "u_steps");
        u_steps = atoi(gtk_entry_get_text(entry));
        entry = g_object_get_data(G_OBJECT(dialog), "v_steps");
        v_steps = atoi(gtk_entry_get_text(entry));
        for (i=0 ; i<16  ; i++)
        {
          gchar *tmp;

          tmp = g_strdup_printf("point%dx", i);
          entry = g_object_get_data(G_OBJECT(dialog), tmp);
          g_free(tmp);
          control_points[i][0] = atof(gtk_entry_get_text(entry));
          tmp = g_strdup_printf("point%dy", i);
          entry = g_object_get_data(G_OBJECT(dialog), tmp);
          g_free(tmp);
          control_points[i][1] = atof(gtk_entry_get_text(entry));
          tmp = g_strdup_printf("point%dz", i);
          entry = g_object_get_data(G_OBJECT(dialog), tmp);
          g_free(tmp);
          control_points[i][2] = atof(gtk_entry_get_text(entry));
        }

        bicubic_patch = giram_bicubic_patch_new(u_steps, v_steps, control_points);
        frame->all_objects = g_slist_append(frame->all_objects, bicubic_patch);
        bicubic_patch->name = create_uniq_object_name(frame, _("bicubic_patch"));
        bicubic_patch->frame = frame;

        giram_object_build_triangle_mesh(bicubic_patch);
        /* Redraw all view plus CSG Tree */
        for (tmp_list = frame->all_views ;
             tmp_list ;
             tmp_list = tmp_list->next)
        {
          ViewStruct *TmpView = tmp_list->data;

          gtk_widget_queue_draw(TmpView->canvas);
        }
        giram_create_tree_model(frame);
      }
    case GTK_RESPONSE_REJECT:
      gtk_widget_destroy(dialog);
      break;
  }
}

/****************************************************************************
*  tool_bicubic_patch_button_press
*****************************************************************************/
static void tool_bicubic_patch_button_press(GtkWidget *DrawingArea, GdkEventButton *bevent)
{
  GtkWidget   *dialog, *label, *entry;
  GtkWidget   *table;
  ViewStruct  *view_data;
  FrameStruct *frame;
  gint         i;

  view_data = get_current_view_data();
  frame = view_data->frame;
  
  dialog = gtk_dialog_new_with_buttons("New Bicubic Patch", NULL, 0,
                                       GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                                       GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
                                       NULL);
  g_signal_connect(G_OBJECT(dialog), "response",
                   G_CALLBACK(tool_bicubic_patch_reponse), frame);
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);


  table = gtk_table_new(18, 4, FALSE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, FALSE, FALSE, 0);
  
  /* u and v parameters */
  label = gtk_label_new(_("u_steps"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 0,1);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 0,1);
  g_object_set_data(G_OBJECT(dialog), "u_steps", entry);

  label = gtk_label_new(_("v_steps"));
  gtk_table_attach_defaults(GTK_TABLE(table), label, 2,3, 0,1);
  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 3,4, 0,1);
  g_object_set_data(G_OBJECT(dialog), "v_steps", entry);

  /* x,y,z labels */
  gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("x")), 1,2, 1,2);
  gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("y")), 2,3, 1,2);
  gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("z")), 3,4, 1,2);

  for (i=0 ; i<16 ; i++)
  {
    gchar *tmp;
    tmp = g_strdup_printf(_("point %d"), i+1);
    label = gtk_label_new(tmp);
    g_free(tmp);
    gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 2+i, 3+i);

    entry = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(table), entry, 1,2, 2+i, 3+i);
    tmp = g_strdup_printf("point%dx", i);
    g_object_set_data(G_OBJECT(dialog), tmp, entry);
    g_free(tmp);

    entry = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(table), entry, 2,3, 2+i, 3+i);
    tmp = g_strdup_printf("point%dy", i);
    g_object_set_data(G_OBJECT(dialog), tmp, entry);
    g_free(tmp);

    entry = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(table), entry, 3,4, 2+i, 3+i);
    tmp = g_strdup_printf("point%dz", i);
    g_object_set_data(G_OBJECT(dialog), tmp, entry);
    g_free(tmp);
  }
  gtk_widget_show_all(dialog);
}

/****************************************************************************
*  tool_bicubic_patch_cursor_update
*****************************************************************************/
static void tool_bicubic_patch_cursor_update(GtkWidget *canvas, guint state)
{
  GdkCursor *cursor;

  cursor = giram_cursor_new(GIRAM_MOUSE_CURSOR,
                            GIRAM_TOOL_CURSOR_NONE,
                            GIRAM_CURSOR_MODIFIER_NONE);
  gdk_window_set_cursor(canvas->window, cursor);
  gdk_cursor_unref(cursor);
}

/****************************************************************************
*  giram_tool_bicubic_patch_register
*****************************************************************************/
GiramTool *giram_tool_bicubic_patch_register(void)
{
  GiramTool *tool;

  tool = g_new(GiramTool, 1);
  tool->ToolTip        = _("New Bicubic Patch");
  tool->Icon           = bicubic_patch_icon;
  tool->Path           = "<ToolBar>";
  tool->ID             = MT_NEW_BICUBIC_PATCH;
  tool->OptionsFunc    = NULL;
  tool->button_press   = tool_bicubic_patch_button_press;
  tool->motion         = NULL;
  tool->button_release = NULL;
  tool->cursor_update  = tool_bicubic_patch_cursor_update;

  return tool;
}

