/* superellipsoid.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include "giram.h"
#include "superellipsoid.h"
#include "trimesh.h"
#include "csgtree.h"

#include "giramintl.h"

static void giram_superellipsoid_build_triangle_mesh(ObjectStruct *object);
static gboolean giram_superellipsoid_inside(ObjectStruct *object, double x, double y, double z);
static gboolean giram_superellipsoid_find_intersection_segment(ObjectStruct *object,
                                                               Vector in_point, Vector out_point,
                                                               Vector inter_point, Vector inter_norm);

/*****************************************************************************
*  SuperEllipsoidMeshNormal FIXME
******************************************************************************/
static void SuperEllipsoidMeshNormal(Vector Result, ObjectStruct *SuperEllipsoid,
                                     Vector Inter)
{ /* FIXME */
  Result[0] = 0.0;
  Result[1] = 0.0;
  Result[2] = 0.0;
}

/*****************************************************************************
*  ComputeSuperEllipsoidTriangleMesh
******************************************************************************/
static void giram_superellipsoid_build_triangle_mesh(ObjectStruct *SuperEllipsoid)
{ /* XXX: clipped_by */
  Vector                P1, P2, P3, P4;
  Vector                N1, N2, N3, N4;
  int                   i, j;
  gint                  detail_level;
  SuperEllipsoidStruct *SSuperEllipsoid = (SuperEllipsoidStruct *)SuperEllipsoid;
  double                t1, s1, c1, t2, s2, c2;

  detail_level = SuperEllipsoid->detail_level;

  if (SuperEllipsoid->FirstTriangle)
    DestroyObjectTriangleMesh(SuperEllipsoid);
  /* First the North Pole */
  V3Deq(P1, 0.0, 0.0, 1.0);
  SuperEllipsoidMeshNormal(N1, SuperEllipsoid, P1);
  if (SuperEllipsoid->Trans)
  {
    MEvaluatePoint(P1, SuperEllipsoid->Trans, P1);
    MEvaluateVector(N1, SuperEllipsoid->Trans, N1);
  }
  for (i=0; i<detail_level; i++)
  { /* The "DetailLevel" triangles adjacents to the pole */
    t1 = M_PI / detail_level;
    if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
    else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
    if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
    else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
    t2 = i * 2.0 * M_PI / detail_level;
    if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
    else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
    if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
    else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
    V3Deq(P2, s1*c2, s1*s2, c1);
    SuperEllipsoidMeshNormal(N2, SuperEllipsoid, P2);
    if (SuperEllipsoid->Trans)
    {
      MEvaluatePoint(P2, SuperEllipsoid->Trans, P2);
      MEvaluateVector(N2, SuperEllipsoid->Trans, N2);
    }
    t2 = (i+1) * 2.0 * M_PI / detail_level;
    if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
    else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
    if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
    else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
    V3Deq(P3, s1*c2, s1*s2, c1);
    SuperEllipsoidMeshNormal(N3, SuperEllipsoid, P3);
    if (SuperEllipsoid->Trans)
    {
      MEvaluatePoint(P3, SuperEllipsoid->Trans, P3);
      MEvaluateVector(N3, SuperEllipsoid->Trans, N3);
    }
    AddTriangleToObjectMesh(SuperEllipsoid, P1,P2,P3, N1,N2,N3);
  }
  /* Then the Mid Zone */
  for (i=1 ; i<detail_level-1 ; i++)
  {
    for (j=0 ; j<detail_level ; j++)
    {
      t1 = i * M_PI / detail_level;
      if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
      else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
      if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
      else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
      t2 = j * 2.0 * M_PI / detail_level;
      if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
      else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
      if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
      else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
      V3Deq(P1, s1*c2, s1*s2, c1);
      SuperEllipsoidMeshNormal(N1, SuperEllipsoid, P1);
      if (SuperEllipsoid->Trans)
      {
        MEvaluatePoint(P1, SuperEllipsoid->Trans, P1);
        MEvaluateVector(N1, SuperEllipsoid->Trans, N1);
      }
      t1 = (i+1) * M_PI / detail_level;
      if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
      else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
      if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
      else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
      t2 = j * 2.0 * M_PI / detail_level;
      if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
      else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
      if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
      else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
      V3Deq(P2, s1*c2, s1*s2, c1);
      SuperEllipsoidMeshNormal(N2, SuperEllipsoid, P2);
      if (SuperEllipsoid->Trans)
      {
        MEvaluatePoint(P2, SuperEllipsoid->Trans, P2);
        MEvaluateVector(N2, SuperEllipsoid->Trans, N2);
      }
      t1 = i * M_PI / detail_level;
      if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
      else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
      if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
      else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
      t2 = (j+1) * 2.0 * M_PI / detail_level;
      if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
      else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
      if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
      else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
      V3Deq(P3, s1*c2, s1*s2, c1);
      SuperEllipsoidMeshNormal(N3, SuperEllipsoid, P3);
      if (SuperEllipsoid->Trans)
      {
        MEvaluatePoint(P3, SuperEllipsoid->Trans, P3);
        MEvaluateVector(N3, SuperEllipsoid->Trans, N3);
      }
      t1 = (i+1) * M_PI / detail_level;
      if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
      else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
      if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
      else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
      t2 = (j+1) * 2.0 * M_PI / detail_level;
      if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
      else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
      if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
      else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
      V3Deq(P4, s1*c2, s1*s2, c1);
      SuperEllipsoidMeshNormal(N4, SuperEllipsoid, P4);
      if (SuperEllipsoid->Trans)
      {
        MEvaluatePoint(P4, SuperEllipsoid->Trans, P4);
        MEvaluateVector(N4, SuperEllipsoid->Trans, N4);
      }
      AddTriangleToObjectMesh(SuperEllipsoid, P1,P2,P4, N1,N2,N4);
      AddTriangleToObjectMesh(SuperEllipsoid, P1,P3,P4, N1,N3,N4);
    }
  }
  /* And the South Pole */
  V3Deq(P1, 0.0, 0.0, -1.0);
  SuperEllipsoidMeshNormal(N1, SuperEllipsoid, P1);
  if (SuperEllipsoid->Trans)
  {
    MEvaluatePoint(P1, SuperEllipsoid->Trans, P1);
    MEvaluateVector(N1, SuperEllipsoid->Trans, N1);
  }
  for (i=0 ; i<detail_level ; i++)
  { /* The "DetailLevel" triangles adjacents to the south pole */
    t1 = M_PI - M_PI / detail_level;
    if (sin(t1) >= 0.0) s1 =  pow( sin(t1), SSuperEllipsoid->N);
    else                s1 = -pow(-sin(t1), SSuperEllipsoid->N);
    if (cos(t1) >= 0.0) c1 =  pow( cos(t1), SSuperEllipsoid->N);
    else                c1 = -pow(-cos(t1), SSuperEllipsoid->N);
    t2 = i * 2.0 * M_PI / detail_level;
    if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
    else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
    if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
    else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
    V3Deq(P2, s1*c2, s1*s2, c1);
    SuperEllipsoidMeshNormal(N2, SuperEllipsoid, P2);
    if (SuperEllipsoid->Trans)
    {
      MEvaluatePoint(P2, SuperEllipsoid->Trans, P2);
      MEvaluateVector(N2, SuperEllipsoid->Trans, N2);
    }
    t2 = (i+1) * 2.0 * M_PI / detail_level;
    if (sin(t2) >= 0.0) s2 =  pow( sin(t2), SSuperEllipsoid->E);
    else                s2 = -pow(-sin(t2), SSuperEllipsoid->E);
    if (cos(t2) >= 0.0) c2 =  pow( cos(t2), SSuperEllipsoid->E);
    else                c2 = -pow(-cos(t2), SSuperEllipsoid->E);
    V3Deq(P3, s1*c2, s1*s2, c1);
    SuperEllipsoidMeshNormal(N3, SuperEllipsoid, P3);
    if (SuperEllipsoid->Trans)
    {
      MEvaluatePoint(P3, SuperEllipsoid->Trans, P3);
      MEvaluateVector(N3, SuperEllipsoid->Trans, N3);
    }
    AddTriangleToObjectMesh(SuperEllipsoid, P1,P2,P3, N1,N2,N3);
  }
}

/*****************************************************************************
*  giram_superellipsoid_inside
******************************************************************************/
static gboolean giram_superellipsoid_inside(ObjectStruct *object, double x, double y, double z)
{
  Vector Vect;

  V3Deq(Vect, x, y, z);
  if (object->Trans)
  {
    MInverseEvaluatePoint(Vect, object->Trans, Vect);
  }
  return FALSE; /* FIXME */
}

/*****************************************************************************
*  giram_superellipsoid_find_intersection_segment
******************************************************************************/
static gboolean giram_superellipsoid_find_intersection_segment(ObjectStruct *object,
                                                               Vector in_point, Vector out_point,
                                                               Vector inter_point, Vector inter_norm)
{
  return FALSE; /* FIXME */
}

/*****************************************************************************
*  giram_superellipsoid_new
******************************************************************************/
ObjectStruct *giram_superellipsoid_new(double N, double E)
{
  ObjectStruct            *SuperEllipsoid;
  SuperEllipsoidStruct    *SSuperEllipsoid;
  static GiramObjectClass *superellipsoid_klass = NULL;

  if (superellipsoid_klass == NULL)
  {
    superellipsoid_klass = giram_object_class_new();

    superellipsoid_klass->name                      = _("SuperEllipsoid");
    superellipsoid_klass->build_triangle_mesh       = giram_superellipsoid_build_triangle_mesh;
    superellipsoid_klass->inside                    = giram_superellipsoid_inside;
    superellipsoid_klass->find_intersection_segment = giram_superellipsoid_find_intersection_segment;
  }
  SSuperEllipsoid = g_new(SuperEllipsoidStruct, 1);
  SuperEllipsoid = (ObjectStruct *)SSuperEllipsoid;
  InitObject(SuperEllipsoid);
  SuperEllipsoid->Type = SUPERELLIPSOID_OBJECT;
  SuperEllipsoid->klass = superellipsoid_klass;
  SuperEllipsoid->detail_level = 16;
  SSuperEllipsoid->E = E;
  SSuperEllipsoid->N = N;
  return SuperEllipsoid;
}

/*****************************************************************************
*  PDBCreateSuperEllipsoid
******************************************************************************/
/*int PDBCreateSuperEllipsoid(int *Id, double *N, double *E)
{
  ObjectStruct *SuperEllipsoid;
  FrameStruct  *LocalFrame;
  GSList       *tmp_list;
  ViewStruct    *TmpView;

  SuperEllipsoid = giram_superellipsoid_new(*N, *E);

  LocalFrame = NULL;
  for (tmp_list = all_frames ; tmp_list ; tmp_list = g_slist_next(tmp_list) )
  {
    LocalFrame = tmp_list->data;
    if (LocalFrame->Id == *Id)
      break;
  }
  if (LocalFrame == NULL)
  {
    g_message(_("PDBCreateSuperEllipsoid() called with an unknown Id (%d)\n"), *Id);
    return 0;
  }
  LocalFrame->all_objects = g_slist_append(LocalFrame->all_objects, SuperEllipsoid);
  giram_object_build_triangle_mesh(SuperEllipsoid);
  for (tmp_list = LocalFrame->all_views ;
       tmp_list ;
       tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->drawing_area);
  }
  RebuildCSGTree(NULL, LocalFrame);
  return SuperEllipsoid->Id;
}*/

