/* mesh.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __GIRAM_MESH_H__
#define __GIRAM_MESH_H__

#include "object.h"

typedef struct MeshStruct
{
  ObjectStruct Object;

  struct TriangleListStruct *FirstTriangle;
} MeshStruct;

ObjectStruct *giram_mesh_new(void);
void giram_mesh_add_triangle(ObjectStruct *Mesh, Vector P1, Vector P2, Vector P3);
void giram_mesh_add_smooth_triangle(ObjectStruct *Mesh,
                                    Vector P1, Vector P2, Vector P3,
                                    Vector N1, Vector N2, Vector N3);

#endif /* __GIRAM_MESH_H__ */
