/* plugins.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2000 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <dirent.h>
#include "giram.h"
#include "giramlib/constplugins.h"
#include "object.h"
#include "primitives/box.h"
#include "primitives/cone.h"
#include "primitives/disc.h"
#include "primitives/cylinder.h"
#include "primitives/plane.h"
#include "primitives/sphere.h"
#include "primitives/superellipsoid.h"
#include "primitives/torus.h"
#include "primitives/triangle.h"

#include "giramintl.h"

#if 0
typedef int (*PDBFunc)(gpointer, ...);

typedef struct PDBStruct
{
  char *FuncName;
  PDBFunc Func;
  int NumberOfArguments;
  int TypeOfArg[10];
} PDBStruct;

PDBStruct PDB[] =
{
  { "CreateBox", (PDBFunc)PDBCreateBox, 3, { FRAMEID_TYPE, VECTOR3_TYPE, VECTOR3_TYPE } },
  { "CreateCone", (PDBFunc)PDBCreateCone, 5, { FRAMEID_TYPE, VECTOR3_TYPE, DOUBLE_TYPE, VECTOR3_TYPE, DOUBLE_TYPE } },
  { "CreateCylinder", (PDBFunc)PDBCreateCylinder, 4, { FRAMEID_TYPE, VECTOR3_TYPE, VECTOR3_TYPE, DOUBLE_TYPE } },
  { "CreateDisc", (PDBFunc)PDBCreateDisc, 5, { FRAMEID_TYPE, VECTOR3_TYPE, VECTOR3_TYPE, DOUBLE_TYPE, DOUBLE_TYPE } },
  { "CreatePlane", (PDBFunc)PDBCreatePlane, 3, { FRAMEID_TYPE, VECTOR3_TYPE, DOUBLE_TYPE } },
  { "CreateSphere", (PDBFunc)PDBCreateSphere, 3, { FRAMEID_TYPE, VECTOR3_TYPE, DOUBLE_TYPE } },
  { "CreateSuperEllipsoid", (PDBFunc)PDBCreateSuperEllipsoid, 3, { FRAMEID_TYPE, DOUBLE_TYPE, DOUBLE_TYPE } },
  { "CreateTorus", (PDBFunc)PDBCreateTorus, 3, { FRAMEID_TYPE, DOUBLE_TYPE, DOUBLE_TYPE } },
  { "CreateTriangle", (PDBFunc)PDBCreateTriangle, 4, { FRAMEID_TYPE, VECTOR3_TYPE, VECTOR3_TYPE, VECTOR3_TYPE } },
  { "TransformObject", (PDBFunc)PDBTransformObject, 3, { FRAMEID_TYPE, OBJECTID_TYPE, TRANSFORM_TYPE } },
};

typedef struct PluginsStruct
{
  char *PrgName;
  char *MenuName;
  struct PluginsStruct *Next;
} PluginsStruct;

typedef struct PluginsMenuEntryStruct
{
  GtkWidget *View;
  char *Name;
} PluginsMenuEntryStruct;

PluginsStruct *FirstPlugins = NULL;

/*****************************************************************************
*  FindFunctionIndexInPDB XXX: should use hashing
******************************************************************************/
static int FindFunctionIndexInPDB(char *FuncName)
{
  guint i;

  for (i=0; i<sizeof(PDB)/sizeof(PDB[0]) ; i++)
  {
    if (!strcmp(PDB[i].FuncName, FuncName))
      return (int)i;
  }
  return -1;
}

/*****************************************************************************
*  ProcessPluginsOutput
******************************************************************************/
static void ProcessPluginsOutput(int pipein, int pipeout)
{
  int type, a;

  do
  {
    a = read(pipein, &type, sizeof(int));
    if (a != sizeof(int))
      printf("Pipe Error\n");
    switch (type)
    {
      case FUNC_TYPE:
        {
          int size, i, j, ArgType;
          char *FuncName;

          a = read(pipein, &size, sizeof(int));
          if (a != sizeof(int))
            printf("Pipe Error 1\n");
          FuncName = g_malloc(size+1);
          a = read(pipein, FuncName, size);
          if (a != size)
            printf("Pipe Error 2\n");
          FuncName[size] = 0;
          i = FindFunctionIndexInPDB(FuncName);
          if (i!=-1)
          {
            void *Arg[10];
            for (j=0 ; j<PDB[i].NumberOfArguments ; j++)
            {
              switch (PDB[i].TypeOfArg[j])
              {
                case FRAMEID_TYPE:
                  Arg[j] = g_malloc(sizeof(int));
                  a = read(pipein, &ArgType, sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 3\n");
                  if (ArgType != FRAMEID_TYPE)
                    printf("A FRAMEID_TYPE was expected here\n");
                  a = read(pipein, Arg[j], sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 4\n");
                  break;
                case OBJECTID_TYPE:
                  Arg[j] = g_malloc(sizeof(int));
                  a = read(pipein, &ArgType, sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 3\n");
                  if (ArgType != OBJECTID_TYPE)
                    printf("An OBJECTID_TYPE was expected here\n");
                  a = read(pipein, Arg[j], sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 4\n");
                  break;
                case DOUBLE_TYPE:
                  Arg[j] = g_malloc(sizeof(double));
                  a = read(pipein, &ArgType, sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 5\n");
                  if (ArgType != DOUBLE_TYPE)
                    printf("A DOUBLE_TYPE was expected here\n");
                  a = read(pipein, Arg[j], sizeof(double));
                  if (a != sizeof(double))
                    printf("Pipe Error 6\n");
                  break;
                case VECTOR3_TYPE:
                  Arg[j] = g_malloc(5*sizeof(double));
                  a = read(pipein, &ArgType, sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error 7\n");
                  if (ArgType != VECTOR3_TYPE)
                    printf("A VECTOR3_TYPE was expected here\n");
                  a = read(pipein, (double *)Arg[j], sizeof(double));
                  if (a != sizeof(double))
                    printf("Pipe Error 8\n");
                  a = read(pipein, ((double *)Arg[j])+1, sizeof(double));
                  if (a != sizeof(double))
                    printf("Pipe Error 9\n");
                  a = read(pipein, ((double *)Arg[j])+2, sizeof(double));
                  if (a != sizeof(double))
                    printf("Pipe Error 10\n");
                  break;
                case TRANSFORM_TYPE:
                  Arg[j] = g_malloc(sizeof(TransformStruct));
                  a = read(pipein, &ArgType, sizeof(int));
                  if (a != sizeof(int))
                    printf("Pipe Error %d\n", __LINE__);
                  if (ArgType != TRANSFORM_TYPE)
                    printf("A TRANSFORM_TYPE was expected here\n");
                  {
                    int x, y;
                    for (x=0 ; x<4 ; x++)
                      for (y=0 ; y<4 ; y++)
                      {
                        a = read(pipein, &(((TransformStruct *)(Arg[j]))->Direct[x][y]), sizeof(double));
                      }
                    for (x=0 ; x<4 ; x++)
                      for (y=0 ; y<4 ; y++)
                      {
                        a = read(pipein, &(((TransformStruct *)(Arg[j]))->Inverse[x][y]), sizeof(double));
                      }
                  }
                  break;
              }
            }
            a = (*(PDB[i].Func))(Arg[0], Arg[1], Arg[2], Arg[3], Arg[4],
                Arg[5], Arg[6], Arg[7], Arg[8], Arg[9]);
            for (j=0 ; j<PDB[i].NumberOfArguments ; j++)
              g_free(Arg[j]);
            write(pipeout, &a, sizeof(int));
          }
        }
        break;
    }
  } while (type != ENDPLUGINS_TYPE);
}

/*****************************************************************************
*  DeadPipe
******************************************************************************/
void DeadPipe(int Dum)
{
/*  printf("Boken pipe :{\n");*/
}

/*****************************************************************************
*  CallPlugInsInit
******************************************************************************/
static char *CallPlugInsInit(char *PlugInsName)
{
  char *Argv[10];
  int GiramToPlugins[2], PluginsToGiram[2];
  int ChildNumber;
  char *MenuName = NULL;

  signal(SIGPIPE, DeadPipe);
  Argv[0] = g_malloc(strlen(PLUGINS_DIR)+strlen(PlugInsName)+1);
  strcpy(Argv[0], PLUGINS_DIR);
  strcat(Argv[0], PlugInsName);
  Argv[1] = "-giram";
  Argv[2] = "-init";
  pipe(GiramToPlugins);
  pipe(PluginsToGiram);
  Argv[3] = g_strdup_printf("%d", PluginsToGiram[1]);
  Argv[4] = g_strdup_printf("%d", GiramToPlugins[0]);
  Argv[5] = "-1";
  Argv[6] = NULL;

  ChildNumber = fork();
  if (ChildNumber > 0)
  { /* We are in the father process, the one which continue with Giram */
    int size, a;
    int Type;
    char *Ack;

    close(PluginsToGiram[1]);
    close(GiramToPlugins[0]);

    fcntl(GiramToPlugins[1],F_SETFL,O_NONBLOCK);
    /* Set the close-on-exec flag */
    fcntl(PluginsToGiram[0], F_SETFD, 1);
    fcntl(GiramToPlugins[1], F_SETFD, 1);
    read(PluginsToGiram[0], &size, sizeof(int));
    Ack = g_malloc(size+1);
    read(PluginsToGiram[0], Ack, size);
    Ack[size] = 0;
    read(PluginsToGiram[0], &Type, sizeof(int));
    read(PluginsToGiram[0], &a, sizeof(int));
    MenuName = g_malloc(a+1);
    read(PluginsToGiram[0], MenuName, a);
    MenuName[a] = 0;
    a = ENDPLUGINS_TYPE;
    write(GiramToPlugins[1], &a, sizeof(int));
    close(PluginsToGiram[0]); /* This should kill the plugins...
                                 but it only make it a zombie */
    close(GiramToPlugins[1]);
    wait(NULL);
  } else
  {
    /* We are in the child process, the one which execute the plug-ins */
    close(GiramToPlugins[1]);
    close(PluginsToGiram[0]);
    execvp(Argv[0], Argv);
/*   something wierd happened... */
    close(PluginsToGiram[1]);
    close(GiramToPlugins[0]);
    exit(1);
  }
  return MenuName;
}

/*****************************************************************************
*  NewPlugins
******************************************************************************/
static PluginsStruct *NewPlugins(void)
{
  PluginsStruct *TmpPI;

  TmpPI = g_malloc(sizeof(PluginsStruct));
  TmpPI->Next = FirstPlugins;
  FirstPlugins = TmpPI;
  return TmpPI;
}

/*****************************************************************************
*  InitPlugins
******************************************************************************/
void InitPlugins(void)
{
  DIR *DirHandle;
  struct dirent *DirEntry;
  char *MenuEntryName;
  PluginsStruct *TmpPlugIns;

/*  printf("Plug ins directory: \"%s\"\n", PLUGINS_DIR);*/
  DirHandle = opendir(PLUGINS_DIR);
  if (DirHandle)
  {
    do
    {
      DirEntry = readdir(DirHandle);
      if (DirEntry && (DirEntry->d_name[0]!='.'))
      {
/*        printf("plugins found: %s\n", DirEntry->d_name);*/
/* FIXME: doesn't work        if (access(DirEntry->d_name, X_OK) == 0)
        {*/
          MenuEntryName = CallPlugInsInit(DirEntry->d_name);
/*          printf("\"%s\" want to be called \"%s\"\n", DirEntry->d_name, MenuEntryName);*/
          if (MenuEntryName)
          {
            TmpPlugIns = NewPlugins();
            TmpPlugIns->PrgName = g_strdup(DirEntry->d_name);
            TmpPlugIns->MenuName = MenuEntryName;
          }
      /*  }*/
      }
    } while (DirEntry);
    closedir(DirHandle);
  }
}

/*****************************************************************************
*  CallPlugIns
******************************************************************************/
void CallPlugIns(GtkWidget *MenuItem, PluginsMenuEntryStruct *Data)
{
  char *Argv[10];
  int GiramToPlugins[2], PluginsToGiram[2];
  int ChildNumber;
  ViewStruct *view_data;

  view_data = g_object_get_data(G_OBJECT(Data->View), "ViewData");
  signal(SIGPIPE, DeadPipe);
  Argv[0] = g_strconcat(PLUGINS_DIR, Data->Name, NULL);
  Argv[1] = "-giram";
  Argv[2] = "dummy";
  pipe(GiramToPlugins);
  pipe(PluginsToGiram);
  Argv[3] = g_strdup_printf("%d", PluginsToGiram[1]);
  Argv[4] = g_strdup_printf("%d", GiramToPlugins[0]);
  Argv[5] = g_strdup_printf("%d", view_data->frame->Id);
  Argv[6] = NULL;

  ChildNumber = fork();
  if (ChildNumber > 0)
  { /* We are in the father process, the one which continue with Giram */
    int size, a;
    char *Ack;

    close(PluginsToGiram[1]);
    close(GiramToPlugins[0]);

    fcntl(GiramToPlugins[1],F_SETFL,O_NONBLOCK);
    /* Set the close-on-exec flag */
    fcntl(PluginsToGiram[0], F_SETFD, 1);
    fcntl(GiramToPlugins[1], F_SETFD, 1);
    read(PluginsToGiram[0], &size, sizeof(int));
    Ack = g_malloc(size+1);
    read(PluginsToGiram[0], Ack, size);
    Ack[size] = 0;
    ProcessPluginsOutput(PluginsToGiram[0], GiramToPlugins[1]);
    a = ENDPLUGINS_TYPE;
    write(GiramToPlugins[1], &a, sizeof(int));
    close(PluginsToGiram[0]); /* This should kill the plugins...
                                 but it only make it a zombie */
    close(GiramToPlugins[1]);
    wait(NULL);
  } else
  {
    /* We are in th child process, the one which execute the plug-ins */
    close(GiramToPlugins[1]);
    close(PluginsToGiram[0]);
    execvp(Argv[0], Argv);
/*   something wierd happened... */
    close(PluginsToGiram[1]);
    close(GiramToPlugins[0]);
    exit(1);
  }
}

/*****************************************************************************
*  CreatePlugInsMenu
*  Create the Plug-ins sub menu
******************************************************************************/
GtkWidget *CreatePlugInsMenu(GtkWidget *DrawingArea)
{
  GtkWidget              *SubMenu;
  GtkWidget              *menu_items;
  GtkWidget              *PluginsMenu;
  PluginsStruct          *Tmp;
  PluginsMenuEntryStruct *Data;

  /* The "Plugins" SubMenu */
  /* Create the SubMenu */
  SubMenu = gtk_menu_new();
  for (Tmp = FirstPlugins ; Tmp ; Tmp=Tmp->Next)
  {
    menu_items = gtk_menu_item_new_with_label(Tmp->MenuName);
/*    printf("Menu entry added : %s\n", Tmp->MenuName);*/
    gtk_menu_append(GTK_MENU(SubMenu), menu_items);
    Data = g_malloc(sizeof(PluginsMenuEntryStruct));
    Data->View = DrawingArea;
    Data->Name = Tmp->PrgName;
    gtk_signal_connect(GTK_OBJECT(menu_items), "activate",
                       GTK_SIGNAL_FUNC(CallPlugIns),
                       Data);
    gtk_widget_show(menu_items);
  }
  PluginsMenu = gtk_menu_item_new_with_label(_("Plugins"));
  gtk_widget_show(PluginsMenu);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(PluginsMenu), SubMenu);
  return PluginsMenu;
}
#endif
