/* pigment.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include "giram.h"

#include "color_map.h"

/*************************************************************************
*  giram_pigment_evaluate
**************************************************************************/
void giram_pigment_evaluate(Vector color, PigmentStruct *pigment, Vector intersect)
{
  int     value;
  gdouble position;

  switch (pigment->Type)
  {
    case PAT_SOLID_COLOR:
      V3Dcopy(color, pigment->Color);
      break;
    case PAT_CHECKER:
      value = (int)(floor(intersect[0]) +
                    floor(intersect[1]) +
                    floor(intersect[2]));

      if (value & 1)
      {
        V3Dcopy(color, pigment->Color2);
      } else
      {
        V3Dcopy(color, pigment->Color);
      }
      break;

    case PAT_ONION:
      position = fmod(sqrt(intersect[0]*intersect[0]+
                           intersect[1]*intersect[1]+
                           intersect[2]*intersect[2]), 1.0);
      color_map_evaluate(pigment->color_map, position, color);
      break;

    case PAT_LEOPARD:
      position = sin(intersect[0])+sin(intersect[1])+sin(intersect[2]);
      position = (position/3.0)*(position/3.0);
      color_map_evaluate(pigment->color_map, position, color);
      break;

    default:
      V3Dcopy(color, pigment->Color);
      break;
  }
}
