/* object.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __OBJECT_H__
#define __OBJECT_H__


typedef struct _ObjectStruct ObjectStruct;
typedef struct _GiramObjectClass GiramObjectClass;

#include  "transformation.h"

/* THE structure defining an object */
struct _ObjectStruct
{
  guint               Type;          /* The shape */
  GiramObjectClass   *klass;
  guint               refcount;
  gchar              *name;
  TriangleListStruct *FirstTriangle; /* The first triangle of the list */
  TransformStruct    *Trans;         /* The transformation matrix */
  TextureStruct      *Texture;
  gboolean            Inverse;       /* Is the object inverted ? (CSG) */
  gboolean            NoShadow;
  gboolean            Hollow;
  gboolean            selected;      /* Is the object currently selected? */
  gboolean            visible;       /* Is the object currently visible? */
  gint                detail_level;  /* NCU: should be used to let the user choose how
                                        detailed is the mesh representation of the objects.
                                        This also could be used for the object->mesh converter. */
  ObjectStruct       *bound;
  ObjectStruct       *clip;
  ObjectStruct       *parent;
  guint               Id;
  struct FrameStruct *frame;
  GSList             *all_transforms;
};

struct _GiramObjectClass
{
  gchar      *name;
  void     (* build_triangle_mesh)       (ObjectStruct *object);
  gboolean (* inside)                    (ObjectStruct *object,
                                          double x,
                                          double y,
                                          double z);
  gboolean (* is_intersection)           (ObjectStruct *object,
                                          Vector origin,
                                          Vector direction);
  gboolean (* click_in_XY)               (ObjectStruct *object,
                                          double x,
                                          double y);
  gboolean (* click_in_XZ)               (ObjectStruct *object,
                                          double x,
                                          double z);
  gboolean (* click_in_ZY)               (ObjectStruct *object,
                                          double z,
                                          double y);
  gboolean (* find_intersection_segment) (ObjectStruct *object,
                                          Vector in_point,
                                          Vector out_point,
                                          Vector inter_point,
                                          Vector inter_norm);
  gboolean (* find_intersection)         (ObjectStruct *object,
                                          Vector origin,
                                          Vector direction,
                                          Vector intersection,
                                          Vector normal);
};

void InitObject(ObjectStruct *Object);
void giram_object_translate(ObjectStruct *object, Vector vect);
void giram_object_rotate(ObjectStruct *object, Vector vect);
void giram_object_scale(ObjectStruct *object, Vector vect);
void giram_object_build_triangle_mesh(ObjectStruct *object);
gboolean giram_object_inside(ObjectStruct *object, double x, double y, double z);
gboolean giram_object_is_intersection(ObjectStruct *object, Vector origin, Vector direction);
gboolean giram_object_click_in_XY(ObjectStruct *object, double x, double y);
gboolean giram_object_click_in_XZ(ObjectStruct *object, double x, double z);
gboolean giram_object_click_in_ZY(ObjectStruct *object, double z, double y);
gboolean giram_object_find_intersection_segment(ObjectStruct *object,
                                                Vector in_point, Vector out_point,
                                                Vector inter_point, Vector inter_norm);
gboolean giram_object_find_intersection(ObjectStruct *object,
                                        Vector origin,
                                        Vector direction,
                                        Vector intersection,
                                        Vector normal);
int PDBTransformObject(int *FrameId, guint *ObjectId, TransformStruct *Trans);
GiramObjectClass *giram_object_class_new(void);

void giram_object_destroy(ObjectStruct *Object);

#endif /* __OBJECT_H__ */
