/* giramobjecteditor.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_OBJECT_EDITOR_H__
#define __GIRAM_OBJECT_EDITOR_H__

#include <gtk/gtk.h>
#include "giram.h"
#include "object.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GIRAM_TYPE_OBJECT_EDITOR            (giram_object_editor_get_type())
#define GIRAM_OBJECT_EDITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GIRAM_TYPE_OBJECT_EDITOR, GiramObjectEditor))
#define GIRAM_OBJECT_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GIRAM_TYPE_OBJECT_EDITOR, GiramObjectEditorClass))
#define GIRAM_IS_OBJECT_EDITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GIRAM_TYPE_OBJECT_EDITOR))
#define GIRAM_IS_OBJECT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GIRAM_TYPE_OBJECT_EDITOR))
#define GIRAM_OBJECT_EDITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIRAM_TYPE_OBJECT_EDITOR, GiramObjectEditorClass))

typedef struct _GiramObjectEditor       GiramObjectEditor;
typedef struct _GiramObjectEditorClass  GiramObjectEditorClass;

struct _GiramObjectEditor
{
  GtkNotebook   notebook;

  /* common */
  GtkWidget    *texture_editor;

  /* bicubic_patch fields */
  GtkWidget    *bicubic_patch_u_steps;
  GtkWidget    *bicubic_patch_v_steps;
  GtkWidget    *bicubic_patch_control_points[16][3];

  /* sphere fields */
  GtkWidget    *sphere_center;
  GtkWidget    *sphere_radius;

  /* box fields */
  GtkWidget    *box_min_x;
  GtkWidget    *box_min_y;
  GtkWidget    *box_min_z;
  GtkWidget    *box_max_x;
  GtkWidget    *box_max_y;
  GtkWidget    *box_max_z;

  /* torus fields */
  GtkWidget    *torus_major;
  GtkWidget    *torus_minor;

  /* plane fields */
  GtkWidget    *plane_normal_x;
  GtkWidget    *plane_normal_y;
  GtkWidget    *plane_normal_z;
  GtkWidget    *plane_distance;

  /* height_field fields */
  GtkWidget    *heightfield_filename;
  GtkWidget    *heightfield_gif;
  GtkWidget    *heightfield_tga;
  GtkWidget    *heightfield_pot;
  GtkWidget    *heightfield_png;
  GtkWidget    *heightfield_pgm;
  GtkWidget    *heightfield_ppm;
  GtkWidget    *heightfield_sys;
  GtkWidget    *heightfield_waterlevel;
  GtkWidget    *heightfield_smooth;

  /* quadric fields */
  GtkWidget    *quadric_a;
  GtkWidget    *quadric_b;
  GtkWidget    *quadric_c;
  GtkWidget    *quadric_d;
  GtkWidget    *quadric_e;
  GtkWidget    *quadric_f;
  GtkWidget    *quadric_g;
  GtkWidget    *quadric_h;
  GtkWidget    *quadric_i;
  GtkWidget    *quadric_j;

  /* background fields */
  GtkWidget    *background_color_button;

  /* lightsource fields  */
  GtkWidget    *lightsource_color_button;
  GtkWidget    *lightsource_pos_x;
  GtkWidget    *lightsource_pos_y;
  GtkWidget    *lightsource_pos_z;

  /* transformation fields */
  GtkWidget    *transformation_label;
  GtkWidget    *transformation_x;
  GtkWidget    *transformation_y;
  GtkWidget    *transformation_z;

  ObjectStruct *object;
  gdouble      *background_color;
  LightSourceStruct  *light;
  TransformationStruct *transformation;
  gint          type;  /*  object,  light, transform,  background, etc. */
};

struct _GiramObjectEditorClass
{
  GtkNotebookClass parent_class;
};


GType      giram_object_editor_get_type(void);
GtkWidget *giram_object_editor_new(ObjectStruct *object);
void       giram_object_editor_set_object(GiramObjectEditor *goe,
                                          ObjectStruct      *object);
void       giram_object_editor_set_background(GiramObjectEditor *goe,
                                              gdouble           *color);
void       giram_object_editor_set_lightsource(GiramObjectEditor *goe,
                                               LightSourceStruct *light);
void       giram_object_editor_set_transformation(GiramObjectEditor    *goe,
                                                  TransformationStruct *transformation);
void       giram_object_editor_update(GiramObjectEditor *goe);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GIRAM_OBJECT_EDITOR_H__ */
