/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramintl.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAMINTL_H__
#define __GIRAMINTL_H__

#include <glib.h>
#include <locale.h>

/* Copied from gnome-i18n.h by Tom Tromey <tromey@creche.cygnus.com>
 * Heavily modified by Daniel Egger <Daniel.Egger@t-online.de>
 * So be sure to hit me instead of him if something is wrong here
 */

#define LOCALEDIR "/usr/local/share/locale"

#ifndef LOCALEDIR
#define LOCALEDIR g_strconcat(giram_data_directory(), \
                              G_DIR_SEPARATOR_S, \
                              "locale", \
                              NULL)
#endif

#ifdef ENABLE_NLS
#    include <libintl.h>
#    define _(String) gettext(String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop(String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

#define INIT_LOCALE( domain )   G_STMT_START{   \
                                  gtk_set_locale ();                      \
                                  setlocale (LC_NUMERIC, "C");            \
                                  bindtextdomain (domain, LOCALEDIR);     \
                                  textdomain (domain);                    \
                                }G_STMT_END

#endif /* __GIRAMINTL_H__ */

