/* frame.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "giram.h"
#include "camera.h"
#include "frame.h"

/*****************************************************************************
*  NewFrame
******************************************************************************/
FrameStruct *NewFrame(char *Name)
{
  GSList       *tmp_list;
  FrameStruct  *frame;
  CameraStruct *Camera;
  int           Id;

  Id = 0;
  for (tmp_list = all_frames ; tmp_list ; tmp_list = g_slist_next(tmp_list))
  {
    frame = tmp_list->data;
    if (frame->Id >= Id)
      Id = frame->Id+1;
  }
  frame = g_new(FrameStruct, 1);
  all_frames = g_slist_append(all_frames, frame);
  if (Name)
    frame->file_name = g_strdup(Name);
  else
    frame->file_name = NULL;
  frame->Id = Id;
  frame->all_cameras = NULL;
  Camera = g_new(CameraStruct, 1);
  InitCamera(Camera);
  ComputeCamera(Camera);
  frame->all_cameras = g_list_append(frame->all_cameras, Camera);
  frame->all_objects = NULL;
  frame->all_light_sources = NULL;
  frame->SkySphere = NULL;

  frame->all_constants[0] = g_hash_table_new(g_str_hash, g_str_equal);

  frame->all_views = NULL;
  frame->selection = NULL;
  V3Deq(frame->RotationCenter, 0.0, 0.0, 0.0);
  V3Deq(frame->ScaleCenter, 0.0, 0.0, 0.0);
  frame->SnapToGrid = FALSE;
  frame->ShowGrid = FALSE;
  V3Deq(frame->SnapGrid, 1.0, 1.0, 1.0);
  V3Deq(frame->background_color, 0.0, 0.0, 0.0);
  return frame;
}

