/* gts.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/*#include <stdio.h>
#include <errno.h>
#include <stdlib.h>*/
#include <string.h>
/*#include <math.h>*/

#include "giram.h"
#include "giramrc.h"
/*#include "object.h"*/
#include "csgtree.h"
#include "view.h"
#include "camera.h"
#include "camera_view.h"
#include "frame.h"
#include "primitives/mesh.h"
#include "widgets/giramviewshell.h"

#include "giramintl.h"

static int giram_parse_gts(char *file_name, FrameStruct *frame);

/*
 * Parse the GTS file
 */

typedef struct gts_line_struct
{
  gint p1, p2;
} gts_line_struct;

typedef struct gts_face_struct
{
  gint l1, l2, l3;
} gts_face_struct;

static int giram_parse_gts(char *file_name, FrameStruct *frame)
{
  ObjectStruct    *TmpMesh;
  FILE            *file;
  gint             points, lines, faces;
  gint             i;
  Vector          *all_points;
  gts_line_struct *all_lines;
  gts_face_struct *all_faces;

  file = fopen(file_name, "r");
  if (!file)
  {
    fprintf (stderr, "***ERROR***\nLoading file %s failed\n", file_name);
    return -1;
  }

  /* first, get the number of points, lines and faces */
  fscanf(file, "%d %d %d", &points, &lines, &faces);
  g_print("points: %d, lines: %d, faces: %d\n", points, lines, faces);

  /* then all points... */
  all_points = g_new(Vector, points+1);
  for (i = 1 ; i <= points ; i++)
  {
    fscanf(file, "%lg %lg %lg", &(all_points[i][0]),
                             &(all_points[i][1]),
                             &(all_points[i][2]) );
  }
  /* then all lines... */
  all_lines = g_new(gts_line_struct, lines+1);
  for (i = 1 ; i <= lines ; i++)
  {
    fscanf(file, "%d %d", &(all_lines[i].p1), &(all_lines[i].p2) );
  }
  /* then all faces... */
  TmpMesh = giram_mesh_new();
  all_faces = g_new(gts_face_struct, faces+1);
  for (i = 1 ; i <= faces ; i++)
  {
    gint index1, index2, index3;
    fscanf(file, "%d %d %d", &(all_faces[i].l1),
                             &(all_faces[i].l2),
                             &(all_faces[i].l3) );
    index1 = all_lines[all_faces[i].l1].p1;
    index2 = all_lines[all_faces[i].l1].p2;
    index3 = all_lines[all_faces[i].l2].p1;
    if (index3 == index1 || index3 == index2)
      index3 = all_lines[all_faces[i].l2].p2;
    giram_mesh_add_triangle(TmpMesh,
                            all_points[index1],
                            all_points[index2],
                            all_points[index3] );
  }
  frame->all_objects = g_slist_append(frame->all_objects, TmpMesh);
  g_free(all_faces); g_free(all_lines); g_free(all_points);

  fclose(file);

  g_slist_foreach(frame->all_objects,
                  (GFunc)giram_object_build_triangle_mesh,
                  NULL);
  return 0;
}

/*****************************************************************************
*  giram_load_gts
******************************************************************************/
void giram_load_gts(GtkWidget *w, GtkFileSelection *FS)
{
  char         *Name;
  FrameStruct  *TmpFrame;
  GtkWidget    *shell;
  ViewStruct   *view_data;

  Name = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(FS)));
  if(!strlen(Name) || Name == NULL)
    return;

  if(Name == NULL)
    return;

  TmpFrame = NewFrame(Name);

  if (giram_parse_gts(Name, TmpFrame) != 0)
  {
    /* Error the frame must be destroyed */
    /* FIXME: DestroyFrame(TmpFrame); */
    return;
  }

  giram_create_tree_model(TmpFrame);
  /* the created views should be chosen from the 'Preferences' */
  if (show_xy_view)
  {
    shell = giram_view_shell_new();
    gtk_window_set_default_size(GTK_WINDOW(shell), 512, 384);
    view_data = giram_view_new(TmpFrame, ORTHO_XY_CAMERA);
    giram_view_shell_add_view(GIRAM_VIEW_SHELL(shell), view_data);
    gtk_box_pack_start_defaults(GTK_BOX(GIRAM_VIEW_SHELL(shell)->vbox),
                                view_data->disp_vbox);
    gtk_widget_show(shell);
    FitToSceneFunc();
  }
  if (show_xz_view)
  {
    shell = giram_view_shell_new();
    gtk_window_set_default_size(GTK_WINDOW(shell), 512, 384);
    view_data = giram_view_new(TmpFrame, ORTHO_XZ_CAMERA);
    giram_view_shell_add_view(GIRAM_VIEW_SHELL(shell), view_data);
    gtk_box_pack_start_defaults(GTK_BOX(GIRAM_VIEW_SHELL(shell)->vbox),
                                view_data->disp_vbox);
    gtk_widget_show(shell);
    FitToSceneFunc();
  }
  if (show_zy_view)
  {
    shell = giram_view_shell_new();
    gtk_window_set_default_size(GTK_WINDOW(shell), 512, 384);
    view_data = giram_view_new(TmpFrame, ORTHO_ZY_CAMERA);
    giram_view_shell_add_view(GIRAM_VIEW_SHELL(shell), view_data);
    gtk_box_pack_start_defaults(GTK_BOX(GIRAM_VIEW_SHELL(shell)->vbox),
                                view_data->disp_vbox);
    gtk_widget_show(shell);
    FitToSceneFunc();
  }
  if (show_camera_view)
  {
    /* FIXME: shell  */
    camera_view_new(TmpFrame);
  }
}

/*****************************************************************************
*  giram_import_gts
******************************************************************************/
void giram_insert_gts(GtkWidget *w, GtkFileSelection *FS)
{
  gchar        *filename;
  FrameStruct  *TmpFrame;
  GSList       *tmp_list;
  ViewStruct   *TmpView;
  CameraStruct *Camera;

  filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(FS)));
  if (!filename || strlen(filename)==0)
    return;

  TmpFrame = g_object_get_data(G_OBJECT(FS), "frame");

  /* Save frame camera */
  Camera = TmpFrame->all_cameras->data;

  if (giram_parse_gts(filename, TmpFrame) != 0)
    return;

  /* destroy the camera loaded from the file */
  g_free(TmpFrame->all_cameras->data);
  /* Restore the frame camera */
  TmpFrame->all_cameras->data = Camera;

  for (tmp_list = TmpFrame->all_views ; tmp_list ; tmp_list = tmp_list->next)
  {
    TmpView = tmp_list->data;
    gtk_widget_queue_draw(TmpView->canvas);
  }
  giram_create_tree_model(TmpFrame);
}
