/* Giram: a simple 3D modeller
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <signal.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gtk/gtk.h>

/*#include "apptypes.h"*/

#include "appenv.h"
/*#include "app_procs.h"*/
#include "errorconsole.h"
#include "errors.h"
#include "giramui.h"

extern gchar *prog_name;

StackTraceMode stack_trace_mode = STACK_TRACE_QUERY;

void giram_message_func(const gchar    *log_domain,
                        GLogLevelFlags  log_level,
                        const gchar    *message,
                        gpointer        data)
{
  if (console_messages == FALSE)
  {
    switch (message_handler)
    {
      case MESSAGE_BOX:
        giram_message_box((gchar *)message, NULL, NULL);
        break;

      case ERROR_CONSOLE:
        error_console_add((gchar *)message);
        break;

      default:
        g_printerr("%s: %s\n", prog_name, (gchar *)message);

        break;
    }
  } else
  {
    g_printerr("%s: %s\n", prog_name, (gchar *)message);
  }
}

void giram_fatal_error(gchar *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  g_printerr("%s: fatal error: %s\n", prog_name, g_strdup_vprintf(fmt, args));
  va_end(args);

  switch (stack_trace_mode)
  {
    case STACK_TRACE_NEVER:
      break;

    case STACK_TRACE_QUERY:
      {
        sigset_t sigset;

        sigemptyset(&sigset);
        sigprocmask(SIG_SETMASK, &sigset, NULL);
        g_on_error_query(prog_name);
      }
      break;

    case STACK_TRACE_ALWAYS:
      {
        sigset_t sigset;

        sigemptyset(&sigset);
        sigprocmask(SIG_SETMASK, &sigset, NULL);
        g_on_error_stack_trace(prog_name);
      }
      break;

    default:
      break;
  }

/*  app_exit (TRUE); FIXME */
  exit(0);
}

void giram_terminate(gchar *fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  g_printerr("%s terminated: %s\n", prog_name, g_strdup_vprintf(fmt, args));
  va_end(args);

  if (use_debug_handler)
  {
    sigset_t sigset;

    sigemptyset(&sigset);
    sigprocmask(SIG_SETMASK, &sigset, NULL);
    g_on_error_query(prog_name);
  }

  gdk_exit(1);
}

