/* povfront.h
 * povfront - A GPLed Front-end for POVray raytracer
 * Copyright (C) 1999 Philippe DAVID <clovis1@club-internet.fr>
 * Copyright (C) 2001 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __POVFRONT_H__
#define __POVFRONT_H__

/****************************************************************
 * Name : 		povfront.h
 * Author : Philippe DAVID
 * update (MM/DD/YY) : 9/10/1999
 * Comments : global variables are beginning with the letter g_
 *            local variables are begining with the letter l_
 *            parameter in function are begining with the letter p_
 ****************************************************************/

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif

#include <limits.h>     /* ARG_MAX  */
#include <unistd.h>     /* execvp  */
#include <sys/types.h>  /* waitpid  */
#include <sys/wait.h>
#include <signal.h>     /* For kill function  */
#include <sys/stat.h>   /* For mkdir function  */
#include <errno.h>
#include <time.h>

/*** i18n things  */
#ifdef ENABLE_NLS
#include <libintl.h>
#include <locale.h>
#ifndef USE_GNOME
#define _(String) gettext(String)
#endif
#ifdef gettext_noop
#define N_(String) gettext_noop(String)
#else
#define N_(String) (String)
#endif
#else /* NLS is disabled  */
#ifndef USE_GNOME
#define _(String) (String)
#define N_(String) (String)
#define textdomain(String) (String)
#define gettext(String) (String)
#define dgettext(Domain,String) (String)
#define dcgettext(Domain,String,Type) (String)
#define bindtextdomain(Domain,Directory) (Domain)
#endif
#endif

#ifndef USE_GNOME
#include "subset.xpm"  /* A Little image for the output page  */
#endif


/*** Global Settings  */
GtkWidget *g_main_window;            /* Main window  */
GtkWidget *g_configure_window;       /* Configure window widget  */
GtkWidget *g_a_propos_window;        /* About... window  */
GtkWidget *g_control_window;         /* Control job window  */
GtkWidget *g_entry_pov_file;         /* Input POV file  */
GtkWidget *g_entry_inifile;          /* Output ini file  */
GtkWidget *g_entry_outfile;          /* Image file name  */
GtkWidget *g_entry_outgrep;          /* Grep of image  */

#ifdef USE_GNOME
GtkWidget *g_canvas = NULL;
GnomeCanvasItem* g_canvas_item_rectangle;
gfloat g_canvas_width = 90.0;
gfloat g_canvas_height = 45.0;
#endif

/* Library page widget  */
GtkWidget *g_entry_library [10];     /* Library path  */
GtkWidget *g_entry_library_version;   /* Version of the POV engine  */

GtkWidget *g_entry_xsize1;             /* Custom _Size X1 of the output image  */
GtkWidget *g_entry_ysize1;             /* Custom _size Y1 of the output image  */
GtkWidget *g_entry_xsize2;             /* Custom size X2 of the output image  */
GtkWidget *g_entry_ysize2;             /* Custom size Y2 of the output image  */
gfloat     g_substartx_value;
gfloat     g_subendx_value;
gfloat     g_substarty_value;
gfloat     g_subendy_value;
GtkObject *g_adjust_5;
GtkObject *g_adjust_6;
GtkObject *g_adjust_7;
GtkObject *g_adjust_8;
GtkWidget *g_entry_out_preview1;        /* Preview flag of image  */
GtkWidget *g_entry_out_preview2;        /* Preview flag of image  */
GtkWidget *g_entry_histo_file;          /* Histogram file name  */
GtkWidget *g_entry_history_xsize;         /* Histogram grid X size  */
GtkWidget *g_entry_history_ysize;         /* Histogram grid Y size  */
GtkWidget *g_entry_anim_clock;          /* value for clock in case of external animation loop  */
GtkWidget *g_entry_anim_frame_ini;       /* Initial frame for internal animation  */
GtkWidget *g_entry_anim_frame_fin;       /* Final frame for internal animation  */
GtkWidget *g_entry_anim_clock_ini;       /* Initial clock for internal animation  */
GtkWidget *g_entry_anim_clock_fin;       /* Final clock for internal animation  */
GtkWidget *g_entry_anim_subset_ini;      /* Initial frame for subset internal animation  */
GtkWidget *g_entry_anim_subset_fin;      /* Final frame for subset internal animation  */
GtkWidget *g_entry_pre_scene;
GtkWidget *g_entry_pre_frame;
GtkWidget *g_entry_post_scene;
GtkWidget *g_entry_post_frame;
GtkWidget *g_entry_user_abort;
GtkWidget *g_entry_fatal_error;
GtkWidget *g_entry_debug_stream;        /* Output messages stream to console or file  */
GtkWidget *g_entry_fatal_stream;        /* Output messages stream to console or file  */
GtkWidget *g_entry_render_stream;       /* Output messages stream to console or file  */
GtkWidget *g_entry_stat_stream;         /* Output messages stream to console or file  */
GtkWidget *g_entry_warning_stream;      /* Output messages stream to console or file  */
GtkWidget *g_entry_all_stream;          /* Output messages stream to console or file  */
GtkWidget *g_entry_command;             /* Command to invoque to run the rendering  */
GtkWidget *g_entry_altcommand;          /* Alternate command to invoque to run the rendering  */
GtkWidget *g_combo_histo_type;          /* Combo for the file type of histogram file  */
GtkWidget *g_combo_out_file;            /* Combo for the file type of the image  */
GtkWidget *g_check_antialiasing;        /* Antialiasing option  */
GtkWidget *g_check_pov_file;            /* Enable parsing of pov file  */
GtkWidget *g_check_sub;                 /* Enable sub rendering options  */
GtkWidget *g_check_out_preview;         /* Enable preview options  */
GtkWidget *g_check_out1;               /* Test abort  */
GtkWidget *g_check_out2;               /* Continue flag  */
GtkWidget *g_check_out3;               /* Pause flag  */
GtkWidget *g_check_out4;               /* Verbose flag  */
GtkWidget *g_check_out5;               /* Draw vista flag  */
GtkWidget *g_check_out6;               /* Display image flag  */
GtkWidget *g_check_out7;               /* Alpha out flag  */
GtkWidget *g_check_inifile;
GtkWidget *g_check_quality1;
GtkWidget *g_check_quality2;
GtkWidget *g_check_quality3;
GtkWidget *g_check_quality4;
GtkWidget *g_check_quality5;
GtkWidget *g_check_quality6;
GtkWidget *g_check_jitter;
GtkWidget *g_check_refresh;
GtkWidget *g_check_histo_file;
GtkWidget *g_check_anim_cyclic;
GtkWidget *g_check_anim_field;
GtkWidget *g_check_anim_odd;
GtkWidget *g_check_debug_stream;
GtkWidget *g_check_fatal_stream;
GtkWidget *g_check_render_stream;
GtkWidget *g_check_stat_stream;
GtkWidget *g_check_warning_stream;
GtkWidget *g_check_all_stream;
GtkObject *g_adjust_threshold;
GtkObject *g_adjust_gamma;
GtkObject *g_adjust_depth;
GtkObject *g_adjust_jitter;
GtkObject *g_adjust_refresh;
GtkObject *g_adjust_quality;
GtkObject *g_adjust_bounding_threshold;
GtkWidget *g_radio_aa1;
GtkWidget *g_radio_aa2;
GtkWidget *g_radio_out_size [10]; /* The radio buttons for the image output size  */
GtkWidget *g_radio_out_color1;
GtkWidget *g_radio_out_color2;
GtkWidget *g_radio_out_color3;
GtkWidget *g_radio_out_file1;
GtkWidget *g_radio_out_file2;
GtkWidget *g_radio_out_file3;
GtkWidget *g_plugin_title;        /* Label in case of plugin the header  */
GtkWidget *g_plugin_subtitle;
GtkTooltips *g_tooltips;

/* global variable for the PVM page of the notebook  */
GtkWidget *g_check_pvm;           /* Enable or not the pvm options (usepvm)  */
gint       g_pvm = 0;
GtkObject *g_adjust_pvm_num;      /* Number of task to perform (pvmnbrtasks)  */
GtkWidget *g_entry_pvm_num;       /*  */
GtkWidget *g_entry_pvm_cmd;       /* Command to use by the slaves (pvmcmd)  */
GtkWidget *g_entry_pvm_dir;       /* Directory to be used by the slaves  (pvmdir)*/
GtkObject *g_adjust_pvm_height;   /* Height of the block to be rendered on the network (pvmheight)  */
GtkWidget *g_entry_pvm_height;
GtkObject *g_adjust_pvm_width;    /* Width of the block to be rendered on the network (pvmwidth)  */
GtkWidget *g_entry_pvm_width;
GtkWidget *g_gtklist_hosts;       /* List of the hosts (pvmhosts)  */
GtkObject *g_adjust_pvm_nice;     /* Nice option for PVM (pvmnice)  */
gfloat     g_pvm_nice_value;
char      **g_pf_environ;         /* Environment variables for execve  */

gint g_input_pov_file = 0;        /* Tell if the ommand take a povfile as input  */
gint g_output_inifile = 0;        /* Tell if povray must provide a ini file  */
gint g_test_abort = 1;            /* Test abort while rendering  */
gint g_continue = 0;              /* Retrieve last begining of rendering  */
gint g_pause = 1;                 /* Test pause while rendering  */
gint g_verbose = 0;               /* Verbose rendering  */
gint g_draw_vista = 0;            /* Draw vista  */
gint g_display_image = 1;         /* Display image while rendering  */
gint g_alpha_out = 0;             /* Output alpha channel  */
gint g_sub_render = 0;            /* Subrendering of the image  */
gint g_preview = 0;               /* preview flag  */
gint g_radiosity = 0;             /* Radiosity flag  */
gint g_bounding_box = 0;          /* Bounding box flag  */
gfloat g_bounding_threshold_value = 25; /* Bounding threshold */
gint g_light_buffer = 0;          /* Light buffer flag  */
gint g_vista_buffer = 0;          /* Vista buffer flag  */
gint g_remove_bounding = 0;       /* Remove bounds flag  */
gint g_split = 0;	          /* Split Union flag  */
gint g_antialiasing = 0;	  /* Antialiasing flag  */
gint g_output_histo_file = 0;     /* Outpout Histogram file flag  */
gint g_debug_stream = 0;          /* Output messages stream to console or file  */
gint g_fatal_stream = 0;          /* Output messages stream to console or file  */
gint g_render_stream = 0;         /* Output messages stream to console or file  */
gint g_stat_stream = 0;           /* Output messages stream to console or file  */
gint g_warning_stream = 0;        /* Output messages stream to console or file  */
gint g_all_stream = 0;            /* Output messages stream to console or file  */
gint g_jitter = 1;                /* Flag = 1 if jittering  */
gint g_refresh = 1;               /* Flag = 1 for auto refresh  */
gint g_field_render = 0;          /* Flag for field rendering in animation  */
gint g_odd_field = 0;             /* Flag for entrelace rendering in animation  */
gint g_cyclic = 0;                /* Flag for cyclic animation  */
gint g_save_settings_exit = 0;     /* Save settings as default when exit  */
gint g_save_settings_exit_local = 0;     /* Save settings as default when exit  */
gint g_beep;                      /* Beep when a job is finished  */
gint g_beep_local;                /* Beep when a job is finished  */
gint g_show_tooltips = 1;         /* Show tooltips options  */
gint g_show_tooltips_local = 1;         /* Show tooltips options  */
gint g_test_overwrite = 1;        /* Test Overwrite of iage output  */
gint g_test_overwrite_local = 1;        /* Test Overwrite of iage output  */

gchar g_entry_save_path[256];     /* Current pah for saving configuration file  */
gchar g_entry_load_path[256];     /* Current pah for sloading configuration file  */
gchar g_entry_pov_version[10];    /* Version of povray engine  */
gchar g_image_size [20];          /* The povray parameters for the image size  */
gchar g_aa_methode [2];           /* AntiAliasing methode: 1 or 2  */
gint  g_size_type;                /* The number of the size radio button activated  */
gchar g_palette [2];              /* Code for palette color  */
gint  g_out_file_mode;            /* Code for _output file mode  */
gchar g_command_to_invoque[50];   /* Command to invoque povray  */
gchar g_alt_command_to_invoque[50];/* Alternate command to invoque povray  */
gint  g_invoque_command_number;   /* Number of the command to invoque (radio button number)  */
gint  g_local_invoque_command_number; /* The same but before apply  */
gfloat g_quality_value;           /* Quality level for rendering  */
gfloat g_jitter_value = 1.0;      /* Value for the jittering  */
gfloat g_refresh_value = 1.0;     /* Value for the jittering  */
gfloat g_quality_depth;           /* Depth of the antialiasing  */
gfloat g_quality_threshold;       /* Threshold of the Antialising  */
gfloat g_quality_gamma;           /* Display Gamma  */
char g_pov_file[256];             /* pov file in the command line  */
gint g_plugin = 0;                /* Set to 1 if the pov file name is on the command line  */
gchar g_home_directory[256];      /* Home directory of the user  */
gchar g_default_config_file[256]; /* File of the default configguration with the path  */
gchar *g_config_file_to_parse=NULL;
gchar *g_image_file_to_compute=NULL;   /* Image File to produce when called as a plugin  */
gchar *g_pov_file_to_parse=NULL;       /* in plugin mode, pos source file to parse  */
gchar *g_redirect_command_to_use=NULL; /* In plugin mode, redirect command to use  */
pid_t g_pid_last_process;
gint     g_timeout_tag;           /* Time tag for the refresh of the job control  */
GdkColor g_tooltips_background_color;
GdkColor g_tooltips_foreground_color;


/* Pre-defined size for output image. It is OK to change just these values
   and nothing else as all refers to this array (not the length of the array)  */
static gint g_predef_size[8][2] = {{1280, 1024},
				   {1024, 768},
				   {800, 600},
				   {768, 576},
				   {640, 480},
				   {320, 240},
				   {320, 200},
				   {160, 100}};

/* Definition to handle the jobs  */
struct _job {
  pid_t pid;
  gint state;
  gchar *time;
  gchar *file;
  gchar *image;
};

typedef struct _job job;
GList *g_jobs_list;              /* List of jobs used by the job control  */

GtkWidget *g_gtklist_jobs;

typedef enum
{
  POVF_RUNNING,
  POVF_HALTED,
  POVF_ABORTED,
  POVF_FINISHED,
  POVF_ERROR,
  POVF_DONE
}proc_mode;

/*** Function declarations  */

void init_programme (void);
gint delete_event(GtkWidget *p_widget, GdkEvent *p_event, gpointer p_data);
void destroy (GtkWidget *p_widget, gpointer p_data);
gint invoque_command (GtkWidget *p_widget, gchar *p_command_to_invoque);
gint image_size (GtkWidget *p_widget, gchar *p_data);
gint aa_methode (GtkWidget *p_widget, gpointer p_data);
gint apply_options (GtkWidget *p_widget, gpointer p_data);
gint options (GtkWidget *p_widget, gpointer p_data);
gint adjustment_value_changed (GtkAdjustment *p_adjustment, gfloat *p_value);
gint load_config_ok (GtkWidget *p_widget, GtkFileSelection *p_file_selection);
gint load_config (GtkWidget *p_widget, gpointer p_data);
gint read_line (FILE *p_file_handle, gchar *p_line);
gint load_config_file (gchar *p_file);
gint write_config_file (gchar *p_selected_file);
gint write_default_config (GtkWidget *p_widget, gpointer *p_data);
gint save_config_ok (GtkWidget *widget, GtkFileSelection *p_file_selection);
gint save_config (GtkWidget *p_widget, gpointer p_data);
gint a_propos (GtkWidget *widget, gpointer p_data);
void povfront_message (gchar *p_data);
void povfront_warning (gchar *p_data);
void povfront_error (gchar *p_data);
void povfront_message_overwrite (gchar *p_data);
gint render (GtkWidget *p_widget, gpointer);
gint render2 (GtkWidget *p_widget, gpointer);
gint pf_abort (GtkWidget *p_widget, gpointer p_data);
gint help (GtkWidget *p_widget, gpointer p_data);
gint refresh (GtkWidget *p_widget, void *p_gtklist);
gint control_on (GtkWidget *p_widget, void *p_data);
gint control_off (GtkWidget *p_widget, void *p_data);
gint refresh_list (GtkWidget *p_gtklist);
void stop_jobs (GtkObject *p_jobs_list);
void continue_jobs (GtkObject *p_jobs_list);
void kill_jobs (GtkWidget *p_widget, void *p_jobs_list);
gint greater_than (gint *p_a, gint *p_b);
void delete_jobs (GtkWidget *p_widget, void *p_jobs_list);
void control (void);
gint switch_option (GtkWidget *p_widget, gint *p_switch);
gint switch_out_file (GtkWidget *p_widget, gchar *p_new_code);
gint switch_palette (GtkWidget *p_widget, gchar *p_new_code);
gint file_selection_ok (GtkWidget *p_widget, GtkFileSelection *p_file_selection);
gint file_selection (GtkWidget *p_widget, gpointer p_entry);
gint file_view (GtkWidget *p_widget, gpointer *p_file_name);
gint povf_parse_options (int argc, char *argv[]);
gint add_pvm_host (GtkObject *p_hosts_list, GtkWidget *p_host_name);
void delete_hosts (GtkObject *p_jobs_list);

#endif /* __POVFRONT_H__ */
