/* Rotate.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2000 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "../../src/giram.h"
#include "../../giramlib/giramlib.h"

/*****************************************************************************
*  RotatePluginOK
******************************************************************************/
gint RotatePluginOK(GtkSpinButton *SpinButton)
{
  int NbRot, i;
  Vector Vect, TransVect, RotateVect;
  int sphere;

  NbRot = gtk_spin_button_get_value_as_int(SpinButton);
  Vect[0] = 0.0; Vect[1] = 0.0; Vect[2] = 0.0;
  TransVect[0] = 10.0; TransVect[1] = 0.0; TransVect[2] = 0.0;
  RotateVect[0] = 0.0; RotateVect[1] = 0.0;
  for (i=0 ; i<NbRot ; i++)
  {
    RotateVect[2] = i*360.0 / NbRot;
    sphere = giramlib_sphere_create(Vect, 1.0);
    giramlib_object_translate(sphere, TransVect);
    giramlib_object_rotate(sphere, RotateVect);
  }
  giramlib_object_realize_all();
  return FALSE;
}

int main(int argc, char *argv[])
{
  GtkWidget *Dialog;
  GtkWidget *Button;
  GtkWidget *OutVBox;
  GtkWidget *Frame;
  GtkWidget *Label;
  GtkWidget *VBox;
  GtkWidget *HBox;
  GtkAdjustment *adj;
  GtkWidget *SpinButton;

  giram_init(argc, argv, "<View>/Plug-Ins/Rotate");
 
  argc = 1;
  gtk_init(&argc, &argv);

  /* The dialog Box */
  Dialog = gtk_dialog_new();
  g_signal_connect(G_OBJECT(Dialog), "delete_event",
                   G_CALLBACK(gtk_main_quit), NULL);
  g_signal_connect(G_OBJECT(Dialog), "destroy",
                   G_CALLBACK(gtk_main_quit), NULL);
  
  /* The main Vbox */
  OutVBox = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(Dialog)->vbox), OutVBox);

  Frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(Frame), GTK_SHADOW_OUT);
  gtk_box_pack_start(GTK_BOX(OutVBox), Frame, FALSE, TRUE, 0);

  Label = gtk_label_new("Rotate Plugins");
  gtk_misc_set_alignment(GTK_MISC(Label), 0.0, 0.5);
  gtk_misc_set_padding(GTK_MISC(Label), 2, 1);
  gtk_container_add(GTK_CONTAINER(Frame), Label);

  VBox = gtk_vbox_new(FALSE, 2);
  gtk_container_set_border_width(GTK_CONTAINER(VBox), 4);
  gtk_container_add(GTK_CONTAINER(OutVBox), VBox);

  /* The number of Rotations: */
  /* The Hbox */
  HBox = gtk_hbox_new(FALSE, 2);
  gtk_box_pack_start(GTK_BOX(VBox), HBox, TRUE, TRUE, 0);
  /* The Label */
  Label = gtk_label_new("Number of Rotations:");
  gtk_box_pack_start(GTK_BOX(HBox), Label, TRUE, TRUE, 0);
  /* The Spin Button */
  adj = (GtkAdjustment *)gtk_adjustment_new(5, 2, 60, 1, 5, 0.0);
  SpinButton = gtk_spin_button_new(adj, 1, 0);
  gtk_box_pack_start(GTK_BOX(HBox), SpinButton, TRUE, TRUE, 0);

  /* The action Area */
  /* The "OK" Button */
  Button = gtk_button_new_with_label("Ok");
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(Dialog)->action_area), Button);
  g_signal_connect_swapped(G_OBJECT(Button), "clicked", 
                           G_CALLBACK(RotatePluginOK), SpinButton);
  g_signal_connect_swapped(G_OBJECT(Button), "clicked", 
                           G_CALLBACK(gtk_main_quit), NULL);
  /* The "Cancel" Button */
  Button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(Dialog)->action_area), Button);
  g_signal_connect_swapped(G_OBJECT(Button), "clicked", 
                           G_CALLBACK(gtk_widget_destroy), (gpointer)Dialog);
  gtk_widget_show_all(Dialog);

  gtk_main();

  giram_exit();
  return 0;
}

