/* Box.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999 David Odin <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../../giramlib/giramlib.h"

int main(int argc, char *argv[])
{
  Vector Vect1, Vect2;
  int box;

  giram_init(argc, argv, "<View>/Plug-Ins/Unit Box");
  
  Vect1[0] = -1.0; Vect1[1] = -1.0; Vect1[2] = -1.0;
  Vect2[0] =  1.0; Vect2[1] =  1.0; Vect2[2] =  1.0;
  box = giramlib_box_create(Vect1, Vect2);
  giramlib_object_realize(box);

  giram_exit();
  return 0;
}

