
#include <math.h>

#include <gtk/gtk.h>

#include "src/giram.h"
#include "src/object.h"
#include "src/camera.h"

gchar *module_icon_xpm[] =
{
  "20 20 2 1",
  " 	c None",
  ".	c #000000",
  "       .............",
  "      ..          ..",
  "     . .         . .",
  "    .  .        .  .",
  "   .   .       .   .",
  "  .    .      .    .",
  " .............     .",
  " .     .     .     .",
  " .     .     .     .",
  " .     .     .     .",
  " .     .     .     .",
  " .     .............",
  " .    .      .    . ",
  " .   .       .   .  ",
  " .  .        .  .   ",
  " . .         . .    ",
  " ..          ..     ",
  " .............      ",
  "                    ",
  "                    "
};

gchar *module_name = "The wireframe renderer module";

gint module_type = 1;

/*****************************************************************************
*  persp_3d_to_2d
******************************************************************************/
static void  persp_3d_to_2d(FrameStruct *frame,
                            Vector Point3d,
                            Vector Point2d,
                            int width,
                            int height)
{
  double xd,yd,zd;
  double norme;
  double vd,v0,t;
  double RiX, RiY, RiZ;
  double Ka, Kb;
  double u,v;
  CameraStruct *Camera;

  Camera = frame->all_cameras->data;

  xd = Point3d[0] - Camera->Location[0];
  yd = Point3d[1] - Camera->Location[1];
  zd = Point3d[2] - Camera->Location[2];
  norme = sqrt(xd*xd+yd*yd+zd*zd);
  xd=xd / norme;
  yd=yd / norme;
  zd=zd / norme;
  vd = Camera->A*xd+Camera->B*yd+Camera->C*zd;
  if (fabs(vd)<1e-6) vd = 1e-6;
  v0 = -(Camera->A*Camera->x0+Camera->B*Camera->y0+Camera->C*Camera->z0+
         Camera->D);
  t = v0 / vd;
  RiX = Camera->Location[0]+xd*t;
  RiY = Camera->Location[1]+yd*t;
  RiZ = Camera->Location[2]+zd*t;
  
  if (fabs(Camera->Du2)<=1e-6)
  {
    u=(Camera->Nc[0]*RiX+Camera->Nc[1]*RiY+Camera->Nc[2]*RiZ-Camera->Du0)/
      (Camera->Du1-Camera->Na[0]*RiX-Camera->Na[1]*RiY-Camera->Na[2]*RiZ);
  } else
  {
    Ka = Camera->Dux + (Camera->Qux[0]*RiX+Camera->Qux[1]*RiY+Camera->Qux[2]*RiZ);
    Kb = Camera->Duy + (Camera->Quy[0]*RiX+Camera->Quy[1]*RiY+Camera->Quy[2]*RiZ);
    u = Ka - sqrt(Ka*Ka-Kb);
    if ((u>1.0) || (u<0.0))
      u = Ka + sqrt(Ka*Ka-Kb);
  }
  if (fabs(Camera->Dv2)<=1e-6)
  {
    v=(Camera->Nb[0]*RiX+Camera->Nb[1]*RiY+Camera->Nb[2]*RiZ-Camera->Dv0)/
      (Camera->Dv1-Camera->Na[0]*RiX-Camera->Na[1]*RiY-Camera->Na[2]*RiZ);
  } else
  {
    Ka = Camera->Dvx + (Camera->Qvx[0]*RiX+Camera->Qvx[1]*RiY+Camera->Qvx[2]*RiZ);
    Kb = Camera->Dvy + (Camera->Qvy[0]*RiX+Camera->Qvy[1]*RiY+Camera->Qvy[2]*RiZ);
    v = Ka - sqrt(Ka*Ka-Kb);
    if ((v>1.0) || (v<0.0))
      v = Ka + sqrt(Ka*Ka-Kb);
  }
  Point2d[0]=(u*width);
  Point2d[1]=((1.0-v)*height);
}

/*************************************************************************
*  rendering_func
**************************************************************************/
GdkPixmap *rendering_func(GtkWidget *area, gint width, gint height)
{
  GdkPixmap          *pixmap;
  FrameStruct        *frame;
  GSList             *tmp_list;
  ObjectStruct       *Tmp;
  TriangleListStruct *TmpTri;
  Vector              P1, P2, P3;

  pixmap = gdk_pixmap_new(area->window, width, height, -1);
  gdk_draw_rectangle(pixmap, area->style->black_gc, TRUE,
                     0, 0, width, height);

  frame = g_object_get_data(G_OBJECT(area), "frame");

  for (tmp_list = frame->all_objects ;
       tmp_list ;
       tmp_list = g_slist_next(tmp_list))
  {
    Tmp = tmp_list->data;
    if (Tmp->visible)
    {
      for (TmpTri = Tmp->FirstTriangle ; TmpTri ; TmpTri = TmpTri->Next)
      {
        persp_3d_to_2d(frame, TmpTri->P1, P1, width, height);
        persp_3d_to_2d(frame, TmpTri->P2, P2, width, height);
        persp_3d_to_2d(frame, TmpTri->P3, P3, width, height);
        gdk_draw_line(pixmap, area->style->white_gc, P1[0], P1[1], P2[0], P2[1]);
        gdk_draw_line(pixmap, area->style->white_gc, P2[0], P2[1], P3[0], P3[1]);
        gdk_draw_line(pixmap, area->style->white_gc, P3[0], P3[1], P1[0], P1[1]);
      }
    } /* if (Tmp->Visible) */
  }
  return pixmap;
}


