/* render_povray.c
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2002 DindinX <David@dindinx.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <gtk/gtk.h>

#include "src/giram.h"

#include "src/filetypes/povray/SavePov.h"

gchar *module_icon_xpm[] =
{
  "20 20 184 2",
  "  	c None",
  ". 	c #804080",
  "+ 	c #7B3F7B",
  "@ 	c #77467B",
  "# 	c #554B60",
  "$ 	c #526167",
  "% 	c #833B76",
  "& 	c #80407F",
  "* 	c #354D44",
  "= 	c #26814F",
  "- 	c #803F7E",
  "; 	c #822B56",
  "> 	c #911831",
  ", 	c #A50309",
  "' 	c #B00307",
  ") 	c #A8162B",
  "! 	c #A11E3B",
  "~ 	c #89376E",
  "{ 	c #743F74",
  "] 	c #275039",
  "^ 	c #178D47",
  "/ 	c #6B4F75",
  "( 	c #763F76",
  "_ 	c #7E1223",
  ": 	c #86050B",
  "< 	c #9D0309",
  "[ 	c #A40309",
  "} 	c #B20307",
  "| 	c #BB0306",
  "1 	c #B7070E",
  "2 	c #9F2040",
  "3 	c #623D62",
  "4 	c #165E33",
  "5 	c #168E46",
  "6 	c #367559",
  "7 	c #5A262F",
  "8 	c #7E070D",
  "9 	c #88050B",
  "0 	c #9B0309",
  "a 	c #A60308",
  "b 	c #AF0307",
  "c 	c #B90306",
  "d 	c #9B2244",
  "e 	c #7F407F",
  "f 	c #4A3C4C",
  "g 	c #156033",
  "h 	c #158C48",
  "i 	c #7A447D",
  "j 	c #513749",
  "k 	c #582224",
  "l 	c #740E13",
  "m 	c #8D040A",
  "n 	c #A20309",
  "o 	c #A80308",
  "p 	c #B10307",
  "q 	c #931019",
  "r 	c #7D3C72",
  "s 	c #323F37",
  "t 	c #126332",
  "u 	c #1E8A48",
  "v 	c #04983F",
  "w 	c #645472",
  "x 	c #383838",
  "y 	c #492C2D",
  "z 	c #6A1519",
  "A 	c #82050B",
  "B 	c #87050B",
  "C 	c #94040A",
  "D 	c #A10309",
  "E 	c #AA0308",
  "F 	c #B30307",
  "G 	c #A10B0E",
  "H 	c #4F2E2F",
  "I 	c #6B2229",
  "J 	c #2B4736",
  "K 	c #27864C",
  "L 	c #3E6F5D",
  "M 	c #452F30",
  "N 	c #5B2022",
  "O 	c #6E1217",
  "P 	c #81050B",
  "Q 	c #83050B",
  "R 	c #90040A",
  "S 	c #980C10",
  "T 	c #463231",
  "U 	c #2A4736",
  "V 	c #0F6632",
  "W 	c #29854C",
  "X 	c #0E9144",
  "Y 	c #423132",
  "Z 	c #5F1D20",
  "` 	c #6F1116",
  " .	c #93040A",
  "..	c #97040A",
  "+.	c #781519",
  "@.	c #373938",
  "#.	c #244E35",
  "$.	c #2C834D",
  "%.	c #099641",
  "&.	c #069740",
  "*.	c #5E586E",
  "=.	c #462E30",
  "-.	c #492C2E",
  ";.	c #562325",
  ">.	c #7C090E",
  ",.	c #572628",
  "'.	c #343D37",
  ").	c #1E5534",
  "!.	c #2D834E",
  "~.	c #0A9541",
  "{.	c #18713C",
  "].	c #3A3737",
  "^.	c #3E3434",
  "/.	c #4A2C2D",
  "(.	c #542426",
  "_.	c #611B1F",
  ":.	c #720F14",
  "<.	c #2E4337",
  "[.	c #1D5734",
  "}.	c #30814F",
  "|.	c #0F9243",
  "1.	c #0A8B3D",
  "2.	c #385138",
  "3.	c #373A38",
  "4.	c #3B3636",
  "5.	c #482D2E",
  "6.	c #572225",
  "7.	c #522628",
  "8.	c #502729",
  "9.	c #175D33",
  "0.	c #156B37",
  "a.	c #2C824D",
  "b.	c #1B8C47",
  "c.	c #3D724E",
  "d.	c #3F5446",
  "e.	c #3C3535",
  "f.	c #462E2F",
  "g.	c #472E2F",
  "h.	c #294936",
  "i.	c #195A34",
  "j.	c #287A48",
  "k.	c #208949",
  "l.	c #328752",
  "m.	c #415648",
  "n.	c #3E3E3E",
  "o.	c #284A36",
  "p.	c #26864B",
  "q.	c #079640",
  "r.	c #323E37",
  "s.	c #244F35",
  "t.	c #176D39",
  "u.	c #109243",
  "v.	c #2E4336",
  "w.	c #146133",
  "x.	c #126935",
  "y.	c #2D7E4C",
  "z.	c #27854C",
  "A.	c #70706B",
  "B.	c #636360",
  "C.	c #464644",
  "D.	c #393939",
  "E.	c #314037",
  "F.	c #234F35",
  "G.	c #1A6F3C",
  "H.	c #257845",
  "I.	c #757570",
  "J.	c #646460",
  "K.	c #444845",
  "L.	c #3E4D43",
  "M.	c #245236",
  "N.	c #277A47",
  "O.	c #2B844D",
  "P.	c #089640",
  "Q.	c #109444",
  "R.	c #73756F",
  "S.	c #72766F",
  "T.	c #687067",
  "U.	c #647266",
  "V.	c #667468",
  "W.	c #5B7763",
  "X.	c #5E7965",
  "Y.	c #667969",
  "Z.	c #657A69",
  "`.	c #6A786B",
  ". . . . . . . . . . . . . . + @ . . . . ",
  ". . . . . . . . . . . . . . # $ . . . . ",
  ". . . . . % % & . . . . . . * = . . . . ",
  ". . - ; > , ' ) ! ~ . . . { ] ^ / . . . ",
  ". ( _ : < [ } | | 1 2 . . 3 4 5 6 . . . ",
  "{ 7 8 9 0 a b | | | c d e f g 5 h i . . ",
  "j k l : m n o } | | p q r s t u v w . . ",
  "x y z A B C D [ E F G H I J t K v L . . ",
  "x M N O P Q R < n a S x T U V W v X . . ",
  "x Y Y Z ` P Q R  ...+.x @.#.V $.%.&.*.. ",
  "x x =.-.;.` >.P P B ,.x '.).V !.~.v {.@.",
  "x x ].^./.(._.:.P P x x <.[.V }.|.v 1.2.",
  "3.x x x 4.=.5.6.7.8.x x <.9.0.a.b.v v c.",
  "d.x x x x e.f.g.M x x x h.i.0.j.k.&.v l.",
  "m.n.x x x x x x x x x x o.g 0.j.p.q.v q.",
  "x x x x x x x x x x x r.s.g t.j.k.u.v v ",
  "x x x x x x x x x x x v.h.w.x.y.z.u.v v ",
  "A.A.A.A.A.A.A.B.C.D.E.h.F.4 G.H.p.b.v v ",
  "I.I.I.I.I.I.I.I.I.J.K.L.M.V x.N.O.k.P.Q.",
  "I.I.I.I.I.I.I.I.I.I.R.S.T.U.V.W.X.Y.Z.`."
};

gchar *module_name = "The POV-Ray renderer module";

gint module_type = 2;

void update_func(slow_module_fd *smfd)
{
  guchar buf[3];
  guint  read_count;
  guint  first_line, last_line;

  first_line = (smfd->read_total-18)/(3*smfd->width);
  do
  {
    read_count = read(smfd->fd, buf, 3);
    if (read_count == 3)
    {
      smfd->big_buf[smfd->read_total+2] = buf[0];
      smfd->big_buf[smfd->read_total+1] = buf[1];
      smfd->big_buf[smfd->read_total+0] = buf[2];
      smfd->read_total += 3;
    }
  } while (read_count == 3);
  
  last_line = (smfd->read_total-18)/(3*smfd->width);
  if (last_line > smfd->height-1)
    last_line = smfd->height -1 ;
  gdk_draw_rgb_image(smfd->pixmap, smfd->area->style->white_gc,
                     0, first_line, smfd->width, last_line-first_line+1,
                     GDK_RGB_DITHER_MAX,
                     smfd->big_buf + 18 + 3*smfd->width*first_line,
                     3 * smfd->width);
  if (smfd->read_total == smfd->buf_size)
  {
    pclose(smfd->pipe);
    g_free(smfd->big_buf);
    smfd->big_buf = NULL;
  }
}

slow_module_fd *rendering_func(GtkWidget *area, gint width, gint height)
{
  GdkPixmap      *pixmap;
  FrameStruct    *frame;
  gchar          *cmd_line;
  slow_module_fd *smfd;
  gchar          *tmp_file_name;

  pixmap = gdk_pixmap_new(area->window, width, height, -1);
  gdk_draw_rectangle(pixmap, area->style->black_gc, TRUE,
                     0, 0, width, height);

  frame = g_object_get_data(G_OBJECT(area), "frame");

  tmp_file_name = g_strdup("/tmp/povXXXXXX");

  close(mkstemp(tmp_file_name));
  
  SavePovByName(frame, tmp_file_name);

  cmd_line = g_strdup_printf("povray +ft +i%s +o- +w%d +h%d -v -GA", 
                             tmp_file_name, width, height);

  smfd = g_new(slow_module_fd, 1);
  smfd->pipe       = popen(cmd_line, "r"); g_free(cmd_line);
  smfd->fd         = fileno(smfd->pipe);
  fcntl(smfd->fd, F_SETFL, O_NONBLOCK);
  smfd->area       = area;
  smfd->width      = width;
  if (width > 1369) smfd->width--;   /* Why? NB 1369*3 # 4k */
  smfd->height     = height;
  smfd->buf_size   = 3 * smfd->width * smfd->height + 18;
  smfd->big_buf    = g_malloc0(smfd->buf_size);
  smfd->read_total = 0;
  smfd->pixmap     = pixmap;
  return smfd;
}

