/* vectors.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIRAM_VECTORS_H__
#define __GIRAM_VECTORS_H__

typedef double Vector[5];
typedef double Vector5D[5];
typedef double Matrix[4][4];

typedef struct TransformStruct
{
  Matrix Direct;
  Matrix Inverse;
} TransformStruct;

#define V3DLength(V) sqrt((V)[0]*(V)[0]+(V)[1]*(V)[1]+(V)[2]*(V)[2])
#define V3DDot(a,b) ( (a)[0]*(b)[0] + (a)[1]*(b)[1] + (a)[2]*(b)[2] )
#define V3Deq(V,a,b,c) (V)[0]=(a); (V)[1]=(b); (V)[2]=(c);
#define V3Dcopy(V1,V2) (V1)[0]=(V2)[0]; (V1)[1]=(V2)[1]; (V1)[2]=(V2)[2];

void MidPoint(Vector Result, Vector a, Vector b);
void VCross(Vector a, Vector b, Vector c);
void MIdentity(Matrix Mat);
void MTimes(Matrix Result, Matrix M1, Matrix M2);
void MInverse(Matrix Result, Matrix M);  
void MEvaluatePoint(Vector Result, TransformStruct *Trans, Vector Source);
void MEvaluateVector(Vector Result, TransformStruct *Trans, Vector Source);  
void MInverseEvaluatePoint(Vector Result, TransformStruct *Trans, Vector Source);
void MInverseEvaluateVector(Vector Result, TransformStruct *Trans, Vector Source);  
void ComputeTranslateTrans(TransformStruct *Trans, Vector Vect);
void ComputeRotateTrans(TransformStruct *Trans, Vector Vect);
void ComputeScaleTrans(TransformStruct *Trans, Vector Vect);
void ComposeTrans(TransformStruct *Trans, TransformStruct *NewTrans);

#define V5DLength(V) sqrt((V)[0]*(V)[0]+(V)[1]*(V)[1]+(V)[2]*(V)[2]+(V)[3]*(V)[3]+(V)[4]*(V)[4])
#define V5DDot(a,b) ( (a)[0]*(b)[0] + (a)[1]*(b)[1] + (a)[2]*(b)[2] + (a)[3]*(b)[3] + (a)[4]*(b)[4])
#define V5Deq(V,a,b,c,d,e) (V)[0]=(a); (V)[1]=(b); (V)[2]=(c); (V)[3]=(d); (V)[4]=(e);
#define V5Dcopy(V1,V2) (V1)[0]=(V2)[0]; (V1)[1]=(V2)[1]; (V1)[2]=(V2)[2]; (V1)[3]=(V2)[3]; (V1)[4]=(V2)[4];

#endif
