/* protocol.h
 * Giram - A GPLed Modelling Program.
 * Copyright (C) 1999-2001 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PROTOCOL_H__
#define __PROTOCOL_H__

#include "constplugins.h"

int giram_send_trans(int ObjectID, TransformStruct *Trans);
int giram_send_box(Vector Vect1, Vector Vect2);
int giram_send_cone(Vector Base, double BaseRadius, 
                    Vector Apex, double ApexRadius);
int giram_send_cylinder(Vector Base, Vector Apex, double Radius);
int giram_send_disc(Vector Center, Vector Normal,
                    double Radius, double HoleRadius);
int giram_send_plane(Vector Normal, double Distance);
int giram_send_sphere(Vector Center, double Radius);
int giram_send_superellipsoid(double E, double N);
int giram_send_torus(double Major, double Minor);
int giram_send_triangle(Vector V1, Vector V2, Vector V3);

#endif /* __PROTOCOL_H__ */
