/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpgrouplayer_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpgrouplayer
 * @title: gimpgrouplayer
 * @short_description: Operations on a group layer.
 *
 * Operations on a group layer.
 **/


/**
 * _gimp_group_layer_new:
 * @image: The image to which to add the group layer.
 *
 * Create a new group layer.
 *
 * This procedure creates a new group layer. Attributes such as layer
 * mode and opacity should be set with explicit procedure calls. Add
 * the new group layer (which is a kind of layer) with
 * [method@image.insert_layer].
 * Other procedures useful with group layers:
 * [method@image_reorder_item], [method@item.get_parent],
 * [method@item.get_children], [method@item.is_group].
 *
 * Returns: (transfer none): The newly created group layer.
 *
 * Since: 2.8
 **/
GimpGroupLayer *
_gimp_group_layer_new (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGroupLayer *group_layer = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-group-layer-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    group_layer = GIMP_VALUES_GET_GROUP_LAYER (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return group_layer;
}

/**
 * gimp_group_layer_merge:
 * @group_layer: The group layer to merge.
 *
 * Merge the passed group layer's layers into one normal layer.
 *
 * This procedure combines the layers of the passed group layer into a
 * single normal layer, replacing the group.
 * The group layer is expected to be attached to an image.
 *
 * Returns: (transfer none): The resulting layer.
 *
 * Since: 2.10.14
 **/
GimpLayer *
gimp_group_layer_merge (GimpGroupLayer *group_layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpLayer *layer = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GROUP_LAYER, group_layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-group-layer-merge",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer = GIMP_VALUES_GET_LAYER (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer;
}
