/*
GtkCEdit
Copyright (C) 2002 Carlos Rodríguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __GTK_CEDIT_H__
#define __GTK_CEDIT_H__

#include <stdio.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkmisc.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtk.h>
#include "cedit/cedit.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_CEDIT		  (gtk_cedit_get_type ())
#define GTK_CEDIT(obj)		  (GTK_CHECK_CAST ((obj), GTK_TYPE_CEDIT, GtkCEdit))
#define GTK_CEDIT_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_CEDIT, GtkCEditClass))
#define GTK_IS_CEDIT(obj)	  (GTK_CHECK_TYPE ((obj), GTK_TYPE_CEDIT))
#define GTK_IS_CEDIT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CEDIT))
#define GTK_CEDIT_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_CEDIT, GtkCEditClass))

#define GTK_CEDIT_DOBLE_BUFFER
#define GTK_CEDIT_INTERLINE 6
//#define DEBUG
//#define GTK_CEDIT_FAST_SCROLL

#define max(a,b) (((a)>(b)) ? (a) : (b))
#define min(a,b) (((a)<(b)) ? (a) : (b))

  typedef struct _GtkCEdit       GtkCEdit;
  typedef struct _GtkCEditClass  GtkCEditClass;
//typedef struct _GtkCEDITSelectionInfo GtkCEDITSelectionInfo;

struct _GtkCEdit
{
  GtkWidget parent;	 /* padre */
  gboolean visible;
  GdkPixmap *doble_buffer; // = NULL;	/* doble buffer */	

  GdkPixmap *mouse_buffer; // buffer del raton, para que no machaque nada importante
  gboolean mouse_drawed;   // el buffer esta lleno?
  gint mouse_buffer_x, mouse_buffer_y;           // de donde se saco el buffer
  gint mouse_buffer_width, mouse_buffer_height;  // alto y ancho del buffer

  GtkAdjustment *hadj;					/* scrolls vertical y horizontal */
  GtkAdjustment *vadj;
  GtkAdjustment *last_hadj;					/* scrolls vertical y horizontal */
  GtkAdjustment *last_vadj;
  
  gboolean redraw_all;
  
  CEdit *edit;
  //  CEdit *screen;

  gchar *name;       // nombre del fichero que se esta editando
  // GtkWindow *window2;

  int scroll_cursor;
 
  GdkColor colors[100];
  GdkGC    *Pleft_edge;
  GdkGC    *Pnormal;
  GdkGC    *Preserved_word;
  GdkGC    *Pmacro;
  GdkGC    *Pcomment;
  GdkGC	   *Pnumber;
  GdkGC    *Ptext;
  GdkGC    *Pbackground;
  GdkGC    *Pendfile;
  GdkGC    *PselectedFore;
  GdkGC    *PselectedBack;
  GdkGC    *PblockBack;
  GdkGC    *PerrorBack;
  GdkGC    *PwarningBack;
  GdkGC    *PMarkBack;
  GdkGC    *gc;

  GdkFont *Fnormal;

  int left_edge;         // espacio para las letras
  int char_height;
  int char_width;
  gboolean flick;
  guint flick_interrupt;
  gboolean show_cursor;

  GtkProgressBar *progressbar; // barra de progreso

  int space_tabs; // numero de espacios q tiene un tab
  int space_width; // ancho en pixels de un espacio

  gboolean left_mouse_button;
  gboolean freeze;

  glong line_mark[10];  // linea donde se dejo una marca (ctrl+1,2,3,4...)

  GdkPixmap *mark_pixmap;
  GdkBitmap *mark_mask;
  
  gboolean fast_scroll; // si el scroll es ha salto o suave

  GtkSignalFunc go_to_definition_callback;
  gpointer *go_to_definition_callback_data;
};

struct _GtkCEditClass
{
  GtkWidgetClass parent_class;

  void (* have_undo) (GtkCEdit *cedit);
  void (* have_redo) (GtkCEdit *cedit);
  void (* no_have_undo) (GtkCEdit *cedit);
  void (* no_have_redo) (GtkCEdit *cedit);
};

//GtkType               gtk_cedit_get_type          (void) G_GNUC_CONST;

GtkWidget*
gtk_cedit_new (void);
gint
gtk_cedit_open_file(GtkCEdit *gtkcedit, gchar *filename);
gint
gtk_cedit_save_file(GtkCEdit *gtkcedit);
gint
gtk_cedit_save_as_file(GtkCEdit *gtkcedit, gchar *filename);
gint
gtk_cedit_set_filename(GtkCEdit *gtkcedit, gchar *filename);
gchar*
gtk_cedit_get_filename(GtkCEdit *gtkcedit);
gint
gtk_cedit_new_file(GtkCEdit *gtkcedit);
gint
gtk_cedit_undo(GtkCEdit *gtkcedit);
gint
gtk_cedit_redo(GtkCEdit *gtkcedit);
gint
gtk_cedit_cut(GtkCEdit *gtkcedit);
gint
gtk_cedit_copy(GtkCEdit *gtkcedit);
gint
gtk_cedit_paste(GtkCEdit *gtkcedit);
gint
gtk_cedit_set_progress_bar(GtkCEdit *gtkcedit, GtkProgressBar *pb);
gint
gtk_cedit_have_undo(GtkCEdit *gtkcedit);
gint
gtk_cedit_have_redo(GtkCEdit *gtkcedit);
gint
gtk_cedit_find (GtkCEdit *gtkcedit, char *text);

gchar *gtk_cedit_go_to_definition(GtkCEdit *gtkcedit, gulong *line);
gchar *gtk_cedit_result_go_to_definition(GtkCEdit *gtkcedit, gulong *line, result_definition_db *res_definition_db);

gint gtk_cedit_set_go_to_definition_callback(GtkCEdit *gtkcedit, GtkSignalFunc func, gpointer data);

void
gtk_cedit_test(GtkWidget *widget);
gboolean
gtk_cedit_set_continuous_color (GtkCEdit *gtkcedit, gboolean status);
gboolean
gtk_cedit_set_continuous_autoidentation (GtkCEdit *gtkcedit, gboolean status); 
gboolean
gtk_cedit_set_fast_scroll (GtkCEdit *gtkcedit, gboolean status); 
gboolean
gtk_cedit_set_text_format (GtkCEdit *gtkcedit, gboolean status); 
gboolean
gtk_cedit_set_continuous_correction (GtkCEdit *gtkcedit, gboolean status); 
gboolean
gtk_cedit_set_correction (GtkCEdit *gtkcedit, gboolean status); 
gint
gtk_cedit_move_cursor(GtkCEdit *gtkcedit, gulong x, gulong y);
gint
gtk_cedit_set_go_to_definition_callback(GtkCEdit *gtkcedit, GtkSignalFunc func, gpointer data);


gint
gtk_cedit_have_bookmark(GtkCEdit *gtkcedit, gint nBookMark);
gint
gtk_cedit_go_to_bookmark(GtkCEdit *gtkcedit, gint nBookMark);
gint 
gtk_cedit_del_bookmark(GtkCEdit *gtkcedit, gint nBookMark);
gint 
gtk_cedit_put_bookmark(GtkCEdit *gtkcedit, gint nBookMark);

GdkColor*
gtk_cedit_get_color(GtkCEdit *gtkcedit, gint color);
gint
gtk_cedit_set_color(GtkCEdit *gtkcedit, gint color, GdkColor *gdkcolor);

gint gtk_cedit_insert_include_path(GtkCEdit *gtkcedit, char *text);
gint gtk_cedit_remove_include_path(GtkCEdit *gtkcedit);


#define gtk_cedit_color_left_edge     0 
#define gtk_cedit_color_background    1
#define gtk_cedit_color_normal        2
#define gtk_cedit_color_end_file      3
#define gtk_cedit_color_reserved_word 4
#define gtk_cedit_color_macro         5
#define gtk_cedit_color_comment       6
#define gtk_cedit_color_number        7
#define gtk_cedit_color_text          8
#define gtk_cedit_color_selected      9
#define gtk_cedit_color_backblock     10
#define gtk_cedit_color_foreblock     11
#define gtk_cedit_color_error         12
#define gtk_cedit_color_mark          13
#define gtk_cedit_color_warning       14


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_CEDIT_H__ */
