/*
CEdit
Copyright (C) 2002 Carlos Rodríguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

    //#ifndef _file_cedit_
    //#define _file_cedit_

    //#include "log.h"
#define TEXT_STEP 10                            // cuanta memoria se reserva de golpe
#define CURSOR_BLOCK 10                          // cuantos cursores se reservan de golpe

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif


    // definicio de una linea

typedef struct _line line;
typedef struct _stack_cursor stack_cursor;
typedef struct _array_cursor array_cursor;
typedef struct _element_undo element_undo;
typedef struct _stack_undo stack_undo;
typedef struct _list_change list_change;
typedef struct _CEdit CEdit;
typedef struct _temporal temporal;
typedef struct _CEditCursor CEditCursor;
typedef struct _definition_db definition_db;
typedef struct _include_db include_db;
typedef struct _include_path include_path;
typedef struct _result_definition_db result_definition_db;

struct _CEditCursor
{
    long x;
    long y;
    line *l_line;
};

struct _line
{
    char *text;
    int *flags;
    line *next;
    line *prev;
    int tabs;                    // cuantos tabs suma o quita esta linea
    int add_tabs;                // cuantos tabs se añaden a esta linea y solo a esta
    int absolute_tabs;           // tabs absolutos, si esto es >=0 entonces este prevalece
    long num_char;
    int num_assigned_step;
};

struct _stack_cursor
{
    long cursor_x;
    long cursor_y;
    line *cursor_line;
    int cursor_tabs;
    stack_cursor *next;
};

struct _list_change
{
    long x;
    long y;
    line *l_line;
    int type;
    list_change *next;
    list_change *prev;
};

struct _array_cursor
{
    long x;
    long y;
    line *l_line;
    int tabs;
    stack_undo *undo;
    char undo_or_redo;                            // uso interno
        //stack_undo *redo;
        //stack_undo *last_undo;
        //stack_undo *last_redo;
};

struct _element_undo
{
    int mode;                                     // si es borrar o insertar
    char *text;                                   // texto borrado
    int join;                                     // si es 1, este undo pertenece a una unión
    int advance;                                  // si tiene que avanzar el cursos o no
    long x, y;                                     // posicion del cursor
    line *l_line;                                 // linea del cursor
    element_undo *next;                           // siguiente en el array
    element_undo *prev;                           // anterior en el array
};

struct _stack_undo
{
    element_undo *first_undo;                     // primer undo de la pila
    element_undo *last_undo;                      // ultimo undo de la pila
    element_undo *first_redo;                     // primer redo de la pila
    element_undo *last_redo;                      // ultimo redo de la pila
    long undo_num_char;                           // numero de caracteres almacenados en los undo's
    long redo_num_char;                           // numero de caracteres almacenados en los redo's
    long limit_undo_redo;                         // numero maximo de caracteres que se le permiten a este cursor
};

struct _temporal
{
    long move_x;                                   // posicion x conocida
    long move_y;                                   // posicion y conocida
    line *move_line;                              // linea conocida
    int move_tabs;                              // numeros de tabs
};

struct _definition_db
{
  char *name;                                    // nombre de la definicion
  int name_long;                                 // longitud del nombre
  int type;                                      // tipo
  definition_db *definition_type;                // tipo del cual proceden
  int pointer;                                   // 1 si es un puntero
  char *typedef_name;                            // nombre del tipo al que representa si es un typedef
  int n_args;                                    // numero de argumentos
  //    char **args;                                   // definicion de los argumentos
  definition_db **definition_type_args;          // tipo del cual procede el argumento
  long n_line;                                   // numero de linea de la definicion
  char *file;                                    // fichero de la definicion
  long n_line_min_boundary;                      // numero de linea en que comienza el ámbito de la definicion
  long n_line_max_boundary;                      // numero de linea en que finaliza el ámbito de la definicion
  char is_deleted;                               // 1 si es una palabra borrada, 0 sino
};

struct _result_definition_db
{
  definition_db *def_db;
  result_definition_db *next;
};

struct _include_db
{
  char *name;                              // nombre del fichero incluido
  char *fullname;                          // nombre completo
  GTree *db;                               // base de datos de las definiciones  
  char is_readed;                          // 1 si ya se ha leido esta vez
  char is_local;                           // 1 si es un include local
  GList *sons;                             // lista de includes que tiene este
  unsigned long filelenght;                // longitud del fichero
  include_db *next;
};

struct _include_path
{
  char *name;
  include_path *next;
};

    // definicion de la clase

struct _CEdit
{
    line *first;                                  // apuntador al primera linea
    long num_line;                                 // numero de lineas del fichero
    char freeze;                                  // 1 si esta congelado
    array_cursor *cursors;                        // array de cursores, apuntador al primer cursor
    int num_cursors;                              // numero de cursores
    int num_block_cursors;                        // cuantos bloques de cursores se han definido
    stack_cursor *first_stack_cursor;             // pila de cursores para el push y el pop
    
    list_change *first_change;                    // lista de cambios del texto
    list_change *last_change;
    long min_change_y;                            // minima posicion y del cambio cedit_change_to_end_of_text
    long min_change_x;                            // minima posicion x del cambio cedit_change_to_end_of_text
    int num_changes;                              // numero de cambios

  char *filename;                                 // nombre del fichero actual
    
    int joined_undo;                              // al pegar, borrar una seleccion... , generara un monton de undo's,
        // si esto esta activado (=1) los undo's iran juntos
    
    char something_has_changed;          // 0 si no ha cambiado nada desde la última vez que se busco flags
    
    long sel_ini_x, sel_ini_y;                     // primer punto de la seleccion
    line *sel_ini_line;
    long sel_end_x, sel_end_y;                     // ultimo punto de la seleccion
    line *sel_end_line;
    
    temporal temp;                                // valores temporales para acelerar
    int insert;                                   // se inserta?
    
    char **reserved_words;                        // lista de palabras reservadas del lenguaje
    long num_reserved_words;                      // cuantas palabras reservadas tiene
    
    char *error;                              // mensaje de error
    int nError;                                   // numero de error
    
    int fast_color;                               // si es 0 se colorea las letras mientra se escribe, sino cuando cambie de linea
    int fast_autoident;                           // si es 0 se identa las lineas mientras se escribe, sino cuando cambie de linea
  int format;                                     // si es 0, el formateo del texto esta desactivado, 1 activado
  int continuous_correction;                      // si es 0, se espera 1 segundo para corregir, 1 para que no
  int correction;                                 // si es 0, no corrige, 1 si
    
    long block_x, block_y;                        // posicion x del inicio o fin de bloque ( {()} )
    line *block_line;
    
    
  GTree *words_db;                               // base de datos de las definiciones
  GTree *copy_db;                          // para poder hacer una copia de la base de datos                
  GTree *global_db;
  GThread *fill_db;                            // hilo para encontrar las definiciones
  GMutex *mutex_text;                   // semaforo para el texto
  int correct_now;                               // si esta a 1, se pone a corregir
  int restart_correct_now;                       // para que vuelva a comenzar, por si se borra una linea, y la este corrigiendo
  char mutex;                                      // 1 si esta activado, sirve para no activar 2 veces el mismo semaforo
    
    int exit;                                      // si esta a 1, los hilos han de salir
  int rand; // pa borrar
  long num_db_words;                               // numero de palabras en la base de datos
  definition_db *list_words;                       // lista de palabras de la base de datos, se añaden aqui para poder borrarlas luego
  include_db *list_include_db;                    // arboles de cada include, para no repetirlos y ir mas rapido
  include_db *incl_dbtonext;                     // para que una funcion pueda devolver 2 parametros
  include_path *list_include_path;

  unsigned long num_definition_words;             // numero de palabras definidas
  unsigned long num_definition_words_deleted;    // numero de palabras borradas, si supera un mximo, libero todo y busco todo de nuevo
  result_definition_db *result_def_db;           // resultados de una consulta para saber definiciones (ir a definicion y sugerencias)
  result_definition_db *result_suggest_def_db;   // resultados de una consulta para saber definiciones (ir a definicion y sugerencias)

  char *file_to_delete;        // fichero a borrar de la tabla de definiciones
  definition_db *definition_deleted; // cuando se borra una definicion, se libera la memoria y el puntero apunta a esta

};

typedef void (*cedit_progress_callback) (double value, void *data);

CEdit *cedit_init (void);
int cedit_exit (CEdit *cedit);
char * cedit_get_error (CEdit *cedit);
int cedit_freeze (CEdit *cedit);
int cedit_unfreeze (CEdit *cedit);

int cedit_cput_char (CEdit *cedit, int cursor, char ch);
int cedit_cput_text (CEdit *cedit, int cursor, char *text);
int cedit_cget_char (CEdit *cedit, int cursor);
int cedit_cdel_char (CEdit *cedit, int cursor);
int cedit_cbackspace_char (CEdit *cedit, int cursor);
int cedit_cdel_until_end_of_line (CEdit *cedit, int cursor);
int cedit_cdel_until_end_of_file (CEdit *cedit, int cursor);

int cedit_cget_next_char (CEdit *cedit, int cursor);
int cedit_cget_prev_char (CEdit *cedit, int cursor);
int cedit_cnext_char (CEdit *cedit, int cursor);
int cedit_cprev_char (CEdit *cedit, int cursor);
int cedit_cnext_line (CEdit *cedit, int cursor);
int cedit_cprev_line (CEdit *cedit, int cursor);
char * cedit_cget_line_text (CEdit *cedit, int cursor);
int * cedit_cget_line_flags (CEdit *cedit, int cursor);
long cedit_cget_line_num_char (CEdit *cedit, int cursor);
long cedit_get_file_num_line (CEdit *cedit);

int cedit_cpush_cursor (CEdit *cedit, int cursor);
int cedit_cpop_cursor (CEdit *cedit, int cursor);
int cedit_copy_cursor (CEdit *cedit, int source, int dest);
int cedit_new_cursor (CEdit *cedit);
int cedit_del_cursor (CEdit *cedit, int cursor);
int cedit_cget_cursor (CEdit *cedit, int cursor, long *x, long *y);
long cedit_cget_cursor_x (CEdit *cedit, int cursor);
long cedit_cget_cursor_y (CEdit *cedit, int cursor);
int cedit_cmove_cursor (CEdit *cedit, int cursor, long x, long y);
int cedit_cmove_cursor_left (CEdit *cedit, int cursor);
int cedit_cmove_cursor_right (CEdit *cedit, int cursor);
int cedit_cmove_cursor_up (CEdit *cedit, int cursor);
int cedit_cmove_cursor_down (CEdit *cedit, int cursor);
int cedit_cmove_cursor_home_line (CEdit *cedit, int cursor);
int cedit_cmove_cursor_end_line (CEdit *cedit, int cursor);

CEdit *cedit_clear (CEdit *cedit);
CEdit *cedit_open_file (CEdit *cedit, char *name, cedit_progress_callback callback, void *data);
int cedit_save_file (CEdit *cedit, char *name);

int cedit_toggle_insert_mode (CEdit *cedit);
int cedit_get_insert_status (CEdit *cedit);

int cedit_cend_of_line (CEdit *cedit, int cursor);
int cedit_clast_line (CEdit *cedit, int cursor);
int cedit_cend_of_file (CEdit *cedit, int cursor);

int cedit_cundo (CEdit *cedit, int cursor);
int cedit_credo (CEdit *cedit, int cursor);

long cedit_cset_limit_undo_redo (CEdit *cedit, int cursor, long limit);
int cedit_chave_undo (CEdit *cedit, int cursor);
int cedit_chave_redo (CEdit *cedit, int cursor);

int cedit_cdel_all_redo (CEdit *cedit, int cursor);

int cedit_del_change (CEdit *cedit);
int cedit_cmove_cursor_to_change (CEdit *cedit, int cursor);
int cedit_prepare_to_change (CEdit *cedit);
int cedit_have_change (CEdit *cedit);
int cedit_get_type_change (CEdit *cedit);

int cedit_get_fast_color (CEdit *cedit);           // devuelve si esta activado el coloreado repido
int cedit_toggle_fast_color (CEdit *cedit);        // activa/desactiva el coloreado rapido

int cedit_get_format (CEdit *cedit);           // devuelve si esta activado el coloreado repido
int cedit_toggle_format (CEdit *cedit);        // activa/desactiva el coloreado rapido

int cedit_get_fast_autoident (CEdit *cedit);
int cedit_toggle_fast_autoident (CEdit *cedit);

int cedit_toggle_correction (CEdit *cedit);
int cedit_get_correction(CEdit *cedit);

int cedit_toggle_continuous_correction (CEdit *cedit);
int cedit_get_continuous_correction(CEdit *cedit);




int cedit_cget_tabs (CEdit *cedit, int cursor);

int cedit_cset_first_selection_point (CEdit *cedit, int cursor);
int cedit_cset_last_selection_point (CEdit *cedit, int cursor);
int cedit_have_selection (CEdit *cedit);
int cedit_del_selection (CEdit *cedit);
char * cedit_get_selection_text (CEdit *cedit);
int cedit_cpaste_text (CEdit *cedit, int cursor, char *text);
int cedit_ccut_text (CEdit *cedit, int cursor);
int cedit_csearch_block_flag (CEdit *cedit, int cursor);

int cedit_cfind (CEdit *cedit, int cursor, char * text);

definition_db *cedit_cgo_to_definition(CEdit *cedit, int cursor);
int cedit_cget_suggestion(CEdit *cedit, int n_cursor);
int cedit_cset_suggestion(CEdit *cedit, int n_cursor, char* text);

result_definition_db *cedit_get_first_result(CEdit *cedit);
result_definition_db *cedit_get_next_result(CEdit *cedit, result_definition_db *def_db);
result_definition_db *cedit_get_first_result_suggest(CEdit *cedit);
char *cedit_get_name_result(CEdit *cedit, result_definition_db *res_def_db);
char *cedit_get_filename_result(CEdit *cedit, result_definition_db *res_def_db);
long cedit_get_line_result(CEdit *cedit, result_definition_db *res_def_db);
int cedit_insert_include_path(CEdit *cedit, char *path);
int cedit_free_include_path(CEdit *cedit);



    // definiciones para acelerar la escritura
#define cedit_put_char(a,b) cedit_cput_char(a, 0, b)
#define cedit_put_text(a,b) cedit_cput_text(a, 0, b)
#define cedit_get_char(a) cedit_cget_char(a,0)
#define cedit_del_char(a) cedit_cdel_char(a,0)
#define cedit_del_until_end_of_line(a) cedit_cdel_until_end_of_line(a,0)
#define cedit_del_until_end_of_file(a) cedit_cdel_until_end_of_file(a,0)
#define cedit_backspace_char(a) cedit_cbackspace_char(a,0)
#define cedit_get_next_char(a) cedit_cget_next_char(a,0)
#define cedit_get_prev_char(a) cedit_cget_prev_char(a,0)
#define cedit_next_char(a) cedit_cnext_char(a,0)
#define cedit_prev_char(a) cedit_cprev_char(a,0)
#define cedit_move_cursor(a,x,y) cedit_cmove_cursor(a,0,x,y)
#define cedit_next_line(a) cedit_cnext_line(a,0)
#define cedit_prev_line(a) cedit_cprev_line(a,0)
#define cedit_get_line_text(a) cedit_cget_line_text(a,0)
#define cedit_get_line_flags(a) cedit_cget_line_flags(a,0);
#define cedit_get_line_num_char(a) cedit_cget_line_num_char(a,0)
#define cedit_push_cursor(a) cedit_cpush_cursor(a,0)
#define cedit_pop_cursor(a) cedit_cpop_cursor(a,0)
#define cedit_get_cursor(a,b,c) cedit_cget_cursor(a,0,b,c)
#define cedit_get_cursor_x(a) cedit_cget_cursor_x(a,0)
#define cedit_get_cursor_y(a) cedit_cget_cursor_y(a,0)
#define cedit_move_cursor_left(a) cedit_cmove_cursor_left(a,0)
#define cedit_move_cursor_right(a) cedit_cmove_cursor_right(a,0)
#define cedit_move_cursor_up(a) cedit_cmove_cursor_up(a,0)
#define cedit_move_cursor_down(a) cedit_cmove_cursor_down(a,0)
#define cedit_move_cursor_home_line(a) cedit_cmove_cursor_home_line(a,0)
#define cedit_move_cursor_end_line(a) cedit_cmove_cursor_end_line(a,0)
#define cedit_end_of_line(a) cedit_cend_of_line(a,0)
#define cedit_last_line(a) cedit_clast_line(a,0)
#define cedit_end_of_file(a) cedit_cend_of_file(a,0)
#define cedit_undo(a) cedit_cundo(a,0)
#define cedit_redo(a) cedit_credo(a,0)
#define cedit_set_limit_undo_redo(a,b) cedit_cset_limit_undo_redo(a,0,b)
#define cedit_have_undo(a) cedit_chave_undo(a,0)
#define cedit_have_redo(a) cedit_chave_redo(a,0)
#define cedit_del_all_redo(a) cedit_cdel_all_redo(a,0)
#define cedit_move_cursor_to_change(a) cedit_cmove_cursor_to_change(a,0)
#define cedit_set_first_selection_point(a) cedit_cset_first_selection_point(a,0)
#define cedit_set_last_selection_point(a) cedit_cset_last_selection_point(a,0)
#define cedit_paste_text(a,b) cedit_cpaste_text(a,0,b)
#define cedit_cut_text(a) cedit_ccut_text(a,0)
#define cedit_get_tabs(a) cedit_cget_tabs(a,0)
#define cedit_search_block_flag(a) cedit_csearch_block_flag(a,0)
#define cedit_find(a,b) cedit_cfind(a,0,b)
#define cedit_go_to_definition(a) cedit_cgo_to_definition(a,0)
#define cedit_get_suggestion(a) cedit_cget_suggestion(a,0)


    // undo o redo
#define cedit_write 0
#define cedit_replace 1
#define cedit_backspace 2
#define cedit_write_left 3

    // cambios
#define cedit_change_this_char 0
#define cedit_change_to_end_of_line 1
#define cedit_change_to_end_of_text 2

    // insert
#define cedit_insert_off 0
#define cedit_insert_on 1

    // flags
#define cedit_flag_selected 0x1
#define cedit_flag_comment 0x2
#define cedit_flag_line_comment 0x4
#define cedit_flag_text 0x8
#define cedit_flag_apostrophe_text 0x10
#define cedit_flag_macro 0x20
#define cedit_flag_reserved_word 0x40
#define cedit_flag_number 0x80
#define cedit_flag_character 0x100
#define cedit_flag_mark 0x200
#define cedit_flag_error 0x400
#define cedit_flag_warning 0x800
#define cedit_flag_block 0x1000

    // type definition_word
    // el orden es muy importante
#define cedit_dw_nothing 1   // palabras como static, NULL, extern...
#define cedit_dw_macro 2
#define cedit_dw_variable 3
#define cedit_dw_function 4
#define cedit_dw_typedef 5   // palabras como struct, enum, class...
#define cedit_dw_data_type 6
#define cedit_dw_struct 7   // struct & class
#define cedit_dw_deleted 8   // definicion borrada


    //#endif
