/*
ICE Intelligent C Editor
Copyright (C) 2002 Carlos Rodríguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "main.h"

int
create_page ()
{
    int i; //, j, max;
    
    i = 0;
    while (i < max_pages && filled [i]== 1)
        i ++;
    
    if (i == max_pages) return - 1;
    
    label [i] = gtk_label_new ("noname.c");
    gtk_widget_ref (label [i]);
        //  gtk_object_set_data_full(GTK_OBJECT(window), "label", label[i],
        //   (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label [i]);
    
        /*
        * --- Creo un gtkcedit
        */
    
    table1 [i] = gtk_table_new (2, 2, FALSE);
    gtk_widget_ref (table1 [i]);
        //  gtk_object_set_data_full(GTK_OBJECT(window), "table1", table1[i],
        //   (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (table1 [i]);
        //  gtk_container_add(GTK_CONTAINER(notebook), table1[i]);
        //  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
    
    
    
    
    
    gtkcedit [i] = gtk_cedit_new ();
    
    gtk_cedit_set_go_to_definition_callback(GTK_CEDIT(gtkcedit[i]), 
					    GTK_SIGNAL_FUNC(edit_go_to_def_popup), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [i]), "have_undo",
        GTK_SIGNAL_FUNC (have_undo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [i]), "no_have_undo",
        GTK_SIGNAL_FUNC (no_have_undo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [i]), "have_redo",
        GTK_SIGNAL_FUNC (have_redo), NULL);
    gtk_signal_connect (GTK_OBJECT (gtkcedit [i]), "no_have_redo",
        GTK_SIGNAL_FUNC (no_have_redo), NULL);
    
    gtk_widget_show (gtkcedit [i]);
    gtk_table_attach (GTK_TABLE (table1 [i]), gtkcedit [i], 0, 1, 0, 1,
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    
    hscrollbar [i] = gtk_hscrollbar_new (GTK_CEDIT (gtkcedit [i])-> hadj);
    gtk_widget_show (hscrollbar [i]);
    gtk_table_attach (GTK_TABLE (table1 [i]), hscrollbar [i], 0, 1, 1, 2,
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
        (GtkAttachOptions) (GTK_FILL), 0, 0);
    
    vscrollbar [i] = gtk_vscrollbar_new (GTK_CEDIT (gtkcedit [i])-> vadj);
    gtk_widget_show (vscrollbar [i]);
    gtk_table_attach (GTK_TABLE (table1 [i]), vscrollbar [i], 1, 2, 0, 1,
        (GtkAttachOptions) (GTK_FILL),
        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
    
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table1 [i], label [i]);
        //  gtk_container_add(GTK_CONTAINER(notebook), table1[i]);
    
        //  virtual_page[i]=gtk_notebook_get_nth_page(GTK_NOTEBOOK (notebook),0);
    filled [i]= 1;
    
        //  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), gtk_notebook_get_nth_page(GTK_NOTEBOOK (notebook),0));
    
        /*
        j=0;
        max=0;
        for (j=0;j<max_pages;j++)
        if (virtual_page[j]>max)
        max=virtual_page[j];
        */
    gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook),  - 1);
    virtual_page [i]= gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
    strcpy (filename [i],"noname.c");

    usar_preferencias(i); // pongo los valores iniciales (colores y path)
    
    
        //    gtk_widget_grab_focus(GTK_WIDGET(gtkcedit[i]));
    
    while (gtk_events_pending ())
        gtk_main_iteration ();
    
        //gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook), gtk_notebook_get_nth_page(GTK_NOTEBOOK (notebook), 0), label);
    
    gtk_cedit_set_progress_bar (GTK_CEDIT (gtkcedit [i]), GTK_PROGRESS_BAR (progressbar));
    no_have_undo (gtkcedit [i], NULL);
    no_have_redo (gtkcedit [i], NULL);
    return i;
}

int
actual_page ()
{
    int i;
    i = 0;
    
        // si no hay paginas
    if (gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)) == - 1)
        return - 1;
    
    while (i < max_pages && virtual_page [i]!= gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))
        i ++;
    
    if (i == max_pages)
        return - 1;
    else return i;
}

int
actual_page2 (gint page)
{
    int i;
    i = 0;
    
    if (page ==- 1) return - 1;
    
    while (i < max_pages && virtual_page [i]!= page)
        i ++;
    
    if (i == max_pages)
        return - 1;
    else return i;
}

int
get_name (char *orig, char *dest)
{
    int i, j;

    if (orig==NULL) return -1;
    if (dest==NULL) return -1;

    i = strlen (orig);
    while (i > 0 && orig [i]!='/')
        i--;
    
    if (i > 0) i ++;
    for (j = 0; j <= strlen (orig)- i; j ++)
    dest [j]= orig [j + i];
    return 0;
}

void FindStringDialog (char *szMessage, void (*YesFunc)(), void (*NoFunc)())
{
    GtkWidget *label;
    GtkWidget *button1;
    GtkWidget *button2;
    GtkWidget *hbox;
    GtkWidget *hbox2;
    
    if (dialog_window) return;
    
    dialog_window = gtk_dialog_new ();
    
    gtk_signal_connect (GTK_OBJECT (dialog_window), "destroy",
        GTK_SIGNAL_FUNC (CancelFind),
        dialog_window);
    
    gtk_window_set_title (GTK_WINDOW (dialog_window), "Buscar");
    
    gtk_container_border_width (GTK_CONTAINER (dialog_window), 2);
    
    hbox = gtk_hbox_new (TRUE, TRUE);
    hbox2 = gtk_hbox_new (TRUE, TRUE);
    
    label = gtk_label_new ("Buscar: ");
    gtk_widget_show (label);
    
    entry = gtk_entry_new ();
    gtk_widget_show (entry);
    
    if (lastfind)
        gtk_entry_set_text (GTK_ENTRY (entry), lastfind);
    
    gtk_box_pack_start (GTK_BOX (hbox),
        label, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox),
        entry, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    
        //gtk_misc_set_padding (GTK_MISC (label), 2, 10);
    
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)-> vbox),
        hbox, TRUE, TRUE, 0);
    button1 = gtk_button_new_with_label ("Buscar siguiente");
    gtk_signal_connect (GTK_OBJECT (button1), "clicked",
        GTK_SIGNAL_FUNC (YesFunc),
        dialog_window);
    
        //gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)-> action_area),
        //button1, TRUE, TRUE, 0);
    
    gtk_widget_show (button1);
    
    button2 = gtk_button_new_with_label ("Cancelar");
    gtk_signal_connect (GTK_OBJECT (button2), "clicked",
        GTK_SIGNAL_FUNC (NoFunc),
        dialog_window);
    gtk_widget_show (button2);
    
    gtk_box_pack_start (GTK_BOX (hbox2),
        button1, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox2),
        button2, TRUE, TRUE, 0);
    gtk_widget_show (hbox2);
    
        //gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_window)-> action_area),
        //button2, TRUE, TRUE, 0);
    
    gtk_container_add (GTK_CONTAINER(GTK_DIALOG (dialog_window)-> action_area), hbox2);
    
    GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (button1);
    gtk_widget_show (dialog_window);
}

void CancelFind (GtkWidget *widget, gpointer data)
{
    gtk_widget_destroy (GTK_WIDGET (data));
    dialog_window = NULL;
}

void msg_box (gchar *text, int type)
{
    GtkWidget *dialog;
    
    dialog = gtk_message_dialog_new (GTK_WINDOW (window),
        GTK_DIALOG_DESTROY_WITH_PARENT,
        type,
        GTK_BUTTONS_CLOSE,
        text,
        NULL);
        /* Close dialog on user response */
    g_signal_connect (G_OBJECT (dialog),
        "response",
        G_CALLBACK (gtk_widget_destroy),
        NULL);
    
    //    GTK_WIDGET_SET_FLAGS (dialog, GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS (dialog, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (dialog);
    gtk_widget_grab_focus (dialog);
    gtk_widget_show (dialog);
}

int
create_preferences( void (*AceptarFunc)(), void (*AplicarFunc)(), void (*CancelarFunc)())
{
  GtkWidget *dialog_vbox1;
  GtkWidget *notebook1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *hbox1;
  GtkWidget *vbox2;
  GtkWidget *cambiarcolor;
  GtkWidget *label2;
  GtkWidget *dialog_action_area1;
  GtkWidget *aceptar;
  GtkWidget *aplicar;
  GtkWidget *cancelar;
  GtkWidget *hboxbuttons;
  GtkWidget *boton;
  GtkWidget *sw;

    if (Preferencias) return 1;
    
    Preferencias = gtk_dialog_new ();
    
    gtk_signal_connect (GTK_OBJECT (Preferencias), "destroy",
        GTK_SIGNAL_FUNC (CancelarPreferencias),
        Preferencias);
    
    gtk_window_set_title (GTK_WINDOW (Preferencias), "Preferencias");
    
    gtk_container_border_width (GTK_CONTAINER (Preferencias), 2);



//  gtk_object_set_data (GTK_OBJECT (Preferencias), "Preferencias", Preferencias);
  //GTK_WINDOW (Preferencias)->type = GTK_WINDOW_DIALOG;
//  gtk_window_set_modal (GTK_WINDOW (Preferencias), TRUE);
//  gtk_window_set_policy (GTK_WINDOW (Preferencias), FALSE, FALSE, FALSE);

  dialog_vbox1 = GTK_DIALOG (Preferencias)->vbox;
  gtk_object_set_data (GTK_OBJECT (Preferencias), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  notebook1 = gtk_notebook_new ();
  gtk_widget_ref (notebook1);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "notebook1", notebook1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), notebook1, TRUE, TRUE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox1);

  coloreado = gtk_check_button_new_with_label ("Coloreado rapido");
  gtk_widget_ref (coloreado);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "coloreado", coloreado,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (coloreado);
  gtk_box_pack_start (GTK_BOX (vbox1), coloreado, FALSE, FALSE, 0);

  identacion = gtk_check_button_new_with_label ("AutoIdentacion rapida");
  gtk_widget_ref (identacion);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "identacion", identacion,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (identacion);
  gtk_box_pack_start (GTK_BOX (vbox1), identacion, FALSE, FALSE, 0);

  scroll = gtk_check_button_new_with_label ("Scroll rapido");
  gtk_widget_ref (scroll);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "scroll", scroll,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scroll);
  gtk_box_pack_start (GTK_BOX (vbox1), scroll, FALSE, FALSE, 0);

  formateado = gtk_check_button_new_with_label ("Formateado del texto");
  gtk_widget_ref (formateado);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "formateado", formateado,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (formateado);
  gtk_box_pack_start (GTK_BOX (vbox1), formateado, FALSE, FALSE, 0);

  correccioncontinua = gtk_check_button_new_with_label ("Correccion del texto continua");
  gtk_widget_ref (correccioncontinua);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "correccioncontinua", correccioncontinua,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (correccioncontinua);
  gtk_box_pack_start (GTK_BOX (vbox1), correccioncontinua, FALSE, FALSE, 0);

  correccion = gtk_check_button_new_with_label ("Correccion del texto");
  gtk_widget_ref (correccion);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "correccion", correccion,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (correccion);
  gtk_box_pack_start (GTK_BOX (vbox1), correccion, FALSE, FALSE, 0);

  label1 = gtk_label_new ("Generales");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label1);




  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox1);

  
  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (hbox1), sw, TRUE, TRUE, 4);
  

  // create tree model 
  //  modelcolores = create_model_colores ();
  
  // create tree view 
  listacolores = gtk_tree_view_new_with_model (modelcolores);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (listacolores), TRUE);
  gtk_tree_view_set_search_column (GTK_TREE_VIEW (listacolores),
				   COLUMN_DESCRIPTION);
  
  //  g_object_unref (G_OBJECT (modelcolores));
  
  gtk_container_add (GTK_CONTAINER (sw), listacolores);
  
  // add columns to the tree view 
  add_columns_colores (GTK_TREE_VIEW (listacolores));
  
  gtk_widget_show (sw);
  gtk_widget_show (listacolores);
  
  /* finish & show */
  //      gtk_window_set_default_size (GTK_WINDOW (window), 280, 250);
  
  
  /*
    listacolores = gtk_list_new ();
    gtk_widget_ref (listacolores);
    gtk_object_set_data_full (GTK_OBJECT (Preferencias), "listacolores", listacolores,
    (GtkDestroyNotify) gtk_widget_unref);
  */



  //  gtk_widget_show (listacolores);
  // gtk_box_pack_start (GTK_BOX (hbox1), listacolores, TRUE, TRUE, 4);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 0);

  cambiarcolor = gtk_button_new_with_label ("Cambiar color...");
  gtk_signal_connect (GTK_OBJECT (cambiarcolor), "clicked",
		      GTK_SIGNAL_FUNC (CambiaColor),
		      listacolores);  
  gtk_widget_ref (cambiarcolor);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "cambiarcolor", cambiarcolor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cambiarcolor);
  gtk_box_pack_start (GTK_BOX (vbox2), cambiarcolor, FALSE, FALSE, 0);

  label2 = gtk_label_new ("Colores");
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label2);






  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox1);



  /* create model */
  //  modelpath = create_model_path ();




      sw = gtk_scrolled_window_new (NULL, NULL);
      gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
					   GTK_SHADOW_ETCHED_IN);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
      gtk_box_pack_start (GTK_BOX (hbox1), sw, TRUE, TRUE, 0);


      /* create tree view */
      listapath = gtk_tree_view_new_with_model (modelpath);
      //      g_object_unref (G_OBJECT (modelpath));
      gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (listapath), TRUE);
      gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (listapath)),
				   GTK_SELECTION_SINGLE);

      add_columns_path (GTK_TREE_VIEW (listapath));

      gtk_container_add (GTK_CONTAINER (sw), listapath);

  gtk_widget_show (sw);
  gtk_widget_show (listapath);




/*
  listapath = gtk_list_new ();
  gtk_widget_show (listapath);
  gtk_box_pack_start (GTK_BOX (hbox1), listapath, TRUE, TRUE, 4);
  */

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 0);

  boton = gtk_button_new_with_label ("Insertar path");
      g_signal_connect (G_OBJECT (boton), "clicked",
			G_CALLBACK (add_item), modelpath);
  gtk_widget_show (boton);
  gtk_box_pack_start (GTK_BOX (vbox2), boton, FALSE, FALSE, 0);
/*
  path=gtk_entry_new();
  gtk_widget_show (path);
  gtk_signal_connect (GTK_OBJECT (boton), "clicked",
        GTK_SIGNAL_FUNC (InsertarPath),
        NULL);
  gtk_box_pack_start (GTK_BOX (vbox2), path, FALSE, FALSE, 0);
*/

  boton = gtk_button_new_with_label ("Borrar path");
     g_signal_connect (G_OBJECT (boton), "clicked",
			G_CALLBACK (remove_item), listapath);
  gtk_widget_show (boton);
  gtk_box_pack_start (GTK_BOX (vbox2), boton, FALSE, FALSE, 0);

  label2 = gtk_label_new ("Caminos");
  gtk_widget_show (label2);

  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label2);






  dialog_action_area1 = GTK_DIALOG (Preferencias)->action_area;
  gtk_object_set_data (GTK_OBJECT (Preferencias), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  aceptar = gtk_button_new_with_label ("Aceptar");
//  gtk_widget_show (button2);


//  gnome_dialog_append_button (GTK_DIALOG (Preferencias), GTK_STOCK_BUTTON_OK);
//  aceptar = GTK_WIDGET (g_list_last (GNOME_DIALOG (Preferencias)->buttons)->data);
//  gtk_widget_ref (aceptar);
  gtk_signal_connect (GTK_OBJECT (aceptar), "clicked",
		      GTK_SIGNAL_FUNC (AceptarFunc),
		      Preferencias);
//  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "aceptar", aceptar,
//                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (aceptar);
//  GTK_WIDGET_SET_FLAGS (aceptar, GTK_CAN_DEFAULT);

  aplicar = gtk_button_new_with_label ("Aplicar");
//  gnome_dialog_append_button (GTK_DIALOG (Preferencias), GTK_STOCK_BUTTON_APPLY);
//  aplicar = GTK_WIDGET (g_list_last (GNOME_DIALOG (Preferencias)->buttons)->data);
//  gtk_widget_ref (aplicar);
  gtk_signal_connect (GTK_OBJECT (aplicar), "clicked",
		      GTK_SIGNAL_FUNC (AplicarFunc),
		      Preferencias);  
//  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "aplicar", aplicar,
//                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (aplicar);
//  GTK_WIDGET_SET_FLAGS (aplicar, GTK_CAN_DEFAULT);

  cancelar = gtk_button_new_with_label ("Cancelar");
//  gnome_dialog_append_button (GTK_DIALOG (Preferencias), GTK_STOCK_BUTTON_CANCEL);
//  cancelar = GTK_WIDGET (g_list_last (GNOME_DIALOG (Preferencias)->buttons)->data);
//  gtk_widget_ref (cancelar);
  gtk_signal_connect (GTK_OBJECT (cancelar), "clicked",
		      GTK_SIGNAL_FUNC (CancelarFunc),
		      Preferencias);
//  gtk_object_set_data_full (GTK_OBJECT (Preferencias), "cancelar", cancelar,
//                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancelar);
//  GTK_WIDGET_SET_FLAGS (cancelar, GTK_CAN_DEFAULT);

    hboxbuttons = gtk_hbox_new (TRUE, TRUE);
  gtk_box_pack_start (GTK_BOX (hboxbuttons),
        aceptar, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hboxbuttons),
        aplicar, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hboxbuttons),
        cancelar, TRUE, TRUE, 0);
    gtk_widget_show (hboxbuttons);

  gtk_container_add (GTK_CONTAINER(GTK_DIALOG (Preferencias)-> action_area), hboxbuttons);


	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(coloreado),lastColor);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(identacion),lastIdentation);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(scroll),lastScroll);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(formateado),lastFormat);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(correccioncontinua),lastContinuousCorrection);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(correccion),lastCorrection);


  gtk_widget_show(Preferencias);
  return 0;
}

gint statusbar_text(gchar *text)
{
	gtk_statusbar_push(GTK_STATUSBAR(statusbar1), 
		gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar1), "nada"),
		text);
	return 0;
}

GtkTreeModel *
create_model_colores (void)
{
  gint i = 0;
  GtkListStore *store;
  GtkTreeIter iter;

  /* create list store */
  store = gtk_list_store_new (NUM_COLUMNS,
			      G_TYPE_STRING);

  /* add data to the list store */
  for (i = 0; i < G_N_ELEMENTS (colores); i++)
    {
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter,
			  COLUMN_DESCRIPTION, colores[i].Direccion,
			  -1);
    }

  return GTK_TREE_MODEL (store);
} 

 
void
add_columns_colores (GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkTreeModel *model = gtk_tree_view_get_model (treeview);


  /* column for description */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Objetos",
						     renderer,
						     "text",
						     COLUMN_DESCRIPTION,
						     NULL);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_DESCRIPTION);
  gtk_tree_view_append_column (treeview, column);
}



// inserta los paths iniciales
void
add_items_path (void)
{
  Item foo;

  g_return_if_fail (ArrayPath != NULL);

  foo.Direccion = g_strdup ("/usr/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/usr/local/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/usr/lib/gcc-lib/i386-redhat-linux/2.96/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/gtk-2.0/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/lib/gtk-2.0/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/atk-1.0/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/pango-1.0/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/usr/X11R6/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/freetype2/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/include/glib-2.0/");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);
  foo.Direccion = g_strdup ("/opt/garnome/lib/glib-2.0/include/");
  foo.editable=TRUE;


  g_array_append_vals (ArrayPath, &foo, 1);
}

GtkTreeModel *
create_model_path (void)
{
  gint i = 0;
  GtkListStore *model;
  GtkTreeIter iter;

  /* create array */
  ArrayPath = g_array_sized_new (FALSE, FALSE, sizeof (Item), 1);

  add_items_path ();

  /* create list store */
  model = gtk_list_store_new (NUM_PATH_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /* add items */
  for (i = 0; i < ArrayPath->len; i++)
    {
      gtk_list_store_append (model, &iter);

      gtk_list_store_set (model, &iter,
			  COLUMN_PATH_DESCRIPTION,
			  g_array_index (ArrayPath, Item, i).Direccion,
			  COLUMN_PATH_EDITABLE,
			  g_array_index (ArrayPath, Item, i).editable,
			  -1);
    }

  return GTK_TREE_MODEL (model);
}


void
add_columns_path (GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeModel *model = gtk_tree_view_get_model (treeview);

  /* product column */
  renderer = gtk_cell_renderer_text_new ();
  g_signal_connect (G_OBJECT (renderer), "edited",
		    G_CALLBACK (cell_edited), model);
  g_object_set_data (G_OBJECT (renderer), "column", (gint *)COLUMN_PATH_DESCRIPTION);

  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
					       -1, "Path", renderer,
					       "text", COLUMN_PATH_DESCRIPTION,
					       "editable", COLUMN_PATH_EDITABLE,
					       NULL);
}


