#ifndef __PREFS_H__
#define __PREFS_H__

#include <gtk/gtk.h>

void prefs_event(GtkWidget *widget, gpointer data);
int prefs_rc_parse(const gchar *filename);
int prefs_rc_write(void);

/* rc defines */

#define GEG_RC_TOOLBAR 0
#define GEG_RC_TOOLTIPS 1
#define GEG_RC_XMIN 2
#define GEG_RC_XMAX 3
#define GEG_RC_YMIN 4
#define GEG_RC_YMAX 5
#define GEG_RC_GRAPH_WIDTH 6
#define GEG_RC_GRAPH_HEIGHT 7
#define GEG_RC_SPACING_TYPE 8
#define GEG_RC_ZOOM_FACTOR 9
#define GEG_RC_NOTCH_SPACING 10
#define GEG_RC_MINIMUM_RESOLUTION 11
#define GEG_RC_MAXIMUM_RESOLUTION 12
#define GEG_RC_INTERPOLATION_FACTOR 13
#define GEG_RC_MAXIMUM_FORMULAS 14
#define GEG_RC_BACKGROUND 15
#define GEG_RC_NUMBERS 16
#define GEG_RC_AXES 17
#define GEG_RC_SELECTION 18

#define GEG_RC_PICTURES_AND_TEXT 19
#define GEG_RC_PICTURES_ONLY 20
#define GEG_RC_TEXT_ONLY 21
#define GEG_RC_ON 22
#define GEG_RC_OFF 23
#define GEG_RC_DECIMAL 24
#define GEG_RC_RADIAN 25

/* defaults */

/* toolbar stuff */
#define DEF_TB GEG_RC_PICTURES_AND_TEXT
#define DEF_TT GEG_RC_ON
/* startup stuff */
#define DEF_XMIN -10
#define DEF_XMAX +10 
#define DEF_YMIN -10
#define DEF_YMAX +10
#define DEF_WIDTH 500
#define DEF_HEIGHT 500
/* misc stuff */
#define DEF_ZOOM 1.0
#define DEF_SPACE 45
#define DEF_MINRES 0.0001
#define DEF_MAXRES 10000.0
#define DEF_INTERP 0
#define DEF_MAXFORM 8
#define DEF_SPACING GEG_RC_DECIMAL
/* color stuff */
#define DEF_BACK_VALS { 0.1, 0.1, 0.4 }
#define DEF_NUMB_VALS { 0.8, 0.9, 1.0 }
#define DEF_AXES_VALS { 0.8, 0.7, 0.6 }
#define DEF_SEL_VALS  { 0.9, 0.8, 0.2 }
/* font stuff */  /* this is not selectable in the prefs yet */
#define DEF_NUMB_FONT "-*-symbol-*-*-*-*-*-*-*-*-*-*-*-*"
#define DEF_TEXT_FONT "-*-helvetica-medium-r-*-*-*-*-*-*-*-*-*-*"

typedef struct {
  /* toolbar stuff */
  gint tb;
  gint tt;
  /* startup stuff */
  gdouble xmin;
  gdouble xmax;
  gdouble ymin;
  gdouble ymax;
  gint width;
  gint height;
  gint spacing;
  /* misc stuff */
  gdouble zoom;
  gint space;
  gdouble minres;
  gdouble maxres;
  gint interp;
  gint maxform;
  /* colors */
  gdouble back_vals[3];
  gdouble numb_vals[3];
  gdouble axes_vals[3];
  gdouble sel_vals[3];
  /* fonts */
  gchar *text_font;
  gchar *numb_font;
} struct_prefs;

#endif /* __PREFS_H__ */

