/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 12 "src/parser/parser.ypp" /* yacc.c:339  */

#include <cstdint>
#include <cstdlib>
#include <iostream>
#include <vector>

#include "utils.hpp"
#include "parser/ast.hpp"
#include "proofs/dichotomy.hpp"
#include "parser/parser.hpp"

#define yyerror(msg) my_yyerror(yylloc, msg)

int yylex(YYSTYPE *yylval_param, YYLTYPE *yylloc_param);

#define error(msg) \
  std::cerr << "Error: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'
#define warning(msg) \
  std::cerr << "Warning: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'

int my_yyerror(YYLTYPE &yylloc, char const *errstr) {
    error(errstr);
    return EXIT_FAILURE;
}

#define failure(msg) do {\
  error(msg); \
  YYERROR; \
} while (0)

extern void register_user_rewrite(ast_real const *, ast_real const *, hint_cond_vect *);
extern void generate_all_approx();
extern void generate_graph(ast_prop const *p);
extern void parse_property_tree(property_tree &tree, ast_prop const *p);
extern void test_ringularity(ast_real const *, ast_real const *, bool);
extern int test_rewriting(ast_real const *, ast_real const *, std::string &);
extern void check_approx(ast_real const *);
extern std::set< ast_real const * > free_variables;
extern bool parameter_rfma;

static ast_number const *negative_number(ast_number const *nn) {
  if (nn->base == 0) return nn;
  ast_number n = *nn;
  char &c = n.mantissa[0];
  assert(c == '+');
  c = '-';
  return normalize(n);
}

static function_class const *rounding_mode = NULL;

static ast_real const *rnd_normalize(ast_real const &real) {
  ast_real const *r = normalize(real, true);
  if (!rounding_mode) return r;
  return normalize(ast_real(real_op(rounding_mode, r)), true);
}

static uintptr_t read_integer_param(ast_number const *n)
{
  return (static_cast<uintptr_t>(atoi(n->mantissa.c_str())) * 2) | 1;
}

static std::vector<function_generator *> user_functions;

RUN_LAST(free_generators) {
  for (std::vector<function_generator *>::const_iterator i = user_functions.begin(),
       i_end = user_functions.end(); i != i_end; ++i)
  {
    delete *i;
  }
  user_functions.clear();
}

#define YYINCLUDED_STDLIB_H


#line 143 "src/parser/parser.cpp" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "parser.hpp".  */
#ifndef YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED
# define YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    IDENT = 258,
    FUNID = 259,
    VARID = 260,
    IN = 261,
    NUMBER = 262,
    SQRT = 263,
    FMA = 264,
    NE = 265,
    LE = 266,
    GE = 267,
    RDIV = 268,
    FIX = 269,
    FLT = 270,
    IMPL = 271,
    OR = 272,
    AND = 273,
    NOT = 274,
    NEG = 275
  };
#endif
/* Tokens.  */
#define IDENT 258
#define FUNID 259
#define VARID 260
#define IN 261
#define NUMBER 262
#define SQRT 263
#define FMA 264
#define NE 265
#define LE 266
#define GE 267
#define RDIV 268
#define FIX 269
#define FLT 270
#define IMPL 271
#define OR 272
#define AND 273
#define NOT 274
#define NEG 275

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED

union YYSTYPE
{
#line 95 "src/parser/parser.ypp" /* yacc.c:355  */

  ast_number const	*number;
  ast_ident		*ident;
  ast_real const	*real;
  ast_real_vect		*reals;
  dichotomy_var		dvar;
  dvar_vect		*dvars;
  ast_prop		*prop;
  function_class const	*function;
  function_params	*params;
  uintptr_t		param;
  hint_cond		*precond;
  hint_cond_vect	*preconds;

#line 238 "src/parser/parser.cpp" /* yacc.c:355  */
};

typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (void);

#endif /* !YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 268 "src/parser/parser.cpp" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   351

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  41
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  22
/* YYNRULES -- Number of rules.  */
#define YYNRULES  78
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  188

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   275

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    39,     2,     2,     2,
      27,    29,    22,    20,    28,    21,     2,    23,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    37,
      35,    34,    36,    32,    38,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    30,     2,    31,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    25,    33,    26,    40,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    24
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   141,   141,   142,   145,   150,   152,   154,   156,   157,
     158,   160,   162,   163,   164,   170,   171,   172,   173,   174,
     177,   178,   179,   182,   189,   196,   197,   200,   201,   209,
     210,   213,   226,   227,   234,   235,   246,   254,   255,   256,
     257,   260,   261,   262,   271,   282,   283,   284,   285,   286,
     287,   288,   295,   296,   297,   300,   301,   308,   309,   312,
     313,   314,   317,   318,   325,   326,   327,   328,   329,   332,
     333,   340,   341,   343,   344,   364,   380,   387,   399
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENT", "FUNID", "VARID", "IN",
  "NUMBER", "SQRT", "FMA", "NE", "LE", "GE", "RDIV", "FIX", "FLT", "IMPL",
  "OR", "AND", "NOT", "'+'", "'-'", "'*'", "'/'", "NEG", "'{'", "'}'",
  "'('", "','", "')'", "'['", "']'", "'?'", "'|'", "'='", "'<'", "'>'",
  "';'", "'@'", "'$'", "'~'", "$accept", "BLOB", "BLOB1", "PROP",
  "SNUMBER", "INTEGER", "SINTEGER", "FUNCTION_PARAM",
  "FUNCTION_PARAMS_AUX", "FUNCTION_PARAMS", "FUNCTION", "EQUAL", "PROG",
  "REAL", "REALS", "DPOINTS", "DVAR", "DVARS", "PRECOND", "PRECONDS_AUX",
  "PRECONDS", "HINTS", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      43,    45,    42,    47,   275,   123,   125,    40,    44,    41,
      91,    93,    63,   124,    61,    60,    62,    59,    64,    36,
     126
};
# endif

#define YYPACT_NINF -125

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-125)))

#define YYTABLE_NINF -1

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -125,    10,  -125,    49,  -125,    92,    -2,  -125,  -125,   162,
     105,  -125,   -22,  -125,  -125,    -7,    33,    44,    88,   162,
     183,   193,   162,   214,   214,    64,  -125,    93,   139,   -16,
    -125,    -9,   214,    13,   252,    -6,  -125,  -125,     1,  -125,
     214,   214,   214,   214,  -125,  -125,   214,   214,  -125,  -125,
    -125,   289,   232,   247,   209,  -125,    20,   162,   162,   162,
     214,   214,    59,   214,    52,    52,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,  -125,   256,  -125,    36,
    -125,    97,   117,  -125,  -125,  -125,   120,    63,   299,   303,
     312,   228,   267,  -125,  -125,   214,  -125,    -1,   214,  -125,
     333,   112,  -125,    51,   325,   129,    52,  -125,   325,  -125,
    -125,   275,   186,    55,    55,  -125,  -125,   325,   262,   325,
      77,  -125,    96,  -125,  -125,     1,  -125,  -125,   214,    52,
     127,   281,  -125,    52,  -125,  -125,  -125,  -125,   115,   114,
     214,   116,  -125,  -125,  -125,  -125,   316,   149,   151,   164,
    -125,   135,    52,    52,  -125,   106,  -125,   146,  -125,   214,
    -125,  -125,   177,    52,  -125,   154,   165,    52,    52,    52,
      52,    52,  -125,   214,   288,  -125,  -125,  -125,    52,  -125,
    -125,  -125,  -125,  -125,  -125,  -125,   163,  -125
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      34,     0,    73,     0,     1,     2,     0,    38,    37,     0,
       0,    43,    29,    42,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,     0,    55,     0,
      32,     0,     0,     0,     0,     0,    40,    39,     0,    31,
       0,     0,     0,     0,    18,    20,     0,     0,    53,    20,
      54,     0,     0,     0,    59,    62,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    33,     0,     3,     0,
      26,     0,     0,    24,    25,    27,     0,     0,     0,     0,
       0,     0,     0,    19,    52,     0,    49,     0,     0,    77,
      17,    16,    15,     0,    55,     0,     0,     8,    14,     4,
       9,     0,    71,    45,    46,    47,    48,    13,     0,    56,
       0,    35,     0,    21,    22,     0,    30,    50,     0,     0,
       0,     0,    23,     0,    60,    63,    76,    44,     0,     0,
       0,     0,    78,    75,    36,    28,     0,     0,     0,     0,
      57,     0,     0,     0,    12,     0,    69,     0,    74,     0,
       5,     6,     0,     0,    61,     0,     0,     0,     0,     0,
       0,     0,    72,     0,     0,    11,    58,     7,     0,    64,
      65,    66,    67,    68,    70,    51,     0,    10
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -125,  -125,  -125,    -8,   -31,    69,  -124,    80,  -125,  -125,
      -3,  -125,  -125,    -5,   166,  -125,   126,   -51,    39,  -125,
    -125,  -125
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,    25,    26,   134,    84,    85,    86,    39,
      27,    32,     3,    34,    29,   151,    55,    56,   156,   157,
     141,     5
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      28,    33,    12,    31,    80,   147,   132,    83,    14,   103,
       4,    44,    74,    38,    51,    48,    50,    52,    53,    54,
      40,    81,    82,    75,   120,    76,   133,    77,    79,    57,
      58,    59,    30,   109,   110,    87,    88,    89,    90,    78,
      12,    91,    92,   179,   180,   181,   182,   183,    98,   100,
     101,   102,     6,     7,     8,    54,   104,    99,   108,    14,
      41,   111,   112,   113,   114,   115,   116,   117,   118,   119,
      54,    42,    81,    82,     9,   138,   122,    70,    71,    98,
      57,    58,    59,    68,    69,    70,    71,    10,   136,   106,
     131,   107,   127,    54,    83,    11,    12,    13,    83,    14,
      15,    16,   150,    60,   123,    98,    17,    18,    35,    36,
      37,    19,    20,    21,   143,    43,   167,   168,   169,    22,
      61,   165,   166,   146,   124,    23,    68,    69,    70,    71,
      59,    24,   176,   144,   132,   155,    83,    83,    83,    83,
      83,   170,   171,   152,   153,    62,   154,   186,   125,    63,
      64,    65,    66,   158,   174,    67,   126,    74,   137,    68,
      69,    70,    71,   163,   164,    11,    12,    13,   155,    14,
      15,    16,   172,    72,   173,   162,    17,    18,   160,    73,
     161,    19,    20,    21,   175,   177,    11,    12,    13,    22,
      45,    15,    16,   178,   187,    23,    11,    12,    13,   148,
      49,    15,    16,    20,    21,   145,    68,    69,    70,    71,
      46,   140,   184,    20,    21,    97,    47,    11,    12,    13,
      46,    14,    15,    16,   135,     0,    47,   105,     0,    68,
      69,    70,    71,     0,    20,    21,     0,     0,    62,     0,
       0,    46,    63,    64,    65,    66,     0,    47,    68,    69,
      70,    71,    68,    69,    70,    71,     0,    94,    62,     0,
      95,    94,    63,    64,    65,    66,    72,    68,    69,    70,
      71,     0,    68,    69,    70,    71,    68,    69,    70,    71,
      96,   139,    68,    69,    70,    71,    72,    68,    69,    70,
      71,     0,     0,   121,     0,    68,    69,    70,    71,   142,
      96,    68,    69,    70,    71,    57,    58,    59,    68,    69,
      70,    71,     0,     0,   149,     0,     0,   185,    93,    68,
      69,    70,    71,    68,    69,    70,    71,   128,     0,     0,
       0,   129,    68,    69,    70,    71,    68,    69,    70,    71,
     130,     0,     0,     0,   159,    68,    69,    70,    71,    57,
      58,    59
};

static const yytype_int16 yycheck[] =
{
       5,     9,     4,     6,     3,   129,     7,    38,     7,    60,
       0,    19,    28,    35,    22,    20,    21,    22,    23,    24,
      27,    20,    21,    39,    75,    34,    27,    32,    34,    16,
      17,    18,    34,    64,    65,    40,    41,    42,    43,    26,
       4,    46,    47,   167,   168,   169,   170,   171,    28,    57,
      58,    59,     3,     4,     5,    60,    61,    37,    63,     7,
      27,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    27,    20,    21,    25,   106,    79,    22,    23,    28,
      16,    17,    18,    20,    21,    22,    23,    38,    37,    30,
      95,    32,    29,    98,   125,     3,     4,     5,   129,     7,
       8,     9,   133,    39,     7,    28,    14,    15,     3,     4,
       5,    19,    20,    21,    37,    27,    10,    11,    12,    27,
      27,   152,   153,   128,     7,    33,    20,    21,    22,    23,
      18,    39,   163,    37,     7,   140,   167,   168,   169,   170,
     171,    35,    36,    28,    30,     6,    32,   178,    28,    10,
      11,    12,    13,    37,   159,    16,    36,    28,    29,    20,
      21,    22,    23,    28,    29,     3,     4,     5,   173,     7,
       8,     9,    26,    34,    28,    11,    14,    15,    29,    40,
      29,    19,    20,    21,     7,    31,     3,     4,     5,    27,
       7,     8,     9,    28,    31,    33,     3,     4,     5,   130,
       7,     8,     9,    20,    21,   125,    20,    21,    22,    23,
      27,    25,   173,    20,    21,     6,    33,     3,     4,     5,
      27,     7,     8,     9,    98,    -1,    33,    61,    -1,    20,
      21,    22,    23,    -1,    20,    21,    -1,    -1,     6,    -1,
      -1,    27,    10,    11,    12,    13,    -1,    33,    20,    21,
      22,    23,    20,    21,    22,    23,    -1,    29,     6,    -1,
      13,    29,    10,    11,    12,    13,    34,    20,    21,    22,
      23,    -1,    20,    21,    22,    23,    20,    21,    22,    23,
      33,     6,    20,    21,    22,    23,    34,    20,    21,    22,
      23,    -1,    -1,    37,    -1,    20,    21,    22,    23,    37,
      33,    20,    21,    22,    23,    16,    17,    18,    20,    21,
      22,    23,    -1,    -1,    33,    -1,    -1,    29,    29,    20,
      21,    22,    23,    20,    21,    22,    23,    28,    -1,    -1,
      -1,    28,    20,    21,    22,    23,    20,    21,    22,    23,
      28,    -1,    -1,    -1,    28,    20,    21,    22,    23,    16,
      17,    18
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    42,    43,    53,     0,    62,     3,     4,     5,    25,
      38,     3,     4,     5,     7,     8,     9,    14,    15,    19,
      20,    21,    27,    33,    39,    44,    45,    51,    54,    55,
      34,    51,    52,    44,    54,     3,     4,     5,    35,    50,
      27,    27,    27,    27,    44,     7,    27,    33,    54,     7,
      54,    44,    54,    54,    54,    57,    58,    16,    17,    18,
      39,    27,     6,    10,    11,    12,    13,    16,    20,    21,
      22,    23,    34,    40,    28,    39,    34,    54,    26,    34,
       3,    20,    21,    45,    47,    48,    49,    54,    54,    54,
      54,    54,    54,    29,    29,    13,    33,     6,    28,    37,
      44,    44,    44,    58,    54,    55,    30,    32,    54,    45,
      45,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      58,    37,    51,     7,     7,    28,    36,    29,    28,    28,
      28,    54,     7,    27,    46,    57,    37,    29,    45,     6,
      25,    61,    37,    37,    37,    48,    54,    47,    46,    33,
      45,    56,    28,    30,    32,    54,    59,    60,    37,    28,
      29,    29,    11,    28,    29,    45,    45,    10,    11,    12,
      35,    36,    26,    28,    54,     7,    45,    31,    28,    47,
      47,    47,    47,    47,    59,    29,    45,    31
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    41,    42,    43,    44,    44,    44,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
      45,    45,    45,    46,    47,    48,    48,    49,    49,    50,
      50,    51,    52,    52,    53,    53,    53,    53,    53,    53,
      53,    54,    54,    54,    54,    54,    54,    54,    54,    54,
      54,    54,    54,    54,    54,    55,    55,    56,    56,    57,
      57,    57,    58,    58,    59,    59,    59,    59,    59,    60,
      60,    61,    61,    62,    62,    62,    62,    62,    62
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     4,     3,     6,     6,     7,     3,     3,
       9,     7,     5,     3,     3,     3,     3,     3,     2,     3,
       1,     2,     2,     1,     1,     1,     1,     1,     3,     0,
       3,     2,     1,     2,     0,     5,     6,     2,     2,     3,
       3,     1,     1,     1,     4,     3,     3,     3,     3,     3,
       4,     8,     3,     2,     2,     1,     3,     1,     3,     1,
       3,     5,     1,     3,     3,     3,     3,     3,     3,     1,
       3,     0,     3,     0,     6,     5,     5,     4,     5
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static unsigned
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  unsigned res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  YYUSE (yylocationp);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yyls1, yysize * sizeof (*yylsp),
                    &yystacksize);

        yyls = yyls1;
        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 141 "src/parser/parser.ypp" /* yacc.c:1646  */
    { generate_all_approx(); }
#line 1596 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 3:
#line 142 "src/parser/parser.ypp" /* yacc.c:1646  */
    { generate_graph((yyvsp[-1].prop)); generate_all_approx(); }
#line 1602 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 4:
#line 146 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    real_op const *p = boost::get< real_op const >((yyvsp[-2].real));
    (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (!p || p->type != UOP_ABS) ? NULL : token_zero, (yyvsp[0].number)));
  }
#line 1611 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 5:
#line 151 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_fix((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1617 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 6:
#line 153 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_flt((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1623 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 7:
#line 155 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1629 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 8:
#line 156 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), NULL, NULL)); }
#line 1635 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 9:
#line 157 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (yyvsp[0].number), NULL)); }
#line 1641 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 10:
#line 159 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-8].real), (yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1647 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 11:
#line 161 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-5].real), (yyvsp[-3].real), negative_number((yyvsp[0].number)), (yyvsp[0].number))); }
#line 1653 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 12:
#line 162 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-4].real), (yyvsp[-2].real), NULL, NULL)); }
#line 1659 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 13:
#line 163 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))); }
#line 1665 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 14:
#line 165 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_number const *const *r = boost::get<ast_number const *const>((yyvsp[0].real));
    if (r && *r == token_zero) (yyval.prop) = new ast_prop(ast_atom_nzr((yyvsp[-2].real)));
    else (yyval.prop) = new ast_prop(new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))));
  }
#line 1675 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 15:
#line 170 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_AND,  (yyvsp[0].prop)); }
#line 1681 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 16:
#line 171 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_OR,   (yyvsp[0].prop)); }
#line 1687 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 17:
#line 172 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_IMPL, (yyvsp[0].prop)); }
#line 1693 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 18:
#line 173 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = new ast_prop((yyvsp[0].prop)); }
#line 1699 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 19:
#line 174 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.prop) = (yyvsp[-1].prop); }
#line 1705 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 20:
#line 177 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.number) = (yyvsp[0].number); }
#line 1711 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 21:
#line 178 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.number) = (yyvsp[0].number); }
#line 1717 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 22:
#line 179 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.number) = negative_number((yyvsp[0].number)); }
#line 1723 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 23:
#line 183 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1732 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 24:
#line 190 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1741 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 25:
#line 196 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.param) = read_integer_param((yyvsp[0].number)); }
#line 1747 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 26:
#line 197 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.param) = reinterpret_cast<uintptr_t>((yyvsp[0].ident)); }
#line 1753 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 27:
#line 200 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.params) = new function_params(1, (yyvsp[0].param)); }
#line 1759 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 28:
#line 202 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    function_params *p = (yyvsp[-2].params);
    p->push_back((yyvsp[0].param));
    (yyval.params) = p;
  }
#line 1769 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 29:
#line 209 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.params) = NULL; }
#line 1775 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 30:
#line 210 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.params) = (yyvsp[-1].params); }
#line 1781 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 31:
#line 214 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_ident *r = (yyvsp[-1].ident);
    function_class const *f;
    if (function_params *p = (yyvsp[0].params)) {
      f = (*r->fun)(*p);
      delete p;
    } else f = (*r->fun)(function_params());
    if (!f) failure("invalid parameters for '" << r->name << "'");
    (yyval.function) = f;
  }
#line 1796 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 33:
#line 228 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    function_class const *f = (yyvsp[-1].function);
    if (f->type != UOP_ID) failure("rounding operator expected, got '" << f->pretty_name() << "'");
    rounding_mode = f;
  }
#line 1806 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 35:
#line 236 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_ident *v = (yyvsp[-3].ident);
    ast_real const *r = (yyvsp[-1].real);
    if (v->type != ID_NONE) failure("redefinition of identifier '" << (yyvsp[-3].ident)->name << "'");
    v->type = ID_VAR;
    v->var = r;
    if (r->name) warning("renaming identifier '" << r->name->name << "' as '" << v->name << "'");
    r->name = v;
    rounding_mode = NULL;
  }
#line 1821 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 36:
#line 247 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_ident *v = (yyvsp[-3].ident);
    v->type = ID_FUN;
    function_generator *g = new default_function_generator((yyvsp[-1].function));
    v->fun = g;
    user_functions.push_back(g);
  }
#line 1833 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 37:
#line 254 "src/parser/parser.ypp" /* yacc.c:1646  */
    { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1839 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 38:
#line 255 "src/parser/parser.ypp" /* yacc.c:1646  */
    { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1845 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 39:
#line 256 "src/parser/parser.ypp" /* yacc.c:1646  */
    { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1851 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 40:
#line 257 "src/parser/parser.ypp" /* yacc.c:1646  */
    { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1857 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 41:
#line 260 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = normalize(ast_real((yyvsp[0].number)), true); }
#line 1863 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 42:
#line 261 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = (yyvsp[0].ident)->var; }
#line 1869 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 43:
#line 263 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_ident *v = (yyvsp[0].ident);
    v->type = ID_VAR;
    ast_real *r = normalize(ast_real(v), true);
    free_variables.insert(r);
    v->var = r;
    (yyval.real) = r;
  }
#line 1882 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 44:
#line 272 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    function_class const *f = (yyvsp[-3].function);
    ast_real_vect *ops = (yyvsp[-1].reals);
    if ((f->type == UOP_ID && ops->size() != 1) ||
        (f->type != UOP_ID && f->type != COP_FMA && ops->size() != 2) ||
        (f->type == COP_FMA && ops->size() != 3))
      failure("incorrect number of arguments for '" << f->pretty_name() << "'");
    (yyval.real) = normalize(ast_real(real_op(f, *ops)), true);
    delete ops;
  }
#line 1897 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 45:
#line 282 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_ADD, (yyvsp[0].real)))); }
#line 1903 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 46:
#line 283 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_SUB, (yyvsp[0].real)))); }
#line 1909 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 47:
#line 284 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_MUL, (yyvsp[0].real)))); }
#line 1915 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 48:
#line 285 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_DIV, (yyvsp[0].real)))); }
#line 1921 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 49:
#line 286 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = normalize(ast_real(real_op(UOP_ABS, (yyvsp[-1].real))), true); }
#line 1927 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 50:
#line 287 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = rnd_normalize(ast_real(real_op(UOP_SQRT, (yyvsp[-1].real)))); }
#line 1933 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 51:
#line 289 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    if (!parameter_rfma)
      (yyval.real) = rnd_normalize(ast_real(real_op(normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true), BOP_ADD, (yyvsp[-1].real))));
    else
      (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-1].real), BOP_ADD, normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true))));
  }
#line 1944 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 52:
#line 295 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = (yyvsp[-1].real); }
#line 1950 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 53:
#line 296 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = (yyvsp[0].real); }
#line 1956 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 54:
#line 297 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.real) = normalize(ast_real(real_op(UOP_NEG, (yyvsp[0].real))), true); }
#line 1962 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 55:
#line 300 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.reals) = new ast_real_vect(1, (yyvsp[0].real)); }
#line 1968 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 56:
#line 302 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    (yyvsp[-2].reals)->push_back((yyvsp[0].real));
    (yyval.reals) = (yyvsp[-2].reals);
  }
#line 1977 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 57:
#line 308 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.param) = fill_splitter(0, (yyvsp[0].number)); }
#line 1983 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 58:
#line 309 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.param) = fill_splitter((yyvsp[-2].param), (yyvsp[0].number)); }
#line 1989 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 59:
#line 312 "src/parser/parser.ypp" /* yacc.c:1646  */
    { dichotomy_var v = { (yyvsp[0].real), 0 }; (yyval.dvar) = v; }
#line 1995 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 60:
#line 313 "src/parser/parser.ypp" /* yacc.c:1646  */
    { dichotomy_var v = { (yyvsp[-2].real), read_integer_param((yyvsp[0].number)) }; (yyval.dvar) = v; }
#line 2001 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 61:
#line 314 "src/parser/parser.ypp" /* yacc.c:1646  */
    { dichotomy_var v = { (yyvsp[-4].real), (yyvsp[-1].param) }; (yyval.dvar) = v; }
#line 2007 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 62:
#line 317 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.dvars) = new dvar_vect(1, (yyvsp[0].dvar)); }
#line 2013 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 63:
#line 319 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    (yyvsp[-2].dvars)->push_back((yyvsp[0].dvar));
    (yyval.dvars) = (yyvsp[-2].dvars);
  }
#line 2022 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 64:
#line 325 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.precond) = new hint_cond(COND_NE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2028 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 65:
#line 326 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.precond) = new hint_cond(COND_LE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2034 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 66:
#line 327 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.precond) = new hint_cond(COND_GE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2040 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 67:
#line 328 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.precond) = new hint_cond(COND_LT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2046 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 68:
#line 329 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.precond) = new hint_cond(COND_GT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2052 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 69:
#line 332 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.preconds) = new hint_cond_vect(1, (yyvsp[0].precond)); }
#line 2058 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 70:
#line 334 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    (yyvsp[-2].preconds)->push_back((yyvsp[0].precond));
    (yyval.preconds) = (yyvsp[-2].preconds);
  }
#line 2067 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 71:
#line 340 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.preconds) = NULL; }
#line 2073 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 72:
#line 341 "src/parser/parser.ypp" /* yacc.c:1646  */
    { (yyval.preconds) = (yyvsp[-1].preconds); }
#line 2079 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 74:
#line 345 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    ast_real const *r1 = (yyvsp[-4].real), *r2 = (yyvsp[-2].real);
    hint_cond_vect *hc = (yyvsp[-1].preconds);
    test_ringularity(r1, r2, !hc);
    std::string info;
    int t = test_rewriting(r1, r2, info);
    if (t == 1) {
      warning("no need for the rewriting");
      std::cerr << "  if one of the following relations is present\n" << info;
    } else if (t == 2) {
      warning("no need for the rewriting");
      if (!info.empty())
        std::cerr << "  if all the following properties can be proved\n" << info;
    }
    check_approx(r1);
    register_user_rewrite(r1, r2, hc);
    register_approx(r1, r2);
    delete hc;
  }
#line 2103 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 75:
#line 365 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    ast_prop *p = NULL;
    for (ast_real_vect::const_iterator i = (yyvsp[-3].reals)->begin(), i_end = (yyvsp[-3].reals)->end();
         i != i_end; ++i)
    {
      ast_prop *q = new ast_prop(ast_atom_bnd(*i, NULL, NULL));
      if (!p) p = q;
      else p = new ast_prop(p, PROP_AND, q);
    }
    delete (yyvsp[-3].reals);
    parse_property_tree(h.dst, p);
    dichotomies.push_back(h);
  }
#line 2123 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 76:
#line 381 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    parse_property_tree(h.dst, (yyvsp[-3].prop));
    dichotomies.push_back(h);
  }
#line 2134 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 77:
#line 388 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    for (dvar_vect::iterator i = h.src.begin(),
         i_end = h.src.end(); i != i_end; ++i)
    {
      // no target property and no splitter, make it four-part by default
      if (!i->splitter) i->splitter = 9;
    }
    dichotomies.push_back(h);
  }
#line 2150 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;

  case 78:
#line 400 "src/parser/parser.ypp" /* yacc.c:1646  */
    {
    if (!register_approx((yyvsp[-3].real), (yyvsp[-1].real)))
      warning("relation already known");
  }
#line 2159 "src/parser/parser.cpp" /* yacc.c:1646  */
    break;


#line 2163 "src/parser/parser.cpp" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[1] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
