Prerequisites
-------------

You will need to have these libraries in order to build Gappa:
  - GMP    http://www.swox.com/gmp/
  - MPFR   http://www.mpfr.org/
  - Boost  http://www.boost.org/

Note that the Boost libraries do not have to be built, as Gappa depends
only on library headers.

You will also need to have Flex and Bison.

The `.tar.gz` file is distributed with a working set of configure files. They
are not in the git repository though. Consequently, if you are building from
git, you will need autoconf (>= 2.59).


Configuring, compiling, and installing
--------------------------------------

Ideally, you should just have to type:

    ./configure && ./remake

But due to Murphy's Law, it will most probably fail. If it does, look at the
following guidelines. First, the `./configure` script may need a few environment
variables. `CPPFLAGS` and `LDFLAGS` will be used to locate the libraries if they
are not in standard locations. `CXX` and `CXXFLAGS` define the compiler and its
compilation flags. Bloated example:

    ./configure "CXX=distcc g++" "CXXFLAGS=-O3" "CPPFLAGS=-I/usr/local/include" "LDFLAGS=-L/usr/local/lib"

If everything went well, the script should say it created the Makefile. So
you just have to launch `./remake` for Gappa to be compiled. As for the
installation, none is needed: `src/gappa` is a standalone executable file. But
if you still want to install it, `./remake install` will do the job. As for
the install location, this is standard `./configure` black magic, so I will
not explain any further and assume you know what you are doing. You can
always rely on `./configure --help` for additional information.

As a last tip, think about `./config.status -V` if you already installed an
older version of Gappa. The output of this script will give you the command-
line you used the last time you ran `./configure` in its directory.


Documentation
-------------

The online documentation may be generated by `./remake doc/html/index.html`.
You will need `xsltproc` and `dblatex`. Their locations can be provided by
`./configure` magic.
