
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <stdlib.h>
#include <string.h>

#include "runtime.h"


/* system()-- Make an operating system call (extension) */

#define system_s prefix(system_s)

void system_s(char *string, int *status, int len) {
char *p;
int m;

    p = get_mem(len+1);
    memcpy(p, string, len);
    p[len] = '\0';

    flush_units();
    m = system(p);
    if (status != NULL)
	*status = m;

    free_mem(p);
}


#define system_f prefix(system_f)

G95_DINT system_f(char *string, int len) {
G95_DINT status;
char *p;

    p = get_mem(len+1);
    memcpy(p, string, len);
    p[len] = '\0';

    flush_units();
    status = system(p);
    free_mem(p);

    return status;
}
