
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the ALL() intrinsic */


#ifdef SUBROUTINE

TYPE SUBROUTINE(g95_array_descriptor *mask) {
G95_AINT extent, index[G95_MAX_DIMENSIONS];
int i, rank;
char *p;

    rank = mask->rank;

    for(i=0; i<rank; i++) {
	extent = mask->info[i].ubound - mask->info[i].lbound + 1;
	if (extent <= 0)
	    return 1;

	index[i] = mask->info[i].lbound;
    }

    for(;;) {
	p = mask->offset;
	for(i=0; i<rank; i++)
	    p += mask->info[i].mult * index[i];

	if (!(*((TYPE *) p)))
	    return 0;

	if (bump_element(mask, index))
	    break;
    }

    return 1;
}


g95_array_descriptor *SUBROUTINE_D(g95_array_descriptor *mask, int *dim_p) {
G95_AINT extent, index[G95_MAX_DIMENSIONS];
int i, m, dim, rank, zero_size;
g95_array_descriptor *result;
char *q1, *q2;
TYPE *p;

    rank = mask->rank;    /* rank is guaranteed to be > 1 */

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;      /* dim is now zero-based */

    section_info[0] = rank - 1;
    section_info[1] = mask->element_size;

    zero_size = 0;
    m = 2;

    for(i=0; i<rank; i++) {
	index[i] = mask->info[i].lbound;

	extent = mask->info[i].ubound - mask->info[i].lbound + 1;
	if (extent <= 0)
	    zero_size = 1;

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q1 = mask->offset;
	for(i=0; i<mask->rank; i++) {
	    if (i == dim)
		continue;

	    q1 += mask->info[i].mult * index[i];
	}

	m = 1;

	for(i=mask->info[dim].lbound; i<=mask->info[dim].ubound; i++) {
	    q2 = q1 + mask->info[dim].mult * i;
	    if (!(*(TYPE *) q2)) {
		m = 0;
		break;
	    }
	}

	*p++ = (TYPE) m;

	if (bump_element_dim(mask, index, dim))
	    break;
    }

    return result;
}

#undef SUBROUTINE
#undef SUBROUTINE_D
#undef TYPE

#else
#include "runtime.h"

#define SUBROUTINE prefix(all_1)
#define SUBROUTINE_D prefix(alld_1)
#define TYPE G95_INT1
#include "all.c"

#define SUBROUTINE prefix(all_2)
#define SUBROUTINE_D prefix(alld_2)
#define TYPE G95_INT2
#include "all.c"

#define SUBROUTINE prefix(all_4)
#define SUBROUTINE_D prefix(alld_4)
#define TYPE G95_INT4
#include "all.c"

#ifdef G95_INT8
#define SUBROUTINE prefix(all_8)
#define SUBROUTINE_D prefix(alld_8)
#define TYPE G95_INT8
#include "all.c"
#endif

#ifdef G95_INT16
#define SUBROUTINE prefix(all_16)
#define SUBROUTINE_D prefix(alld_16)
#define TYPE G95_INT16
#include "all.c"
#endif

#endif
