/*
 * tvmenu.h
 *
 * API to build and maintain the app menubar.
 *
 * (C) 1997 Randall Hopper
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __TVMENU_H
#define __TVMENU_H

#include <X11/Intrinsic.h>
#include "tvtypes.h"
#include "tvcapture.h"
#include "app_rsrc.h"
#include "glob.h"

typedef enum {
    TV_MENUITEM_FILE_IMGSAVE = 0,
    TV_MENUITEM_FILE_IMGSAVEAS,
    TV_MENUITEM_FILE_AUDSAVEAS,
    TV_MENUITEM_FILE_VIDSAVEAS,
    TV_MENUITEM_FILE_PRINT,
    TV_MENUITEM_FILE_PRINTSETUP,
    TV_MENUITEM_FILE_QUIT,
    TV_MENUITEM_INPUT_APPEARANCE,
    TV_MENUITEM_INPUT_TUNER,
    TV_MENUITEM_INPUT_VIDEO,
    TV_MENUITEM_INPUT_SVIDEO,
    TV_MENUITEM_INPUT_CSVIDEO,
    TV_MENUITEM_INPUT_DEV3,
    TV_MENUITEM_TMODE_ANTENNA,
    TV_MENUITEM_TMODE_CABLE,
    TV_MENUITEM_AUDINP_AUTO,
    TV_MENUITEM_AUDINP_INTERN,
    TV_MENUITEM_FORMAT_NTSCM,
    TV_MENUITEM_FORMAT_NTSCJ,
    TV_MENUITEM_FORMAT_PALBDGHI,
    TV_MENUITEM_FORMAT_PALM,
    TV_MENUITEM_FORMAT_PALN,
    TV_MENUITEM_FORMAT_SECAM,
    TV_MENUITEM_FORMAT_PALNCOMB,
    TV_MENUITEM_OPTIONS_ASPECT,
    TV_MENUITEM_OPTIONS_AFC,
    TV_MENUITEM_OPTIONS_SAVE,
    TV_MENUITEM_HELP_ABOUT,
       TV_NUM_MENUITEMS
} TV_MENUITEM_KEY;


typedef enum {
    TV_TOOLITEM_FREEZE   = 0,
    TV_TOOLITEM_FULLSCREEN,
    TV_TOOLITEM_MUTE,
    TV_TOOLITEM_CHANUP,
    TV_TOOLITEM_CHANTEXT,
    TV_TOOLITEM_CHANDOWN, 
      TV_NUM_TOOLITEMS
} TV_TOOLITEM_KEY;


#ifdef __cplusplus
extern "C" {
#endif

Widget TVMENUCreate( Widget parent );

Widget TVTOOLSCreate( Widget parent );

void TVTOOLSSetToggleState( TV_TOOLITEM_KEY key,
                            TV_BOOL            state );

Widget TVTOOLSGetVolumeScrollbar( void );

void TVMENUSetSelectedInputDevice( TV_INPUT_DEVICE dev );

void TVMENUSetSelectedInputFormat( TV_INPUT_FORMAT fmt );

void TVMENUSetSelectedAudioInputDevice( TV_AUDIO_INPUT_DEVICE dev );

void TVMENUSetSelectedAfcMode( TV_BOOL afc );

void TVMENUSetSelectedAspectLock( TV_BOOL aspect_lock );

void TVMENUSetSelectedTunerMode( TV_TUNER_MODE mode );

void TVMENUResync();

void TVTOOLSSetStationText( char str[] );

void TVTOOLSResync();

#ifdef __cplusplus
}  /* Close 'extern "C"' */
#endif

#endif
