#include "simplestdetector.h"

Detector::LangList SimplestDetector::langList;

const Detector::LangList &SimplestDetector::getLanguages()
{
if(langList.empty())
  {
  LangInfo info={"ru","Russian"};
  langList.push_back(info);
  }
return langList;
}

SimplestDetector::SimplestDetector(const string &aDefaultCharset):
                  Detector(aDefaultCharset,"ru"),wins(0),pes(0)
{
}

void SimplestDetector::scan(const string &s)
{
Detector::scan(s);
for(string::const_iterator i=s.begin();i!=s.end();i++)
   {
   int c=(unsigned char)*i;
   if(c>=0xe0 && c<=0xff)
     wins++;
   if(c==0xd0)
     pes++;
   }
}

string SimplestDetector::getCharset() const
{
if(total>=20) // Lower bound for autodetection
  if(pes*3>=total)
    return "utf-8";
  else
    if(wins*2>=total)
      return "Windows-1251";
    else
      return "koi8-r";
else
  return defaultCharset;
}
