// @(#) $Id: input.cc,v 1.2 2003/07/29 23:29:11 balu Exp $

#include "input.h"
#include <iostream>
#include <fstream>

/* Input */

void Input::setEof(bool aEof)
{
eof=aEof;
}

Input::Input():
       eof(false)
{
}

bool Input::isEof() const
{
return eof;
}

Input::operator void *() const
{
return (void *)!isEof();
}

/* InputFile */

void InputFile::next()
{
if(!in)
  return;
if(!*in)
  if(list==NULL)
    {
    setEof(true);
    return;
    }
  else
    {
    delete in;
    in=NULL;
    current++;
    if(current==list->end())
      {
      setEof(true);
      return;
      }
    else
      in=new ifstream(current->c_str());
    }
getline(*in,line);
}

InputFile::InputFile(FileList *aList):
           list(aList),in(NULL)
{
if(list && list->empty())
  list=NULL;
if(list==NULL)
  in=&cin;
else
  {
  current=list->begin();
  in=new ifstream(current->c_str());
  }
next();
}

string &InputFile::getLine()
{
return line;
}

string InputFile::nextLine()
{
string s=line;
next();
return s;
}

/* InputFilter */

InputFilter::InputFilter(Input *anUpper)
{
upper=anUpper;
}

Input *InputFilter::getUpper() const
{
return upper;
}

string &InputFilter::getLine()
{
return upper->getLine();
}

string InputFilter::nextLine()
{
if(!isEof())
  if(!upper->isEof())
    {
    string s=upper->nextLine();
    if(isBoundary())
      setEof(true);
    return s;
    }
  else
    setEof(true);
return getLine();
}

/* FromFilter */

bool FromFilter::isBoundary()
{
const char *from="From ";
return getLine().substr(0,strlen(from))==from;
}

FromFilter::FromFilter(Input *upper):
            InputFilter(upper)
{
}

/* BoundaryFilter */

bool BoundaryFilter::isBoundary()
{
return getLine().substr(0,boundary.length()+2)=="--"+boundary;
}

BoundaryFilter::BoundaryFilter(Input *input,const string &aBoundary):
                InputFilter(input),boundary(aBoundary)
{
}
