#include <config.h>
#include "detector.h"
#ifdef HAVE_ENCA
#include "encadetector.h"
#else
#include "simplestdetector.h"
#endif
#include <ctype.h>
#include <algorithm>

Detector *Detector::defaultDetector(const string &defaultCharset,
                                    const string &lang)
{
#ifdef HAVE_ENCA
return new ENCADetector(defaultCharset,lang);
#else
return new SimplestDetector(defaultCharset);
#endif
}

const Detector::LangList &Detector::getLanguages()
{
#ifdef HAVE_ENCA
return ENCADetector::getLanguages();
#else
return SimplestDetector::getLanguages();
#endif
}

bool Detector::isLanguageValid(const string &code)
{
const LangList &langs=getLanguages();
return find(langs.begin(),langs.end(),code)!=langs.end();
}

string Detector::getDetectorName()
{
#ifdef HAVE_ENCA
return "ENCA";
#else
return "built-in";
#endif
}

Detector::Detector(const string &aDefaultCharset,const string &aLang):
          defaultCharset(aDefaultCharset),lang(aLang),total(0)
{
}

Detector::~Detector()
{
}

void Detector::scan(const string &s)
{
for(string::const_iterator i=s.begin();i!=s.end();i++)
   {
   int c=(unsigned char)*i;
   if(c>=0x80 && c<=0xff)
     total++;
   }
}

bool Detector::isAscii() const
{
return total==0; // Only characters 0x00-0x7F
}

bool operator ==(const Detector::LangInfo &info,const string &code)
{
return info.code.length()==code.length() && code.length()>=2 &&
       tolower(info.code[0])==tolower(code[0]) &&
       tolower(info.code[1])==tolower(code[1]);
}

string canonCharset(const string &s)
{
string c;

for(string::const_iterator i=s.begin();i!=s.end();i++)
   if(*i!='-' && *i!='_')
     c+=tolower(*i);
return c;
}

bool isSameCharset(const string &cs1,const string &cs2)
{
return canonCharset(cs1)==canonCharset(cs2);
}
