// @(#) $Id: decoder.cc,v 1.7 2003/08/28 18:45:38 balu Exp $

#include "decoder.h"

unsigned char base64_rank[256]=
       {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255, 62,255,255,255, 63,
	 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,255,255,255,  0,255,255,
	255,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
	 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,255,255,255,255,255,
	255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
	 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
char base64_code[65]="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                     "abcdefghijklmnopqrstuvwxyz"
                     "0123456789+/";

int hexchar(char c)
{
return c<='9' ? c-'0' : c-'A'+10;
}

string decodeQuotedPrintable(const string &s)
{
string c;

for(string::const_iterator i=s.begin();i!=s.end();i++)
   if(*i=='_')
     c+=' ';
   else
     if(*i!='=')
       c+=*i;
     else
       if(i+1!=s.end() && i+2!=s.end())
         {
         c+=hexchar(*(i+1))*16+hexchar(*(i+2));
         i+=2;
         }
       else
         break;
return c;
}

// Based on libgmime2 algorithm
string decodeBase64(const string &s)
{
string c;
unsigned int saved=0;
short int state=0;
string::const_iterator i;

// convert 4 base64 bytes to 3 normal bytes
for(i=s.begin();i!=s.end();i++)
   {
   unsigned int n=base64_rank[(unsigned char)*i];
   if(n!=0xff)
     {
     saved=(saved<<6) | n;
     state++;
     if(state==4)
       {
       c+=saved >> 16;
       c+=saved >> 8;
       c+=saved;
       state=0;
       }
     }
   }

// quick scan back for '=' on the end somewhere
// fortunately we can drop 1 output char for each trailing = (upto 2)
state=2;
int len=c.length();
i=s.end();
while(i!=s.begin() && state)
     {
     i--;
     if(base64_rank[(unsigned char)*i]!=0xff)
       {
       if(*i=='=' && len>0)
         len--;
       state--;
       }
     }
c.resize(len);
return c;
}

string encodeBase64(const string &s)
{
string c;
unsigned int saved=0;
short int state=0;

for(string::const_iterator i=s.begin();i!=s.end();i++)
   {
   saved=(saved<<8) | (unsigned char)*i;
   state+=8;
   while(state>=6)
        {
        state-=6;
        c+=base64_code[(saved>>state) & 0x3f];
        }
   }
switch(state)
      {
      case 2:
           c+=base64_code[(saved & 0x3)<<4];
           c+="==";
           break;
      case 4:
           c+=base64_code[(saved & 0xf)<<2];
           c+="=";
           break;
      }
return c;
}

string decode(const string &s,int enc)
{
switch(enc)
      {
      case TE_QUOTED_PRINTABLE:
           return decodeQuotedPrintable(s);
      case TE_BASE64:
           return decodeBase64(s);
      default:
           return s;
      }
}

string encode(const string &s)
{
return encodeBase64(s);
}

string decodeWord(const string &s)
{
int n=s.find('?',2);
string c=s.substr(n+3,s.length()-n-5);
switch(s[n+1])
      {
      case 'q':
      case 'Q':
           return decodeQuotedPrintable(c);
           break;
      case 'b':
      case 'B':
           return decodeBase64(c);
           break;
      }
return "";
}

bool isRFCSpace(char c)
{
static const char spaces[]=" \t()<>@,;:'\"/[]?.=";

return strchr(spaces,c)!=NULL;
}

string getRFCWord(const string &s,string::const_iterator p)
{
string::const_iterator i=p+1;

for(;i!=s.end();i++)
   switch(*i)
         {
         case '=':
              if((i+1==s.end() || isRFCSpace(*(i+1))) && *(i-1)=='?')
                return string(p,i+1);
              break;
         case ' ':
         case '\t':
         case '\n':
         case '\r':
              return string();
         }
return string();
}

string decodeHeader(const string &s)
{
string c,space;
bool midspace=false;

for(string::const_iterator i=s.begin();i!=s.end();i++)
   switch(*i)
         {
         case ' ':
         case '\t':
         case '\n':
         case '\r':
              if(midspace)
                space+=*i;
              else
                c+=*i;
              break;
         case '=':
              if((i==s.begin() || isRFCSpace(*(i-1))) &&
                 i+1!=s.end() && *(i+1)=='?')
                {
                string ss=getRFCWord(s,i);
                if(ss.length()!=0)
                  {
                  c+=decodeWord(ss);
                  i+=ss.length()-1;
                  midspace=true;
                  space=string();
                  break;
                  }
                }
         default:
              if(midspace)
                {
                midspace=false;
                c+=space;
                space=string();
                }
              c+=*i;
         }
return c;
}
