/*
  setup.h
  
  for FInal Battle
  
  By Mike Hufnagel and Bill Kendrick
  Previously modified: 11/19/95 (clean up)
  Last modified: 11/3/97
  
  Handles setup of game etc.
*/

#ifndef SETUP_H
#define SETUP_H

void setup(int argc, char *argv[]);
/* 
   Begin a new game, accepting a list of player names and their servers to be
   the starting players, or add to a running game, accepting a player name,
   the server to start the new player on, and the server where the first
   starting player is at. 
*/

int add(int pln, int x, int y);
/* 
   Adds a new player ("pln").  Opens connection to the server, opens the game
   windows, sets the player's defaults (position, direction, status, etc.).
   The server, player's name, etc. are provided and accessed via global arrays
   reference by "pln".
   X and Y are the starting location for the action window.
*/


void initstate(int i);
/*
  Init's a player's state.  (Good for beginning of game or when they
  die and are reincarnated.)
*/

#endif /* SETUP_H */
