/*
  movement.c
  
  for Final Battle
  
  Mike Hufnagel & Bill Kendrick
  Previously modified: 12/8/95
  Last modified: 4/2/98
*/


#include <math.h>
#include "const.h"
#include "glovar.h"
#include "math.h"
#include "movement.h"
#include "types.h"
#include "weaponwin.h"
#include "misc.h"
#include "weapons.h"
#include "event.h"
#include "upgradewin.h"


/* Local prototypes */

int distance_between(int x1, int y1, int x2, int y2);
void getupgrade(int pln, int u);


void collision(int pln)
{
  int i;
  
  
  /* See if you hit an asteroid: */
  
  for (i = 0; i < NUM_ASTEROIDS; i++)
    {
      if (asteroid[i].exist)
	{
	  if ((player[pln].x >= asteroid[i].x - 32) &&
	      (player[pln].x <= asteroid[i].x + 32) &&
	      (player[pln].y >= asteroid[i].y - 32) &&
	      (player[pln].y <= asteroid[i].y + 32))
	    {
	      hurt(pln, asteroid[i].xm, asteroid[i].ym, 2);
	      asteroid[i].exist = 0;
	    }
	}
    }
  

  /* See if you hit a drone: */
  
  for (i = 0; i < NUM_DRONES; i++)
    {
      if (drone[i].exist)
	{
	  if ((player[pln].x >= drone[i].x - 32) &&
	      (player[pln].x <= drone[i].x + 32) &&
	      (player[pln].y >= drone[i].y - 32) &&
	      (player[pln].y <= drone[i].y + 32))
	    {
	    hurt(pln, drone[i].xm, drone[i].ym, 2);
	    drone[i].exist = 0;
	    }
	}
    }
  

  /* See if you picked up an upgrade: */
  
  for (i = 0; i < NUM_UPGRADES; i++)
    {
      if (upgrade[i].exist)
	{
	  if ((player[pln].x >= upgrade[i].x - 32) &&
	      (player[pln].x <= upgrade[i].x + 32) &&
	      (player[pln].y >= upgrade[i].y - 32) &&
	      (player[pln].y <= upgrade[i].y + 32))
	    getupgrade(pln, i);
	}
    }
  
  
  /* See if you hit another player: */
  
  for (i = 0; i < SERV; i++)
    {
      if (player[i].exist && i != pln)
	{
	  if ((player[pln].x >= player[i].x - 32) &&
	      (player[pln].x <= player[i].x + 32) &&
	      (player[pln].y >= player[i].y - 32) &&
	      (player[pln].y <= player[i].y + 32))
	    {
	      hurt(pln, player[i].xm, player[i].ym, 5);
	      hurt(i, player[pln].xm, player[pln].ym, 5);
	    }
	}
    }
  
  
  /* See if you hit a wormhole: */
  
  wormholetest(&player[pln].x, &player[pln].y, 0);
}


void moveasteroid(void)
{
  int j;
  
  
  /* Asteroid control */
  
  for (j = 0; j < NUM_ASTEROIDS; j++)
    {
      if (asteroid[j].exist)
	{
	  /* Move the asteroid */
	  
	  asteroid[j].x = asteroid[j].x + asteroid[j].xm;
	  if (asteroid[j].x > WIDTH_OF_WORLD)
	    asteroid[j].x = 0;
	  if (asteroid[j].x < 0)
	    asteroid[j].x = WIDTH_OF_WORLD;
	  
	  asteroid[j].y = asteroid[j].y + asteroid[j].ym;
	  if (asteroid[j].y > HEIGHT_OF_WORLD)
	    asteroid[j].y = 0;
	  if (asteroid[j].y < 0)
	    asteroid[j].y = HEIGHT_OF_WORLD;
	  
	  
	  /* Handle its animation */
	  
	  asteroid[j].rotation = (asteroid[j].rotation +
				  asteroid[j].rotationm);
	  
	  while (asteroid[j].rotation > 15)
	    asteroid[j].rotation -= 16;
	  while (asteroid[j].rotation < 0)
	    asteroid[j].rotation += 16;	  


	  /* See if it hit a wormhole: */
	  
	  wormholetest(&asteroid[j].x, &asteroid[j].y, 1);
	}
    } /* (for NUM_ASTEROIDS) */ 
}


void movedrone(void)
{
  int j, opln;
  
  
  /* Drone control */
  
  for (j = 0; j < NUM_DRONES; j++)
    {
      if (drone[j].exist)
	{
	  /* Move the drone */
	  
	  drone[j].x = drone[j].x + drone[j].xm;
	  if (drone[j].x > WIDTH_OF_WORLD)
	    drone[j].x = 0;
	  if (drone[j].x < 0)
	    drone[j].x = WIDTH_OF_WORLD;
	  
	  drone[j].y = drone[j].y + drone[j].ym;
	  if (drone[j].y > HEIGHT_OF_WORLD)
	    drone[j].y = 0;
	  if (drone[j].y < 0)
	    drone[j].y = HEIGHT_OF_WORLD;
	
	  
	  /* Make drone home: */
	  
	  if (drone[j].homeship != -1 && rndm(CHANCE_DRONE_ROTATE) < 1 &&
	      player[drone[j].homeship].cloaked == 0)
	    {
	      if (drone[j].x < player[drone[j].homeship].x && drone[j].xm < 16)
		drone[j].xm++;
	      else if (drone[j].x > player[drone[j].homeship].x &&
		       drone[j].xm > -16)
		drone[j].xm--;
	      
	      if (drone[j].y < player[drone[j].homeship].y && drone[j].ym < 16)
		drone[j].ym++;
	      else if (drone[j].y > player[drone[j].homeship].y &&
		       drone[j].ym > -16)
		drone[j].ym--;
	    }
	  
	  
	  /* Maybe home on someone else? */
	  
	  drone[j].hometime--;
	  
	  if (drone[j].hometime <= 0)
	    resetdrone(j);
	  
	  
	  /* Maybe fire at someone? */
	  
	  for (opln = 0; opln < SERV; opln++)
	    {
	      if (player[opln].exist == 1 &&
		  player[opln].x > drone[j].x - DRONE_FIRING_PROXIMITY &&
		  player[opln].x < drone[j].x + DRONE_FIRING_PROXIMITY &&
		  player[opln].y > drone[j].y - DRONE_FIRING_PROXIMITY &&
		  player[opln].y < drone[j].y + DRONE_FIRING_PROXIMITY &&
		  rndm(CHANCE_DRONE_FIRE) < 1 &&
		  player[opln].cloaked != CLOAK_TOTAL)
		{
		  dronefireweapon(j, opln);
		}
	    }


	  /* See if it hit a wormhole: */
	  
	  wormholetest(&drone[j].x, &drone[j].y, 1);
	}
    } /* (for NUM_DRONES) */ 
}


void movedebris(void)
{
  int opln;
  

  /* Debris control */
  
  for (opln = 0; opln < NUM_DEBRIS; opln++)
    {
      if (debris[opln].exist)
	{
	  /* Move the debris */
	  
	  debris[opln].x = debris[opln].x + debris[opln].xm;
	  if (debris[opln].x > WIDTH_OF_WORLD)
	    debris[opln].x = 0;
	  if (debris[opln].x < 0)
	    debris[opln].x = WIDTH_OF_WORLD;
	  
	  debris[opln].y = debris[opln].y + debris[opln].ym;
	  if (debris[opln].y > HEIGHT_OF_WORLD)
	    debris[opln].y = 0;
	  if (debris[opln].y < 0)
	    debris[opln].y = HEIGHT_OF_WORLD;
	  
	  
	  /* Debris disappears after a while: */
	  
	  debris[opln].range--;
	  if (debris[opln].range <= 0)
	    debris[opln].exist = 0;
	}
    } /* (for NUM_DEBRIS) */
}


void movedeadman(void)
{
  int opln;
  

  /* Deadman control */
  
  for (opln = 0; opln < NUM_DEADMAN; opln++)
    {
      if (deadman[opln].exist)
	{
	  /* Move the deadman */
	  
	  deadman[opln].x = deadman[opln].x + deadman[opln].xm;
	  if (deadman[opln].x > WIDTH_OF_WORLD)
	    deadman[opln].x = 0;
	  if (deadman[opln].x < 0)
	    deadman[opln].x = WIDTH_OF_WORLD;
	  
	  deadman[opln].y = deadman[opln].y + deadman[opln].ym;
	  if (deadman[opln].y > HEIGHT_OF_WORLD)
	    deadman[opln].y = 0;
	  if (deadman[opln].y < 0)
	    deadman[opln].y = HEIGHT_OF_WORLD;
	  
	  
	  /* Deadman disappears after a while: */
	  
	  deadman[opln].range--;
	  if (deadman[opln].range <= 0)
	    deadman[opln].exist = 0;


	  /* See if it hit a wormhole: */
	  
	  wormholetest(&deadman[opln].x, &deadman[opln].y, 1);
	}
    } /* (for NUM_DEADMAN) */
}


void moveship(int pln)
{
  int want_xm, want_ym, want_dir;
  
  
  /* If they're tracking (homing in on) a ship, update their homing
     positions to match that of the ship: */
  
  if (player[pln].homingmode == HOME_HOMING)
    {
      if (player[player[pln].homeship].exist &&
	  (player[player[pln].homeship].cloaked == 0 ||
	   player[pln].cloakradar))
	{
	  player[pln].homex = player[player[pln].homeship].x;
	  player[pln].homey = player[player[pln].homeship].y;
	}
      else
	{
	  message(pln, GOD, "Ship tracking aborted: Ship gone");
	  player[pln].homingmode = HOME_NONE;
	}
    }


  /* See if they want to be homing any more: */
  
  if (player[pln].homingmode != HOME_NONE)
    {
      if (player[pln].x > player[pln].homex - STOP_HOME_RANGE &&
	  player[pln].x < player[pln].homex + STOP_HOME_RANGE &&
	  player[pln].y > player[pln].homey - STOP_HOME_RANGE &&
	  player[pln].y < player[pln].homey + STOP_HOME_RANGE)
	stophoming(pln);
    }
  
  
  /* Adjust their direction if they're tracking a ship ("home") or homing-in
     on a point ("auto-pilot") */
  
  if (player[pln].homingmode != HOME_NONE)
    {
      /* Find out what direction they want to be facing: */
      
      want_xm = 0;
      want_ym = 0;
      
      if (player[pln].x < player[pln].homex)
	want_xm = 1;
      else if (player[pln].x > player[pln].homex)
	want_xm = -1;
      
      if (player[pln].y < player[pln].homey)
	want_ym = 1;
      else if (player[pln].y > player[pln].homey)
	want_ym = -1;
      
      
      if (want_xm == 0 && want_ym == -1)
	want_dir = 0;
      else if (want_xm == 1 && want_ym == -1)
	want_dir = 2;
      else if (want_xm == 1 && want_ym == 0)
	want_dir = 4;
      else if (want_xm == 1 && want_ym == 1)
	want_dir = 6;
      else if (want_xm == 0 && want_ym == 1)
	want_dir = 8;
      else if (want_xm == -1 && want_ym == 1)
	want_dir = 10;
      else if (want_xm == -1 && want_ym == 0)
	want_dir = 12;
      else if (want_xm == -1 && want_ym == -1)
	want_dir = 14;
      
      
      if (player[pln].dir != want_dir &&
	  (player[pln].damage[DAM_THRUST] == OK ||
	   (player[pln].damage[DAM_THRUST] == DAMAGED &&
	    (rndm(10) < 5))))
	{
	  if (player[pln].dir < want_dir)
	    {
	      player[pln].dir = player[pln].dir + 1;
	      if (player[pln].dir > 15)
		player[pln].dir = 0;
	    }
	  else
	    {
	      player[pln].dir = player[pln].dir - 1;
	      if (player[pln].dir < 0)
		player[pln].dir = 15;
	    }
	}
      
      
      /* Fire their engines: */
      
      if (player[pln].dir == want_dir)
	{
	  if (player[pln].damage[DAM_ENGINE] == OK ||
	      (player[pln].damage[DAM_ENGINE] == DAMAGED &&
	       (rndm(10) < 5)))
	    {
	      player[pln].xm += xmove[player[pln].dir];
	      player[pln].ym += ymove[player[pln].dir];
	      
	      if (player[pln].xm >= player[pln].max)
		player[pln].xm = player[pln].max;
	      else if (player[pln].xm <= -player[pln].max)
		player[pln].xm = -player[pln].max;
	      
	      if (player[pln].ym >= player[pln].max)
		player[pln].ym = player[pln].max;
	      else if (player[pln].ym <= -player[pln].max)
		player[pln].ym = -player[pln].max;
	    }
	}
    }
  
  
  /* Move the ship in the direction it's flying:*/
  
  player[pln].x = player[pln].x + player[pln].xm;
  player[pln].y = player[pln].y + player[pln].ym;
  
  
  if (WORLD_WRAP == 0)
    {
      /* Keep them in bounds */
      
      if (player[pln].x < 16)
	{
	  player[pln].x = 16;
	  player[pln].xm = 0;
	}
      else if (player[pln].x > WIDTH_OF_WORLD - 16)
	{
	  player[pln].x = WIDTH_OF_WORLD - 16;
	  player[pln].xm = 0;
	}
      if (player[pln].y < 16)
	{
	  player[pln].y = 16;
	  player[pln].ym = 0;
	}
      else if (player[pln].y > HEIGHT_OF_WORLD - 16)
	{
	  player[pln].y = HEIGHT_OF_WORLD - 16;
	  player[pln].ym = 0;
	}  
    }
  else
    {
      /* Wrap them: */
      
      if (player[pln].x < 16)
	player[pln].x = WIDTH_OF_WORLD - 16;
      else if (player[pln].x > WIDTH_OF_WORLD - 16)
	  player[pln].x = 16;
      if (player[pln].y < 16)
	player[pln].y = WIDTH_OF_WORLD - 16;
      else if (player[pln].y > HEIGHT_OF_WORLD - 16)
	player[pln].y = 16;
    }
}


void moveupgrades(void)
{
  int j;


  /* Upgrade control */
  
  for (j = 0; j < NUM_UPGRADES; j++)
    {
      if (upgrade[j].exist)
	{
	  /* Move the upgrade */
	  
	  upgrade[j].x = upgrade[j].x + upgrade[j].xm;
	  upgrade[j].y = upgrade[j].y + upgrade[j].ym;
	  
	  if ((upgrade[j].x > WIDTH_OF_WORLD) ||
	      (upgrade[j].x < 0) ||
	      (upgrade[j].y > HEIGHT_OF_WORLD) ||
	      (upgrade[j].y < 0))
	    {
	      upgrade[j].exist = 0;
	    }
	  else
	    {
	      /* Handle its animation */
	      
	      upgrade[j].rotation++;
	      
	      while (upgrade[j].rotation > 7)
		upgrade[j].rotation -= 8;
	      while (upgrade[j].rotation < 0)
		upgrade[j].rotation += 8;
	    }


	  /* See if it hit a wormhole: */
	  
	  wormholetest(&upgrade[j].x, &upgrade[j].y, 1);
	}
    } /* (for NUM_UPGRADES) */
}


int nearest_ship(int x, int y, int pln)
{
  int i, dist, this_dist, closest_player;
  
  dist = 32767;
  closest_player = -1;
  
  for (i = 0; i < SERV; i++)
    {
      if (player[i].exist && i != pln)
	{
	  this_dist = distance_between(player[i].x, player[i].y, player[pln].x,
				       player[pln].y);

	  if (this_dist < dist)
	    {
	      closest_player = i;
	      dist = this_dist;
	    }
	}
    }
  
  return(closest_player);
}


void moveweapon(void)
{
  int i, j;

  for (j = 0; j < NUM_WEAPONS; j++)
    {
      if (weapons[j].exist)
	{
	  /* --- Move it depending on its momentum --- */
	  
	  weapons[j].x = weapons[j].x + weapons[j].xm;
	  weapons[j].y = weapons[j].y + weapons[j].ym;
	  
	  
	  /* --- Missile weapons' momentums change! --- */
	  
	  /* Missiles barely steer */
	  
	  if ((weapons[j].type == MISSILE)
	      && (weapons[j].range >= range_of_weapon[MISSILE] - 5))
	    adjustweapon(j);
	  

	  /* Homing missiles, of course, steer constantly */
	  
	  if (weapons[j].type == HOMING_MISSILE)
	    {
	      /* First, update targetx/y to keep up with the ship 
		 we've tagged */
	      
	      if (player[weapons[j].targetship].exist)
		{
		  weapons[j].targetx = player[weapons[j].targetship].x;
		  weapons[j].targety = player[weapons[j].targetship].y;
		}
	      
	      adjustweapon(j);
	    }
	  

	  /* Weapons don't last forever */
	  
	  weapons[j].range--;
	  
	  
	  /* Out of the universe or it's gone its distance? Bye! */
	  
	  if ((weapons[j].x > WIDTH_OF_WORLD) ||
	      (weapons[j].x < 0) ||
	      (weapons[j].y > HEIGHT_OF_WORLD) ||
	      (weapons[j].y < 0) ||
	      (weapons[j].range <= 0))
	    {
	      weapons[j].exist = 0;
	    }
	  else
	    {
	      /* See if it hit a wormhole: */
	      
	      wormholetest(&weapons[j].x, &weapons[j].y, 1);
	      
	      
	      /* Collision with object */
	      
	      /* Asteroids: */
	      
	      for (i = 0; i < NUM_ASTEROIDS; i++)
		{
		  if (asteroid[i].exist)
		    {
		      if ((weapons[j].x >= asteroid[i].x) &&
			  (weapons[j].x <= asteroid[i].x + 32) &&
			  (weapons[j].y >= asteroid[i].y) &&
			  (weapons[j].y <= asteroid[i].y + 32))
			{
			  weapons[j].exist = 0;
			  asteroid[i].exist = 0;
			  add_upgrade(asteroid[i].x, asteroid[i].y,
				      asteroid[i].xm, asteroid[i].ym);
			  add_debris(asteroid[i].x + 16, asteroid[i].y + 16,
				     weapons[j].xm, weapons[j].ym);
			}
		    }
		}
	      

	      /* Drones: */
	      
	      for (i = 0; i < NUM_DRONES; i++)
		{
		  if (drone[i].exist)
		    {
		      if ((weapons[j].x >= drone[i].x) &&
			  (weapons[j].x <= drone[i].x + 32) &&
			  (weapons[j].y >= drone[i].y) &&
			  (weapons[j].y <= drone[i].y + 32))
			{
			  weapons[j].exist = 0;
			  drone[i].exist = 0;
			  add_upgrade(drone[i].x, drone[i].y,
				      drone[i].xm, drone[i].ym);
			  add_debris(drone[i].x + 16, drone[i].y + 16,
				     weapons[j].xm, weapons[j].ym);
			}
		    }
		}
	      
	      
	      /* Players (including yourself!) : */
	      
	      for (i = 0; i < SERV; i++)
		{
		  if (player[i].exist)
		    {
		      if ((weapons[j].x >= player[i].x) &&
			  (weapons[j].x <= player[i].x + 32) &&
			  (weapons[j].y >= player[i].y) &&
			  (weapons[j].y <= player[i].y + 32))
			{
			  weapons[j].exist = 0;
			  hurt(i, weapons[j].xm, weapons[j].ym, 5);
			}
		    }
		}
	    }
	} /* if (weapons.exist[i]) */
    } /* for NUM_WEAPONS */
}


/* Local functions */

int distance_between(int x1, int y1, int x2, int y2)
{
  int a, b;
  
  /* d = sqrt ((x1 - x2)^2 * (y1 - y2)^2) */
  
  a = (x1 - x2);
  b = (y1 - y2);
  
  return(sqrt((a * a) + (b * b)));
}


void getupgrade(int pln, int u)
{
  int type, weapon;              /* So we don't need to ref. the struct */
  int many;                      /* We'll pick a random amount to give you */
  char str[100];                 /* So we can notify you (via comm. window) */
  
  type = upgrade[u].type;
  weapon = upgrade[u].weapon_num;
  many = rndm(10) + 1;           /* Many can change, depending on what you
				    pick up.  If it's -1, it's not a
				    quantitative thing... (like speed).
				    Otherwise, it is (like shields or weaps) */
  
  upgrade[u].exist = 0;
  
  if (type == UPGRADE_WEAPON)
    {
      many = many * 10;
      player[pln].weapons[weapon] += num_to_shoot[weapon] * many;
      sprintf(str, "Got %d %s weapon!", num_to_shoot[weapon] * many,
	      weapon_name_strings[weapon]);
      updateweaponwin(pln);
    }
  else
    {
      if (type == UPGRADE_ARMOR)
	{
	  many = many * 5;
	  player[pln].armor += many;
	}
      else if (type == UPGRADE_SHIELDS)
	player[pln].shields += many;
      else if (type == UPGRADE_CLOAK)
	{
	  many = rndm(3) + 1;
	  player[pln].can_radar_cloak += many;
	}
      else if (type == UPGRADE_TOTALCLOAK)
	{
	  many = rndm(3) + 1;
	  player[pln].can_total_cloak += many;
	}
      else if (type == UPGRADE_CLOAKRADAR)
	{
	  many = -1;
	  player[pln].cloakradar = 1;
	}
      else if (type == UPGRADE_WARP)
	{
	  many = 1;
	  player[pln].warp++;
	}
      else if (type == UPGRADE_HOME)
	{
	  many = 1;
	  player[pln].home++;
	}
      else if (type == UPGRADE_AUTO)
	{
	  many = 1;
	  player[pln].autop++;
	}
      else if (type == UPGRADE_SPEED)
	{
	  many = -1;
	  player[pln].max = SUPER_SPEED;
	}
      else if (type == UPGRADE_ENERGY)
	{
	  many = many * ENERGY_FACTOR;
	  player[pln].energy += many;
	}
      
      if (many != -1)
	sprintf(str, "Got %d %s!", many, upgrade_name_strings[type]);
      else
	sprintf(str, "Got %s!", upgrade_name_strings[type]);
    }
  
  /* Let them know! */
  
  message(pln, GOD, str);
  
  if (strlen(upgrade_help_strings[type]) != 0)
    message(pln, "", upgrade_help_strings[type]);
  
  updateupgradewin(pln);
}


void movewormhole(void)
{
  if (wormhole.exist)
    {
      wormhole.x = wormhole.x + wormhole.xm;
      wormhole.y = wormhole.y + wormhole.ym;
      
      if (wormhole.x >= WIDTH_OF_WORLD)
	wormhole.x = wormhole.x - WIDTH_OF_WORLD;
      else if (wormhole.x < 0)
	wormhole.x = wormhole.x + WIDTH_OF_WORLD;

      if (wormhole.y >= HEIGHT_OF_WORLD)
	wormhole.y = wormhole.y - HEIGHT_OF_WORLD;
      else if (wormhole.y < 0)
	wormhole.y = wormhole.y + HEIGHT_OF_WORLD;
      
      wormhole.range--;
      
      if (wormhole.range <= 0)
	wormhole.exist = 0;
      
      wormhole.warpx = wormhole.warpx + wormhole.warpxm;
      wormhole.warpy = wormhole.warpy + wormhole.warpym;
      
      if (wormhole.warpx >= WIDTH_OF_WORLD)
	wormhole.warpx = wormhole.warpx - WIDTH_OF_WORLD;
      else if (wormhole.warpx < 0)
	wormhole.warpx = wormhole.warpx + WIDTH_OF_WORLD;

      if (wormhole.warpy >= HEIGHT_OF_WORLD)
	wormhole.warpy = wormhole.warpy - HEIGHT_OF_WORLD;
      else if (wormhole.warpy < 0)
	wormhole.warpy = wormhole.warpy + HEIGHT_OF_WORLD;
    }
  else
    {
      if (rndm(CHANCE_OF_WORMHOLE) < 1)
	{
	  actionmessage_all("WORMHOLE DETECTED!");
	  wormhole.exist = 1;
	  wormhole.x = rndm(WIDTH_OF_WORLD);
	  wormhole.y = rndm(HEIGHT_OF_WORLD);
	  wormhole.warpx = rndm(WIDTH_OF_WORLD);
	  wormhole.warpy = rndm(HEIGHT_OF_WORLD);
	  wormhole.xm = rndm(WORMHOLESPEED * 2) - WORMHOLESPEED;
	  wormhole.ym = rndm(WORMHOLESPEED * 2) - WORMHOLESPEED;
	  wormhole.warpxm = rndm(WORMHOLESPEED * 2) - WORMHOLESPEED;
	  wormhole.warpym = rndm(WORMHOLESPEED * 2) - WORMHOLESPEED;
	  wormhole.range = rndm(WORMHOLERANGE);
	}
    }
}


void wormholetest(int * x, int * y, int goaway)
{
  if (wormhole.exist)
    {
      if (*x >= wormhole.x - WORMHOLESIZE - 32 &&
	  *x <= wormhole.x + WORMHOLESIZE &&
	  *y >= wormhole.y - WORMHOLESIZE - 32 &&
	  *y <= wormhole.y + WORMHOLESIZE)
	{
	  wormhole.exist = goaway;
	  
	  /* *x = rndm(WIDTH_OF_WORLD);
	  *y = rndm(HEIGHT_OF_WORLD); */
	  
	  *x = wormhole.warpx;
	  *y = wormhole.warpy;
	}
    }
}
