/*
  misc.h
  
  for Final Battle
  
  by Bill Kendrick and Mike Hufnagel
  Last modified: 11/2/97
  
  Miscellaneous function calls.
*/

#ifndef MISC_H
#define MISC_H

void hurt(int pln, int xm, int ym, int damage);
/*
  Hurts player pln, jolting them in the direction xm,ym and
  damaging them (shields, if they have any, then armor)
*/

void disconnect(int pln);
/*
  Disconnects from the server pln is playing on and frees up their
  resources.
*/

void add_debris(int x, int y, int xm, int ym);
/*
  Adds some random debris at x,y moving in general direction xm,ym
  (a random amount, in random colors, going in slightly random directions
  will be added to the game)
*/

void add_upgrade(int x, int y, int xm, int ym);
/*
  Adds an upgrade at x,y going in direction xm,ym.
  (Happens when asteroids and drones get destroyed)
*/

void kill(int pln, int xm, int ym, char * reason);
/*
  Kills a user, either disconnecting them or reincarnating them.
  Lets all of the other players know (and know why)
*/

void resetdrone(int i);
/*
  Resets a drone when it's timer runs down.  (Chooses a random
  target (or none) to home-in on.
*/

#endif /* MISC_H */
