/*
  misc.c
  
  For Final Battle
  
  by Bill Kendrick and Mike Hufnagel
  
  Last modified: 11/4/97
*/


#include "lib/rndm.h"
#include "misc.h"
#include "types.h"
#include "glovar.h"
#include "const.h"
#include "actionwin.h"
#include "weaponwin.h"
#include "damagewin.h"


/* Damage a player */

void hurt(int pln, int xm, int ym, int damage)
{
  char buf[100];                /* Text for mesg. in case they die */
  int i;
  
  /* Shake them */

  player[pln].x += xm;
  player[pln].y += ym;

  /* If they have shields, damage the shields (absorb momentum, no debris) */
  
  if (player[pln].shields > 0)
    {
      player[pln].shields = player[pln].shields - damage;
      if (player[pln].shields <= 0)
	{
	  actionmessage(pln, "Shields destroyed!");
	  message(pln, GOD, "Shields destroyed");
	  player[pln].shields = 0;
	}
    }
  else
    {
      /* Change their momentum */
      
      player[pln].xm += xm / (rndm(3) + 3);
      player[pln].ym += ym / (rndm(3) + 3);
      
      /* Keep their momentum sane (within max bounds) */
      
      if (player[pln].xm > MAX_SPEED)
	player[pln].xm = MAX_SPEED;
      else if (player[pln].xm < -MAX_SPEED)
	player[pln].xm = -MAX_SPEED;
      
      if (player[pln].ym > MAX_SPEED)
	player[pln].ym = MAX_SPEED;
      else if (player[pln].ym < -MAX_SPEED)
	player[pln].ym = -MAX_SPEED;
      
      /* Damage them and maybe destroy them */
      player[pln].armor = player[pln].armor - damage;
      
      if (player[pln].armor < 10)
	{
	  actionmessage(pln, "ARMOR LOW!");
	}
      
      /* Ohh.. they're dead! */
      if (player[pln].armor <= 0)
	kill(pln, xm, ym, "armor was destroyed!");
      
      /* Make some mess */
      add_debris(player[pln].x, player[pln].y, xm, ym);
      
      /* Maybe damage a ship component (how nice :) ) */
      if (rndm(CHANCE_OF_DAMAGE) < 1)
	{
	  i = rndm(UNIQUE_DAMAGABLES);
	  if (player[pln].damage[i] != DESTROYED)
	    player[pln].damage[i]++;
	  player[pln].damagetime[i] = rndm(DAMAGE_TIME_RANGE) +
	    DAMAGE_TIME_INC;
	  updatedamagewin(pln);
	  sprintf(buf, "%s is ", damagable_name_strings[i]);
	  if (player[pln].damage[i] == DESTROYED)
	    strcat(buf, "destroyed!");
	  else
	    strcat(buf, "damaged!");
	  actionmessage(pln, buf);
	  message(pln, GOD, buf);
	}
    } /* (if shields else) */
}

/* Clean up a bunch of stuff and disconnect from the server */
void disconnect(int pln)
{
  int i, j;                     /* Counters */
  
  player[pln].exist = 0;
  
  /* Remove your bitmaps from everyone else's server, and everyone else's
     bitmaps from your server */

  for (i = 0; i < SERV; i++)
    if (player[i].exist)
      {
	for (j = 0; j < 15; j++)
	  {
	    XFreePixmap(display[i],shipbitmaps[i][pln][j]);    /* Us... */
	    XFreePixmap(display[i],shipbitmasks[i][pln][j]);
	    XFreePixmap(display[pln],shipbitmaps[pln][i][j]);  /* Them... */
	    XFreePixmap(display[pln],shipbitmasks[pln][i][j]);
	  }
      }

  /* Remove asteroid bitmaps from your server */

  for (j = 0; j < 15; j++)
    {
      XFreePixmap(display[pln],asteroidbitmaps[pln][j]);
      XFreePixmap(display[pln],asteroidbitmasks[pln][j]);
    }

  /* Free the fontstruct (and perhaps the font, if no other client on your
     server is using it) */

  XFreeFont(display[pln], font[pln]);
  
  XCloseDisplay(display[pln]);
}


/* Bring some debris to life */

void add_debris(int x, int y, int xm, int ym)
{
  int i;                     /* Counter for adding debris to the game */
  
  for (i = 0; i < 5 + rndm(5); i++)
    {
      current_debris = (current_debris + 1) % NUM_DEBRIS;
      
      debris[current_debris].exist = 1;
      debris[current_debris].range = rndm(10) + 10;
      debris[current_debris].x = x - xm + 16;
      debris[current_debris].y = y - ym + 16;
      debris[current_debris].xm = rndm(7) - 3 + (xm / 2);
      debris[current_debris].ym = rndm(7) - 3 + (ym / 2);
      debris[current_debris].color = rndm(EXPLODE_COLORS);
    }
}


/* Bring some deadmen to life (har har!) */

void add_deadman(int x, int y)
{
  int i;                     /* Counter for adding deadman to the game */
  
  current_deadman = (current_deadman + 1) % NUM_DEADMAN;
  
  deadman[current_deadman].exist = 1;
  deadman[current_deadman].range = rndm(40) + 50;
  deadman[current_deadman].x = x;
  deadman[current_deadman].y = y;
  deadman[current_deadman].xm = rndm(7) - 3;
  deadman[current_deadman].ym = rndm(7) - 3;
}


/* Possibly bring an upgrade to life */

void add_upgrade(int x, int y, int xm, int ym)
{
  int i, slot;                /* So we can find a free slot */
  
  i = rndm(CHANCE_OF_UPGRADE);
  
  if (i < 1)
    {
      for (i = 0; i < NUM_UPGRADES; i++)
	{
	  if (upgrade[i].exist == 0)
	    {
	      slot = i;
	      break;
	    }
	}
      
      if (rndm(CHANCE_OF_WEAPON) < 1)
	upgrade[slot].type = rndm(UNIQUE_UPGRADES - 1);
      else
	upgrade[slot].type = UPGRADE_WEAPON;
      
      upgrade[slot].exist = 1;
      upgrade[slot].x = x - xm;
      upgrade[slot].y = y - ym;
      upgrade[slot].xm = xm / 2;
      upgrade[slot].ym = ym / 2;
      upgrade[slot].rotation = rndm(8);
      upgrade[slot].weapon_num = rndm(UNIQUE_WEAPONS - 1) + 1;
    }
}

void kill(int pln, int xm, int ym, char * reason)
{
  int i;
  char buf[1024];
  
  
  /* Make even more mess! */
  
  add_debris(player[pln].x, player[pln].y, xm, ym);
  add_debris(player[pln].x, player[pln].y, xm, ym);
  
  
  /* Throw the crew out into space! >:^) */
  
  for (i = 0; i < player[pln].crew_free; i++)
    add_deadman(player[pln].x, player[pln].y);
  
  
  /* Later, dead guy! */
  
  complain(pln, "Oh No!!!");
  
  
  /* Tell everyone how much this player sucked :) */
  
  sprintf(buf, "%s's %s", name[pln], reason);
  message_all(GOD, buf);
  
  player[pln].current_weapon = EIGHT_WAY;
  fireweapon(pln);
  fireweapon(pln);
  
  if (REPLAY_ON_DEATH == 1)
    {
      initstate(pln);
      
      sprintf(buf, "%s has been reincarnated!", name[pln]);
      message_all(GOD, buf);
      
      updatedamagewin(pln);
      updateweaponwin(pln);
    }
  else
    {
      disconnect(pln);
      
      sprintf(buf, "%s has been destroyed!", name[pln]);
      message_all(GOD, buf);
    }
  
  actionmessage_all(buf);
}

void resetdrone(int i)
{
  if (rndm(CHANCE_DRONENOTHOME) >= 1)
    {
      do
	{
	  drone[i].homeship = rndm(SERV);
	}
      while (player[drone[i].homeship].exist == 0);
    }
  else
    drone[i].homeship = -1;
  
  drone[i].hometime = rndm(DRONE_HOMETIME_MAX);
}
